/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.facet.frameworks.SettingsConnectionService;
import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.internal.statistic.eventLog.EventLogSettingsService;
import com.intellij.internal.statistic.eventLog.LogEventCompositeFilter;
import com.intellij.internal.statistic.eventLog.LogEventFilter;
import com.intellij.internal.statistic.eventLog.LogEventSnapshotBuildFilter;
import com.intellij.internal.statistic.eventLog.LogEventWhitelistFilter;
import com.intellij.internal.statistic.persistence.ApprovedGroupsCacheConfigurable;
import com.intellij.internal.statistic.service.fus.FUSWhitelist;
import com.intellij.internal.statistic.service.fus.FUStatisticsWhiteListGroupsService;
import com.intellij.internal.statistic.utils.StatisticsUploadAssistant;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventLogExternalSettingsService
extends SettingsConnectionService
implements EventLogSettingsService {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.internal.statistic.eventLog.EventLogExternalSettingsService");
    private static final String APPROVED_GROUPS_SERVICE = "white-list-service";
    private static final String DICTIONARY_SERVICE = "dictionary-service";
    private static final String PERCENT_TRAFFIC = "percent-traffic";
    private static final long ACCEPTED_CACHE_AGE_MS = TimeUnit.MILLISECONDS.convert(7L, TimeUnit.DAYS);
    private static final long DONT_REQUIRE_UPDATE_AGE_MS = TimeUnit.MILLISECONDS.convert(1L, TimeUnit.DAYS);

    public static EventLogExternalSettingsService getInstance() {
        return new EventLogExternalSettingsService();
    }

    protected EventLogExternalSettingsService() {
        super(((ApplicationInfoImpl)ApplicationInfoImpl.getShadowInstance()).getEventLogSettingsUrl(), null);
    }

    @NotNull
    public String[] getAttributeNames() {
        String[] stringArray = ArrayUtil.mergeArrays((String[])super.getAttributeNames(), (String[])new String[]{PERCENT_TRAFFIC, APPROVED_GROUPS_SERVICE, DICTIONARY_SERVICE});
        if (stringArray == null) {
            EventLogExternalSettingsService.$$$reportNull$$$0(0);
        }
        return stringArray;
    }

    @Override
    public int getPermittedTraffic() {
        String permitted = this.getSettingValue(PERCENT_TRAFFIC);
        if (permitted != null) {
            try {
                return Integer.parseInt(permitted);
            }
            catch (NumberFormatException e) {
                LOG.trace("Permitted traffic is not defined or has invalid format: '" + permitted + "'");
            }
        }
        return 0;
    }

    @Override
    @Nullable
    public String getDictionaryServiceUrl() {
        return this.getSettingValue(DICTIONARY_SERVICE);
    }

    @NotNull
    public FUSWhitelist getApprovedGroups() {
        FUSWhitelist fUSWhitelist = this.getApprovedGroups(ApprovedGroupsCacheConfigurable.getInstance());
        if (fUSWhitelist == null) {
            EventLogExternalSettingsService.$$$reportNull$$$0(1);
        }
        return fUSWhitelist;
    }

    @NotNull
    public FUSWhitelist getApprovedGroups(ApprovedGroupsCacheConfigurable cache) {
        Date currentDate = new Date();
        BuildNumber currentBuild = EventLogExternalSettingsService.getCurrentBuild();
        FUSWhitelist cachedGroups = cache.getCachedGroups(currentDate, DONT_REQUIRE_UPDATE_AGE_MS, currentBuild);
        if (cachedGroups != null) {
            FUSWhitelist fUSWhitelist = cachedGroups;
            if (fUSWhitelist == null) {
                EventLogExternalSettingsService.$$$reportNull$$$0(2);
            }
            return fUSWhitelist;
        }
        FUSWhitelist groups = this.getWhitelistedGroups();
        if (groups != null) {
            FUSWhitelist fUSWhitelist = cache.cacheGroups(currentDate, groups, currentBuild);
            if (fUSWhitelist == null) {
                EventLogExternalSettingsService.$$$reportNull$$$0(3);
            }
            return fUSWhitelist;
        }
        FUSWhitelist fUSWhitelist = (FUSWhitelist)ObjectUtils.notNull((Object)cache.getCachedGroups(currentDate, ACCEPTED_CACHE_AGE_MS), (Object)FUSWhitelist.empty());
        if (fUSWhitelist == null) {
            EventLogExternalSettingsService.$$$reportNull$$$0(4);
        }
        return fUSWhitelist;
    }

    @Override
    @NotNull
    public LogEventFilter getEventFilter() {
        FUSWhitelist whitelist = (FUSWhitelist)ObjectUtils.notNull((Object)this.getWhitelistedGroups(), (Object)FUSWhitelist.empty());
        LogEventCompositeFilter logEventCompositeFilter = new LogEventCompositeFilter(new LogEventWhitelistFilter(whitelist), LogEventSnapshotBuildFilter.INSTANCE);
        if (logEventCompositeFilter == null) {
            EventLogExternalSettingsService.$$$reportNull$$$0(5);
        }
        return logEventCompositeFilter;
    }

    @Override
    public boolean isInternal() {
        return StatisticsUploadAssistant.isTestStatisticsEnabled();
    }

    @Nullable
    protected FUSWhitelist getWhitelistedGroups() {
        String approvedGroupsServiceUrl = this.getSettingValue(APPROVED_GROUPS_SERVICE);
        if (approvedGroupsServiceUrl == null) {
            return null;
        }
        String productUrl = approvedGroupsServiceUrl + ApplicationInfo.getInstance().getBuild().getProductCode() + ".json";
        return FUStatisticsWhiteListGroupsService.getApprovedGroups(productUrl, EventLogExternalSettingsService.getCurrentBuild());
    }

    @NotNull
    private static BuildNumber getCurrentBuild() {
        BuildNumber buildNumber = BuildNumber.fromString((String)EventLogConfiguration.INSTANCE.getBuild());
        if (buildNumber == null) {
            EventLogExternalSettingsService.$$$reportNull$$$0(6);
        }
        return buildNumber;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/internal/statistic/eventLog/EventLogExternalSettingsService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeNames";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getApprovedGroups";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventFilter";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentBuild";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

