/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.actions;

import com.intellij.internal.statistic.eventLog.EventLogExternalSettingsService;
import com.intellij.internal.statistic.service.fus.FUSWhitelist;
import com.intellij.internal.statistic.service.fus.collectors.FUStateUsagesLogger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import org.jetbrains.annotations.NotNull;

public class RecordStateStatisticsEventLogAction
extends AnAction {
    private static final FUStateUsagesLogger myStatesLogger = new FUStateUsagesLogger();
    private static final EventLogExternalSettingsService myEventLogSettingsService = EventLogExternalSettingsService.getInstance();

    public void actionPerformed(final @NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            RecordStateStatisticsEventLogAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "Collecting Feature Usages In Event Log", false){

            public void run(@NotNull ProgressIndicator indicator) {
                String serviceUrl;
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((serviceUrl = myEventLogSettingsService.getServiceUrl()) == null) {
                    return;
                }
                FUSWhitelist whitelist = myEventLogSettingsService.getApprovedGroups();
                if (whitelist.isEmpty() && !ApplicationManagerEx.getApplicationEx().isInternal()) {
                    return;
                }
                myStatesLogger.logApplicationStates(whitelist, true);
                myStatesLogger.logProjectStates(project, whitelist, true);
                ApplicationManager.getApplication().invokeLater(() -> RecordStateStatisticsEventLogAction.this.showNotification(project, e, "Collecting and recording events was finished"));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/internal/statistic/actions/RecordStateStatisticsEventLogAction$1", "run"));
            }
        });
    }

    protected void showNotification(@NotNull Project project, @NotNull AnActionEvent event, @NotNull String message) {
        if (project == null) {
            RecordStateStatisticsEventLogAction.$$$reportNull$$$0(1);
        }
        if (event == null) {
            RecordStateStatisticsEventLogAction.$$$reportNull$$$0(2);
        }
        if (message == null) {
            RecordStateStatisticsEventLogAction.$$$reportNull$$$0(3);
        }
        JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, MessageType.INFO, null).setFadeoutTime(2000L).setDisposable((Disposable)project).createBalloon().show(JBPopupFactory.getInstance().guessBestPopupLocation(event.getDataContext()), Balloon.Position.below);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        objectArray2[1] = "com/intellij/internal/statistic/actions/RecordStateStatisticsEventLogAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "showNotification";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

