/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.impl;

import com.intellij.conversion.ConversionResult;
import com.intellij.conversion.impl.ConversionRunner;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.VcsShowConfirmationOptionImpl;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.actions.EditAction;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ConversionResultImpl
implements ConversionResult {
    public static final ConversionResultImpl CONVERSION_NOT_NEEDED = new ConversionResultImpl(false, false, false);
    public static final ConversionResultImpl CONVERSION_CANCELED = new ConversionResultImpl(true, true, false);
    public static final ConversionResultImpl ERROR_OCCURRED = new ConversionResultImpl(true, false, true);
    private final boolean myConversionNeeded;
    private final boolean myConversionCanceled;
    private final boolean myErrorOccurred;
    private final Set<File> myChangedFiles = new HashSet<File>();
    private final Set<File> myCreatedFiles = new HashSet<File>();

    public ConversionResultImpl(boolean conversionNeeded, boolean conversionCanceled, boolean errorOccurred) {
        this.myConversionNeeded = conversionNeeded;
        this.myConversionCanceled = conversionCanceled;
        this.myErrorOccurred = errorOccurred;
    }

    public ConversionResultImpl(List<? extends ConversionRunner> converters2) {
        this(true, false, false);
        for (ConversionRunner conversionRunner : converters2) {
            this.myChangedFiles.addAll(conversionRunner.getAffectedFiles());
            this.myCreatedFiles.addAll(conversionRunner.getCreatedFiles());
        }
    }

    @Override
    public boolean conversionNotNeeded() {
        return !this.myConversionNeeded;
    }

    @Override
    public boolean openingIsCanceled() {
        return this.myConversionCanceled || this.myErrorOccurred;
    }

    @Override
    public void postStartupActivity(@NotNull Project project) {
        List<VirtualFile> createdFiles;
        Application application;
        if (project == null) {
            ConversionResultImpl.$$$reportNull$$$0(0);
        }
        if ((application = ApplicationManager.getApplication()).isHeadlessEnvironment() || application.isUnitTestMode()) {
            return;
        }
        List<VirtualFile> changedFiles = ConversionResultImpl.findVirtualFiles(this.myChangedFiles);
        if (!changedFiles.isEmpty()) {
            EditAction.editFilesAndShowErrors(project, changedFiles);
        }
        if (ConversionResultImpl.containsFilesUnderVcs(createdFiles = ConversionResultImpl.findVirtualFiles(this.myCreatedFiles), project)) {
            VcsShowConfirmationOptionImpl option2 = new VcsShowConfirmationOptionImpl("", "", "", "", "");
            Collection selected = AbstractVcsHelper.getInstance((Project)project).selectFilesToProcess(createdFiles, "Files Created", "Select files to be added to version control", null, null, (VcsShowConfirmationOption)option2);
            if (selected != null && !selected.isEmpty()) {
                ChangeListManagerImpl changeListManager = ChangeListManagerImpl.getInstanceImpl(project);
                changeListManager.addUnversionedFiles(changeListManager.getDefaultChangeList(), new ArrayList(selected));
            }
        }
    }

    private static boolean containsFilesUnderVcs(List<? extends VirtualFile> files2, Project project) {
        for (VirtualFile virtualFile : files2) {
            if (ChangesUtil.getVcsForFile((VirtualFile)virtualFile, (Project)project) == null) continue;
            return true;
        }
        return false;
    }

    private static List<VirtualFile> findVirtualFiles(Collection<? extends File> ioFiles) {
        ArrayList<VirtualFile> files2 = new ArrayList<VirtualFile>();
        for (File file2 : ioFiles) {
            ContainerUtil.addIfNotNull(files2, (Object)LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file2));
        }
        return files2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/impl/ConversionResultImpl", "postStartupActivity"));
    }
}

