/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.scopeChooser;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.execution.ExecutionBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.scopeChooser.ScopeConfigurable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.MasterDetailsState;
import com.intellij.openapi.ui.MasterDetailsStateService;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.Comparing;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.search.scope.packageSet.CustomScopesProvider;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.xmlb.annotations.XCollection;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScopeChooserConfigurable
extends MasterDetailsComponent
implements SearchableConfigurable {
    @NonNls
    public static final String SCOPE_CHOOSER_CONFIGURABLE_UI_KEY = "ScopeChooserConfigurable.UI";
    public static final String PROJECT_SCOPES = "project.scopes";
    private final NamedScopesHolder myLocalScopesManager;
    private final NamedScopesHolder mySharedScopesManager;
    private final Project myProject;

    public ScopeChooserConfigurable(Project project) {
        super((MasterDetailsState)new ScopeChooserConfigurableState());
        this.myLocalScopesManager = NamedScopeManager.getInstance((Project)project);
        this.mySharedScopesManager = DependencyValidationManager.getInstance((Project)project);
        this.myProject = project;
        this.initTree();
    }

    protected String getComponentStateKey() {
        return SCOPE_CHOOSER_CONFIGURABLE_UI_KEY;
    }

    protected Dimension getPanelPreferredSize() {
        return JBUI.size((int)400, (int)200);
    }

    protected MasterDetailsStateService getStateService() {
        return MasterDetailsStateService.getInstance((Project)this.myProject);
    }

    protected ArrayList<AnAction> createActions(boolean fromPopup) {
        ArrayList<AnAction> result2 = new ArrayList<AnAction>();
        result2.add((AnAction)new MyAddAction(fromPopup));
        result2.add((AnAction)new MasterDetailsComponent.MyDeleteAction((MasterDetailsComponent)this, ScopeChooserConfigurable.forAll(o -> {
            if (o instanceof MasterDetailsComponent.MyNode) {
                NamedConfigurable namedConfigurable = ((MasterDetailsComponent.MyNode)o).getConfigurable();
                Object editableObject = namedConfigurable != null ? namedConfigurable.getEditableObject() : null;
                return editableObject instanceof NamedScope;
            }
            return false;
        })));
        result2.add(new MyCopyAction());
        result2.add(new MySaveAsAction());
        result2.add(new MyMoveAction(ExecutionBundle.message((String)"move.up.action.name", (Object[])new Object[0]), IconUtil.getMoveUpIcon(), -1));
        result2.add(new MyMoveAction(ExecutionBundle.message((String)"move.down.action.name", (Object[])new Object[0]), IconUtil.getMoveDownIcon(), 1));
        return result2;
    }

    public void reset() {
        this.myRoot.removeAllChildren();
        this.loadScopes(this.mySharedScopesManager);
        this.loadScopes(this.myLocalScopesManager);
        this.loadComponentState();
        List<String> order = this.getScopesState().myOrder;
        TreeUtil.sortRecursively((MutableTreeNode)this.myRoot, (o1, o2) -> {
            int idx1 = order.indexOf(o1.getDisplayName());
            int idx2 = order.indexOf(o2.getDisplayName());
            return idx1 - idx2;
        });
        if (this.getScopesState().myOrder.size() != this.myRoot.getChildCount()) {
            this.loadStateOrder();
        }
        super.reset();
    }

    public void apply() throws ConfigurationException {
        this.checkForEmptyAndDuplicatedNames(ProjectBundle.message((String)"rename.message.prefix.scope", (Object[])new Object[0]), ProjectBundle.message((String)"rename.scope.title", (Object[])new Object[0]), ScopeConfigurable.class);
        this.checkForPredefinedNames();
        super.apply();
        this.processScopes();
        this.loadStateOrder();
    }

    private void checkForPredefinedNames() throws ConfigurationException {
        HashSet<String> predefinedScopes = new HashSet<String>();
        for (CustomScopesProvider scopesProvider : CustomScopesProvider.CUSTOM_SCOPES_PROVIDER.getExtensionList((AreaInstance)this.myProject)) {
            for (NamedScope namedScope : scopesProvider.getFilteredScopes()) {
                predefinedScopes.add(namedScope.getName());
            }
        }
        for (int i = 0; i < this.myRoot.getChildCount(); ++i) {
            MasterDetailsComponent.MyNode node = (MasterDetailsComponent.MyNode)this.myRoot.getChildAt(i);
            NamedConfigurable scopeConfigurable = node.getConfigurable();
            String name = scopeConfigurable.getDisplayName();
            if (!predefinedScopes.contains(name)) continue;
            this.selectNodeInTree((DefaultMutableTreeNode)node);
            throw new ConfigurationException("Scope name equals to predefined one", ProjectBundle.message((String)"rename.scope.title", (Object[])new Object[0]));
        }
    }

    public ScopeChooserConfigurableState getScopesState() {
        return (ScopeChooserConfigurableState)this.myState;
    }

    public boolean isModified() {
        List<String> order = this.getScopesState().myOrder;
        if (this.myRoot.getChildCount() != order.size()) {
            return true;
        }
        for (int i = 0; i < this.myRoot.getChildCount(); ++i) {
            MasterDetailsComponent.MyNode node = (MasterDetailsComponent.MyNode)this.myRoot.getChildAt(i);
            ScopeConfigurable scopeConfigurable = (ScopeConfigurable)node.getConfigurable();
            NamedScope namedScope = scopeConfigurable.getEditableObject();
            if (order.size() <= i) {
                return true;
            }
            String name = order.get(i);
            if (!Comparing.strEqual((String)name, (String)namedScope.getName())) {
                return true;
            }
            if (!this.isInitialized(scopeConfigurable)) continue;
            NamedScopesHolder holder = scopeConfigurable.getHolder();
            NamedScope scope = holder.getScope(name);
            if (scope == null) {
                return true;
            }
            if (!scopeConfigurable.isModified()) continue;
            return true;
        }
        return false;
    }

    private void processScopes() {
        ArrayList<NamedScope> localScopes = new ArrayList<NamedScope>();
        ArrayList<NamedScope> sharedScopes = new ArrayList<NamedScope>();
        for (int i = 0; i < this.myRoot.getChildCount(); ++i) {
            MasterDetailsComponent.MyNode node = (MasterDetailsComponent.MyNode)this.myRoot.getChildAt(i);
            ScopeConfigurable scopeConfigurable = (ScopeConfigurable)node.getConfigurable();
            NamedScope namedScope = scopeConfigurable.getScope();
            if (scopeConfigurable.getHolder() == this.myLocalScopesManager) {
                localScopes.add(namedScope);
                continue;
            }
            sharedScopes.add(namedScope);
        }
        this.myLocalScopesManager.setScopes(localScopes.toArray(NamedScope.EMPTY_ARRAY));
        this.mySharedScopesManager.setScopes(sharedScopes.toArray(NamedScope.EMPTY_ARRAY));
    }

    private void loadStateOrder() {
        List<String> order = this.getScopesState().myOrder;
        order.clear();
        for (int i = 0; i < this.myRoot.getChildCount(); ++i) {
            order.add(((MasterDetailsComponent.MyNode)this.myRoot.getChildAt(i)).getDisplayName());
        }
    }

    private void loadScopes(NamedScopesHolder holder) {
        NamedScope[] scopes;
        for (NamedScope scope : scopes = holder.getScopes()) {
            if (this.isPredefinedScope(scope)) continue;
            this.myRoot.add((MutableTreeNode)new MasterDetailsComponent.MyNode((NamedConfigurable)new ScopeConfigurable(scope, holder == this.mySharedScopesManager, this.myProject, this.TREE_UPDATER)));
        }
    }

    private boolean isPredefinedScope(NamedScope scope) {
        return ScopeChooserConfigurable.getPredefinedScopes(this.myProject).contains(scope);
    }

    private static Collection<NamedScope> getPredefinedScopes(Project project) {
        ArrayList<NamedScope> result2 = new ArrayList<NamedScope>();
        result2.addAll(NamedScopeManager.getInstance((Project)project).getPredefinedScopes());
        result2.addAll(DependencyValidationManager.getInstance((Project)project).getPredefinedScopes());
        return result2;
    }

    protected void initTree() {
        this.myTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                MasterDetailsComponent.MyNode node;
                NamedConfigurable namedConfigurable;
                TreePath path = e.getOldLeadSelectionPath();
                if (path != null && (namedConfigurable = (node = (MasterDetailsComponent.MyNode)path.getLastPathComponent()).getConfigurable()) instanceof ScopeConfigurable) {
                    ((ScopeConfigurable)namedConfigurable).cancelCurrentProgress();
                }
            }
        });
        super.initTree();
        this.myTree.setShowsRootHandles(false);
        new TreeSpeedSearch(this.myTree, (Convertor<? super TreePath, String>)((Convertor)treePath -> ((MasterDetailsComponent.MyNode)treePath.getLastPathComponent()).getDisplayName()), true);
        this.myTree.getEmptyText().setText(IdeBundle.message((String)"scopes.no.scoped", (Object[])new Object[0]));
    }

    protected boolean wasObjectStored(Object editableObject) {
        if (editableObject instanceof NamedScope) {
            NamedScope scope = (NamedScope)editableObject;
            String scopeName = scope.getName();
            return this.myLocalScopesManager.getScope(scopeName) != null || this.mySharedScopesManager.getScope(scopeName) != null;
        }
        return false;
    }

    public String getDisplayName() {
        return IdeBundle.message((String)"scopes.display.name", (Object[])new Object[0]);
    }

    @NotNull
    @NonNls
    public String getHelpTopic() {
        if (PROJECT_SCOPES == null) {
            ScopeChooserConfigurable.$$$reportNull$$$0(0);
        }
        return PROJECT_SCOPES;
    }

    protected void updateSelection(@Nullable NamedConfigurable configurable) {
        super.updateSelection(configurable);
        if (configurable instanceof ScopeConfigurable) {
            ((ScopeConfigurable)configurable).restoreCanceledProgress();
        }
    }

    @Nullable
    protected String getEmptySelectionString() {
        return "Select a scope to view or edit its details here";
    }

    private String createUniqueName() {
        String str = InspectionsBundle.message((String)"inspection.profile.unnamed", (Object[])new Object[0]);
        HashSet<String> treeScopes = new HashSet<String>();
        this.obtainCurrentScopes(treeScopes);
        if (!treeScopes.contains(str)) {
            return str;
        }
        int i = 1;
        while (treeScopes.contains(str + i)) {
            ++i;
        }
        return str + i;
    }

    private void obtainCurrentScopes(HashSet<String> scopes) {
        for (int i = 0; i < this.myRoot.getChildCount(); ++i) {
            MasterDetailsComponent.MyNode node = (MasterDetailsComponent.MyNode)this.myRoot.getChildAt(i);
            NamedScope scope = (NamedScope)node.getConfigurable().getEditableObject();
            scopes.add(scope.getName());
        }
    }

    private void addNewScope(NamedScope scope, boolean isLocal) {
        MasterDetailsComponent.MyNode nodeToAdd = new MasterDetailsComponent.MyNode((NamedConfigurable)new ScopeConfigurable(scope, !isLocal, this.myProject, this.TREE_UPDATER));
        this.myRoot.add((MutableTreeNode)nodeToAdd);
        ((DefaultTreeModel)this.myTree.getModel()).reload((TreeNode)this.myRoot);
        this.selectNodeInTree((DefaultMutableTreeNode)nodeToAdd);
    }

    private void createScope(boolean isLocal, String title, PackageSet set2) {
        final NamedScopesHolder holder = isLocal ? this.myLocalScopesManager : this.mySharedScopesManager;
        String newName = Messages.showInputDialog((Component)this.myTree, (String)IdeBundle.message((String)"add.scope.name.label", (Object[])new Object[0]), (String)title, (Icon)Messages.getInformationIcon(), (String)this.createUniqueName(), (InputValidator)new InputValidator(){

            public boolean checkInput(String inputString) {
                for (NamedScope scope : holder.getPredefinedScopes()) {
                    if (!Comparing.strEqual((String)scope.getName(), (String)inputString.trim())) continue;
                    return false;
                }
                return inputString.trim().length() > 0;
            }

            public boolean canClose(String inputString) {
                return this.checkInput(inputString);
            }
        });
        if (newName != null) {
            this.addNewScope(holder.createScope(newName, set2), isLocal);
        }
    }

    @NotNull
    @NonNls
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            ScopeChooserConfigurable.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/ide/util/scopeChooser/ScopeChooserConfigurable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpTopic";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static class ScopeChooserConfigurableState
    extends MasterDetailsState {
        @XCollection(propertyElementName="order", elementName="scope", valueAttributeName="name")
        public List<String> myOrder = new ArrayList<String>();
    }

    private class MySaveAsAction
    extends AnAction {
        MySaveAsAction() {
            super(ExecutionBundle.message((String)"action.name.save.as.configuration", (Object[])new Object[0]), ExecutionBundle.message((String)"action.name.save.as.configuration", (Object[])new Object[0]), AllIcons.Actions.Menu_saveall);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            ScopeConfigurable scopeConfigurable;
            PackageSet set2;
            MasterDetailsComponent.MyNode node;
            NamedConfigurable configurable;
            TreePath selectionPath;
            if (e == null) {
                MySaveAsAction.$$$reportNull$$$0(0);
            }
            if ((selectionPath = ScopeChooserConfigurable.this.myTree.getSelectionPath()) != null && (configurable = (node = (MasterDetailsComponent.MyNode)selectionPath.getLastPathComponent()).getConfigurable()) instanceof ScopeConfigurable && (set2 = (scopeConfigurable = (ScopeConfigurable)configurable).getEditableObject().getValue()) != null) {
                if (scopeConfigurable.getHolder() == ScopeChooserConfigurable.this.mySharedScopesManager) {
                    ScopeChooserConfigurable.this.createScope(true, IdeBundle.message((String)"scopes.save.dialog.title.local", (Object[])new Object[0]), set2.createCopy());
                } else {
                    ScopeChooserConfigurable.this.createScope(false, IdeBundle.message((String)"scopes.save.dialog.title.shared", (Object[])new Object[0]), set2.createCopy());
                }
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MySaveAsAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(ScopeChooserConfigurable.this.getSelectedObject() instanceof NamedScope);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ide/util/scopeChooser/ScopeChooserConfigurable$MySaveAsAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyCopyAction
    extends AnAction {
        MyCopyAction() {
            super(ExecutionBundle.message((String)"copy.configuration.action.name", (Object[])new Object[0]), ExecutionBundle.message((String)"copy.configuration.action.name", (Object[])new Object[0]), COPY_ICON);
            this.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(68, 2)), (JComponent)ScopeChooserConfigurable.this.myTree);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            NamedScope scope;
            if (e == null) {
                MyCopyAction.$$$reportNull$$$0(0);
            }
            if ((scope = (NamedScope)ScopeChooserConfigurable.this.getSelectedObject()) != null) {
                ScopeConfigurable configurable = (ScopeConfigurable)((MasterDetailsComponent.MyNode)ScopeChooserConfigurable.this.myTree.getSelectionPath().getLastPathComponent()).getConfigurable();
                NamedScopesHolder holder = configurable.getHolder();
                PackageSet set2 = scope.getValue();
                ScopeChooserConfigurable.this.addNewScope(holder.createScope(ScopeChooserConfigurable.this.createUniqueName(), set2 == null ? null : set2.createCopy()), holder == ScopeChooserConfigurable.this.myLocalScopesManager);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyCopyAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(ScopeChooserConfigurable.this.getSelectedObject() instanceof NamedScope);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ide/util/scopeChooser/ScopeChooserConfigurable$MyCopyAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyMoveAction
    extends AnAction {
        private final int myDirection;

        protected MyMoveAction(String text, Icon icon, int direction) {
            super(text, text, icon);
            this.myDirection = direction;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyMoveAction.$$$reportNull$$$0(0);
            }
            TreeUtil.moveSelectedRow((JTree)ScopeChooserConfigurable.this.myTree, (int)this.myDirection);
        }

        public void update(@NotNull AnActionEvent e) {
            DefaultMutableTreeNode treeNode;
            if (e == null) {
                MyMoveAction.$$$reportNull$$$0(1);
            }
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(false);
            TreePath selectionPath = ScopeChooserConfigurable.this.myTree.getSelectionPath();
            if (selectionPath != null && (treeNode = (DefaultMutableTreeNode)selectionPath.getLastPathComponent()).getUserObject() instanceof ScopeConfigurable) {
                if (this.myDirection < 0) {
                    presentation.setEnabled(treeNode.getPreviousSibling() != null);
                } else {
                    presentation.setEnabled(treeNode.getNextSibling() != null);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ide/util/scopeChooser/ScopeChooserConfigurable$MyMoveAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyAddAction
    extends ActionGroup
    implements MasterDetailsComponent.ActionGroupWithPreselection,
    DumbAware {
        private AnAction[] myChildren;
        private final boolean myFromPopup;

        MyAddAction(boolean fromPopup) {
            super(IdeBundle.message((String)"add.scope.popup.title", (Object[])new Object[0]), true);
            this.myFromPopup = fromPopup;
            Presentation presentation = this.getTemplatePresentation();
            presentation.setIcon(IconUtil.getAddIcon());
            this.setShortcutSet(CommonShortcuts.INSERT);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyAddAction.$$$reportNull$$$0(0);
            }
            super.update(e);
            if (this.myFromPopup) {
                this.setPopup(false);
            }
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            if (this.myChildren == null) {
                this.myChildren = new AnAction[2];
                this.myChildren[0] = new DumbAwareAction(IdeBundle.message((String)"add.local.scope.action.text", (Object[])new Object[0]), IdeBundle.message((String)"add.local.scope.action.text", (Object[])new Object[0]), ScopeChooserConfigurable.this.myLocalScopesManager.getIcon()){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        ScopeChooserConfigurable.this.createScope(true, IdeBundle.message((String)"add.scope.dialog.title", (Object[])new Object[0]), null);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/util/scopeChooser/ScopeChooserConfigurable$MyAddAction$1", "actionPerformed"));
                    }
                };
                this.myChildren[1] = new DumbAwareAction(IdeBundle.message((String)"add.shared.scope.action.text", (Object[])new Object[0]), IdeBundle.message((String)"add.shared.scope.action.text", (Object[])new Object[0]), ScopeChooserConfigurable.this.mySharedScopesManager.getIcon()){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        ScopeChooserConfigurable.this.createScope(false, IdeBundle.message((String)"add.scope.dialog.title", (Object[])new Object[0]), null);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/util/scopeChooser/ScopeChooserConfigurable$MyAddAction$2", "actionPerformed"));
                    }
                };
            }
            if (this.myFromPopup) {
                AnAction action = this.myChildren[this.getDefaultIndex()];
                action.getTemplatePresentation().setIcon(IconUtil.getAddIcon());
                AnAction[] anActionArray = new AnAction[]{action};
                if (anActionArray == null) {
                    MyAddAction.$$$reportNull$$$0(1);
                }
                return anActionArray;
            }
            if (this.myChildren == null) {
                MyAddAction.$$$reportNull$$$0(2);
            }
            return this.myChildren;
        }

        public ActionGroup getActionGroup() {
            return this;
        }

        public int getDefaultIndex() {
            TreePath selectionPath = ScopeChooserConfigurable.this.myTree.getSelectionPath();
            if (selectionPath != null) {
                MasterDetailsComponent.MyNode node = (MasterDetailsComponent.MyNode)selectionPath.getLastPathComponent();
                Object editableObject = node.getConfigurable().getEditableObject();
                if (editableObject instanceof NamedScope) {
                    editableObject = ((MasterDetailsComponent.MyNode)node.getParent()).getConfigurable().getEditableObject();
                }
                if (editableObject instanceof NamedScopeManager) {
                    return 0;
                }
                if (editableObject instanceof DependencyValidationManager) {
                    return 1;
                }
            }
            return 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/util/scopeChooser/ScopeChooserConfigurable$MyAddAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/util/scopeChooser/ScopeChooserConfigurable$MyAddAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

