/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.util.projectWizard.CustomStepProjectGenerator;
import com.intellij.ide.util.projectWizard.ProjectSettingsStepBase;
import com.intellij.ide.util.projectWizard.actions.ProjectSpecificAction;
import com.intellij.idea.ActionsBundle;
import com.intellij.internal.statistic.beans.ConvertUsagesUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.platform.DirectoryProjectGenerator;
import com.intellij.platform.HideableProjectGenerator;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.platform.ProjectGeneratorPeer;
import com.intellij.platform.templates.ArchivedTemplatesFactory;
import com.intellij.platform.templates.LocalArchivedTemplate;
import com.intellij.platform.templates.TemplateProjectDirectoryGenerator;
import com.intellij.projectImport.ProjectOpenedCallback;
import com.intellij.util.PairConsumer;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumSet;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractNewProjectStep<T>
extends DefaultActionGroup
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(AbstractNewProjectStep.class);
    private final Customization<T> myCustomization;

    protected AbstractNewProjectStep(@NotNull Customization<T> customization) {
        if (customization == null) {
            AbstractNewProjectStep.$$$reportNull$$$0(0);
        }
        super(null, true);
        this.myCustomization = customization;
        this.updateActions();
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AbstractNewProjectStep.$$$reportNull$$$0(1);
        }
        super.update(e);
        this.updateActions();
    }

    protected void updateActions() {
        this.removeAll();
        AbstractCallback<T> callback2 = this.myCustomization.createCallback();
        ProjectSpecificAction projectSpecificAction = this.myCustomization.createProjectSpecificAction(callback2);
        this.addProjectSpecificAction(projectSpecificAction);
        DirectoryProjectGenerator[] generators = this.myCustomization.getProjectGenerators();
        this.myCustomization.setUpBasicAction(projectSpecificAction, generators);
        this.addAll(this.myCustomization.getActions(generators, callback2));
        if (this.myCustomization.showUserDefinedProjects()) {
            ArchivedTemplatesFactory factory = new ArchivedTemplatesFactory();
            Object[] templates = factory.createTemplates("User-defined", null);
            DirectoryProjectGenerator[] projectGenerators = (DirectoryProjectGenerator[])ContainerUtil.map((Object[])templates, template -> new TemplateProjectDirectoryGenerator((LocalArchivedTemplate)template), (Object[])new DirectoryProjectGenerator[templates.length]);
            this.addAll(this.myCustomization.getActions(projectGenerators, callback2));
        }
        this.addAll(this.myCustomization.getExtraActions(callback2));
    }

    protected void addProjectSpecificAction(@NotNull ProjectSpecificAction projectSpecificAction) {
        if (projectSpecificAction == null) {
            AbstractNewProjectStep.$$$reportNull$$$0(2);
        }
        this.addAll(projectSpecificAction.getChildren(null));
    }

    public static Project doGenerateProject(@Nullable Project projectToClose, @NotNull String locationString, @Nullable DirectoryProjectGenerator generator, @NotNull Object settings) {
        String message;
        int rc;
        File location;
        if (locationString == null) {
            AbstractNewProjectStep.$$$reportNull$$$0(3);
        }
        if (settings == null) {
            AbstractNewProjectStep.$$$reportNull$$$0(4);
        }
        if (!(location = new File(FileUtil.toSystemDependentName((String)locationString))).exists() && !location.mkdirs()) {
            String message2 = ActionsBundle.message((String)"action.NewDirectoryProject.cannot.create.dir", (Object[])new Object[]{location.getAbsolutePath()});
            Messages.showErrorDialog((Project)projectToClose, (String)message2, (String)ActionsBundle.message((String)"action.NewDirectoryProject.title", (Object[])new Object[0]));
            return null;
        }
        VirtualFile baseDir = (VirtualFile)WriteAction.compute(() -> LocalFileSystem.getInstance().refreshAndFindFileByIoFile(location));
        if (baseDir == null) {
            LOG.error("Couldn't find '" + location + "' in VFS");
            return null;
        }
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{baseDir});
        if (baseDir.getChildren().length > 0 && (rc = Messages.showYesNoDialog((Project)projectToClose, (String)(message = ActionsBundle.message((String)"action.NewDirectoryProject.not.empty", (Object[])new Object[]{location.getAbsolutePath()})), (String)ActionsBundle.message((String)"action.NewDirectoryProject.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon())) == 0) {
            return PlatformProjectOpenProcessor.getInstance().doOpenProject(baseDir, null, false);
        }
        String generatorName = generator == null ? "empty" : ConvertUsagesUtil.ensureProperKey(generator.getName());
        RecentProjectsManager.getInstance().setLastProjectCreationLocation(PathUtil.toSystemIndependentName((String)location.getParent()));
        ProjectOpenedCallback callback2 = null;
        if (generator instanceof TemplateProjectDirectoryGenerator) {
            ((TemplateProjectDirectoryGenerator)generator).generateProject(baseDir.getName(), locationString);
        } else {
            callback2 = (p, module) -> {
                if (generator != null) {
                    generator.generateProject(p, baseDir, settings, module);
                }
            };
        }
        EnumSet<PlatformProjectOpenProcessor.Option> options = EnumSet.noneOf(PlatformProjectOpenProcessor.Option.class);
        return PlatformProjectOpenProcessor.doOpenProject(baseDir, projectToClose, -1, callback2, options);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customization";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSpecificAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locationString";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/util/projectWizard/AbstractNewProjectStep";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addProjectSpecificAction";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doGenerateProject";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class AbstractCallback<T>
    implements PairConsumer<ProjectSettingsStepBase<T>, ProjectGeneratorPeer<T>> {
        public void consume(@Nullable ProjectSettingsStepBase<T> settings, @NotNull ProjectGeneratorPeer<T> projectGeneratorPeer) {
            if (projectGeneratorPeer == null) {
                AbstractCallback.$$$reportNull$$$0(0);
            }
            if (settings == null) {
                return;
            }
            IdeFrame frame = IdeFocusManager.getGlobalInstance().getLastFocusedFrame();
            Project projectToClose = frame != null ? frame.getProject() : null;
            DirectoryProjectGenerator<T> generator = settings.getProjectGenerator();
            T actualSettings = projectGeneratorPeer.getSettings();
            AbstractNewProjectStep.doGenerateProject(projectToClose, settings.getProjectLocation(), generator, actualSettings);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectGeneratorPeer", "com/intellij/ide/util/projectWizard/AbstractNewProjectStep$AbstractCallback", "consume"));
        }
    }

    protected static abstract class Customization<T> {
        protected Customization() {
        }

        @NotNull
        protected ProjectSpecificAction createProjectSpecificAction(@NotNull AbstractCallback<T> callback2) {
            if (callback2 == null) {
                Customization.$$$reportNull$$$0(0);
            }
            DirectoryProjectGenerator<T> emptyProjectGenerator = this.createEmptyProjectGenerator();
            ProjectSpecificAction projectSpecificAction = new ProjectSpecificAction(emptyProjectGenerator, this.createProjectSpecificSettingsStep(emptyProjectGenerator, callback2));
            if (projectSpecificAction == null) {
                Customization.$$$reportNull$$$0(1);
            }
            return projectSpecificAction;
        }

        @NotNull
        protected abstract AbstractCallback<T> createCallback();

        @NotNull
        protected abstract DirectoryProjectGenerator<T> createEmptyProjectGenerator();

        @NotNull
        protected abstract ProjectSettingsStepBase<T> createProjectSpecificSettingsStep(@NotNull DirectoryProjectGenerator<T> var1, @NotNull AbstractCallback<T> var2);

        @NotNull
        protected DirectoryProjectGenerator<T>[] getProjectGenerators() {
            DirectoryProjectGenerator[] directoryProjectGeneratorArray = (DirectoryProjectGenerator[])DirectoryProjectGenerator.EP_NAME.getExtensions();
            if (directoryProjectGeneratorArray == null) {
                Customization.$$$reportNull$$$0(2);
            }
            return directoryProjectGeneratorArray;
        }

        public AnAction[] getActions(@NotNull DirectoryProjectGenerator<T>[] generators, @NotNull AbstractCallback<T> callback2) {
            if (generators == null) {
                Customization.$$$reportNull$$$0(3);
            }
            if (callback2 == null) {
                Customization.$$$reportNull$$$0(4);
            }
            ArrayList actions = ContainerUtil.newArrayList();
            for (DirectoryProjectGenerator<T> projectGenerator : generators) {
                try {
                    actions.addAll(ContainerUtil.list((Object[])this.getActions(projectGenerator, callback2)));
                }
                catch (Throwable throwable) {
                    LOG.error("Broken project generator " + projectGenerator, throwable);
                }
            }
            return actions.toArray(AnAction.EMPTY_ARRAY);
        }

        @NotNull
        public AnAction[] getActions(@NotNull DirectoryProjectGenerator<T> generator, @NotNull AbstractCallback<T> callback2) {
            if (generator == null) {
                Customization.$$$reportNull$$$0(5);
            }
            if (callback2 == null) {
                Customization.$$$reportNull$$$0(6);
            }
            if (this.shouldIgnore(generator)) {
                if (AnAction.EMPTY_ARRAY == null) {
                    Customization.$$$reportNull$$$0(7);
                }
                return AnAction.EMPTY_ARRAY;
            }
            ProjectSettingsStepBase step = generator instanceof CustomStepProjectGenerator ? (ProjectSettingsStepBase)((CustomStepProjectGenerator)((Object)generator)).createStep(generator, callback2) : this.createProjectSpecificSettingsStep(generator, callback2);
            ProjectSpecificAction projectSpecificAction = new ProjectSpecificAction(generator, step);
            AnAction[] anActionArray = projectSpecificAction.getChildren(null);
            if (anActionArray == null) {
                Customization.$$$reportNull$$$0(8);
            }
            return anActionArray;
        }

        protected boolean shouldIgnore(@NotNull DirectoryProjectGenerator generator) {
            if (generator == null) {
                Customization.$$$reportNull$$$0(9);
            }
            return generator instanceof HideableProjectGenerator && ((HideableProjectGenerator)((Object)generator)).isHidden();
        }

        @NotNull
        public AnAction[] getExtraActions(@NotNull AbstractCallback<T> callback2) {
            if (callback2 == null) {
                Customization.$$$reportNull$$$0(10);
            }
            if (AnAction.EMPTY_ARRAY == null) {
                Customization.$$$reportNull$$$0(11);
            }
            return AnAction.EMPTY_ARRAY;
        }

        public void setUpBasicAction(@NotNull ProjectSpecificAction projectSpecificAction, @NotNull DirectoryProjectGenerator[] generators) {
            if (projectSpecificAction == null) {
                Customization.$$$reportNull$$$0(12);
            }
            if (generators == null) {
                Customization.$$$reportNull$$$0(13);
            }
        }

        public boolean showUserDefinedProjects() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 7: 
                case 8: 
                case 11: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 7: 
                case 8: 
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callback";
                    break;
                }
                case 1: 
                case 2: 
                case 7: 
                case 8: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/util/projectWizard/AbstractNewProjectStep$Customization";
                    break;
                }
                case 3: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "generators";
                    break;
                }
                case 5: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "generator";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "projectSpecificAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/util/projectWizard/AbstractNewProjectStep$Customization";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createProjectSpecificAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProjectGenerators";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActions";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExtraActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createProjectSpecificAction";
                    break;
                }
                case 1: 
                case 2: 
                case 7: 
                case 8: 
                case 11: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getActions";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "shouldIgnore";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getExtraActions";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "setUpBasicAction";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 7: 
                case 8: 
                case 11: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

