/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.io.File;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiElementModuleRenderer
extends DefaultListCellRenderer {
    private String myText;

    @Override
    public Component getListCellRendererComponent(JList list2, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Component listCellRendererComponent = super.getListCellRendererComponent((JList<?>)list2, (Object)null, index, isSelected, cellHasFocus);
        this.customizeCellRenderer(value, isSelected);
        return listCellRendererComponent;
    }

    @Override
    public String getText() {
        return this.myText;
    }

    private void customizeCellRenderer(Object value, boolean selected) {
        PsiElement element;
        this.myText = "";
        if (value instanceof PsiElement && (element = (PsiElement)value).isValid()) {
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)element.getProject()).getFileIndex();
            VirtualFile vFile = PsiUtilCore.getVirtualFile((PsiElement)element);
            if (vFile != null && fileIndex.isInLibrary(vFile)) {
                this.showLibraryLocation(fileIndex, vFile);
            } else {
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
                if (module != null) {
                    this.showProjectLocation(vFile, module, fileIndex);
                }
            }
        }
        this.setText(this.myText);
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, UIUtil.getListCellHPadding()));
        this.setHorizontalTextPosition(2);
        this.setHorizontalAlignment(4);
        this.setBackground(selected ? UIUtil.getListSelectionBackground() : UIUtil.getListBackground());
        this.setForeground(selected ? UIUtil.getListSelectionForeground() : UIUtil.getInactiveTextColor());
    }

    private void showProjectLocation(@Nullable VirtualFile vFile, @NotNull Module module, @NotNull ProjectFileIndex fileIndex) {
        String path;
        boolean inTestSource;
        if (module == null) {
            PsiElementModuleRenderer.$$$reportNull$$$0(0);
        }
        if (fileIndex == null) {
            PsiElementModuleRenderer.$$$reportNull$$$0(1);
        }
        boolean bl = inTestSource = vFile != null && fileIndex.isInTestSourceContent(vFile);
        this.myText = Registry.is((String)"ide.show.folder.name.instead.of.module.name") ? (StringUtil.isEmpty((String)(path = ModuleUtilCore.getModuleDirPath((Module)module))) ? module.getName() : new File(path).getName()) : module.getName();
        if (inTestSource) {
            this.setIcon(AllIcons.Modules.TestSourceFolder);
        } else {
            this.setIcon(ModuleType.get((Module)module).getIcon());
        }
    }

    private void showLibraryLocation(ProjectFileIndex fileIndex, VirtualFile vFile) {
        this.setIcon(AllIcons.Nodes.PpLibFolder);
        for (OrderEntry order : fileIndex.getOrderEntriesForFile(vFile)) {
            if (!(order instanceof LibraryOrderEntry) && !(order instanceof JdkOrderEntry)) continue;
            this.myText = this.getPresentableName(order, vFile);
            break;
        }
        if (StringUtil.isEmpty((String)this.myText) && Registry.is((String)"index.run.configuration.jre")) {
            for (Sdk sdk : ProjectJdkTable.getInstance().getAllJdks()) {
                Set roots = StreamEx.of((Object[])sdk.getRootProvider().getFiles(OrderRootType.CLASSES)).append((Object[])sdk.getRootProvider().getFiles(OrderRootType.SOURCES)).toSet();
                if (!VfsUtilCore.isUnder((VirtualFile)vFile, (Set)roots)) continue;
                this.myText = "< " + sdk.getName() + " >";
                break;
            }
        }
        this.myText = this.myText.substring(this.myText.lastIndexOf(File.separatorChar) + 1);
        VirtualFile jar = JarFileSystem.getInstance().getVirtualFileForJar(vFile);
        if (jar != null && !this.myText.equals(jar.getName())) {
            this.myText = this.myText + " (" + jar.getName() + ")";
        }
    }

    protected String getPresentableName(OrderEntry order, VirtualFile vFile) {
        return order.getPresentableName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "module";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "fileIndex";
                break;
            }
        }
        objectArray[1] = "com/intellij/ide/util/PsiElementModuleRenderer";
        objectArray[2] = "showProjectLocation";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

