/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.search;

import com.intellij.application.options.SkipSelfSearchComponent;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.ui.search.ComponentHighligtingListener;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.ide.ui.search.PorterStemmerUtil;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.ide.ui.search.SearchableOptionsRegistrarImpl;
import com.intellij.ide.ui.search.TraverseUIHelper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.CompositeConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.MasterDetails;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.basic.BasicComboPopup;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SearchUtil {
    private static final String DEBUGGER_CONFIGURABLE_CLASS = "com.intellij.xdebugger.impl.settings.DebuggerConfigurable";
    private static final Pattern HTML_PATTERN = Pattern.compile("<[^<>]*>");
    private static final Pattern QUOTED = Pattern.compile("\"([^\"]+)\"");
    private static final Pattern NON_WORD_PATTERN = Pattern.compile("[\\W&&[^\\p{Punct}\\p{Blank}]]");
    public static final String HIGHLIGHT_WITH_BORDER = "searchUtil.highlightWithBorder";
    public static final String STYLE_END = "</style>";

    private SearchUtil() {
    }

    public static void processProjectConfigurables(Project project, Map<SearchableConfigurable, Set<OptionDescription>> options) {
        SearchUtil.processConfigurables(ShowSettingsUtilImpl.getConfigurables(project, true), options);
    }

    private static void processConfigurables(@NotNull List<Configurable> configurables, Map<SearchableConfigurable, Set<OptionDescription>> options) {
        if (configurables == null) {
            SearchUtil.$$$reportNull$$$0(0);
        }
        for (Configurable configurable : configurables) {
            if (!(configurable instanceof SearchableConfigurable) || configurable instanceof SearchableConfigurable.Parent && !((SearchableConfigurable.Parent)configurable).isVisible()) continue;
            SearchableConfigurable searchableConfigurable = (SearchableConfigurable)configurable;
            TreeSet<OptionDescription> configurableOptions = new TreeSet<OptionDescription>();
            options.put(searchableConfigurable, configurableOptions);
            for (TraverseUIHelper extension : (TraverseUIHelper[])TraverseUIHelper.helperExtensionPoint.getExtensions()) {
                extension.beforeConfigurable(searchableConfigurable, configurableOptions);
            }
            if (configurable instanceof MasterDetails) {
                MasterDetails md = (MasterDetails)configurable;
                md.initUi();
                SearchUtil.processComponent(searchableConfigurable, configurableOptions, md.getMaster());
                SearchUtil.processComponent(searchableConfigurable, configurableOptions, md.getDetails().getComponent());
            } else {
                SearchUtil.processComponent(searchableConfigurable, configurableOptions, configurable.createComponent());
                Configurable unwrapped = SearchUtil.unwrapConfigurable(configurable);
                if (unwrapped instanceof CompositeConfigurable) {
                    List children2 = ((CompositeConfigurable)unwrapped).getConfigurables();
                    for (UnnamedConfigurable child2 : children2) {
                        JComponent component;
                        TreeSet childConfigurableOptions = new TreeSet();
                        options.put(new SearchableConfigurableAdapter(searchableConfigurable, child2), childConfigurableOptions);
                        if (child2 instanceof SearchableConfigurable) {
                            SearchUtil.processUILabel(((SearchableConfigurable)child2).getDisplayName(), childConfigurableOptions, null);
                        }
                        if ((component = child2.createComponent()) != null) {
                            SearchUtil.processComponent(component, childConfigurableOptions, null);
                        }
                        configurableOptions.removeAll(childConfigurableOptions);
                    }
                }
            }
            for (TraverseUIHelper extension : (TraverseUIHelper[])TraverseUIHelper.helperExtensionPoint.getExtensions()) {
                extension.afterConfigurable(searchableConfigurable, configurableOptions);
            }
        }
    }

    @NotNull
    private static Configurable unwrapConfigurable(@NotNull Configurable configurable) {
        Class clazz;
        Configurable rootConfigurable;
        UnnamedConfigurable wrapped;
        if (configurable == null) {
            SearchUtil.$$$reportNull$$$0(1);
        }
        if (configurable instanceof ConfigurableWrapper && (wrapped = ((ConfigurableWrapper)configurable).getConfigurable()) instanceof SearchableConfigurable) {
            configurable = (Configurable)wrapped;
        }
        if (DEBUGGER_CONFIGURABLE_CLASS.equals(configurable.getClass().getName()) && (rootConfigurable = (Configurable)ReflectionUtil.getField((Class)(clazz = ReflectionUtil.forName((String)DEBUGGER_CONFIGURABLE_CLASS)), (Object)configurable, Configurable.class, (String)"myRootConfigurable")) != null) {
            Configurable configurable2 = rootConfigurable;
            if (configurable2 == null) {
                SearchUtil.$$$reportNull$$$0(2);
            }
            return configurable2;
        }
        Configurable configurable3 = configurable;
        if (configurable3 == null) {
            SearchUtil.$$$reportNull$$$0(3);
        }
        return configurable3;
    }

    private static void processComponent(SearchableConfigurable configurable, Set<? super OptionDescription> configurableOptions, JComponent component) {
        if (component != null) {
            for (TraverseUIHelper extension : (TraverseUIHelper[])TraverseUIHelper.helperExtensionPoint.getExtensions()) {
                extension.beforeComponent(configurable, component, configurableOptions);
            }
            SearchUtil.processUILabel(configurable.getDisplayName(), configurableOptions, null);
            SearchUtil.processComponent(component, configurableOptions, null);
            for (TraverseUIHelper extension : (TraverseUIHelper[])TraverseUIHelper.helperExtensionPoint.getExtensions()) {
                extension.afterComponent(configurable, component, configurableOptions);
            }
        }
    }

    private static void processComponent(JComponent component, Set<? super OptionDescription> configurableOptions, String path) {
        block7: {
            block10: {
                Object tabbedPane;
                block9: {
                    block8: {
                        block6: {
                            String label2;
                            TitledBorder titledBorder;
                            String title;
                            if (component instanceof SkipSelfSearchComponent) {
                                return;
                            }
                            Border border = component.getBorder();
                            if (border instanceof TitledBorder && (title = (titledBorder = (TitledBorder)border).getTitle()) != null) {
                                SearchUtil.processUILabel(title, configurableOptions, path);
                            }
                            if ((label2 = SearchUtil.getLabelFromComponent(component)) == null) break block6;
                            SearchUtil.processUILabel(label2, configurableOptions, path);
                            break block7;
                        }
                        if (!(component instanceof JComboBox)) break block8;
                        List<String> labels = SearchUtil.getItemsFromComboBox((JComboBox)component);
                        for (String each : labels) {
                            SearchUtil.processUILabel(each, configurableOptions, path);
                        }
                        break block7;
                    }
                    if (!(component instanceof JTabbedPane)) break block9;
                    tabbedPane = (JTabbedPane)component;
                    int tabCount = ((JTabbedPane)tabbedPane).getTabCount();
                    for (int i = 0; i < tabCount; ++i) {
                        String title = path != null ? path + '.' + ((JTabbedPane)tabbedPane).getTitleAt(i) : ((JTabbedPane)tabbedPane).getTitleAt(i);
                        SearchUtil.processUILabel(title, configurableOptions, title);
                        Component tabComponent = ((JTabbedPane)tabbedPane).getComponentAt(i);
                        if (!(tabComponent instanceof JComponent)) continue;
                        SearchUtil.processComponent((JComponent)tabComponent, configurableOptions, title);
                    }
                    break block7;
                }
                if (!(component instanceof TabbedPaneWrapper.TabbedPaneHolder)) break block10;
                tabbedPane = ((TabbedPaneWrapper.TabbedPaneHolder)component).getTabbedPaneWrapper();
                int tabCount = ((TabbedPaneWrapper)tabbedPane).getTabCount();
                for (int i = 0; i < tabCount; ++i) {
                    String tabTitle = ((TabbedPaneWrapper)tabbedPane).getTitleAt(i);
                    String title = path != null ? path + '.' + tabTitle : tabTitle;
                    SearchUtil.processUILabel(title, configurableOptions, title);
                    JComponent tabComponent = ((TabbedPaneWrapper)tabbedPane).getComponentAt(i);
                    if (tabComponent == null) continue;
                    SearchUtil.processComponent(tabComponent, configurableOptions, title);
                }
                break block7;
            }
            Component[] components = component.getComponents();
            if (components == null) break block7;
            for (Component child2 : components) {
                if (!(child2 instanceof JComponent)) continue;
                SearchUtil.processComponent((JComponent)child2, configurableOptions, path);
            }
        }
    }

    @Nullable
    private static String getLabelFromComponent(@Nullable Component component) {
        String label2 = null;
        if (component instanceof JLabel) {
            label2 = ((JLabel)component).getText();
        } else if (component instanceof JCheckBox) {
            label2 = ((JCheckBox)component).getText();
        } else if (component instanceof JRadioButton) {
            label2 = ((JRadioButton)component).getText();
        } else if (component instanceof JButton) {
            label2 = ((JButton)component).getText();
        }
        return StringUtil.nullize((String)label2, (boolean)true);
    }

    @NotNull
    private static List<String> getItemsFromComboBox(@NotNull JComboBox comboBox2) {
        DefaultListCellRenderer renderer2;
        if (comboBox2 == null) {
            SearchUtil.$$$reportNull$$$0(4);
        }
        if ((renderer2 = comboBox2.getRenderer()) == null) {
            renderer2 = new DefaultListCellRenderer();
        }
        JList<Object> jList = new BasicComboPopup(comboBox2).getList();
        ArrayList<String> result2 = new ArrayList<String>();
        int count = comboBox2.getItemCount();
        for (int i = 0; i < count; ++i) {
            Object value = comboBox2.getItemAt(i);
            Component labelComponent = renderer2.getListCellRendererComponent(jList, value, i, false, false);
            String label2 = SearchUtil.getLabelFromComponent(labelComponent);
            if (label2 == null) continue;
            result2.add(label2);
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            SearchUtil.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private static void processUILabel(String title, Set<? super OptionDescription> configurableOptions, String path) {
        title = HTML_PATTERN.matcher(title).replaceAll(" ");
        Set words = SearchableOptionsRegistrar.getInstance().getProcessedWordsWithoutStemming(title);
        title = NON_WORD_PATTERN.matcher(title).replaceAll(" ");
        for (String option2 : words) {
            configurableOptions.add((OptionDescription)new OptionDescription(option2, title, path));
        }
    }

    public static void lightOptions(SearchableConfigurable configurable, JComponent component, String option2) {
        if (!SearchUtil.traverseComponentsTree(configurable, component, option2, true)) {
            SearchUtil.traverseComponentsTree(configurable, component, option2, false);
        }
    }

    private static int getSelection(String tabIdx, JTabbedPane tabbedPane) {
        SearchableOptionsRegistrar searchableOptionsRegistrar = SearchableOptionsRegistrar.getInstance();
        for (int i = 0; i < tabbedPane.getTabCount(); ++i) {
            Set pathWords = searchableOptionsRegistrar.getProcessedWords(tabIdx);
            String title = tabbedPane.getTitleAt(i);
            if (!pathWords.isEmpty()) {
                Set titleWords = searchableOptionsRegistrar.getProcessedWords(title);
                pathWords.removeAll(titleWords);
                if (!pathWords.isEmpty()) continue;
                return i;
            }
            if (!tabIdx.equalsIgnoreCase(title)) continue;
            return i;
        }
        return -1;
    }

    public static int getSelection(String tabIdx, TabbedPaneWrapper tabbedPane) {
        SearchableOptionsRegistrar searchableOptionsRegistrar = SearchableOptionsRegistrar.getInstance();
        for (int i = 0; i < tabbedPane.getTabCount(); ++i) {
            Set pathWords = searchableOptionsRegistrar.getProcessedWords(tabIdx);
            String title = tabbedPane.getTitleAt(i);
            Set titleWords = searchableOptionsRegistrar.getProcessedWords(title);
            pathWords.removeAll(titleWords);
            if (!pathWords.isEmpty()) continue;
            return i;
        }
        return -1;
    }

    private static boolean traverseComponentsTree(SearchableConfigurable configurable, JComponent rootComponent, String option2, boolean force) {
        String title;
        Border border;
        int index;
        String path;
        rootComponent.putClientProperty(HIGHLIGHT_WITH_BORDER, null);
        if (option2 == null || option2.trim().length() == 0) {
            return false;
        }
        String label2 = SearchUtil.getLabelFromComponent(rootComponent);
        if (label2 != null) {
            if (SearchUtil.isComponentHighlighted(label2, option2, force, configurable)) {
                SearchUtil.highlightComponent(rootComponent, option2);
                return true;
            }
        } else if (rootComponent instanceof JComboBox) {
            List<String> labels = SearchUtil.getItemsFromComboBox((JComboBox)rootComponent);
            if (ContainerUtil.exists(labels, it -> SearchUtil.isComponentHighlighted(it, option2, force, configurable))) {
                SearchUtil.highlightComponent(rootComponent, option2);
                return true;
            }
        } else if (rootComponent instanceof JTabbedPane) {
            JTabbedPane tabbedPane = (JTabbedPane)rootComponent;
            path = SearchableOptionsRegistrar.getInstance().getInnerPath(configurable, option2);
            if (path != null && (index = SearchUtil.getSelection(path, tabbedPane)) > -1 && index < tabbedPane.getTabCount() && tabbedPane.getTabComponentAt(index) instanceof JComponent) {
                SearchUtil.highlightComponent((JComponent)tabbedPane.getTabComponentAt(index), option2);
            }
        } else if (rootComponent instanceof TabbedPaneWrapper.TabbedPaneHolder) {
            TabbedPaneWrapper tabbedPaneWrapper = ((TabbedPaneWrapper.TabbedPaneHolder)rootComponent).getTabbedPaneWrapper();
            path = SearchableOptionsRegistrar.getInstance().getInnerPath(configurable, option2);
            if (path != null && (index = SearchUtil.getSelection(path, tabbedPaneWrapper)) > -1 && index < tabbedPaneWrapper.getTabCount()) {
                SearchUtil.highlightComponent((JComponent)tabbedPaneWrapper.getTabComponentAt(index), option2);
            }
        }
        if ((border = rootComponent.getBorder()) instanceof TitledBorder && SearchUtil.isComponentHighlighted(title = ((TitledBorder)border).getTitle(), option2, force, configurable)) {
            SearchUtil.highlightComponent(rootComponent, option2);
            rootComponent.putClientProperty(HIGHLIGHT_WITH_BORDER, Boolean.TRUE);
            return true;
        }
        boolean highlight = false;
        for (Component component : rootComponent.getComponents()) {
            if (!(component instanceof JComponent) || !SearchUtil.traverseComponentsTree(configurable, (JComponent)component, option2, force)) continue;
            highlight = true;
        }
        return highlight;
    }

    private static void highlightComponent(@NotNull JComponent rootComponent, @NotNull String searchString) {
        if (rootComponent == null) {
            SearchUtil.$$$reportNull$$$0(6);
        }
        if (searchString == null) {
            SearchUtil.$$$reportNull$$$0(7);
        }
        ((ComponentHighligtingListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(ComponentHighligtingListener.TOPIC)).highlight(rootComponent, searchString);
    }

    public static boolean isComponentHighlighted(String text, String option2, boolean force, SearchableConfigurable configurable) {
        Set options;
        if (text == null || option2 == null || option2.length() == 0) {
            return false;
        }
        SearchableOptionsRegistrar searchableOptionsRegistrar = SearchableOptionsRegistrar.getInstance();
        Set words = searchableOptionsRegistrar.getProcessedWords(option2);
        Set set2 = options = configurable != null ? searchableOptionsRegistrar.replaceSynonyms(words, configurable) : words;
        if (options == null || options.isEmpty()) {
            return text.toLowerCase(Locale.US).contains(option2.toLowerCase(Locale.US));
        }
        Set tokens = searchableOptionsRegistrar.getProcessedWords(text);
        if (!force) {
            options.retainAll(tokens);
            boolean highlight = !options.isEmpty();
            return highlight || text.toLowerCase(Locale.US).contains(option2.toLowerCase(Locale.US));
        }
        options.removeAll(tokens);
        return options.isEmpty();
    }

    public static String markup(@NotNull String textToMarkup, @Nullable String filter) {
        String foot;
        String head;
        if (textToMarkup == null) {
            SearchUtil.$$$reportNull$$$0(8);
        }
        if (filter == null || filter.length() == 0) {
            return textToMarkup;
        }
        int bodyStart = textToMarkup.indexOf("<body>");
        int bodyEnd = textToMarkup.indexOf("</body>");
        if (bodyStart >= 0) {
            head = textToMarkup.substring(0, bodyStart += "<body>".length());
            foot = bodyEnd >= 0 ? textToMarkup.substring(bodyEnd) : "";
            textToMarkup = textToMarkup.substring(bodyStart, bodyEnd);
        } else {
            foot = "";
            head = "";
        }
        Pattern insideHtmlTagPattern = Pattern.compile("[<[^<>]*>]*<[^<>]*");
        SearchableOptionsRegistrar registrar = SearchableOptionsRegistrar.getInstance();
        HashSet quoted = new HashSet();
        filter = SearchUtil.processFilter(SearchUtil.quoteStrictOccurrences(textToMarkup, filter), quoted);
        Set options = registrar.getProcessedWords(filter);
        Set words = registrar.getProcessedWords(textToMarkup);
        for (String option2 : options) {
            if (!words.contains(option2)) continue;
            textToMarkup = SearchUtil.markup(textToMarkup, insideHtmlTagPattern, option2);
        }
        for (String stripped : quoted) {
            if (registrar.isStopWord(stripped)) continue;
            textToMarkup = SearchUtil.markup(textToMarkup, insideHtmlTagPattern, stripped);
        }
        return head + textToMarkup + foot;
    }

    private static String quoteStrictOccurrences(String textToMarkup, String filter) {
        StringBuilder cur = new StringBuilder();
        String s = textToMarkup.toLowerCase(Locale.US);
        for (String part : filter.split(" ")) {
            if (s.contains(part)) {
                cur.append("\"").append(part).append("\" ");
                continue;
            }
            cur.append(part).append(" ");
        }
        return cur.toString();
    }

    private static String markup(String textToMarkup, Pattern insideHtmlTagPattern, String option2) {
        int styleIdx = textToMarkup.indexOf("<style");
        int styleEndIdx = textToMarkup.indexOf(STYLE_END);
        if (styleIdx < 0 || styleEndIdx < 0) {
            return SearchUtil.markupInText(textToMarkup, insideHtmlTagPattern, option2);
        }
        return SearchUtil.markup(textToMarkup.substring(0, styleIdx), insideHtmlTagPattern, option2) + SearchUtil.markup(textToMarkup.substring(styleEndIdx + STYLE_END.length()), insideHtmlTagPattern, option2);
    }

    private static String markupInText(String textToMarkup, Pattern insideHtmlTagPattern, String option2) {
        int idx;
        StringBuilder result2 = new StringBuilder();
        int beg = 0;
        while ((idx = StringUtil.indexOfIgnoreCase((String)textToMarkup, (String)option2, (int)beg)) != -1) {
            String prefix = textToMarkup.substring(beg, idx);
            String toMark = textToMarkup.substring(idx, idx + option2.length());
            if (insideHtmlTagPattern.matcher(prefix).matches()) {
                int lastIdx = textToMarkup.indexOf(">", idx);
                result2.append(prefix).append(textToMarkup, idx, lastIdx + 1);
                beg = lastIdx + 1;
                continue;
            }
            result2.append(prefix).append("<font color='#ffffff' bgColor='#1d5da7'>").append(toMark).append("</font>");
            beg = idx + option2.length();
        }
        result2.append(textToMarkup.substring(beg));
        return result2.toString();
    }

    public static void appendFragments(String filter, String text, @SimpleTextAttributes.StyleAttributeConstant int style, Color foreground, Color background, SimpleColoredComponent textRenderer) {
        if (text == null) {
            return;
        }
        if (filter == null || filter.length() == 0) {
            textRenderer.append(text, new SimpleTextAttributes(background, foreground, (Color)JBColor.RED, style));
        } else {
            HashSet quoted = new HashSet();
            filter = SearchUtil.processFilter(SearchUtil.quoteStrictOccurrences(text, filter), quoted);
            TreeMap<Integer, String> indx = new TreeMap<Integer, String>();
            for (String stripped : quoted) {
                int idx;
                int beg = 0;
                while ((idx = StringUtil.indexOfIgnoreCase((String)text, (String)stripped, (int)beg)) != -1) {
                    indx.put(idx, text.substring(idx, idx + stripped.length()));
                    beg = idx + stripped.length();
                }
            }
            ArrayList<String> selectedWords = new ArrayList<String>();
            int pos = 0;
            for (Integer index : indx.keySet()) {
                String stripped = (String)indx.get(index);
                int start2 = index;
                if (pos > start2) {
                    String highlighted = (String)selectedWords.get(selectedWords.size() - 1);
                    if (highlighted.length() >= stripped.length()) continue;
                    selectedWords.remove(highlighted);
                }
                SearchUtil.appendSelectedWords(text, selectedWords, pos, start2, filter);
                selectedWords.add(stripped);
                pos = start2 + stripped.length();
            }
            SearchUtil.appendSelectedWords(text, selectedWords, pos, text.length(), filter);
            int idx = 0;
            for (String word : selectedWords) {
                String before = (text = text.substring(idx)).substring(0, text.indexOf(word));
                if (before.length() > 0) {
                    textRenderer.append(before, new SimpleTextAttributes(background, foreground, null, style));
                }
                idx = text.indexOf(word) + word.length();
                textRenderer.append(text.substring(idx - word.length(), idx), new SimpleTextAttributes(background, foreground, null, style | 0x40));
            }
            String after = text.substring(idx);
            if (after.length() > 0) {
                textRenderer.append(after, new SimpleTextAttributes(background, foreground, null, style));
            }
        }
    }

    private static void appendSelectedWords(String text, List<? super String> selectedWords, int pos, int end, String filter) {
        if (pos < end) {
            String[] words;
            Set filters = SearchableOptionsRegistrar.getInstance().getProcessedWords(filter);
            for (String word : words = text.substring(pos, end).split("[\\W&&[^-]]+")) {
                if (!filters.contains(PorterStemmerUtil.stem(word.toLowerCase(Locale.US)))) continue;
                selectedWords.add(word);
            }
        }
    }

    public static List<Set<String>> findKeys(String filter, Set<? super String> quoted) {
        filter = SearchUtil.processFilter(filter.toLowerCase(Locale.US), quoted);
        ArrayList<Set<String>> keySetList = new ArrayList<Set<String>>();
        SearchableOptionsRegistrar optionsRegistrar = SearchableOptionsRegistrar.getInstance();
        Set words = optionsRegistrar.getProcessedWords(filter);
        for (String word : words) {
            Set<OptionDescription> descriptions = ((SearchableOptionsRegistrarImpl)optionsRegistrar).getAcceptableDescriptions(word);
            HashSet<String> keySet = new HashSet<String>();
            if (descriptions != null) {
                for (OptionDescription description : descriptions) {
                    keySet.add(description.getPath());
                }
            }
            keySetList.add(keySet);
        }
        if (keySetList.isEmpty() && !StringUtil.isEmptyOrSpaces((String)filter)) {
            keySetList.add(Collections.singleton(filter));
        }
        return keySetList;
    }

    public static String processFilter(String filter, Set<? super String> quoted) {
        StringBuilder withoutQuoted = new StringBuilder();
        int beg = 0;
        Matcher matcher = QUOTED.matcher(filter);
        while (matcher.find()) {
            int start2 = matcher.start(1);
            withoutQuoted.append(" ").append(filter, beg, start2);
            beg = matcher.end(1);
            String trimmed = filter.substring(start2, beg).trim();
            if (trimmed.length() <= 0) continue;
            quoted.add(trimmed);
        }
        return withoutQuoted + " " + filter.substring(beg);
    }

    public static List<Configurable> expand(ConfigurableGroup[] groups) {
        ArrayList<Configurable> result2 = new ArrayList<Configurable>();
        for (ConfigurableGroup eachGroup : groups) {
            result2.addAll(SearchUtil.expandGroup(eachGroup));
        }
        return result2;
    }

    public static List<Configurable> expandGroup(ConfigurableGroup group) {
        Object[] configurables = group.getConfigurables();
        ArrayList result2 = new ArrayList();
        ContainerUtil.addAll(result2, (Object[])configurables);
        for (Object each : configurables) {
            SearchUtil.addChildren((Configurable)each, result2);
        }
        return ContainerUtil.filter(result2, configurable -> !(configurable instanceof SearchableConfigurable.Parent) || ((SearchableConfigurable.Parent)configurable).isVisible());
    }

    private static void addChildren(Configurable configurable, List<? super Configurable> list2) {
        if (configurable instanceof Configurable.Composite) {
            Configurable[] kids;
            for (Configurable eachKid : kids = ((Configurable.Composite)configurable).getConfigurables()) {
                list2.add((Configurable)eachKid);
                SearchUtil.addChildren(eachKid, list2);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurables";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/ui/search/SearchUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comboBox";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootComponent";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchString";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textToMarkup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/ui/search/SearchUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapConfigurable";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemsFromComboBox";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processConfigurables";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "unwrapConfigurable";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getItemsFromComboBox";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "highlightComponent";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "markup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class SearchableConfigurableAdapter
    implements SearchableConfigurable {
        private final SearchableConfigurable myOriginal;
        private final UnnamedConfigurable myDelegate;

        private SearchableConfigurableAdapter(@NotNull SearchableConfigurable original, @NotNull UnnamedConfigurable delegate) {
            if (original == null) {
                SearchableConfigurableAdapter.$$$reportNull$$$0(0);
            }
            if (delegate == null) {
                SearchableConfigurableAdapter.$$$reportNull$$$0(1);
            }
            this.myOriginal = original;
            this.myDelegate = delegate;
        }

        @NotNull
        public String getId() {
            String string = this.myOriginal.getId();
            if (string == null) {
                SearchableConfigurableAdapter.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Title)
        public String getDisplayName() {
            return this.myOriginal.getDisplayName();
        }

        @NotNull
        public Class<?> getOriginalClass() {
            Class clazz = this.myDelegate instanceof SearchableConfigurable ? ((SearchableConfigurable)this.myDelegate).getOriginalClass() : this.myDelegate.getClass();
            if (clazz == null) {
                SearchableConfigurableAdapter.$$$reportNull$$$0(3);
            }
            return clazz;
        }

        @Nullable
        public JComponent createComponent() {
            return null;
        }

        public boolean isModified() {
            return false;
        }

        public void apply() {
        }

        public String toString() {
            return this.getDisplayName();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/ui/search/SearchUtil$SearchableConfigurableAdapter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/ui/search/SearchUtil$SearchableConfigurableAdapter";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getId";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOriginalClass";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

