/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.CopyPasteUtil;
import com.intellij.ide.bookmarks.Bookmark;
import com.intellij.ide.bookmarks.BookmarksListener;
import com.intellij.ide.projectView.ProjectViewPsiTreeChangeListener;
import com.intellij.ide.projectView.impl.AbstractProjectTreeStructure;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.ProjectViewFileVisitor;
import com.intellij.ide.projectView.impl.ProjectViewNodeVisitor;
import com.intellij.ide.projectView.impl.ProjectViewPaneSelectionHelper;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.AbstractTreeUpdater;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.ProblemListener;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.RestoreSelectionListener;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.tree.TreeCollector;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.ui.tree.project.ProjectFileNode;
import com.intellij.ui.tree.project.ProjectFileNodeUpdater;
import com.intellij.util.SmartList;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;

class AsyncProjectViewSupport {
    private static final Logger LOG = Logger.getInstance(AsyncProjectViewSupport.class);
    private final ProjectFileNodeUpdater myNodeUpdater;
    private final StructureTreeModel myStructureTreeModel;
    private final AsyncTreeModel myAsyncTreeModel;

    AsyncProjectViewSupport(@NotNull Disposable parent, final @NotNull Project project, @NotNull JTree tree, final @NotNull AbstractTreeStructure structure, @NotNull Comparator<NodeDescriptor> comparator2) {
        if (parent == null) {
            AsyncProjectViewSupport.$$$reportNull$$$0(0);
        }
        if (project == null) {
            AsyncProjectViewSupport.$$$reportNull$$$0(1);
        }
        if (tree == null) {
            AsyncProjectViewSupport.$$$reportNull$$$0(2);
        }
        if (structure == null) {
            AsyncProjectViewSupport.$$$reportNull$$$0(3);
        }
        if (comparator2 == null) {
            AsyncProjectViewSupport.$$$reportNull$$$0(4);
        }
        this.myStructureTreeModel = new StructureTreeModel<AbstractTreeStructure>(structure, comparator2);
        this.myAsyncTreeModel = new AsyncTreeModel((TreeModel)((Object)this.myStructureTreeModel), parent);
        this.myAsyncTreeModel.setRootImmediately(this.myStructureTreeModel.getRootImmediately());
        this.myNodeUpdater = new ProjectFileNodeUpdater(project, this.myStructureTreeModel.getInvoker()){

            /*
             * WARNING - void declaration
             */
            @Override
            protected void updateStructure(boolean fromRoot, @NotNull Set<? extends VirtualFile> updatedFiles) {
                if (updatedFiles == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (fromRoot) {
                    AsyncProjectViewSupport.this.updateAll(null);
                } else {
                    long time = System.currentTimeMillis();
                    LOG.debug("found ", new Object[]{updatedFiles.size(), " changed files"});
                    TreeCollector<VirtualFile> collector = TreeCollector.createFileRootsCollector();
                    for (VirtualFile virtualFile : updatedFiles) {
                        void var7_6;
                        if (!virtualFile.isDirectory()) {
                            VirtualFile virtualFile2 = virtualFile.getParent();
                        }
                        if (var7_6 == null || ProjectFileNode.findArea((VirtualFile)var7_6, project) == null) continue;
                        collector.add((VirtualFile)var7_6);
                    }
                    List<VirtualFile> roots = collector.get();
                    LOG.debug("found ", new Object[]{roots.size(), " roots in ", System.currentTimeMillis() - time, "ms"});
                    AsyncProjectViewSupport.this.myStructureTreeModel.getInvoker().runOrInvokeLater(() -> roots.forEach(root -> AsyncProjectViewSupport.this.updateByFile((VirtualFile)root, true)));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updatedFiles", "com/intellij/ide/projectView/impl/AsyncProjectViewSupport$1", "updateStructure"));
            }
        };
        AsyncProjectViewSupport.setModel(tree, this.myAsyncTreeModel);
        MessageBusConnection connection = project.getMessageBus().connect(parent);
        connection.subscribe(BookmarksListener.TOPIC, (Object)new BookmarksListener(){

            @Override
            public void bookmarkAdded(@NotNull Bookmark bookmark) {
                if (bookmark == null) {
                    2.$$$reportNull$$$0(0);
                }
                AsyncProjectViewSupport.this.updateByFile(bookmark.getFile(), false);
            }

            @Override
            public void bookmarkRemoved(@NotNull Bookmark bookmark) {
                if (bookmark == null) {
                    2.$$$reportNull$$$0(1);
                }
                AsyncProjectViewSupport.this.updateByFile(bookmark.getFile(), false);
            }

            @Override
            public void bookmarkChanged(@NotNull Bookmark bookmark) {
                if (bookmark == null) {
                    2.$$$reportNull$$$0(2);
                }
                AsyncProjectViewSupport.this.updateByFile(bookmark.getFile(), false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "bookmark";
                objectArray2[1] = "com/intellij/ide/projectView/impl/AsyncProjectViewSupport$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "bookmarkAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "bookmarkRemoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "bookmarkChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        PsiManager.getInstance((Project)project).addPsiTreeChangeListener((PsiTreeChangeListener)new ProjectViewPsiTreeChangeListener(project){

            @Override
            protected boolean isFlattenPackages() {
                return structure instanceof AbstractProjectTreeStructure && ((AbstractProjectTreeStructure)structure).isFlattenPackages();
            }

            @Override
            protected AbstractTreeUpdater getUpdater() {
                return null;
            }

            @Override
            protected DefaultMutableTreeNode getRootNode() {
                return null;
            }

            @Override
            protected void addSubtreeToUpdateByRoot() {
                AsyncProjectViewSupport.this.myNodeUpdater.updateFromRoot();
            }

            @Override
            protected boolean addSubtreeToUpdateByElement(@NotNull PsiElement element) {
                VirtualFile file2;
                if (element == null) {
                    3.$$$reportNull$$$0(0);
                }
                if ((file2 = PsiUtilCore.getVirtualFile((PsiElement)element)) != null) {
                    AsyncProjectViewSupport.this.myNodeUpdater.updateFromFile(file2);
                } else {
                    AsyncProjectViewSupport.this.updateByElement(element, true);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ide/projectView/impl/AsyncProjectViewSupport$3", "addSubtreeToUpdateByElement"));
            }
        }, parent);
        FileStatusManager.getInstance((Project)project).addFileStatusListener(new FileStatusListener(){

            public void fileStatusesChanged() {
                AsyncProjectViewSupport.this.updateAllPresentations();
            }

            public void fileStatusChanged(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                AsyncProjectViewSupport.this.updateByFile(file2, false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/projectView/impl/AsyncProjectViewSupport$4", "fileStatusChanged"));
            }
        }, parent);
        CopyPasteUtil.addDefaultListener(parent, element -> this.updateByElement((PsiElement)element, false));
        project.getMessageBus().connect(parent).subscribe(ProblemListener.TOPIC, (Object)new ProblemListener(){

            public void problemsAppeared(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    5.$$$reportNull$$$0(0);
                }
                AsyncProjectViewSupport.this.updatePresentationsFromRootTo(file2);
            }

            public void problemsDisappeared(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    5.$$$reportNull$$$0(1);
                }
                AsyncProjectViewSupport.this.updatePresentationsFromRootTo(file2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "file";
                objectArray2[1] = "com/intellij/ide/projectView/impl/AsyncProjectViewSupport$5";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "problemsAppeared";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "problemsDisappeared";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void setComparator(@NotNull Comparator<? super NodeDescriptor> comparator2) {
        if (comparator2 == null) {
            AsyncProjectViewSupport.$$$reportNull$$$0(5);
        }
        this.myStructureTreeModel.setComparator(comparator2);
    }

    public void select(JTree tree, Object object, VirtualFile file2) {
        if (object instanceof AbstractTreeNode) {
            AbstractTreeNode node = (AbstractTreeNode)object;
            object = node.getValue();
            LOG.debug("select AbstractTreeNode");
        }
        PsiElement element = object instanceof PsiElement ? (PsiElement)object : null;
        LOG.debug("select object: ", new Object[]{object, " in file: ", file2});
        SmartList pathsToSelect = new SmartList();
        TreeVisitor visitor = AbstractProjectViewPane.createVisitor(element, file2, (List<? super TreePath>)pathsToSelect);
        if (visitor != null) {
            this.myNodeUpdater.updateImmediately(() -> TreeState.expand((JTree)tree, promise -> this.myAsyncTreeModel.accept(visitor).onProcessed(path -> {
                if (AsyncProjectViewSupport.selectPaths(tree, (List<TreePath>)pathsToSelect, visitor) || element == null || file2 == null || Registry.is((String)"async.project.view.support.extra.select.disabled")) {
                    promise.setResult(null);
                } else {
                    pathsToSelect.clear();
                    TreeVisitor fileVisitor = AbstractProjectViewPane.createVisitor(null, file2, (List<? super TreePath>)pathsToSelect);
                    this.myAsyncTreeModel.accept(fileVisitor).onProcessed(path2 -> {
                        AsyncProjectViewSupport.selectPaths(tree, (List<TreePath>)pathsToSelect, fileVisitor);
                        promise.setResult(null);
                    });
                }
            })));
        }
    }

    private static boolean selectPaths(@NotNull JTree tree, @NotNull List<TreePath> paths, @NotNull TreeVisitor visitor) {
        if (tree == null) {
            AsyncProjectViewSupport.$$$reportNull$$$0(6);
        }
        if (paths == null) {
            AsyncProjectViewSupport.$$$reportNull$$$0(7);
        }
        if (visitor == null) {
            AsyncProjectViewSupport.$$$reportNull$$$0(8);
        }
        if (paths.isEmpty()) {
            return false;
        }
        if (paths.size() > 1) {
            if (visitor instanceof ProjectViewNodeVisitor) {
                ProjectViewNodeVisitor nodeVisitor = (ProjectViewNodeVisitor)visitor;
                return AsyncProjectViewSupport.selectPaths(tree, new ProjectViewPaneSelectionHelper.SelectionDescriptor((PsiElement)nodeVisitor.getElement(), nodeVisitor.getFile(), paths));
            }
            if (visitor instanceof ProjectViewFileVisitor) {
                ProjectViewFileVisitor fileVisitor = (ProjectViewFileVisitor)visitor;
                return AsyncProjectViewSupport.selectPaths(tree, new ProjectViewPaneSelectionHelper.SelectionDescriptor(null, (VirtualFile)fileVisitor.getElement(), paths));
            }
        }
        TreePath path = paths.get(0);
        tree.expandPath(path);
        TreeUtil.selectPath((JTree)tree, (TreePath)path);
        return true;
    }

    private static boolean selectPaths(@NotNull JTree tree, @NotNull ProjectViewPaneSelectionHelper.SelectionDescriptor selectionDescriptor) {
        if (tree == null) {
            AsyncProjectViewSupport.$$$reportNull$$$0(9);
        }
        if (selectionDescriptor == null) {
            AsyncProjectViewSupport.$$$reportNull$$$0(10);
        }
        List<? extends TreePath> adjustedPaths = ProjectViewPaneSelectionHelper.getAdjustedPaths(selectionDescriptor);
        adjustedPaths.forEach(it -> tree.expandPath((TreePath)it));
        TreeUtil.selectPaths((JTree)tree, adjustedPaths);
        return true;
    }

    public void updateAll(Runnable onDone) {
        LOG.debug((Throwable)new RuntimeException("reload a whole tree"));
        Promise<?> promise = this.myStructureTreeModel.invalidate();
        if (onDone != null) {
            promise.onSuccess(res2 -> this.myAsyncTreeModel.onValidThread(onDone));
        }
    }

    public void update(@NotNull TreePath path, boolean structure) {
        if (path == null) {
            AsyncProjectViewSupport.$$$reportNull$$$0(11);
        }
        this.myStructureTreeModel.invalidate(path, structure);
    }

    public void update(@NotNull List<? extends TreePath> list2, boolean structure) {
        if (list2 == null) {
            AsyncProjectViewSupport.$$$reportNull$$$0(12);
        }
        for (TreePath treePath : list2) {
            this.update(treePath, structure);
        }
    }

    public void updateByFile(@NotNull VirtualFile file2, boolean structure) {
        if (file2 == null) {
            AsyncProjectViewSupport.$$$reportNull$$$0(13);
        }
        LOG.debug(structure ? "updateChildrenByFile: " : "updatePresentationByFile: ", new Object[]{file2});
        this.update(null, file2, structure);
    }

    public void updateByElement(@NotNull PsiElement element, boolean structure) {
        if (element == null) {
            AsyncProjectViewSupport.$$$reportNull$$$0(14);
        }
        LOG.debug(structure ? "updateChildrenByElement: " : "updatePresentationByElement: ", new Object[]{element});
        this.update(element, null, structure);
    }

    private void update(PsiElement element, VirtualFile file2, boolean structure) {
        SmartList list2 = new SmartList();
        TreeVisitor visitor = AbstractProjectViewPane.createVisitor(element, file2, (List<? super TreePath>)list2);
        if (visitor != null) {
            this.acceptAndUpdate(visitor, (List<? extends TreePath>)list2, structure);
        }
    }

    private void acceptAndUpdate(@NotNull TreeVisitor visitor, List<? extends TreePath> list2, boolean structure) {
        if (visitor == null) {
            AsyncProjectViewSupport.$$$reportNull$$$0(15);
        }
        this.myAsyncTreeModel.accept(visitor, false).onSuccess(path -> this.update(list2, structure));
    }

    private void updatePresentationsFromRootTo(@NotNull VirtualFile file2) {
        if (file2 == null) {
            AsyncProjectViewSupport.$$$reportNull$$$0(16);
        }
        while (!file2.isValid()) {
            if ((file2 = file2.getParent()) != null) continue;
            return;
        }
        SmartList structures = new SmartList();
        final SmartList presentations = new SmartList();
        this.myAsyncTreeModel.accept(new ProjectViewFileVisitor(file2, arg_0 -> ((SmartList)structures).add(arg_0)){

            @Override
            @NotNull
            protected TreeVisitor.Action visit(@NotNull TreePath path, @NotNull AbstractTreeNode node, @NotNull VirtualFile element) {
                TreeVisitor.Action action;
                if (path == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (node == null) {
                    6.$$$reportNull$$$0(1);
                }
                if (element == null) {
                    6.$$$reportNull$$$0(2);
                }
                if ((action = super.visit(path, node, element)) == TreeVisitor.Action.CONTINUE) {
                    presentations.add((Object)path);
                }
                TreeVisitor.Action action2 = action;
                if (action2 == null) {
                    6.$$$reportNull$$$0(3);
                }
                return action2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "path";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/projectView/impl/AsyncProjectViewSupport$6";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/projectView/impl/AsyncProjectViewSupport$6";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visit";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visit";
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, false).onSuccess(path -> {
            this.update((List<? extends TreePath>)presentations, false);
            this.update((List<? extends TreePath>)structures, true);
        });
    }

    private void updateAllPresentations() {
        final SmartList list2 = new SmartList();
        this.acceptAndUpdate(new TreeVisitor(){

            @NotNull
            public TreeVisitor.Action visit(@NotNull TreePath path) {
                if (path == null) {
                    7.$$$reportNull$$$0(0);
                }
                list2.add((Object)path);
                TreeVisitor.Action action = TreeVisitor.Action.CONTINUE;
                if (action == null) {
                    7.$$$reportNull$$$0(1);
                }
                return action;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "path";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/projectView/impl/AsyncProjectViewSupport$7";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/projectView/impl/AsyncProjectViewSupport$7";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visit";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visit";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, (List<? extends TreePath>)list2, false);
    }

    private static void setModel(@NotNull JTree tree, @NotNull AsyncTreeModel model) {
        if (tree == null) {
            AsyncProjectViewSupport.$$$reportNull$$$0(17);
        }
        if (model == null) {
            AsyncProjectViewSupport.$$$reportNull$$$0(18);
        }
        RestoreSelectionListener listener2 = new RestoreSelectionListener();
        tree.addTreeSelectionListener(listener2);
        tree.setModel((TreeModel)((Object)model));
        Disposer.register((Disposable)model, () -> {
            tree.setModel(null);
            tree.removeTreeSelectionListener(listener2);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structure";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionDescriptor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/projectView/impl/AsyncProjectViewSupport";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "setComparator";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "selectPaths";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "updateByFile";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "updateByElement";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "acceptAndUpdate";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "updatePresentationsFromRootTo";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "setModel";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

