/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.ide.plugins.newui.SearchPopupCallback;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindow;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.Consumer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import org.jetbrains.annotations.NotNull;

public class SearchPopup
implements CaretListener {
    public final Type type;
    private final JBPopupListener myListener;
    private final JBTextField myEditor;
    private JBPopup myPopup;
    private LightweightWindowEvent myEvent;
    public final CollectionListModel<Object> model;
    public JList<Object> list;
    public int caretPosition;
    public SearchPopupCallback callback;
    public boolean skipCaretEvent;
    public Object data;

    public SearchPopup(@NotNull SearchTextField searchTextField, @NotNull JBPopupListener listener2, @NotNull Type type, @NotNull CollectionListModel<Object> model, int caretPosition) {
        if (searchTextField == null) {
            SearchPopup.$$$reportNull$$$0(0);
        }
        if (listener2 == null) {
            SearchPopup.$$$reportNull$$$0(1);
        }
        if (type == null) {
            SearchPopup.$$$reportNull$$$0(2);
        }
        if (model == null) {
            SearchPopup.$$$reportNull$$$0(3);
        }
        this.myEditor = searchTextField.getTextEditor();
        this.myListener = listener2;
        this.type = type;
        this.model = model;
        this.caretPosition = caretPosition;
    }

    public void createAndShow(@NotNull Consumer callback2, @NotNull ColoredListCellRenderer renderer2, boolean async) {
        if (callback2 == null) {
            SearchPopup.$$$reportNull$$$0(4);
        }
        if (renderer2 == null) {
            SearchPopup.$$$reportNull$$$0(5);
        }
        if (callback2 instanceof SearchPopupCallback) {
            this.callback = (SearchPopupCallback)callback2;
        }
        Insets ipad = renderer2.getIpad();
        ipad.left = ipad.right = SearchPopup.getXOffset();
        renderer2.setFont(this.myEditor.getFont());
        this.list = new JBList(this.model);
        this.myPopup = JBPopupFactory.getInstance().createListPopupBuilder((JList)this.list).setMovable(false).setResizable(false).setRequestFocus(false).setItemChosenCallback(callback2).setFont(this.myEditor.getFont()).setRenderer((ListCellRenderer)renderer2).createPopup();
        this.myEvent = new LightweightWindowEvent((LightweightWindow)this.myPopup);
        this.skipCaretEvent = true;
        this.myPopup.addListener(this.myListener);
        this.myEditor.addCaretListener((CaretListener)this);
        if (async) {
            SwingUtilities.invokeLater(this::show);
        } else {
            this.show();
        }
    }

    private static int getXOffset() {
        return JBUI.scale((int)(UIUtil.isUnderWin10LookAndFeel() ? 5 : UIUtil.getListCellHPadding()));
    }

    @NotNull
    private Point getPopupLocation() {
        Point location;
        try {
            Rectangle view = this.myEditor.modelToView(this.caretPosition);
            location = new Point((int)view.getMaxX(), (int)view.getMaxY());
        }
        catch (BadLocationException ignore) {
            location = this.myEditor.getCaret().getMagicCaretPosition();
        }
        SwingUtilities.convertPointToScreen(location, (Component)this.myEditor);
        location.x -= SearchPopup.getXOffset() + JBUI.scale((int)2);
        location.y += 2;
        Point point = location;
        if (point == null) {
            SearchPopup.$$$reportNull$$$0(6);
        }
        return point;
    }

    public boolean isValid() {
        return this.myPopup.isVisible() && this.myPopup.getContent().getParent() != null;
    }

    public void update() {
        this.skipCaretEvent = true;
        this.myPopup.setLocation(this.getPopupLocation());
        this.myPopup.pack(true, true);
    }

    private void show() {
        if (this.myPopup != null) {
            this.list.clearSelection();
            this.myPopup.showInScreenCoordinates((Component)this.myEditor, this.getPopupLocation());
        }
    }

    public void hide() {
        this.myEditor.removeCaretListener((CaretListener)this);
        if (this.myPopup != null) {
            this.myPopup.cancel();
            this.myPopup = null;
        }
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        if (this.skipCaretEvent) {
            this.skipCaretEvent = false;
        } else {
            this.hide();
            this.myListener.onClosed(this.myEvent);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchTextField";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/newui/SearchPopup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/newui/SearchPopup";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPopupLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createAndShow";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Type {
        AttributeName,
        AttributeValue,
        SearchQuery;

    }
}

