/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class RepositoryContentHandler
extends DefaultHandler {
    private static final String CATEGORY = "category";
    private static final String PLUGIN = "plugin";
    private static final String IDEA_PLUGIN = "idea-plugin";
    private static final String NAME = "name";
    private static final String ID = "id";
    private static final String DESCRIPTION = "description";
    private static final String VERSION = "version";
    private static final String VENDOR = "vendor";
    private static final String EMAIL = "email";
    private static final String URL = "url";
    private static final String IDEA_VERSION = "idea-version";
    private static final String SINCE_BUILD = "since-build";
    private static final String UNTIL_BUILD = "until-build";
    private static final String CHANGE_NOTES = "change-notes";
    private static final String DEPENDS = "depends";
    private static final String DOWNLOADS = "downloads";
    private static final String DOWNLOAD_URL = "downloadUrl";
    private static final String DOWNLOAD_URL_NEW_STYLE = "download-url";
    private static final String SIZE = "size";
    private static final String RATING = "rating";
    private static final String DATE = "date";
    private static final String PLUGIN_UPDATED_DATE = "updatedDate";
    private static final String TAGS = "tags";
    private final StringBuilder currentValue = new StringBuilder();
    private PluginNode currentPlugin;
    private List<IdeaPluginDescriptor> plugins;
    private Stack<String> categories;
    private String categoryName;

    RepositoryContentHandler() {
    }

    @NotNull
    public List<IdeaPluginDescriptor> getPluginsList() {
        List<Object> list2 = this.plugins != null ? this.plugins : Collections.emptyList();
        if (list2 == null) {
            RepositoryContentHandler.$$$reportNull$$$0(0);
        }
        return list2;
    }

    @Override
    public void startDocument() {
        this.plugins = ContainerUtil.newArrayList();
        this.categories = ContainerUtil.newStack();
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals(CATEGORY)) {
            String category = attributes.getValue(NAME);
            if (!StringUtil.isEmptyOrSpaces((String)category)) {
                this.categories.push((Object)category);
                this.categoryName = null;
            }
        } else if (qName.equals(IDEA_PLUGIN)) {
            String dateString;
            this.currentPlugin = new PluginNode();
            this.currentPlugin.setCategory(this.buildCategoryName());
            this.currentPlugin.setDownloads(attributes.getValue(DOWNLOADS));
            this.currentPlugin.setSize(attributes.getValue(SIZE));
            this.currentPlugin.setUrl(attributes.getValue(URL));
            String string = dateString = attributes.getValue(PLUGIN_UPDATED_DATE) != null ? attributes.getValue(PLUGIN_UPDATED_DATE) : attributes.getValue(DATE);
            if (dateString != null) {
                this.currentPlugin.setDate(dateString);
            }
            this.currentPlugin.setIncomplete(false);
        } else if (qName.equals(IDEA_VERSION)) {
            this.currentPlugin.setSinceBuild(attributes.getValue(SINCE_BUILD));
            this.currentPlugin.setUntilBuild(IdeaPluginDescriptorImpl.convertExplicitBigNumberInUntilBuildToStar(attributes.getValue(UNTIL_BUILD)));
        } else if (qName.equals(VENDOR)) {
            this.currentPlugin.setVendorEmail(attributes.getValue(EMAIL));
            this.currentPlugin.setVendorUrl(attributes.getValue(URL));
        } else if (qName.equals(PLUGIN)) {
            this.currentPlugin = new PluginNode();
            String id = attributes.getValue(ID);
            if (id != null) {
                this.currentPlugin.setId(id);
            }
            this.currentPlugin.setDownloadUrl(attributes.getValue(URL));
            this.currentPlugin.setVersion(attributes.getValue(VERSION));
            this.currentPlugin.setIncomplete(true);
        }
        this.currentValue.setLength(0);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) {
        String currentValueString = this.currentValue.toString();
        this.currentValue.setLength(0);
        if (qName.equals(ID)) {
            this.currentPlugin.setId(currentValueString);
        } else if (qName.equals(NAME)) {
            this.currentPlugin.setName(currentValueString);
        } else if (qName.equals(DESCRIPTION)) {
            this.currentPlugin.setDescription(currentValueString);
        } else if (qName.equals(VERSION)) {
            this.currentPlugin.setVersion(currentValueString);
        } else if (qName.equals(VENDOR)) {
            this.currentPlugin.setVendor(currentValueString);
        } else if (qName.equals(DEPENDS)) {
            this.currentPlugin.addDepends(currentValueString);
        } else if (qName.equals(CHANGE_NOTES)) {
            this.currentPlugin.setChangeNotes(currentValueString);
        } else if (qName.equals(CATEGORY)) {
            this.categories.pop();
            this.categoryName = null;
        } else if (qName.equals(RATING)) {
            this.currentPlugin.setRating(currentValueString);
        } else if (qName.equals(DOWNLOAD_URL) || qName.equals(DOWNLOAD_URL_NEW_STYLE)) {
            this.currentPlugin.setDownloadUrl(currentValueString);
        } else if (qName.equals(IDEA_PLUGIN) || qName.equals(PLUGIN)) {
            if (this.currentPlugin != null && !PluginManagerCore.isBrokenPlugin(this.currentPlugin)) {
                this.plugins.add(this.currentPlugin);
            }
            this.currentPlugin = null;
        } else if (qName.equals(TAGS)) {
            this.currentPlugin.addTags(currentValueString);
        }
    }

    @Override
    public void characters(char[] ch, int start2, int length) {
        this.currentValue.append(ch, start2, length);
    }

    @NotNull
    private String buildCategoryName() {
        if (this.categoryName == null) {
            StringBuilder builder2 = new StringBuilder();
            for (int i = 0; i < this.categories.size(); ++i) {
                if (i > 0) {
                    builder2.append('/');
                }
                builder2.append((String)this.categories.get(i));
            }
            this.categoryName = builder2.toString();
        }
        String string = this.categoryName;
        if (string == null) {
            RepositoryContentHandler.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/ide/plugins/RepositoryContentHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginsList";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildCategoryName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

