/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.ide.OccurenceNavigatorSupport;
import com.intellij.ide.PsiCopyPasteManager;
import com.intellij.ide.dnd.DnDAction;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDSource;
import com.intellij.ide.dnd.TransferableWrapper;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.hierarchy.HierarchyBrowserBase;
import com.intellij.ide.hierarchy.HierarchyBrowserManager;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyProvider;
import com.intellij.ide.hierarchy.HierarchyTreeBuilder;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.ide.hierarchy.actions.BrowseHierarchyActionBase;
import com.intellij.ide.projectView.impl.ProjectViewTree;
import com.intellij.ide.util.scopeChooser.EditScopesDialog;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.TreeBuilderUtil;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.PsiElementNavigatable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.pom.Navigatable;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.popup.HintUpdateSupply;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.usageView.UsageViewTypeLocation;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EditSourceOnEnterKeyHandler;
import com.intellij.util.SingleAlarm;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.tree.TreeUtil;
import gnu.trove.THashMap;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HierarchyBrowserBaseEx
extends HierarchyBrowserBase
implements OccurenceNavigator {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.hierarchy.HierarchyBrowserBaseEx");
    public static final String SCOPE_PROJECT = IdeBundle.message((String)"hierarchy.scope.project", (Object[])new Object[0]);
    public static final String SCOPE_ALL = IdeBundle.message((String)"hierarchy.scope.all", (Object[])new Object[0]);
    public static final String SCOPE_TEST = IdeBundle.message((String)"hierarchy.scope.test", (Object[])new Object[0]);
    public static final String SCOPE_CLASS = IdeBundle.message((String)"hierarchy.scope.this.class", (Object[])new Object[0]);
    public static final String HELP_ID = "reference.toolWindows.hierarchy";
    @Deprecated
    protected final Hashtable<String, HierarchyTreeBuilder> myBuilders;
    @Deprecated
    protected String myCurrentViewType;
    private final Map<String, Sheet> myType2Sheet;
    private final RefreshAction myRefreshAction;
    private final SingleAlarm myCursorAlarm;
    private SmartPsiElementPointer mySmartPsiElementPointer;
    private final CardLayout myCardLayout;
    private final JPanel myTreePanel;
    private boolean myCachedIsValidBase;

    public HierarchyBrowserBaseEx(@NotNull Project project, @NotNull PsiElement element) {
        JPanel contentPanel;
        if (project == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(0);
        }
        if (element == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(1);
        }
        super(project);
        this.myBuilders = new Hashtable();
        this.myType2Sheet = new THashMap();
        this.myRefreshAction = new RefreshAction();
        this.myCursorAlarm = new SingleAlarm(() -> this.setCursor(Cursor.getPredefinedCursor(3)), 100, this);
        this.setHierarchyBase(element);
        this.myCardLayout = new CardLayout();
        this.myTreePanel = new JPanel(this.myCardLayout);
        THashMap type2treeMap = new THashMap();
        this.createTrees((Map<String, JTree>)type2treeMap);
        HierarchyBrowserManager.State state = HierarchyBrowserManager.getSettings(project);
        for (Map.Entry entry : type2treeMap.entrySet()) {
            JTree tree = (JTree)entry.getValue();
            String type = (String)entry.getKey();
            String scope = state.SCOPE != null ? state.SCOPE : SCOPE_ALL;
            OccurenceNavigatorSupport occurenceNavigatorSupport = new OccurenceNavigatorSupport(tree){

                @Nullable
                protected Navigatable createDescriptorForNode(@NotNull DefaultMutableTreeNode node) {
                    PsiElement psiElement;
                    HierarchyNodeDescriptor descriptor;
                    if (node == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((descriptor = HierarchyBrowserBaseEx.this.getDescriptor(node)) != null && (psiElement = HierarchyBrowserBaseEx.this.getOpenFileElementFromDescriptor(descriptor)) != null && psiElement.isValid()) {
                        return new PsiElementNavigatable(psiElement);
                    }
                    return null;
                }

                @NotNull
                public String getNextOccurenceActionName() {
                    String string = HierarchyBrowserBaseEx.this.getNextOccurenceActionNameImpl();
                    if (string == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return string;
                }

                @NotNull
                public String getPreviousOccurenceActionName() {
                    String string = HierarchyBrowserBaseEx.this.getPrevOccurenceActionNameImpl();
                    if (string == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: 
                        case 2: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: 
                        case 2: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "node";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/ide/hierarchy/HierarchyBrowserBaseEx$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/ide/hierarchy/HierarchyBrowserBaseEx$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getNextOccurenceActionName";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getPreviousOccurenceActionName";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "createDescriptorForNode";
                            break;
                        }
                        case 1: 
                        case 2: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: 
                        case 2: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
            this.myType2Sheet.put(type, new Sheet(type, tree, scope, (OccurenceNavigator)occurenceNavigatorSupport));
            this.myTreePanel.add((Component)ScrollPaneFactory.createScrollPane((Component)tree), type);
        }
        JPanel legendPanel = this.createLegendPanel();
        if (legendPanel != null) {
            contentPanel = new JPanel(new BorderLayout());
            contentPanel.add((Component)this.myTreePanel, "Center");
            contentPanel.add((Component)legendPanel, "South");
        } else {
            contentPanel = this.myTreePanel;
        }
        this.buildUi(this.createToolbar(this.getActionPlace(), HELP_ID).getComponent(), contentPanel);
    }

    @Nullable
    protected PsiElement getOpenFileElementFromDescriptor(@NotNull HierarchyNodeDescriptor descriptor) {
        if (descriptor == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(2);
        }
        return this.getElementFromDescriptor(descriptor);
    }

    @Override
    @Nullable
    protected abstract PsiElement getElementFromDescriptor(@NotNull HierarchyNodeDescriptor var1);

    @NotNull
    protected abstract String getPrevOccurenceActionNameImpl();

    @NotNull
    protected abstract String getNextOccurenceActionNameImpl();

    protected abstract void createTrees(@NotNull Map<String, JTree> var1);

    @Nullable
    protected abstract JPanel createLegendPanel();

    protected abstract boolean isApplicableElement(@NotNull PsiElement var1);

    protected boolean isApplicableElementForBaseOn(@NotNull PsiElement element) {
        if (element == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(3);
        }
        return this.isApplicableElement(element);
    }

    @Nullable
    protected abstract HierarchyTreeStructure createHierarchyTreeStructure(@NotNull String var1, @NotNull PsiElement var2);

    @Nullable
    protected abstract Comparator<NodeDescriptor> getComparator();

    @NotNull
    protected abstract String getActionPlace();

    @NotNull
    protected abstract String getBrowserDataKey();

    @Nullable
    protected Color getFileColorForNode(Object node) {
        if (node instanceof HierarchyNodeDescriptor) {
            PsiFile containingFile = ((HierarchyNodeDescriptor)((Object)node)).getContainingFile();
            return ProjectViewTree.getColorForElement((PsiElement)containingFile);
        }
        return null;
    }

    @NotNull
    protected final JTree createTree(boolean dndAware) {
        Tree tree;
        DefaultTreeModel treeModel = new DefaultTreeModel(new DefaultMutableTreeNode(""));
        if (dndAware) {
            tree = new DnDAwareTree(treeModel){

                public void addNotify() {
                    super.addNotify();
                    HierarchyBrowserBaseEx.this.myRefreshAction.registerShortcutOn((JComponent)((Object)this));
                }

                public void removeNotify() {
                    super.removeNotify();
                    HierarchyBrowserBaseEx.this.myRefreshAction.unregisterCustomShortcutSet((JComponent)((Object)this));
                }

                public boolean isFileColorsEnabled() {
                    return ProjectViewTree.isFileColorsEnabledFor((JTree)((Object)this));
                }

                public Color getFileColorFor(Object object) {
                    return HierarchyBrowserBaseEx.this.getFileColorForNode(object);
                }
            };
            if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
                DnDManager.getInstance().registerSource(new DnDSource(){

                    public boolean canStartDragging(DnDAction action, Point dragOrigin) {
                        return HierarchyBrowserBaseEx.this.getSelectedElements().length > 0;
                    }

                    public DnDDragStartBean startDragging(DnDAction action, Point dragOrigin) {
                        return new DnDDragStartBean((Object)new TransferableWrapper(){

                            @Override
                            public TreeNode[] getTreeNodes() {
                                return (TreeNode[])tree.getSelectedNodes(TreeNode.class, null);
                            }

                            @Override
                            public PsiElement[] getPsiElements() {
                                return HierarchyBrowserBaseEx.this.getSelectedElements();
                            }

                            @Override
                            public List<File> asFileList() {
                                return PsiCopyPasteManager.asFileList(this.getPsiElements());
                            }
                        });
                    }

                    public void dragDropEnd() {
                    }

                    public void dropActionChanged(int gestureModifiers) {
                    }
                }, (JComponent)tree);
            }
        } else {
            tree = new Tree(treeModel){

                public void addNotify() {
                    super.addNotify();
                    HierarchyBrowserBaseEx.this.myRefreshAction.registerShortcutOn((JComponent)((Object)this));
                }

                public void removeNotify() {
                    super.removeNotify();
                    HierarchyBrowserBaseEx.this.myRefreshAction.unregisterCustomShortcutSet((JComponent)((Object)this));
                }

                public boolean isFileColorsEnabled() {
                    return ProjectViewTree.isFileColorsEnabledFor((JTree)((Object)this));
                }

                public Color getFileColorFor(Object object) {
                    return HierarchyBrowserBaseEx.this.getFileColorForNode(object);
                }
            };
        }
        HintUpdateSupply.installDataContextHintUpdateSupply((JComponent)tree);
        this.configureTree(tree);
        EditSourceOnDoubleClickHandler.install((JTree)tree);
        EditSourceOnEnterKeyHandler.install((JTree)tree);
        Tree tree2 = tree;
        if (tree2 == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(4);
        }
        return tree2;
    }

    protected void setHierarchyBase(@NotNull PsiElement element) {
        if (element == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(5);
        }
        this.mySmartPsiElementPointer = SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer(element);
    }

    protected PsiElement getHierarchyBase() {
        return this.mySmartPsiElementPointer.getElement();
    }

    private void restoreCursor() {
        this.myCursorAlarm.cancelAllRequests();
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void setWaitCursor() {
        this.myCursorAlarm.request();
    }

    public void changeView(@NotNull String typeName) {
        if (typeName == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(6);
        }
        this.changeView(typeName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeView(@NotNull String typeName, boolean requestFocus) {
        String displayName;
        if (typeName == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(7);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myCurrentViewType = typeName;
        PsiElement element = this.mySmartPsiElementPointer.getElement();
        if (element == null || !this.isApplicableElement(element)) {
            return;
        }
        if (this.myContent != null && (displayName = this.getContentDisplayName(typeName, element)) != null) {
            this.myContent.setDisplayName(displayName);
        }
        this.myCardLayout.show(this.myTreePanel, typeName);
        Sheet sheet = this.myType2Sheet.get(typeName);
        if (sheet.myStructureTreeModel == null) {
            try {
                this.setWaitCursor();
                JTree tree = sheet.myTree;
                HierarchyTreeStructure structure = this.createHierarchyTreeStructure(typeName, element);
                if (structure == null) {
                    return;
                }
                Comparator<NodeDescriptor> comparator2 = this.getComparator();
                StructureTreeModel<HierarchyTreeStructure> myModel = comparator2 == null ? new StructureTreeModel<HierarchyTreeStructure>(structure) : new StructureTreeModel<HierarchyTreeStructure>(structure, comparator2);
                AsyncTreeModel atm = new AsyncTreeModel((TreeModel)((Object)myModel), sheet);
                tree.setModel((TreeModel)((Object)atm));
                sheet.myStructureTreeModel = myModel;
                sheet.myAsyncTreeModel = atm;
                this.selectLater(tree, structure.getBaseDescriptor());
                this.expandLater(tree, structure.getBaseDescriptor());
            }
            finally {
                this.restoreCursor();
            }
        }
        if (requestFocus) {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.getCurrentTree(), true));
        }
    }

    private static boolean isAncestor(@NotNull Project project, @NotNull HierarchyNodeDescriptor ancestor, @NotNull HierarchyNodeDescriptor child2) {
        if (project == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(8);
        }
        if (ancestor == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(9);
        }
        if (child2 == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(10);
        }
        PsiElement ancestorElement = ancestor.getPsiElement();
        while (child2 != null) {
            PsiElement childElement = child2.getPsiElement();
            if (PsiManager.getInstance((Project)project).areElementsEquivalent(ancestorElement, childElement)) {
                return true;
            }
            child2 = (HierarchyNodeDescriptor)child2.getParentDescriptor();
        }
        return false;
    }

    private void selectLater(@NotNull JTree tree, @NotNull HierarchyNodeDescriptor descriptor) {
        if (tree == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(11);
        }
        if (descriptor == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(12);
        }
        TreeUtil.promiseSelect((JTree)tree, (TreeVisitor)this.visitor(descriptor));
    }

    private void selectLater(@NotNull JTree tree, @NotNull List<? extends HierarchyNodeDescriptor> descriptors) {
        if (tree == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(13);
        }
        if (descriptors == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(14);
        }
        TreeUtil.promiseSelect((JTree)tree, descriptors.stream().map(descriptor -> this.visitor((HierarchyNodeDescriptor)((Object)descriptor))));
    }

    private void expandLater(@NotNull JTree tree, @NotNull HierarchyNodeDescriptor descriptor) {
        if (tree == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(15);
        }
        if (descriptor == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(16);
        }
        TreeUtil.promiseExpand((JTree)tree, (TreeVisitor)this.visitor(descriptor));
    }

    @NotNull
    private TreeVisitor visitor(@NotNull HierarchyNodeDescriptor descriptor) {
        PsiElement element;
        if (descriptor == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(17);
        }
        if ((element = descriptor.getPsiElement()) == null) {
            TreeVisitor treeVisitor = path -> TreeVisitor.Action.INTERRUPT;
            if (treeVisitor == null) {
                HierarchyBrowserBaseEx.$$$reportNull$$$0(18);
            }
            return treeVisitor;
        }
        PsiManager psiManager = element.getManager();
        TreeVisitor treeVisitor = path -> {
            Object component = path.getLastPathComponent();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)component;
            Object object = node.getUserObject();
            HierarchyNodeDescriptor current = (HierarchyNodeDescriptor)((Object)((Object)object));
            PsiElement currentPsiElement = current.getPsiElement();
            if (psiManager.areElementsEquivalent(currentPsiElement, element)) {
                return TreeVisitor.Action.INTERRUPT;
            }
            return HierarchyBrowserBaseEx.isAncestor(this.myProject, current, descriptor) ? TreeVisitor.Action.CONTINUE : TreeVisitor.Action.SKIP_CHILDREN;
        };
        if (treeVisitor == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(19);
        }
        return treeVisitor;
    }

    @Nullable
    protected String getContentDisplayName(@NotNull String typeName, @NotNull PsiElement element) {
        if (typeName == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(20);
        }
        if (element == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(21);
        }
        if (element instanceof PsiNamedElement) {
            return MessageFormat.format(typeName, ((PsiNamedElement)element).getName());
        }
        return null;
    }

    @Override
    protected void appendActions(@NotNull DefaultActionGroup actionGroup, @Nullable String helpID) {
        if (actionGroup == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(22);
        }
        this.prependActions(actionGroup);
        actionGroup.add((AnAction)this.myRefreshAction);
        super.appendActions(actionGroup, helpID);
    }

    protected void prependActions(@NotNull DefaultActionGroup actionGroup) {
        if (actionGroup == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(23);
        }
    }

    public boolean hasNextOccurence() {
        return this.getOccurrenceNavigator().hasNextOccurence();
    }

    @NotNull
    private OccurenceNavigator getOccurrenceNavigator() {
        OccurenceNavigator navigator;
        String currentViewType = this.getCurrentViewType();
        if (currentViewType != null && (navigator = this.myType2Sheet.get(currentViewType).myOccurenceNavigator) != null) {
            OccurenceNavigator occurenceNavigator = navigator;
            if (occurenceNavigator == null) {
                HierarchyBrowserBaseEx.$$$reportNull$$$0(24);
            }
            return occurenceNavigator;
        }
        OccurenceNavigator occurenceNavigator = EMPTY;
        if (occurenceNavigator == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(25);
        }
        return occurenceNavigator;
    }

    public boolean hasPreviousOccurence() {
        return this.getOccurrenceNavigator().hasPreviousOccurence();
    }

    public OccurenceNavigator.OccurenceInfo goNextOccurence() {
        return this.getOccurrenceNavigator().goNextOccurence();
    }

    public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
        return this.getOccurrenceNavigator().goPreviousOccurence();
    }

    @NotNull
    public String getNextOccurenceActionName() {
        String string = this.getOccurrenceNavigator().getNextOccurenceActionName();
        if (string == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    public String getPreviousOccurenceActionName() {
        String string = this.getOccurrenceNavigator().getPreviousOccurenceActionName();
        if (string == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(27);
        }
        return string;
    }

    @NotNull
    public StructureTreeModel getTreeModel(@NotNull String viewType) {
        if (viewType == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(28);
        }
        StructureTreeModel structureTreeModel = this.myType2Sheet.get(viewType).myStructureTreeModel;
        if (structureTreeModel == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(29);
        }
        return structureTreeModel;
    }

    @Override
    StructureTreeModel getCurrentBuilder() {
        String viewType = this.getCurrentViewType();
        if (viewType == null) {
            return null;
        }
        Sheet sheet = this.myType2Sheet.get(viewType);
        return sheet == null ? null : sheet.myStructureTreeModel;
    }

    final boolean isValidBase() {
        if (this.myProject.isDisposed()) {
            return false;
        }
        if (PsiDocumentManager.getInstance((Project)this.myProject).getUncommittedDocuments().length > 0) {
            return this.myCachedIsValidBase;
        }
        PsiElement element = this.mySmartPsiElementPointer.getElement();
        this.myCachedIsValidBase = element != null && this.isApplicableElement(element) && element.isValid();
        return this.myCachedIsValidBase;
    }

    @Override
    protected JTree getCurrentTree() {
        String currentViewType = this.getCurrentViewType();
        return currentViewType == null ? null : this.myType2Sheet.get(currentViewType).myTree;
    }

    protected final String getCurrentViewType() {
        return this.myCurrentViewType;
    }

    @Override
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(30);
        }
        if (this.getBrowserDataKey().equals(dataId)) {
            return this;
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return HELP_ID;
        }
        return super.getData(dataId);
    }

    @Override
    public void dispose() {
        this.disposeAllSheets();
        super.dispose();
    }

    private void disposeAllSheets() {
        for (Sheet sheet : this.myType2Sheet.values()) {
            this.disposeSheet(sheet);
        }
    }

    private void disposeSheet(@NotNull Sheet sheet) {
        if (sheet == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(31);
        }
        Disposer.dispose((Disposable)sheet);
        this.myType2Sheet.put(sheet.myType, new Sheet(sheet.myType, sheet.myTree, sheet.myScope, sheet.myOccurenceNavigator));
    }

    protected void doRefresh(boolean currentBuilderOnly) {
        PsiElement element;
        if (currentBuilderOnly) {
            LOG.assertTrue(this.getCurrentViewType() != null);
        }
        if (!this.isValidBase()) {
            return;
        }
        if (this.getCurrentBuilder() == null) {
            return;
        }
        String currentViewType = this.getCurrentViewType();
        ArrayList pathsToExpand = new ArrayList();
        ArrayList selectionPaths = new ArrayList();
        if (currentViewType != null) {
            Sheet sheet = this.myType2Sheet.get(currentViewType);
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)sheet.myAsyncTreeModel.getRoot();
            TreeBuilderUtil.storePaths((JTree)sheet.myTree, (DefaultMutableTreeNode)root, pathsToExpand, selectionPaths, (boolean)true);
        }
        if ((element = this.mySmartPsiElementPointer.getElement()) == null || !this.isApplicableElement(element)) {
            return;
        }
        if (currentBuilderOnly) {
            Sheet sheet = this.myType2Sheet.get(currentViewType);
            this.disposeSheet(sheet);
        } else {
            this.disposeAllSheets();
        }
        this.setHierarchyBase(element);
        this.validate();
        ApplicationManager.getApplication().invokeLater(() -> {
            this.changeView(currentViewType);
            for (Object p : pathsToExpand) {
                HierarchyNodeDescriptor descriptor = (HierarchyNodeDescriptor)((Object)((Object)p));
                this.expandLater(this.getCurrentTree(), descriptor);
            }
            this.selectLater(this.getCurrentTree(), selectionPaths);
        }, __ -> this.isDisposed());
    }

    protected String getCurrentScopeType() {
        String currentViewType = this.getCurrentViewType();
        return currentViewType == null ? null : this.myType2Sheet.get(currentViewType).myScope;
    }

    @NotNull
    private Collection<String> getValidScopeNames() {
        NamedScopesHolder[] holders;
        ArrayList<String> result2 = new ArrayList<String>();
        result2.add(SCOPE_PROJECT);
        result2.add(SCOPE_TEST);
        result2.add(SCOPE_ALL);
        result2.add(SCOPE_CLASS);
        for (NamedScopesHolder holder : holders = NamedScopesHolder.getAllNamedScopeHolders((Project)this.myProject)) {
            NamedScope[] scopes;
            for (NamedScope scope : scopes = holder.getEditableScopes()) {
                result2.add(scope.getName());
            }
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            HierarchyBrowserBaseEx.$$$reportNull$$$0(32);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 18: 
            case 19: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 18: 
            case 19: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 12: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: 
            case 18: 
            case 19: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/hierarchy/HierarchyBrowserBaseEx";
                break;
            }
            case 6: 
            case 7: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionGroup";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewType";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sheet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/hierarchy/HierarchyBrowserBaseEx";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createTree";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "visitor";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getOccurrenceNavigator";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextOccurenceActionName";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreviousOccurenceActionName";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeModel";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidScopeNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getOpenFileElementFromDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableElementForBaseOn";
                break;
            }
            case 4: 
            case 18: 
            case 19: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 32: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setHierarchyBase";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "changeView";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isAncestor";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "selectLater";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "expandLater";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "visitor";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getContentDisplayName";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "appendActions";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "prependActions";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getTreeModel";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "disposeSheet";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 18: 
            case 19: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class ChangeScopeAction
    extends ComboBoxAction {
        public final void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ChangeScopeAction.$$$reportNull$$$0(0);
            }
            Presentation presentation = e.getPresentation();
            Project project = e.getProject();
            if (project == null) {
                return;
            }
            presentation.setEnabled(this.isEnabled());
            presentation.setText(HierarchyBrowserBaseEx.this.getCurrentScopeType());
        }

        protected boolean isEnabled() {
            return true;
        }

        @NotNull
        protected final DefaultActionGroup createPopupActionGroup(JComponent button) {
            DefaultActionGroup group = new DefaultActionGroup();
            for (String name : HierarchyBrowserBaseEx.this.getValidScopeNames()) {
                group.add((AnAction)new MenuAction(name));
            }
            group.add((AnAction)new ConfigureScopesAction());
            DefaultActionGroup defaultActionGroup = group;
            if (defaultActionGroup == null) {
                ChangeScopeAction.$$$reportNull$$$0(1);
            }
            return defaultActionGroup;
        }

        private void selectScope(@NotNull String scopeType) {
            if (scopeType == null) {
                ChangeScopeAction.$$$reportNull$$$0(2);
            }
            ((Sheet)HierarchyBrowserBaseEx.this.myType2Sheet.get(HierarchyBrowserBaseEx.this.getCurrentViewType())).myScope = scopeType;
            HierarchyBrowserManager.getSettings((Project)HierarchyBrowserBaseEx.this.myProject).SCOPE = scopeType;
            ApplicationManager.getApplication().invokeLater(() -> HierarchyBrowserBaseEx.this.doRefresh(true), __ -> HierarchyBrowserBaseEx.this.isDisposed());
        }

        @NotNull
        public final JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
            if (presentation == null) {
                ChangeScopeAction.$$$reportNull$$$0(3);
            }
            if (place == null) {
                ChangeScopeAction.$$$reportNull$$$0(4);
            }
            JPanel panel2 = new JPanel(new GridBagLayout());
            panel2.add((Component)new JLabel(IdeBundle.message((String)"label.scope", (Object[])new Object[0])), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, (Insets)JBUI.insetsLeft((int)5), 0, 0));
            panel2.add((Component)super.createCustomComponent(presentation, place), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 1, (Insets)JBUI.emptyInsets(), 0, 0));
            JPanel jPanel = panel2;
            if (jPanel == null) {
                ChangeScopeAction.$$$reportNull$$$0(5);
            }
            return jPanel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/hierarchy/HierarchyBrowserBaseEx$ChangeScopeAction";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scopeType";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/hierarchy/HierarchyBrowserBaseEx$ChangeScopeAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createPopupActionGroup";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createCustomComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: 
                case 5: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "selectScope";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createCustomComponent";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private final class ConfigureScopesAction
        extends AnAction {
            private ConfigureScopesAction() {
                super("Configure...");
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    ConfigureScopesAction.$$$reportNull$$$0(0);
                }
                EditScopesDialog.showDialog(HierarchyBrowserBaseEx.this.myProject, null);
                if (!HierarchyBrowserBaseEx.this.getValidScopeNames().contains(HierarchyBrowserBaseEx.this.getCurrentScopeType())) {
                    ChangeScopeAction.this.selectScope(SCOPE_ALL);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/hierarchy/HierarchyBrowserBaseEx$ChangeScopeAction$ConfigureScopesAction", "actionPerformed"));
            }
        }

        private final class MenuAction
        extends AnAction {
            private final String myScopeType;

            MenuAction(String scopeType) {
                if (scopeType == null) {
                    MenuAction.$$$reportNull$$$0(0);
                }
                super(scopeType);
                this.myScopeType = scopeType;
            }

            public final void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    MenuAction.$$$reportNull$$$0(1);
                }
                ChangeScopeAction.this.selectScope(this.myScopeType);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "scopeType";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/ide/hierarchy/HierarchyBrowserBaseEx$ChangeScopeAction$MenuAction";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private class RefreshAction
    extends com.intellij.ide.actions.RefreshAction {
        RefreshAction() {
            super(IdeBundle.message((String)"action.refresh", (Object[])new Object[0]), IdeBundle.message((String)"action.refresh", (Object[])new Object[0]), AllIcons.Actions.Refresh);
        }

        @Override
        public final void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                RefreshAction.$$$reportNull$$$0(0);
            }
            HierarchyBrowserBaseEx.this.doRefresh(false);
        }

        @Override
        public final void update(@NotNull AnActionEvent event) {
            if (event == null) {
                RefreshAction.$$$reportNull$$$0(1);
            }
            Presentation presentation = event.getPresentation();
            presentation.setEnabled(HierarchyBrowserBaseEx.this.isValidBase());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/hierarchy/HierarchyBrowserBaseEx$RefreshAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class BaseOnThisElementAction
    extends AnAction {
        private final String myBrowserDataKey;
        private final LanguageExtension<HierarchyProvider> myProviderLanguageExtension;

        protected BaseOnThisElementAction(@NotNull String text, @NotNull String browserDataKey, @NotNull LanguageExtension<HierarchyProvider> providerLanguageExtension) {
            if (text == null) {
                BaseOnThisElementAction.$$$reportNull$$$0(0);
            }
            if (browserDataKey == null) {
                BaseOnThisElementAction.$$$reportNull$$$0(1);
            }
            if (providerLanguageExtension == null) {
                BaseOnThisElementAction.$$$reportNull$$$0(2);
            }
            super(text);
            this.myBrowserDataKey = browserDataKey;
            this.myProviderLanguageExtension = providerLanguageExtension;
        }

        public final void actionPerformed(@NotNull AnActionEvent event) {
            DataContext dataContext;
            HierarchyBrowserBaseEx browser2;
            if (event == null) {
                BaseOnThisElementAction.$$$reportNull$$$0(3);
            }
            if ((browser2 = (HierarchyBrowserBaseEx)((Object)(dataContext = event.getDataContext()).getData(this.myBrowserDataKey))) == null) {
                return;
            }
            PsiElement selectedElement = browser2.getSelectedElement();
            if (selectedElement == null || !browser2.isApplicableElementForBaseOn(selectedElement)) {
                return;
            }
            String currentViewType = browser2.getCurrentViewType();
            Disposer.dispose((Disposable)browser2);
            HierarchyProvider provider = BrowseHierarchyActionBase.findProvider(this.myProviderLanguageExtension, selectedElement, selectedElement.getContainingFile(), event.getDataContext());
            if (provider != null) {
                HierarchyBrowserBaseEx newBrowser = (HierarchyBrowserBaseEx)BrowseHierarchyActionBase.createAndAddToPanel(selectedElement.getProject(), provider, selectedElement);
                ApplicationManager.getApplication().invokeLater(() -> newBrowser.changeView(this.correctViewType(browser2, currentViewType)), __ -> newBrowser.isDisposed());
            }
        }

        protected String correctViewType(@NotNull HierarchyBrowserBaseEx browser2, String viewType) {
            if (browser2 == null) {
                BaseOnThisElementAction.$$$reportNull$$$0(4);
            }
            return viewType;
        }

        public final void update(@NotNull AnActionEvent event) {
            if (event == null) {
                BaseOnThisElementAction.$$$reportNull$$$0(5);
            }
            Presentation presentation = event.getPresentation();
            DataContext dataContext = event.getDataContext();
            HierarchyBrowserBaseEx browser2 = (HierarchyBrowserBaseEx)((Object)dataContext.getData(this.myBrowserDataKey));
            if (browser2 == null) {
                presentation.setVisible(false);
                presentation.setEnabled(false);
                return;
            }
            presentation.setVisible(true);
            PsiElement selectedElement = browser2.getSelectedElement();
            if (selectedElement == null || !browser2.isApplicableElementForBaseOn(selectedElement)) {
                presentation.setEnabledAndVisible(false);
            } else {
                String typeName = ElementDescriptionUtil.getElementDescription((PsiElement)selectedElement, (ElementDescriptionLocation)UsageViewTypeLocation.INSTANCE);
                if (StringUtil.isNotEmpty((String)typeName)) {
                    presentation.setText(IdeBundle.message((String)"action.base.on.this.0", (Object[])new Object[]{StringUtil.capitalize((String)typeName)}));
                }
                presentation.setEnabled(this.isEnabled(browser2, selectedElement));
            }
        }

        protected boolean isEnabled(@NotNull HierarchyBrowserBaseEx browser2, @NotNull PsiElement element) {
            if (browser2 == null) {
                BaseOnThisElementAction.$$$reportNull$$$0(6);
            }
            if (element == null) {
                BaseOnThisElementAction.$$$reportNull$$$0(7);
            }
            return !element.equals(browser2.mySmartPsiElementPointer.getElement()) && element.isValid();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "browserDataKey";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "providerLanguageExtension";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "browser";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/hierarchy/HierarchyBrowserBaseEx$BaseOnThisElementAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "correctViewType";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabled";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected class AlphaSortAction
    extends ToggleAction {
        public AlphaSortAction() {
            super(IdeBundle.message((String)"action.sort.alphabetically", (Object[])new Object[0]), IdeBundle.message((String)"action.sort.alphabetically", (Object[])new Object[0]), AllIcons.ObjectBrowser.Sorted);
        }

        public final boolean isSelected(@NotNull AnActionEvent event) {
            if (event == null) {
                AlphaSortAction.$$$reportNull$$$0(0);
            }
            return HierarchyBrowserManager.getSettings((Project)HierarchyBrowserBaseEx.this.myProject).SORT_ALPHABETICALLY;
        }

        public final void setSelected(@NotNull AnActionEvent event, boolean flag) {
            if (event == null) {
                AlphaSortAction.$$$reportNull$$$0(1);
            }
            HierarchyBrowserManager.getSettings((Project)HierarchyBrowserBaseEx.this.myProject).SORT_ALPHABETICALLY = flag;
            Comparator<NodeDescriptor> comparator2 = HierarchyBrowserBaseEx.this.getComparator();
            HierarchyBrowserBaseEx.this.myType2Sheet.values().stream().map(s -> ((Sheet)s).myStructureTreeModel).filter(m -> m != null).forEach(m -> m.setComparator(comparator2));
        }

        public final void update(@NotNull AnActionEvent event) {
            if (event == null) {
                AlphaSortAction.$$$reportNull$$$0(2);
            }
            super.update(event);
            Presentation presentation = event.getPresentation();
            presentation.setEnabled(HierarchyBrowserBaseEx.this.isValidBase());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/ide/hierarchy/HierarchyBrowserBaseEx$AlphaSortAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class Sheet
    implements Disposable {
        private AsyncTreeModel myAsyncTreeModel;
        private StructureTreeModel myStructureTreeModel;
        @NotNull
        private final String myType;
        private final JTree myTree;
        private String myScope;
        private final OccurenceNavigator myOccurenceNavigator;

        Sheet(@NotNull String type, @NotNull JTree tree, @NotNull String scope, @NotNull OccurenceNavigator occurenceNavigator) {
            if (type == null) {
                Sheet.$$$reportNull$$$0(0);
            }
            if (tree == null) {
                Sheet.$$$reportNull$$$0(1);
            }
            if (scope == null) {
                Sheet.$$$reportNull$$$0(2);
            }
            if (occurenceNavigator == null) {
                Sheet.$$$reportNull$$$0(3);
            }
            this.myType = type;
            this.myTree = tree;
            this.myScope = scope;
            this.myOccurenceNavigator = occurenceNavigator;
        }

        public void dispose() {
            this.myAsyncTreeModel = null;
            this.myStructureTreeModel = null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tree";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "scope";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "occurenceNavigator";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ide/hierarchy/HierarchyBrowserBaseEx$Sheet";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

