/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.pom.Navigatable;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerUtil;
import java.awt.Component;
import java.awt.Window;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class OccurenceNavigatorActionBase
extends AnAction
implements DumbAware {
    OccurenceNavigatorActionBase() {
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            OccurenceNavigatorActionBase.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        OccurenceNavigator navigator = this.getNavigator(e.getDataContext());
        if (navigator == null) {
            return;
        }
        if (!this.hasOccurenceToGo(navigator)) {
            return;
        }
        OccurenceNavigator.OccurenceInfo occurenceInfo = this.go(navigator);
        if (occurenceInfo == null) {
            return;
        }
        Navigatable descriptor = occurenceInfo.getNavigateable();
        if (descriptor != null && descriptor.canNavigate()) {
            descriptor.navigate(true);
        }
        if (occurenceInfo.getOccurenceNumber() == -1 || occurenceInfo.getOccurencesCount() == -1) {
            return;
        }
        WindowManager.getInstance().getStatusBar(project).setInfo(IdeBundle.message((String)"message.occurrence.N.of.M", (Object[])new Object[]{occurenceInfo.getOccurenceNumber(), occurenceInfo.getOccurencesCount()}));
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            OccurenceNavigatorActionBase.$$$reportNull$$$0(1);
        }
        Presentation presentation = event.getPresentation();
        Project project = (Project)event.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            presentation.setEnabled(false);
            presentation.setVisible(!ActionPlaces.isMainMenuOrActionSearch((String)event.getPlace()));
            return;
        }
        OccurenceNavigator navigator = this.getNavigator(event.getDataContext());
        if (navigator == null) {
            presentation.setEnabled(false);
            presentation.setVisible(!ActionPlaces.isMainMenuOrActionSearch((String)event.getPlace()));
            return;
        }
        presentation.setVisible(true);
        try {
            presentation.setEnabled(this.hasOccurenceToGo(navigator));
            presentation.setText(this.getDescription(navigator));
        }
        catch (IndexNotReadyException e) {
            presentation.setEnabled(false);
        }
    }

    protected abstract OccurenceNavigator.OccurenceInfo go(OccurenceNavigator var1);

    protected abstract boolean hasOccurenceToGo(OccurenceNavigator var1);

    protected abstract String getDescription(OccurenceNavigator var1);

    @Nullable
    protected OccurenceNavigator getNavigator(DataContext dataContext) {
        ContentManager contentManager = ContentManagerUtil.getContentManagerFromContext(dataContext, false);
        if (contentManager != null) {
            Content content = contentManager.getSelectedContent();
            if (content == null) {
                return null;
            }
            JComponent component = content.getComponent();
            return OccurenceNavigatorActionBase.findNavigator(component);
        }
        return (OccurenceNavigator)OccurenceNavigatorActionBase.getOccurenceNavigatorFromContext(dataContext);
    }

    @Nullable
    private static OccurenceNavigator findNavigator(JComponent parent) {
        LinkedList<JComponent> queue2 = new LinkedList<JComponent>();
        queue2.addLast(parent);
        while (!queue2.isEmpty()) {
            JComponent component = (JComponent)queue2.removeFirst();
            if (component instanceof OccurenceNavigator) {
                return (OccurenceNavigator)component;
            }
            if (component instanceof JTabbedPane) {
                JComponent selectedComponent = (JComponent)((JTabbedPane)component).getSelectedComponent();
                if (selectedComponent == null) continue;
                queue2.addLast(selectedComponent);
                continue;
            }
            if (component == null) continue;
            for (int i = 0; i < component.getComponentCount(); ++i) {
                Component child2 = component.getComponent(i);
                if (!(child2 instanceof JComponent)) continue;
                queue2.addLast((JComponent)child2);
            }
        }
        return null;
    }

    @Nullable
    private static Component getOccurenceNavigatorFromContext(DataContext dataContext) {
        Project project;
        Window window = WindowManagerEx.getInstanceEx().getMostRecentFocusedWindow();
        if (window != null) {
            Component component2;
            for (Component c = component2 = window.getFocusOwner(); c != null; c = c.getParent()) {
                if (!(c instanceof OccurenceNavigator)) continue;
                return c;
            }
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
            return null;
        }
        ToolWindowManagerEx mgr = ToolWindowManagerEx.getInstanceEx(project);
        String id = mgr.getLastActiveToolWindowId((Condition<? super JComponent>)((Condition)component -> OccurenceNavigatorActionBase.findNavigator(component) != null));
        if (id == null) {
            return null;
        }
        return (Component)OccurenceNavigatorActionBase.findNavigator(mgr.getToolWindow(id).getComponent());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/actions/OccurenceNavigatorActionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

