/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.FrameStateListener;
import com.intellij.ide.FrameStateManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.BusyObject;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrameStateManagerImpl
extends FrameStateManager {
    private final List<FrameStateListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final BusyObject.Impl myActive = new BusyObject.Impl(){

        public boolean isReady() {
            return ApplicationManager.getApplication().isActive();
        }
    };

    public FrameStateManagerImpl() {
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(ApplicationActivationListener.TOPIC, (Object)new ApplicationActivationListener(){
            private final FrameStateListener myPublisher = (FrameStateListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(FrameStateListener.TOPIC);

            public void applicationActivated(@NotNull IdeFrame ideFrame) {
                if (ideFrame == null) {
                    2.$$$reportNull$$$0(0);
                }
                System.setProperty("com.jetbrains.suppressWindowRaise", "false");
                FrameStateManagerImpl.this.myActive.onReady();
                this.myPublisher.onFrameActivated();
                for (FrameStateListener listener2 : FrameStateManagerImpl.this.myListeners) {
                    listener2.onFrameActivated();
                }
            }

            public void applicationDeactivated(@NotNull IdeFrame ideFrame) {
                if (ideFrame == null) {
                    2.$$$reportNull$$$0(1);
                }
                System.setProperty("com.jetbrains.suppressWindowRaise", "true");
                if (ApplicationManager.getApplication().isDisposed()) {
                    return;
                }
                this.myPublisher.onFrameDeactivated();
                for (FrameStateListener listener2 : FrameStateManagerImpl.this.myListeners) {
                    listener2.onFrameDeactivated();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "ideFrame";
                objectArray2[1] = "com/intellij/ide/FrameStateManagerImpl$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "applicationActivated";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "applicationDeactivated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public ActionCallback getApplicationActive() {
        return this.myActive.getReady((Object)this);
    }

    public void addListener(@NotNull FrameStateListener listener2) {
        if (listener2 == null) {
            FrameStateManagerImpl.$$$reportNull$$$0(0);
        }
        this.myListeners.add(listener2);
    }

    public void addListener(@NotNull FrameStateListener listener2, @Nullable Disposable disposable) {
        if (listener2 == null) {
            FrameStateManagerImpl.$$$reportNull$$$0(1);
        }
        if (disposable == null) {
            this.myListeners.add(listener2);
        } else {
            ApplicationManager.getApplication().getMessageBus().connect(disposable).subscribe(FrameStateListener.TOPIC, (Object)listener2);
        }
    }

    public void removeListener(@NotNull FrameStateListener listener2) {
        if (listener2 == null) {
            FrameStateManagerImpl.$$$reportNull$$$0(2);
        }
        this.myListeners.remove(listener2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "listener";
        objectArray2[1] = "com/intellij/ide/FrameStateManagerImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addListener";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "removeListener";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

