/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl.statistics;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.UnknownConfigurationType;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.TObjectIntHashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractRunConfigurationTypeUsagesCollector
extends ProjectUsagesCollector {
    private static final String DEFAULT_ID = "third.party";

    protected abstract boolean isApplicable(@NotNull RunManager var1, @NotNull RunnerAndConfigurationSettings var2);

    @Override
    @NotNull
    public Set<UsageDescriptor> getUsages(@NotNull Project project) {
        if (project == null) {
            AbstractRunConfigurationTypeUsagesCollector.$$$reportNull$$$0(0);
        }
        TObjectIntHashMap templates = new TObjectIntHashMap();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            if (project.isDisposed()) {
                return;
            }
            RunManager runManager = RunManager.getInstance((Project)project);
            for (RunnerAndConfigurationSettings settings : runManager.getAllSettings()) {
                FeatureUsageData data;
                String key;
                ConfigurationFactory configurationFactory;
                RunConfiguration runConfiguration = settings.getConfiguration();
                if (!this.isApplicable(runManager, settings) || (configurationFactory = runConfiguration.getFactory()) == null || !StringUtil.isNotEmpty((String)(key = AbstractRunConfigurationTypeUsagesCollector.toReportedId(configurationFactory, data = new FeatureUsageData())))) continue;
                Template template = new Template(key, AbstractRunConfigurationTypeUsagesCollector.addContext(data, settings, runConfiguration));
                if (templates.containsKey((Object)template)) {
                    templates.increment((Object)template);
                    continue;
                }
                templates.put((Object)template, 1);
            }
        });
        HashSet<UsageDescriptor> result2 = new HashSet<UsageDescriptor>();
        templates.forEachEntry((template, value) -> result2.add(((Template)template).createUsageDescriptor(value)));
        HashSet<UsageDescriptor> hashSet = result2;
        if (hashSet == null) {
            AbstractRunConfigurationTypeUsagesCollector.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    @Nullable
    public static String toReportedId(@NotNull ConfigurationFactory factory, @NotNull FeatureUsageData data) {
        ConfigurationType configurationType;
        if (factory == null) {
            AbstractRunConfigurationTypeUsagesCollector.$$$reportNull$$$0(2);
        }
        if (data == null) {
            AbstractRunConfigurationTypeUsagesCollector.$$$reportNull$$$0(3);
        }
        if ((configurationType = factory.getType()) instanceof UnknownConfigurationType) {
            return null;
        }
        PluginInfo info = PluginInfoDetectorKt.getPluginInfo(configurationType.getClass());
        data.addPluginInfo(info);
        if (!info.isDevelopedByJetBrains()) {
            return DEFAULT_ID;
        }
        StringBuilder keyBuilder = new StringBuilder();
        keyBuilder.append(configurationType.getId());
        if (configurationType.getConfigurationFactories().length > 1) {
            keyBuilder.append(".").append(factory.getId());
        }
        return keyBuilder.toString();
    }

    private static FeatureUsageData addContext(@NotNull FeatureUsageData data, @NotNull RunnerAndConfigurationSettings settings, @NotNull RunConfiguration runConfiguration) {
        if (data == null) {
            AbstractRunConfigurationTypeUsagesCollector.$$$reportNull$$$0(4);
        }
        if (settings == null) {
            AbstractRunConfigurationTypeUsagesCollector.$$$reportNull$$$0(5);
        }
        if (runConfiguration == null) {
            AbstractRunConfigurationTypeUsagesCollector.$$$reportNull$$$0(6);
        }
        return data.addData("shared", settings.isShared()).addData("edit_before_run", settings.isEditBeforeRun()).addData("activate_before_run", settings.isActivateToolWindowBeforeRun()).addData("parallel", runConfiguration.isAllowRunningInParallel());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/impl/statistics/AbstractRunConfigurationTypeUsagesCollector";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/impl/statistics/AbstractRunConfigurationTypeUsagesCollector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getUsages";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "toReportedId";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Template {
        private final String myKey;
        private final FeatureUsageData myData;

        private Template(String key, FeatureUsageData data) {
            this.myKey = key;
            this.myData = data;
        }

        private UsageDescriptor createUsageDescriptor(int count) {
            return new UsageDescriptor(this.myKey, count, this.myData);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Template template = (Template)o;
            return Objects.equals(this.myKey, template.myKey) && Objects.equals(this.myData, template.myData);
        }

        public int hashCode() {
            return Objects.hash(this.myKey, this.myData);
        }
    }
}

