/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.UnknownRunConfiguration;
import com.intellij.execution.impl.BeforeRunTaskAndProvider;
import com.intellij.execution.impl.RunConfigurationBeforeRunProvider;
import com.intellij.execution.impl.RunManagerImplKt;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.SmartList;
import com.intellij.util.ui.JBUI;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class BeforeRunStepsPanel
extends JPanel {
    private final JCheckBox myShowSettingsBeforeRunCheckBox;
    private final JCheckBox myActivateToolWindowBeforeRunCheckBox;
    private final JBList<BeforeRunTask<?>> myList;
    private final CollectionListModel<BeforeRunTask<?>> myModel;
    private RunConfiguration myRunConfiguration;
    private final List<BeforeRunTask<?>> originalTasks;
    private final StepsBeforeRunListener myListener;
    private final JPanel myPanel;
    private final Set<BeforeRunTask<?>> clonedTasks;

    BeforeRunStepsPanel(@NotNull StepsBeforeRunListener listener2) {
        if (listener2 == null) {
            BeforeRunStepsPanel.$$$reportNull$$$0(0);
        }
        this.originalTasks = new SmartList();
        this.clonedTasks = new THashSet();
        this.myListener = listener2;
        this.myModel = new CollectionListModel((Object[])new BeforeRunTask[0]);
        this.myList = new JBList(this.myModel);
        this.myList.getEmptyText().setText(ExecutionBundle.message((String)"before.launch.panel.empty", (Object[])new Object[0]));
        this.myList.setSelectionMode(0);
        this.myList.setCellRenderer((ListCellRenderer)((Object)new MyListCellRenderer()));
        this.myList.setVisibleRowCount(4);
        this.myModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                BeforeRunStepsPanel.this.updateText();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                BeforeRunStepsPanel.this.updateText();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
            }
        });
        ToolbarDecorator myDecorator = ToolbarDecorator.createDecorator(this.myList);
        if (!SystemInfo.isMac) {
            myDecorator.setAsUsualTopToolbar();
        }
        myDecorator.setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                BeforeRunTaskAndProvider selection = BeforeRunStepsPanel.this.getSelection();
                if (selection == null) {
                    return;
                }
                BeforeRunTask task2 = selection.getTask();
                if (!BeforeRunStepsPanel.this.clonedTasks.contains(task2)) {
                    task2 = task2.clone();
                    BeforeRunStepsPanel.this.clonedTasks.add(task2);
                    BeforeRunStepsPanel.this.myModel.setElementAt((Object)task2, selection.getIndex());
                }
                selection.getProvider().configureTask(button.getDataContext(), BeforeRunStepsPanel.this.myRunConfiguration, task2).onSuccess(changed -> {
                    if (changed.booleanValue()) {
                        BeforeRunStepsPanel.this.updateText();
                    }
                });
            }
        });
        myDecorator.setEditActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(@NotNull AnActionEvent e) {
                BeforeRunTaskAndProvider selection;
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                return (selection = BeforeRunStepsPanel.this.getSelection()) != null && selection.getProvider().isConfigurable();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/impl/BeforeRunStepsPanel$3", "isEnabled"));
            }
        });
        myDecorator.setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                BeforeRunStepsPanel.this.doAddAction(button);
            }
        });
        myDecorator.setAddActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(@NotNull AnActionEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                return BeforeRunStepsPanel.this.checkBeforeRunTasksAbility(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/impl/BeforeRunStepsPanel$5", "isEnabled"));
            }
        });
        this.myShowSettingsBeforeRunCheckBox = new JCheckBox(ExecutionBundle.message((String)"configuration.edit.before.run", (Object[])new Object[0]));
        this.myShowSettingsBeforeRunCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BeforeRunStepsPanel.this.updateText();
            }
        });
        this.myActivateToolWindowBeforeRunCheckBox = new JCheckBox(ExecutionBundle.message((String)"configuration.activate.toolwindow.before.run", (Object[])new Object[0]));
        this.myActivateToolWindowBeforeRunCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BeforeRunStepsPanel.this.updateText();
            }
        });
        this.myPanel = myDecorator.createPanel();
        myDecorator.getActionsPanel().setCustomShortcuts(CommonActionsPanel.Buttons.EDIT, new ShortcutSet[]{CommonActionsPanel.getCommonShortcut((CommonActionsPanel.Buttons)CommonActionsPanel.Buttons.EDIT), CommonShortcuts.DOUBLE_CLICK_1});
        this.setLayout(new BorderLayout());
        this.add((Component)this.myPanel, "Center");
        JPanel checkboxPanel = new JPanel(new FlowLayout(3, JBUI.scale((int)5), JBUI.scale((int)5)));
        checkboxPanel.add(this.myShowSettingsBeforeRunCheckBox);
        checkboxPanel.add(this.myActivateToolWindowBeforeRunCheckBox);
        this.add((Component)checkboxPanel, "South");
    }

    @Nullable
    private BeforeRunTaskAndProvider getSelection() {
        int index = this.myList.getSelectedIndex();
        if (index == -1) {
            return null;
        }
        BeforeRunTask task2 = (BeforeRunTask)this.myModel.getElementAt(index);
        BeforeRunTaskProvider provider = BeforeRunTaskProvider.getProvider((Project)this.myRunConfiguration.getProject(), (Key)task2.getProviderId());
        return provider == null ? null : new BeforeRunTaskAndProvider(task2, provider, index);
    }

    void doReset(@NotNull RunnerAndConfigurationSettings settings) {
        if (settings == null) {
            BeforeRunStepsPanel.$$$reportNull$$$0(1);
        }
        this.clonedTasks.clear();
        this.myRunConfiguration = settings.getConfiguration();
        this.originalTasks.clear();
        this.originalTasks.addAll(RunManagerImplKt.doGetBeforeRunTasks(this.myRunConfiguration));
        this.myModel.replaceAll(this.originalTasks);
        this.myShowSettingsBeforeRunCheckBox.setSelected(settings.isEditBeforeRun());
        this.myShowSettingsBeforeRunCheckBox.setEnabled(!this.isUnknown());
        this.myActivateToolWindowBeforeRunCheckBox.setSelected(settings.isActivateToolWindowBeforeRun());
        this.myActivateToolWindowBeforeRunCheckBox.setEnabled(!this.isUnknown());
        this.myPanel.setVisible(this.checkBeforeRunTasksAbility(false));
        this.updateText();
    }

    private void updateText() {
        List tasks;
        StringBuilder sb = new StringBuilder();
        if (this.myShowSettingsBeforeRunCheckBox.isSelected()) {
            sb.append(ExecutionBundle.message((String)"configuration.edit.before.run", (Object[])new Object[0]));
        }
        if (!(tasks = this.myModel.getItems()).isEmpty()) {
            BeforeRunTaskProvider provider;
            LinkedHashMap<BeforeRunTaskProvider, Integer> counter = new LinkedHashMap<BeforeRunTaskProvider, Integer>();
            for (BeforeRunTask beforeRunTask : tasks) {
                provider = BeforeRunTaskProvider.getProvider((Project)this.myRunConfiguration.getProject(), (Key)beforeRunTask.getProviderId());
                if (provider == null) continue;
                Integer count = (Integer)counter.get(provider);
                count = count == null ? Integer.valueOf(beforeRunTask.getItemsCount()) : Integer.valueOf(count + beforeRunTask.getItemsCount());
                counter.put(provider, count);
            }
            for (Map.Entry entry : counter.entrySet()) {
                provider = (BeforeRunTaskProvider)entry.getKey();
                String name = provider.getName();
                name = StringUtil.trimStart((String)name, (String)"Run ");
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(name);
                if ((Integer)entry.getValue() <= 1) continue;
                sb.append(" (").append((Integer)entry.getValue()).append(")");
            }
        }
        if (this.myActivateToolWindowBeforeRunCheckBox.isSelected()) {
            sb.append(sb.length() > 0 ? ", " : "").append(ExecutionBundle.message((String)"configuration.activate.toolwindow.before.run", (Object[])new Object[0]));
        }
        if (sb.length() > 0) {
            sb.insert(0, ": ");
        }
        sb.insert(0, ExecutionBundle.message((String)"before.launch.panel.title", (Object[])new Object[0]));
        this.myListener.titleChanged(sb.toString());
    }

    @NotNull
    public List<BeforeRunTask<?>> getTasks() {
        List items = this.myModel.getItems();
        List<Object> list2 = items.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(items);
        if (list2 == null) {
            BeforeRunStepsPanel.$$$reportNull$$$0(2);
        }
        return list2;
    }

    public boolean needEditBeforeRun() {
        return this.myShowSettingsBeforeRunCheckBox.isSelected();
    }

    public boolean needActivateToolWindowBeforeRun() {
        return this.myActivateToolWindowBeforeRunCheckBox.isSelected();
    }

    private boolean checkBeforeRunTasksAbility(boolean checkOnlyAddAction) {
        if (this.isUnknown()) {
            return false;
        }
        Set<Key> activeProviderKeys = this.getActiveProviderKeys();
        for (BeforeRunTaskProvider<BeforeRunTask> provider : this.getBeforeRunTaskProviders()) {
            if (provider.createTask(this.myRunConfiguration) == null) continue;
            if (!checkOnlyAddAction) {
                return true;
            }
            if (provider.isSingleton() && activeProviderKeys.contains(provider.getId())) continue;
            return true;
        }
        return false;
    }

    private boolean isUnknown() {
        return this.myRunConfiguration instanceof UnknownRunConfiguration;
    }

    private void doAddAction(final @NotNull AnActionButton button) {
        if (button == null) {
            BeforeRunStepsPanel.$$$reportNull$$$0(3);
        }
        if (this.isUnknown()) {
            return;
        }
        Set<Key> activeProviderKeys = this.getActiveProviderKeys();
        DefaultActionGroup actionGroup = new DefaultActionGroup(null, false);
        for (final BeforeRunTaskProvider<BeforeRunTask> provider : this.getBeforeRunTaskProviders()) {
            if (provider.createTask(this.myRunConfiguration) == null || activeProviderKeys.contains(provider.getId()) && provider.isSingleton()) continue;
            actionGroup.add(new AnAction(provider.getName(), null, provider.getIcon()){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    BeforeRunTask task2;
                    if (e == null) {
                        8.$$$reportNull$$$0(0);
                    }
                    if ((task2 = provider.createTask(BeforeRunStepsPanel.this.myRunConfiguration)) == null) {
                        return;
                    }
                    provider.configureTask(button.getDataContext(), BeforeRunStepsPanel.this.myRunConfiguration, task2).onSuccess(changed -> {
                        if (!provider.canExecuteTask(BeforeRunStepsPanel.this.myRunConfiguration, task2)) {
                            return;
                        }
                        task2.setEnabled(true);
                        THashSet configurationSet = new THashSet();
                        BeforeRunStepsPanel.this.getAllRunBeforeRuns(task2, (Set)configurationSet);
                        if (configurationSet.contains(BeforeRunStepsPanel.this.myRunConfiguration)) {
                            JOptionPane.showMessageDialog(BeforeRunStepsPanel.this, ExecutionBundle.message((String)"before.launch.panel.cyclic_dependency_warning", (Object[])new Object[]{BeforeRunStepsPanel.this.myRunConfiguration.getName(), provider.getDescription(task2)}), ExecutionBundle.message((String)"warning.common.title", (Object[])new Object[0]), 2);
                            return;
                        }
                        BeforeRunStepsPanel.this.addTask(task2);
                        BeforeRunStepsPanel.this.myListener.fireStepsBeforeRunChanged();
                    });
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/impl/BeforeRunStepsPanel$8", "actionPerformed"));
                }
            });
        }
        ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup(ExecutionBundle.message((String)"add.new.run.configuration.action2.name", (Object[])new Object[0]), (ActionGroup)actionGroup, SimpleDataContext.getProjectContext(this.myRunConfiguration.getProject()), false, false, false, null, -1, Conditions.alwaysTrue());
        popup2.show(Objects.requireNonNull(button.getPreferredPopupPoint()));
    }

    @NotNull
    private List<BeforeRunTaskProvider<BeforeRunTask>> getBeforeRunTaskProviders() {
        List list2 = BeforeRunTaskProvider.EXTENSION_POINT_NAME.getExtensionList((AreaInstance)this.myRunConfiguration.getProject());
        if (list2 == null) {
            BeforeRunStepsPanel.$$$reportNull$$$0(4);
        }
        return list2;
    }

    public void addTask(@NotNull BeforeRunTask task2) {
        if (task2 == null) {
            BeforeRunStepsPanel.$$$reportNull$$$0(5);
        }
        this.myModel.add((Object)task2);
    }

    @NotNull
    private Set<Key> getActiveProviderKeys() {
        THashSet result2 = new THashSet();
        for (BeforeRunTask task2 : this.myModel.getItems()) {
            result2.add(task2.getProviderId());
        }
        THashSet tHashSet = result2;
        if (tHashSet == null) {
            BeforeRunStepsPanel.$$$reportNull$$$0(6);
        }
        return tHashSet;
    }

    private void getAllRunBeforeRuns(@NotNull BeforeRunTask task2, @NotNull Set<RunConfiguration> configurationSet) {
        if (task2 == null) {
            BeforeRunStepsPanel.$$$reportNull$$$0(7);
        }
        if (configurationSet == null) {
            BeforeRunStepsPanel.$$$reportNull$$$0(8);
        }
        if (task2 instanceof RunConfigurationBeforeRunProvider.RunConfigurableBeforeRunTask) {
            RunConfiguration configuration = Objects.requireNonNull(((RunConfigurationBeforeRunProvider.RunConfigurableBeforeRunTask)task2).getSettings()).getConfiguration();
            for (BeforeRunTask<?> beforeRunTask : RunManagerImplKt.doGetBeforeRunTasks(configuration)) {
                if (!(beforeRunTask instanceof RunConfigurationBeforeRunProvider.RunConfigurableBeforeRunTask) || !configurationSet.add(Objects.requireNonNull(((RunConfigurationBeforeRunProvider.RunConfigurableBeforeRunTask)beforeRunTask).getSettings()).getConfiguration())) continue;
                this.getAllRunBeforeRuns(beforeRunTask, configurationSet);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/impl/BeforeRunStepsPanel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "button";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/impl/BeforeRunStepsPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTasks";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBeforeRunTaskProviders";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveProviderKeys";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "doReset";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doAddAction";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addTask";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAllRunBeforeRuns";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyListCellRenderer
    extends JBList.StripedListCellRenderer {
        private MyListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list2, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list2, value, index, isSelected, cellHasFocus);
            if (value instanceof BeforeRunTask) {
                BeforeRunTask task2 = (BeforeRunTask)value;
                BeforeRunTaskProvider provider = BeforeRunTaskProvider.getProvider((Project)BeforeRunStepsPanel.this.myRunConfiguration.getProject(), (Key)task2.getProviderId());
                if (provider != null) {
                    Icon icon = provider.getTaskIcon(task2);
                    this.setIcon(icon != null ? icon : provider.getIcon());
                    this.setText(provider.getDescription(task2));
                }
            }
            return this;
        }
    }

    static interface StepsBeforeRunListener {
        public void fireStepsBeforeRunChanged();

        public void titleChanged(@NotNull String var1);
    }
}

