/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard.tree;

import com.intellij.execution.dashboard.hyperlink.RunDashboardHyperlinkComponent;
import com.intellij.execution.dashboard.tree.RunDashboardLinkMouseListenerBase;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ObjectUtils;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunDashboardTreeMouseListener
extends RunDashboardLinkMouseListenerBase {
    @NotNull
    private final Tree myTree;

    public RunDashboardTreeMouseListener(@NotNull Tree tree) {
        if (tree == null) {
            RunDashboardTreeMouseListener.$$$reportNull$$$0(0);
        }
        this.myTree = tree;
    }

    @Override
    protected Object getAimedObject(MouseEvent e) {
        DefaultMutableTreeNode treeNode;
        Object aimedObject = null;
        TreePath path = this.myTree.getPathForLocation(e.getX(), e.getY());
        if (path != null && (treeNode = (DefaultMutableTreeNode)ObjectUtils.tryCast((Object)path.getLastPathComponent(), DefaultMutableTreeNode.class)) != null) {
            aimedObject = treeNode.getUserObject();
        }
        return aimedObject;
    }

    @Override
    protected void repaintComponent(MouseEvent e) {
        Rectangle bounds2;
        TreePath path = this.myTree.getPathForLocation(e.getX(), e.getY());
        Rectangle rectangle = bounds2 = path == null ? null : this.myTree.getPathBounds(path);
        if (bounds2 != null) {
            this.myTree.repaint(bounds2);
        }
    }

    @Override
    @Nullable
    protected RunDashboardHyperlinkComponent getTagAt(@NotNull MouseEvent e) {
        TreePath path;
        if (e == null) {
            RunDashboardTreeMouseListener.$$$reportNull$$$0(1);
        }
        if ((path = this.myTree.getPathForLocation(e.getX(), e.getY())) == null) {
            return null;
        }
        Rectangle rectangle = this.myTree.getPathBounds(path);
        if (rectangle == null) {
            return null;
        }
        int dx = e.getX() - rectangle.x;
        Object treeNode = path.getLastPathComponent();
        int row2 = this.myTree.getRowForLocation(e.getX(), e.getY());
        boolean isLeaf = this.myTree.getModel().isLeaf(treeNode);
        Object tag = null;
        Component component = this.myTree.getCellRenderer().getTreeCellRendererComponent((JTree)this.myTree, treeNode, true, false, isLeaf, row2, true);
        if (component instanceof ColoredTreeCellRenderer) {
            tag = ((ColoredTreeCellRenderer)component).getFragmentTagAt(dx);
        } else {
            component.setBounds(rectangle);
            component.doLayout();
            Point componentPoint = new Point(dx, 0);
            Component child2 = component.getComponentAt(componentPoint);
            if (child2 instanceof ColoredTreeCellRenderer) {
                Point childPoint = SwingUtilities.convertPoint(component, componentPoint, child2);
                tag = ((ColoredTreeCellRenderer)child2).getFragmentTagAt(childPoint.x);
            } else if (child2 instanceof JLabel) {
                tag = ((JLabel)child2).getIcon();
            }
        }
        if (tag instanceof RunDashboardHyperlinkComponent) {
            return (RunDashboardHyperlinkComponent)tag;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/dashboard/tree/RunDashboardTreeMouseListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getTagAt";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

