/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard.actions;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.dashboard.RunDashboardRunConfigurationNode;
import com.intellij.execution.dashboard.actions.RunDashboardActionUtils;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.ui.content.Content;
import com.intellij.util.containers.JBIterable;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class ExecutorAction
extends AnAction {
    protected ExecutorAction() {
    }

    protected ExecutorAction(String text, String description, Icon icon) {
        super(text, description, icon);
    }

    public void update(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ExecutorAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) == null) {
            this.update(e, false);
            return;
        }
        JBIterable<RunDashboardRunConfigurationNode> targetNodes = RunDashboardActionUtils.getLeafTargets(e);
        if (RunDashboardManager.getInstance((Project)project).isShowConfigurations()) {
            boolean running = targetNodes.filter(node -> {
                Content content = node.getContent();
                return content != null && !RunContentManagerImpl.isTerminated(content);
            }).isNotEmpty();
            this.update(e, running);
            e.getPresentation().setEnabled(targetNodes.filter(this::canRun).isNotEmpty());
        } else {
            Content content = RunDashboardManager.getInstance((Project)project).getDashboardContentManager().getSelectedContent();
            this.update(e, content != null && !RunContentManagerImpl.isTerminated(content));
            e.getPresentation().setEnabled(content != null);
        }
    }

    private boolean canRun(@NotNull RunDashboardRunConfigurationNode node) {
        if (node == null) {
            ExecutorAction.$$$reportNull$$$0(1);
        }
        String executorId = this.getExecutor().getId();
        RunnerAndConfigurationSettings configurationSettings = node.getConfigurationSettings();
        ProgramRunner runner = ProgramRunnerUtil.getRunner(executorId, configurationSettings);
        ExecutionTarget target2 = ExecutionTargetManager.getActiveTarget((Project)node.getProject());
        RunConfiguration configuration = configurationSettings.getConfiguration();
        return this.isValid(node) && runner != null && runner.canRun(executorId, (RunProfile)configuration) && ExecutionTargetManager.canRun((RunConfiguration)configuration, (ExecutionTarget)target2) && !ExecutorAction.isStarting(node.getProject(), configurationSettings, executorId, runner.getRunnerId());
    }

    private static boolean isStarting(Project project, RunnerAndConfigurationSettings configurationSettings, String executorId, String runnerId) {
        ExecutorRegistry executorRegistry = ExecutorRegistry.getInstance();
        if (executorRegistry.isStarting(project, executorId, runnerId)) {
            return true;
        }
        if (configurationSettings.getConfiguration().isAllowRunningInParallel()) {
            return false;
        }
        for (Executor executor : executorRegistry.getRegisteredExecutors()) {
            ProgramRunner runner;
            if (executor.getId().equals(executorId) || (runner = ProgramRunnerUtil.getRunner(executor.getId(), configurationSettings)) == null || !executorRegistry.isStarting(project, executor.getId(), runner.getRunnerId())) continue;
            return true;
        }
        return false;
    }

    private boolean isValid(RunDashboardRunConfigurationNode node) {
        try {
            node.getConfigurationSettings().checkSettings(this.getExecutor());
            return true;
        }
        catch (IndexNotReadyException ex) {
            return true;
        }
        catch (RuntimeConfigurationError ex) {
            return false;
        }
        catch (RuntimeConfigurationException ex) {
            return true;
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ExecutorAction.$$$reportNull$$$0(2);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        if (RunDashboardManager.getInstance((Project)project).isShowConfigurations()) {
            for (RunDashboardRunConfigurationNode node : RunDashboardActionUtils.getLeafTargets(e)) {
                this.doActionPerformed(node);
            }
        } else {
            Content content = RunDashboardManager.getInstance((Project)project).getDashboardContentManager().getSelectedContent();
            if (content != null) {
                RunContentDescriptor descriptor = RunContentManagerImpl.getRunContentDescriptorByContent(content);
                JComponent component = content.getComponent();
                if (component == null) {
                    return;
                }
                ExecutionEnvironment environment = (ExecutionEnvironment)LangDataKeys.EXECUTION_ENVIRONMENT.getData(DataManager.getInstance().getDataContext((Component)component));
                if (environment == null) {
                    return;
                }
                ExecutionManager.getInstance((Project)project).restartRunProfile(project, this.getExecutor(), ExecutionTargetManager.getActiveTarget((Project)project), environment.getRunnerAndConfigurationSettings(), descriptor == null ? null : descriptor.getProcessHandler());
            }
        }
    }

    private void doActionPerformed(RunDashboardRunConfigurationNode node) {
        if (!this.canRun(node)) {
            return;
        }
        RunContentDescriptor descriptor = node.getDescriptor();
        ExecutionManager.getInstance((Project)node.getProject()).restartRunProfile(node.getProject(), this.getExecutor(), ExecutionTargetManager.getActiveTarget((Project)node.getProject()), node.getConfigurationSettings(), descriptor == null ? null : descriptor.getProcessHandler());
    }

    protected abstract Executor getExecutor();

    protected abstract void update(@NotNull AnActionEvent var1, boolean var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/dashboard/actions/ExecutorAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "canRun";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

