/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configuration;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.EnvVariablesTable;
import com.intellij.execution.util.EnvironmentVariable;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.UserActivityProviderComponent;
import com.intellij.ui.table.TableView;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnvironmentVariablesTextFieldWithBrowseButton
extends TextFieldWithBrowseButton
implements UserActivityProviderComponent {
    private EnvironmentVariablesData myData = EnvironmentVariablesData.DEFAULT;
    private final Map<String, String> myParentDefaults = new LinkedHashMap<String, String>();
    private final List<ChangeListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public EnvironmentVariablesTextFieldWithBrowseButton() {
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EnvironmentVariablesTextFieldWithBrowseButton.this.setEnvs(EnvVariablesTable.parseEnvsFromText((String)EnvironmentVariablesTextFieldWithBrowseButton.this.getText()));
                new MyEnvironmentVariablesDialog().show();
            }
        });
    }

    @NotNull
    public Map<String, String> getEnvs() {
        Map<String, String> map2 = this.myData.getEnvs();
        if (map2 == null) {
            EnvironmentVariablesTextFieldWithBrowseButton.$$$reportNull$$$0(0);
        }
        return map2;
    }

    public void setEnvs(@NotNull Map<String, String> envs) {
        if (envs == null) {
            EnvironmentVariablesTextFieldWithBrowseButton.$$$reportNull$$$0(1);
        }
        this.setData(EnvironmentVariablesData.create(envs, this.myData.isPassParentEnvs()));
    }

    @NotNull
    public EnvironmentVariablesData getData() {
        EnvironmentVariablesData environmentVariablesData = this.myData;
        if (environmentVariablesData == null) {
            EnvironmentVariablesTextFieldWithBrowseButton.$$$reportNull$$$0(2);
        }
        return environmentVariablesData;
    }

    public void setData(@NotNull EnvironmentVariablesData data) {
        if (data == null) {
            EnvironmentVariablesTextFieldWithBrowseButton.$$$reportNull$$$0(3);
        }
        EnvironmentVariablesData oldData = this.myData;
        this.myData = data;
        this.setText(EnvironmentVariablesTextFieldWithBrowseButton.stringifyEnvs(data.getEnvs()));
        if (!oldData.equals(data)) {
            this.fireStateChanged();
        }
    }

    @NotNull
    protected Icon getDefaultIcon() {
        Icon icon = AllIcons.General.InlineVariables;
        if (icon == null) {
            EnvironmentVariablesTextFieldWithBrowseButton.$$$reportNull$$$0(4);
        }
        return icon;
    }

    @NotNull
    protected Icon getHoveredIcon() {
        Icon icon = AllIcons.General.InlineVariablesHover;
        if (icon == null) {
            EnvironmentVariablesTextFieldWithBrowseButton.$$$reportNull$$$0(5);
        }
        return icon;
    }

    @NotNull
    private static String stringifyEnvs(@NotNull Map<String, String> envs) {
        if (envs == null) {
            EnvironmentVariablesTextFieldWithBrowseButton.$$$reportNull$$$0(6);
        }
        if (envs.isEmpty()) {
            if ("" == null) {
                EnvironmentVariablesTextFieldWithBrowseButton.$$$reportNull$$$0(7);
            }
            return "";
        }
        StringBuilder buf = new StringBuilder();
        for (Map.Entry<String, String> entry : envs.entrySet()) {
            if (buf.length() > 0) {
                buf.append(";");
            }
            buf.append(StringUtil.escapeChar((String)entry.getKey(), (char)';')).append("=").append(StringUtil.escapeChar((String)entry.getValue(), (char)';'));
        }
        String string = buf.toString();
        if (string == null) {
            EnvironmentVariablesTextFieldWithBrowseButton.$$$reportNull$$$0(8);
        }
        return string;
    }

    public boolean isPassParentEnvs() {
        return this.myData.isPassParentEnvs();
    }

    public void setPassParentEnvs(boolean passParentEnvs) {
        this.setData(EnvironmentVariablesData.create(this.myData.getEnvs(), passParentEnvs));
    }

    public void addChangeListener(@NotNull ChangeListener changeListener) {
        if (changeListener == null) {
            EnvironmentVariablesTextFieldWithBrowseButton.$$$reportNull$$$0(9);
        }
        this.myListeners.add(changeListener);
    }

    public void removeChangeListener(@NotNull ChangeListener changeListener) {
        if (changeListener == null) {
            EnvironmentVariablesTextFieldWithBrowseButton.$$$reportNull$$$0(10);
        }
        this.myListeners.remove(changeListener);
    }

    private void fireStateChanged() {
        for (ChangeListener listener2 : this.myListeners) {
            listener2.stateChanged(new ChangeEvent((Object)this));
        }
    }

    private static List<EnvironmentVariable> convertToVariables(Map<String, String> map2, final boolean readOnly) {
        return ContainerUtil.map(map2.entrySet(), entry -> new EnvironmentVariable((String)entry.getKey(), (String)entry.getValue(), readOnly){

            public boolean getNameIsWriteable() {
                return !readOnly;
            }
        });
    }

    private boolean isModifiedSysEnv(@NotNull EnvironmentVariable v) {
        if (v == null) {
            EnvironmentVariablesTextFieldWithBrowseButton.$$$reportNull$$$0(11);
        }
        return !v.getNameIsWriteable() && !Comparing.equal((String)v.getValue(), (String)this.myParentDefaults.get(v.getName()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/configuration/EnvironmentVariablesTextFieldWithBrowseButton";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeListener";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "v";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvs";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/configuration/EnvironmentVariablesTextFieldWithBrowseButton";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getData";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultIcon";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getHoveredIcon";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "stringifyEnvs";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setEnvs";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setData";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "stringifyEnvs";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addChangeListener";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeChangeListener";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isModifiedSysEnv";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyEnvVariablesTable
    extends EnvVariablesTable {
        private final boolean myUserList;

        private MyEnvVariablesTable(List<EnvironmentVariable> list2, boolean userList) {
            this.myUserList = userList;
            TableView tableView = this.getTableView();
            tableView.setPreferredScrollableViewportSize(new Dimension(tableView.getPreferredScrollableViewportSize().width, tableView.getRowHeight() * 7));
            this.setValues(list2);
            this.setPasteActionEnabled(this.myUserList);
        }

        @Nullable
        protected AnActionButtonRunnable createAddAction() {
            return this.myUserList ? super.createAddAction() : null;
        }

        @Nullable
        protected AnActionButtonRunnable createRemoveAction() {
            return this.myUserList ? super.createRemoveAction() : null;
        }

        @NotNull
        protected AnActionButton[] createExtraActions() {
            AnActionButton[] anActionButtonArray = this.myUserList ? super.createExtraActions() : (AnActionButton[])ArrayUtil.append((Object[])super.createExtraActions(), (Object)new AnActionButton(ActionsBundle.message((String)"action.ChangesView.Revert.text", (Object[])new Object[0]), AllIcons.Actions.Rollback){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    MyEnvVariablesTable.this.stopEditing();
                    List variables = MyEnvVariablesTable.this.getSelection();
                    for (EnvironmentVariable environmentVariable : variables) {
                        if (!EnvironmentVariablesTextFieldWithBrowseButton.this.isModifiedSysEnv(environmentVariable)) continue;
                        environmentVariable.setValue((String)EnvironmentVariablesTextFieldWithBrowseButton.this.myParentDefaults.get(environmentVariable.getName()));
                        MyEnvVariablesTable.this.setModified();
                    }
                    MyEnvVariablesTable.this.getTableView().revalidate();
                    MyEnvVariablesTable.this.getTableView().repaint();
                }

                public boolean isEnabled() {
                    List selection = MyEnvVariablesTable.this.getSelection();
                    for (EnvironmentVariable variable : selection) {
                        if (!EnvironmentVariablesTextFieldWithBrowseButton.this.isModifiedSysEnv(variable)) continue;
                        return true;
                    }
                    return false;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/configuration/EnvironmentVariablesTextFieldWithBrowseButton$MyEnvVariablesTable$1", "actionPerformed"));
                }
            });
            if (anActionButtonArray == null) {
                MyEnvVariablesTable.$$$reportNull$$$0(0);
            }
            return anActionButtonArray;
        }

        protected ListTableModel createListModel() {
            return new ListTableModel(new ColumnInfo[]{new MyNameColumnInfo(), new MyValueColumnInfo()});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configuration/EnvironmentVariablesTextFieldWithBrowseButton$MyEnvVariablesTable", "createExtraActions"));
        }

        protected class MyValueColumnInfo
        extends EnvVariablesTable.ValueColumnInfo {
            private final DefaultTableCellRenderer myModifiedRenderer;

            protected MyValueColumnInfo() {
                super((EnvVariablesTable)MyEnvVariablesTable.this);
                this.myModifiedRenderer = new DefaultTableCellRenderer(){

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row2, int column) {
                        Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row2, column);
                        component.setFont(component.getFont().deriveFont(1));
                        if (!hasFocus && !isSelected) {
                            component.setForeground(JBUI.CurrentTheme.Link.linkColor());
                        }
                        return component;
                    }
                };
            }

            public boolean isCellEditable(EnvironmentVariable environmentVariable) {
                return true;
            }

            public TableCellRenderer getCustomizedRenderer(EnvironmentVariable o, TableCellRenderer renderer2) {
                return EnvironmentVariablesTextFieldWithBrowseButton.this.isModifiedSysEnv(o) ? this.myModifiedRenderer : renderer2;
            }
        }

        protected class MyNameColumnInfo
        extends EnvVariablesTable.NameColumnInfo {
            private final DefaultTableCellRenderer myModifiedRenderer;

            protected MyNameColumnInfo() {
                super((EnvVariablesTable)MyEnvVariablesTable.this);
                this.myModifiedRenderer = new DefaultTableCellRenderer(){

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row2, int column) {
                        Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row2, column);
                        component.setEnabled(table.isEnabled() && (hasFocus || isSelected));
                        return component;
                    }
                };
            }

            public TableCellRenderer getCustomizedRenderer(EnvironmentVariable o, TableCellRenderer renderer2) {
                return o.getNameIsWriteable() ? renderer2 : this.myModifiedRenderer;
            }
        }
    }

    private class MyEnvironmentVariablesDialog
    extends DialogWrapper {
        private final EnvVariablesTable myUserTable;
        private final EnvVariablesTable mySystemTable;
        private final JCheckBox myIncludeSystemVarsCb;
        private final JPanel myWholePanel;

        protected MyEnvironmentVariablesDialog() {
            super((Component)((Object)EnvironmentVariablesTextFieldWithBrowseButton.this), true);
            LinkedHashMap<String, String> userMap = new LinkedHashMap<String, String>(EnvironmentVariablesTextFieldWithBrowseButton.this.myData.getEnvs());
            TreeMap parentMap = new TreeMap(new GeneralCommandLine().getParentEnvironment());
            EnvironmentVariablesTextFieldWithBrowseButton.this.myParentDefaults.putAll(parentMap);
            Iterator iterator = userMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!parentMap.containsKey(entry.getKey())) continue;
                parentMap.put(entry.getKey(), entry.getValue());
                iterator.remove();
            }
            List userList = EnvironmentVariablesTextFieldWithBrowseButton.convertToVariables(userMap, false);
            List systemList = EnvironmentVariablesTextFieldWithBrowseButton.convertToVariables(parentMap, true);
            this.myUserTable = new MyEnvVariablesTable(userList, true);
            this.mySystemTable = new MyEnvVariablesTable(systemList, false);
            this.myIncludeSystemVarsCb = new JCheckBox(ExecutionBundle.message((String)"env.vars.system.title", (Object[])new Object[0]));
            this.myIncludeSystemVarsCb.setSelected(EnvironmentVariablesTextFieldWithBrowseButton.this.isPassParentEnvs());
            this.myIncludeSystemVarsCb.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MyEnvironmentVariablesDialog.this.updateSysTableState();
                }
            });
            JLabel label2 = new JLabel(ExecutionBundle.message((String)"env.vars.user.title", (Object[])new Object[0]));
            label2.setLabelFor(this.myUserTable.getTableView().getComponent());
            this.myWholePanel = new JPanel((LayoutManager)new MigLayout("fill, ins 0, gap 0, hidemode 3"));
            this.myWholePanel.add((Component)label2, "hmax pref, wrap");
            this.myWholePanel.add((Component)this.myUserTable.getComponent(), "push, grow, wrap, gaptop 5");
            this.myWholePanel.add((Component)this.myIncludeSystemVarsCb, "hmax pref, wrap, gaptop 5");
            this.myWholePanel.add((Component)this.mySystemTable.getComponent(), "push, grow, wrap, gaptop 5");
            this.updateSysTableState();
            this.setTitle(ExecutionBundle.message((String)"environment.variables.dialog.title", (Object[])new Object[0]));
            this.init();
        }

        @Nullable
        protected String getDimensionServiceKey() {
            return "EnvironmentVariablesDialog";
        }

        private void updateSysTableState() {
            this.mySystemTable.getTableView().setEnabled(this.myIncludeSystemVarsCb.isSelected());
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return this.myWholePanel;
        }

        @Nullable
        protected ValidationInfo doValidate() {
            for (EnvironmentVariable variable : this.myUserTable.getEnvironmentVariables()) {
                String name = variable.getName();
                String value = variable.getValue();
                if (StringUtil.isEmpty((String)name) && StringUtil.isEmpty((String)value)) continue;
                if (!EnvironmentUtil.isValidName((String)name)) {
                    return new ValidationInfo(IdeBundle.message((String)"run.configuration.invalid.env.name", (Object[])new Object[]{name}));
                }
                if (EnvironmentUtil.isValidValue((String)value)) continue;
                return new ValidationInfo(IdeBundle.message((String)"run.configuration.invalid.env.value", (Object[])new Object[]{name, value}));
            }
            return super.doValidate();
        }

        protected void doOKAction() {
            this.myUserTable.stopEditing();
            LinkedHashMap<String, String> envs = new LinkedHashMap<String, String>();
            for (EnvironmentVariable variable : this.myUserTable.getEnvironmentVariables()) {
                if (StringUtil.isEmpty((String)variable.getName()) && StringUtil.isEmpty((String)variable.getValue())) continue;
                envs.put(variable.getName(), variable.getValue());
            }
            for (EnvironmentVariable variable : this.mySystemTable.getEnvironmentVariables()) {
                if (!EnvironmentVariablesTextFieldWithBrowseButton.this.isModifiedSysEnv(variable)) continue;
                envs.put(variable.getName(), variable.getValue());
            }
            EnvironmentVariablesTextFieldWithBrowseButton.this.setEnvs(envs);
            EnvironmentVariablesTextFieldWithBrowseButton.this.setPassParentEnvs(this.myIncludeSystemVarsCb.isSelected());
            super.doOKAction();
        }
    }
}

