/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.compound;

import com.intellij.execution.DefaultExecutionTarget;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.ExecutionTargetManagerImpl;
import com.intellij.execution.Executor;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.RunnerIconProvider;
import com.intellij.execution.SuggestUsingRunDashBoardUtil;
import com.intellij.execution.compound.CompoundRunConfiguration;
import com.intellij.execution.compound.CompoundRunConfigurationOptions;
import com.intellij.execution.compound.CompoundRunConfigurationSettingsEditor;
import com.intellij.execution.compound.CompoundRunConfigurationType;
import com.intellij.execution.compound.SettingsAndEffectiveTarget;
import com.intellij.execution.compound.TypeNameTarget;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationMinimalBase;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.WithoutOwnBeforeRunSteps;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u001e\n\u0002\b\u0002\u0018\u0000 52\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u00042\u00020\u0005:\u00015B%\b\u0007\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0013H\u0016J\u000e\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bJ\b\u0010\u001c\u001a\u00020\u001dH\u0016J\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fJ\u001c\u0010!\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00140\"2\u0006\u0010\u001a\u001a\u00020\u001bJ\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00132\u0006\u0010&\u001a\u00020'H\u0016J\n\u0010(\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010&\u001a\u00020'2\u0006\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020\u0010H\u0002J\u0010\u0010-\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010.\u001a\u00020\u00172\u0006\u0010/\u001a\u00020\u0002H\u0016J\b\u00100\u001a\u00020\u0017H\u0002J\u001c\u00101\u001a\u00020\u00172\u0014\u00102\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00140\"J\u0014\u00103\u001a\u00020\u00172\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u001304R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R.\u0010\u0011\u001a\"\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0012j\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u0014`\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/intellij/execution/compound/CompoundRunConfiguration;", "Lcom/intellij/execution/configurations/RunConfigurationMinimalBase;", "Lcom/intellij/execution/compound/CompoundRunConfigurationOptions;", "Lcom/intellij/execution/RunnerIconProvider;", "Lcom/intellij/execution/configurations/WithoutOwnBeforeRunSteps;", "", "name", "", "project", "Lcom/intellij/openapi/project/Project;", "factory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/configurations/ConfigurationFactory;)V", "isDirty", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isInitialized", "", "sortedConfigurationsWithTargets", "Ljava/util/LinkedHashMap;", "Lcom/intellij/execution/configurations/RunConfiguration;", "Lcom/intellij/execution/ExecutionTarget;", "Lkotlin/collections/LinkedHashMap;", "checkConfiguration", "", "clone", "doInit", "runManager", "Lcom/intellij/execution/impl/RunManagerImpl;", "getConfigurationEditor", "Lcom/intellij/execution/compound/CompoundRunConfigurationSettingsEditor;", "getConfigurationsWithEffectiveRunTargets", "", "Lcom/intellij/execution/compound/SettingsAndEffectiveTarget;", "getConfigurationsWithTargets", "", "getExecutorIcon", "Ljavax/swing/Icon;", "configuration", "executor", "Lcom/intellij/execution/Executor;", "getState", "Lcom/intellij/execution/configurations/RunProfileState;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "hasRunningSingletons", "initIfNeed", "loadState", "state", "markInitialized", "setConfigurationsWithTargets", "value", "setConfigurationsWithoutTargets", "", "Companion", "intellij.platform.lang.impl"})
public final class CompoundRunConfiguration
extends RunConfigurationMinimalBase<CompoundRunConfigurationOptions>
implements RunnerIconProvider,
WithoutOwnBeforeRunSteps,
Cloneable {
    private LinkedHashMap<RunConfiguration, ExecutionTarget> sortedConfigurationsWithTargets;
    private boolean isInitialized;
    private final AtomicBoolean isDirty;
    @JvmField
    @NotNull
    public static final Comparator<RunConfiguration> COMPARATOR;
    public static final Companion Companion;

    @NotNull
    public final Map<RunConfiguration, ExecutionTarget> getConfigurationsWithTargets(@NotNull RunManagerImpl runManager) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)runManager), (String)"runManager");
        this.initIfNeed(runManager);
        return this.sortedConfigurationsWithTargets;
    }

    public final void setConfigurationsWithTargets(@NotNull Map<RunConfiguration, ? extends ExecutionTarget> value) {
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        this.markInitialized();
        this.sortedConfigurationsWithTargets.clear();
        this.sortedConfigurationsWithTargets.putAll(value);
        this.isDirty.set(true);
    }

    /*
     * WARNING - void declaration
     */
    public final void setConfigurationsWithoutTargets(@NotNull Collection<? extends RunConfiguration> value) {
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        Iterable iterable = value;
        CompoundRunConfiguration compoundRunConfiguration = this;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
        void var4_5 = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            Map map2 = destination$iv$iv;
            RunConfiguration it = (RunConfiguration)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it, null);
            map2.put(pair.getFirst(), pair.getSecond());
        }
        Map map3 = destination$iv$iv;
        compoundRunConfiguration.setConfigurationsWithTargets(map3);
    }

    private final void initIfNeed(RunManagerImpl runManager) {
        if (this.isInitialized) {
            return;
        }
        this.doInit(runManager);
    }

    public final void doInit(@NotNull RunManagerImpl runManager) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)runManager), (String)"runManager");
        this.sortedConfigurationsWithTargets.clear();
        ExecutionTargetManager executionTargetManager = ExecutionTargetManager.getInstance((Project)this.getProject());
        if (executionTargetManager == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.execution.ExecutionTargetManagerImpl");
        }
        ExecutionTargetManagerImpl targetManager = (ExecutionTargetManagerImpl)executionTargetManager;
        for (TypeNameTarget item : ((CompoundRunConfigurationOptions)this.getOptions()).getConfigurations()) {
            ExecutionTarget executionTarget;
            String type = item.getType();
            String name = item.getName();
            if (type == null || name == null) continue;
            RunnerAndConfigurationSettings runnerAndConfigurationSettings = runManager.findConfigurationByTypeAndName(type, name);
            Object settings = runnerAndConfigurationSettings != null ? runnerAndConfigurationSettings.getConfiguration() : null;
            if (settings == null || settings == this) continue;
            if (item.getTargetId() != null) {
                String string;
                String it = string;
                boolean bl = false;
                executionTarget = targetManager.findTargetByIdFor((RunConfiguration)settings, it);
            } else {
                executionTarget = null;
            }
            ExecutionTarget target2 = executionTarget;
            this.sortedConfigurationsWithTargets.put((RunConfiguration)settings, target2);
        }
        this.markInitialized();
    }

    private final void markInitialized() {
        this.isInitialized = true;
    }

    @NotNull
    public CompoundRunConfigurationSettingsEditor getConfigurationEditor() {
        return new CompoundRunConfigurationSettingsEditor(this.getProject());
    }

    public void checkConfiguration() {
        if (this.sortedConfigurationsWithTargets.isEmpty()) {
            throw (Throwable)new RuntimeConfigurationException("There is nothing to run");
        }
        if (ExecutionTargetManager.getInstance((Project)this.getProject()).getTargetsFor((RunConfiguration)this).isEmpty()) {
            throw (Throwable)new RuntimeConfigurationException("No suitable targets to run on; please choose a target for each configuration");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) {
        Collection<ConfigurationType> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        try {
            this.checkConfiguration();
        }
        catch (RuntimeConfigurationException e) {
            throw (Throwable)new ExecutionException(e.getMessage());
        }
        Iterable e = this.getConfigurationsWithEffectiveRunTargets();
        Project project = this.getProject();
        void var4_6 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            SettingsAndEffectiveTarget settingsAndEffectiveTarget = (SettingsAndEffectiveTarget)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            ConfigurationType configurationType = it.getConfiguration().getType();
            collection.add(configurationType);
        }
        collection = (List)destination$iv$iv;
        SuggestUsingRunDashBoardUtil.promptUserToUseRunDashboard((Project)project, (Collection)collection);
        return new RunProfileState(this, executor){
            final /* synthetic */ CompoundRunConfiguration this$0;
            final /* synthetic */ Executor $executor;

            @Nullable
            public final Void execute(Executor $noName_0, @NotNull ProgramRunner<RunnerSettings> $noName_1) {
                Intrinsics.checkParameterIsNotNull($noName_1, (String)"<anonymous parameter 1>");
                ApplicationManager.getApplication().invokeLater(new Runnable(this){
                    final /* synthetic */ getState.2 this$0;

                    public final void run() {
                        long groupId = ExecutionEnvironment.getNextUnusedExecutionId();
                        for (SettingsAndEffectiveTarget settingsAndEffectiveTarget : this.this$0.this$0.getConfigurationsWithEffectiveRunTargets()) {
                            RunnerAndConfigurationSettings settings;
                            RunConfiguration configuration = settingsAndEffectiveTarget.component1();
                            ExecutionTarget target2 = settingsAndEffectiveTarget.component2();
                            if (RunManagerImpl.Companion.getInstanceImpl(this.this$0.this$0.getProject()).findSettings(configuration) == null) {
                                continue;
                            }
                            ExecutionUtil.runConfiguration((RunnerAndConfigurationSettings)settings, (Executor)this.this$0.$executor, (ExecutionTarget)target2, (long)groupId);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
                return null;
            }
            {
                this.this$0 = compoundRunConfiguration;
                this.$executor = executor;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<SettingsAndEffectiveTarget> getConfigurationsWithEffectiveRunTargets() {
        void $receiver$iv$iv;
        void $receiver$iv$iv$iv;
        Map $receiver$iv;
        ExecutionTarget executionTarget = ExecutionTargetManager.getActiveTarget((Project)this.getProject());
        Intrinsics.checkExpressionValueIsNotNull((Object)executionTarget, (String)"ExecutionTargetManager.getActiveTarget(project)");
        ExecutionTarget activeTarget = executionTarget;
        ExecutionTarget defaultTarget = DefaultExecutionTarget.INSTANCE;
        Map map2 = $receiver$iv = (Map)this.sortedConfigurationsWithTargets;
        Collection destination$iv$iv = new ArrayList();
        void var7_7 = $receiver$iv$iv$iv = $receiver$iv$iv;
        Iterator iterator = var7_7.entrySet().iterator();
        while (iterator.hasNext()) {
            SettingsAndEffectiveTarget settingsAndEffectiveTarget;
            ExecutionTarget effectiveTarget;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv;
            Map.Entry $configuration_specifiedTarget = element$iv$iv = (element$iv$iv$iv = iterator.next());
            boolean bl = false;
            Map.Entry entry = $configuration_specifiedTarget;
            RunConfiguration configuration = (RunConfiguration)entry.getKey();
            entry = $configuration_specifiedTarget;
            ExecutionTarget specifiedTarget = (ExecutionTarget)entry.getValue();
            ExecutionTarget executionTarget2 = specifiedTarget;
            if (executionTarget2 == null) {
                executionTarget2 = ExecutionTargetManager.canRun((RunConfiguration)configuration, (ExecutionTarget)activeTarget) ? activeTarget : defaultTarget;
            }
            ExecutionTarget executionTarget3 = effectiveTarget = executionTarget2;
            Intrinsics.checkExpressionValueIsNotNull((Object)executionTarget3, (String)"effectiveTarget");
            SettingsAndEffectiveTarget it$iv$iv = settingsAndEffectiveTarget = new SettingsAndEffectiveTarget(configuration, executionTarget3);
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public CompoundRunConfigurationOptions getState() {
        if (this.isDirty.compareAndSet(true, false)) {
            Collection collection;
            void $receiver$iv;
            Map map2 = this.sortedConfigurationsWithTargets;
            Collection collection2 = new ArrayList();
            CompoundRunConfigurationOptions compoundRunConfigurationOptions = (CompoundRunConfigurationOptions)this.getOptions();
            void var3_4 = $receiver$iv;
            Iterator iterator = var3_4.entrySet().iterator();
            while (iterator.hasNext()) {
                void entry;
                void destination$iv;
                Map.Entry item$iv;
                Map.Entry entry2 = item$iv = iterator.next();
                collection = destination$iv;
                boolean bl = false;
                ConfigurationType configurationType = ((RunConfiguration)entry.getKey()).getType();
                Intrinsics.checkExpressionValueIsNotNull((Object)configurationType, (String)"entry.key.type");
                String string = configurationType.getId();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"entry.key.type.id");
                String string2 = ((RunConfiguration)entry.getKey()).getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"entry.key.name");
                ExecutionTarget executionTarget = (ExecutionTarget)entry.getValue();
                TypeNameTarget typeNameTarget = new TypeNameTarget(string, string2, executionTarget != null ? executionTarget.getId() : null);
                collection.add(typeNameTarget);
            }
            collection = collection2;
            compoundRunConfigurationOptions.setConfigurations((List)collection);
        }
        return (CompoundRunConfigurationOptions)this.getOptions();
    }

    public void loadState(@NotNull CompoundRunConfigurationOptions state) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)state), (String)"state");
        super.loadState((BaseState)state);
        this.sortedConfigurationsWithTargets.clear();
        this.isInitialized = false;
    }

    @NotNull
    public RunConfiguration clone() {
        CompoundRunConfiguration clone = new CompoundRunConfiguration(this.getName(), this.getProject(), this.getFactory());
        CompoundRunConfigurationOptions compoundRunConfigurationOptions = this.getState();
        if (compoundRunConfigurationOptions == null) {
            Intrinsics.throwNpe();
        }
        clone.loadState(compoundRunConfigurationOptions);
        return (RunConfiguration)clone;
    }

    @NotNull
    public Icon getExecutorIcon(@NotNull RunConfiguration configuration, @NotNull Executor executor) {
        Icon icon;
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
        if (Intrinsics.areEqual((Object)DefaultRunExecutor.EXECUTOR_ID, (Object)executor.getId()) && this.hasRunningSingletons()) {
            Icon icon2 = AllIcons.Actions.Restart;
            icon = icon2;
            Intrinsics.checkExpressionValueIsNotNull((Object)icon2, (String)"AllIcons.Actions.Restart");
        } else {
            Icon icon3 = executor.getIcon();
            icon = icon3;
            Intrinsics.checkExpressionValueIsNotNull((Object)icon3, (String)"executor.icon");
        }
        return icon;
    }

    private final boolean hasRunningSingletons() {
        Project project = this.getProject();
        if (project.isDisposed()) {
            return false;
        }
        List<RunContentDescriptor> list2 = ExecutionManagerImpl.getInstance(project).getRunningDescriptors((Condition<RunnerAndConfigurationSettings>)((Condition)new Condition<RunnerAndConfigurationSettings>(this, project){
            final /* synthetic */ CompoundRunConfiguration this$0;
            final /* synthetic */ Project $project;

            public final boolean value(RunnerAndConfigurationSettings s) {
                RunManagerImpl manager = RunManagerImpl.Companion.getInstanceImpl(this.$project);
                Map map2 = CompoundRunConfiguration.access$getSortedConfigurationsWithTargets$p(this.this$0);
                for (Map.Entry<K, V> entry : map2.entrySet()) {
                    Map.Entry<K, V> entry2 = entry;
                    RunConfiguration configuration = (RunConfiguration)entry2.getKey();
                    if (configuration instanceof CompoundRunConfiguration && CompoundRunConfiguration.access$hasRunningSingletons((CompoundRunConfiguration)configuration)) {
                        return true;
                    }
                    RunnerAndConfigurationSettings settings = manager.findSettings(configuration);
                    if (settings == null) continue;
                    RunConfiguration runConfiguration = settings.getConfiguration();
                    Intrinsics.checkExpressionValueIsNotNull((Object)runConfiguration, (String)"settings.configuration");
                    if (runConfiguration.isAllowRunningInParallel()) continue;
                    RunnerAndConfigurationSettings runnerAndConfigurationSettings = s;
                    Intrinsics.checkExpressionValueIsNotNull((Object)runnerAndConfigurationSettings, (String)"s");
                    if (!Intrinsics.areEqual((Object)configuration, (Object)runnerAndConfigurationSettings.getConfiguration())) continue;
                    return true;
                }
                return false;
            }
            {
                this.this$0 = compoundRunConfiguration;
                this.$project = project;
            }
        }));
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"ExecutionManagerImpl.get\u2026      }\n      false\n    }");
        Collection collection = list2;
        return !collection.isEmpty();
    }

    @JvmOverloads
    public CompoundRunConfiguration(@Nullable String name, @NotNull Project project, @NotNull ConfigurationFactory factory) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)factory, (String)"factory");
        super(name, factory, project);
        this.sortedConfigurationsWithTargets = new LinkedHashMap();
        this.isDirty = new AtomicBoolean();
    }

    @JvmOverloads
    public /* synthetic */ CompoundRunConfiguration(String string, Project project, ConfigurationFactory configurationFactory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            boolean $i$f$runConfigurationType = false;
            configurationFactory = (ConfigurationFactory)ConfigurationTypeUtil.findConfigurationType(CompoundRunConfigurationType.class);
        }
        this(string, project, configurationFactory);
    }

    @JvmOverloads
    public CompoundRunConfiguration(@Nullable String name, @NotNull Project project) {
        this(name, project, null, 4, null);
    }

    @JvmOverloads
    public CompoundRunConfiguration(@NotNull Project project) {
        this(null, project, null, 5, null);
    }

    static {
        Companion = new Companion(null);
        COMPARATOR = Companion.COMPARATOR.1.INSTANCE;
    }

    public static final /* synthetic */ LinkedHashMap access$getSortedConfigurationsWithTargets$p(CompoundRunConfiguration $this) {
        return $this.sortedConfigurationsWithTargets;
    }

    public static final /* synthetic */ void access$setSortedConfigurationsWithTargets$p(CompoundRunConfiguration $this, LinkedHashMap linkedHashMap) {
        $this.sortedConfigurationsWithTargets = linkedHashMap;
    }

    public static final /* synthetic */ boolean access$hasRunningSingletons(CompoundRunConfiguration $this) {
        return $this.hasRunningSingletons();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/execution/compound/CompoundRunConfiguration$Companion;", "", "()V", "COMPARATOR", "Ljava/util/Comparator;", "Lcom/intellij/execution/configurations/RunConfiguration;", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

