/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.side;

import com.intellij.diff.DiffContext;
import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.tools.holders.EditorHolder;
import com.intellij.diff.tools.holders.EditorHolderFactory;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.FocusTrackerSupport;
import com.intellij.diff.tools.util.SimpleDiffPanel;
import com.intellij.diff.tools.util.base.ListenerDiffViewerBase;
import com.intellij.diff.tools.util.side.ThreesideContentPanel;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.ThreeSide;
import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.pom.Navigatable;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ThreesideDiffViewer<T extends EditorHolder>
extends ListenerDiffViewerBase {
    @NotNull
    protected final SimpleDiffPanel myPanel;
    @NotNull
    protected final ThreesideContentPanel myContentPanel;
    @NotNull
    private final List<T> myHolders;
    @NotNull
    private final FocusTrackerSupport<ThreeSide> myFocusTrackerSupport;

    public ThreesideDiffViewer(@NotNull DiffContext context, @NotNull ContentDiffRequest request, @NotNull EditorHolderFactory<T> factory) {
        if (context == null) {
            ThreesideDiffViewer.$$$reportNull$$$0(0);
        }
        if (request == null) {
            ThreesideDiffViewer.$$$reportNull$$$0(1);
        }
        if (factory == null) {
            ThreesideDiffViewer.$$$reportNull$$$0(2);
        }
        super(context, request);
        this.myHolders = this.createEditorHolders(factory);
        List<JComponent> titlePanel = this.createTitles();
        this.myFocusTrackerSupport = new FocusTrackerSupport.Threeside(this.myHolders);
        this.myContentPanel = new ThreesideContentPanel(this.myHolders, titlePanel);
        this.myPanel = new SimpleDiffPanel(this.myContentPanel, (DataProvider)this, context);
    }

    @Override
    protected void onInit() {
        super.onInit();
        this.myPanel.setPersistentNotifications(DiffUtil.getCustomNotifications((UserDataHolder)this.myContext, (UserDataHolder)this.myRequest));
    }

    @Override
    protected void onDispose() {
        this.destroyEditorHolders();
        super.onDispose();
    }

    @Override
    protected void processContextHints() {
        super.processContextHints();
        this.myFocusTrackerSupport.processContextHints((DiffRequest)this.myRequest, this.myContext);
    }

    @Override
    protected void updateContextHints() {
        super.updateContextHints();
        this.myFocusTrackerSupport.updateContextHints((DiffRequest)this.myRequest, this.myContext);
    }

    @NotNull
    protected List<T> createEditorHolders(@NotNull EditorHolderFactory<T> factory) {
        if (factory == null) {
            ThreesideDiffViewer.$$$reportNull$$$0(3);
        }
        List contents = this.myRequest.getContents();
        ArrayList<T> holders = new ArrayList<T>(3);
        for (int i = 0; i < 3; ++i) {
            DiffContent content = (DiffContent)contents.get(i);
            holders.add(factory.create(content, this.myContext));
        }
        ArrayList<T> arrayList = holders;
        if (arrayList == null) {
            ThreesideDiffViewer.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private void destroyEditorHolders() {
        for (EditorHolder holder : this.myHolders) {
            Disposer.dispose((Disposable)holder);
        }
    }

    @NotNull
    protected List<JComponent> createTitles() {
        List<JComponent> list2 = DiffUtil.createSyncHeightComponents(DiffUtil.createSimpleTitles(this.myRequest));
        if (list2 == null) {
            ThreesideDiffViewer.$$$reportNull$$$0(5);
        }
        return list2;
    }

    @NotNull
    public JComponent getComponent() {
        SimpleDiffPanel simpleDiffPanel = this.myPanel;
        if (simpleDiffPanel == null) {
            ThreesideDiffViewer.$$$reportNull$$$0(6);
        }
        return simpleDiffPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        if (!this.myPanel.isGoodContent()) {
            return null;
        }
        return ((EditorHolder)this.getCurrentEditorHolder()).getPreferredFocusedComponent();
    }

    @NotNull
    public ThreeSide getCurrentSide() {
        ThreeSide threeSide = this.myFocusTrackerSupport.getCurrentSide();
        if (threeSide == null) {
            ThreesideDiffViewer.$$$reportNull$$$0(7);
        }
        return threeSide;
    }

    protected void setCurrentSide(@NotNull ThreeSide side) {
        if (side == null) {
            ThreesideDiffViewer.$$$reportNull$$$0(8);
        }
        this.myFocusTrackerSupport.setCurrentSide(side);
    }

    @NotNull
    protected List<T> getEditorHolders() {
        List<T> list2 = this.myHolders;
        if (list2 == null) {
            ThreesideDiffViewer.$$$reportNull$$$0(9);
        }
        return list2;
    }

    @NotNull
    protected T getCurrentEditorHolder() {
        EditorHolder editorHolder = (EditorHolder)this.getCurrentSide().select(this.getEditorHolders());
        if (editorHolder == null) {
            ThreesideDiffViewer.$$$reportNull$$$0(10);
        }
        return (T)editorHolder;
    }

    @Override
    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            ThreesideDiffViewer.$$$reportNull$$$0(11);
        }
        if (DiffDataKeys.CURRENT_CONTENT.is(dataId)) {
            return this.getCurrentSide().select(this.myRequest.getContents());
        }
        return super.getData(dataId);
    }

    @Override
    @Nullable
    protected Navigatable getNavigatable() {
        return ((DiffContent)this.getCurrentSide().select(this.getRequest().getContents())).getNavigatable();
    }

    public static <T extends EditorHolder> boolean canShowRequest(@NotNull DiffContext context, @NotNull DiffRequest request, @NotNull EditorHolderFactory<T> factory) {
        if (context == null) {
            ThreesideDiffViewer.$$$reportNull$$$0(12);
        }
        if (request == null) {
            ThreesideDiffViewer.$$$reportNull$$$0(13);
        }
        if (factory == null) {
            ThreesideDiffViewer.$$$reportNull$$$0(14);
        }
        if (!(request instanceof ContentDiffRequest)) {
            return false;
        }
        List contents = ((ContentDiffRequest)request).getContents();
        if (contents.size() != 3) {
            return false;
        }
        boolean canShow = true;
        boolean wantShow = false;
        for (DiffContent content : contents) {
            canShow &= factory.canShowContent(content, context);
            wantShow |= factory.wantShowContent(content, context);
        }
        return canShow && wantShow;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: 
            case 3: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/util/side/ThreesideDiffViewer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/util/side/ThreesideDiffViewer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorHolders";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createTitles";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentSide";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorHolders";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentEditorHolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createEditorHolders";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentSide";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "canShowRequest";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class ShowPartialDiffAction
    extends DumbAwareAction {
        @NotNull
        protected final ThreeSide mySide1;
        @NotNull
        protected final ThreeSide mySide2;

        public ShowPartialDiffAction(PartialDiffMode mode, boolean hasFourSides) {
            String id;
            if (mode == null) {
                ShowPartialDiffAction.$$$reportNull$$$0(0);
            }
            Icon icon = null;
            switch (mode) {
                case LEFT_MIDDLE: {
                    this.mySide1 = ThreeSide.LEFT;
                    this.mySide2 = ThreeSide.BASE;
                    id = "Diff.ComparePartial.Base.Left";
                    if (hasFourSides) break;
                    icon = AllIcons.Diff.Compare3LeftMiddle;
                    break;
                }
                case RIGHT_MIDDLE: {
                    this.mySide1 = ThreeSide.RIGHT;
                    this.mySide2 = ThreeSide.BASE;
                    id = "Diff.ComparePartial.Base.Right";
                    if (hasFourSides) break;
                    icon = AllIcons.Diff.Compare3MiddleRight;
                    break;
                }
                case MIDDLE_LEFT: {
                    this.mySide1 = ThreeSide.BASE;
                    this.mySide2 = ThreeSide.LEFT;
                    id = "Diff.ComparePartial.Base.Left";
                    if (hasFourSides) break;
                    icon = AllIcons.Diff.Compare3LeftMiddle;
                    break;
                }
                case MIDDLE_RIGHT: {
                    this.mySide1 = ThreeSide.BASE;
                    this.mySide2 = ThreeSide.RIGHT;
                    id = "Diff.ComparePartial.Base.Right";
                    if (hasFourSides) break;
                    icon = AllIcons.Diff.Compare3MiddleRight;
                    break;
                }
                case LEFT_RIGHT: {
                    this.mySide1 = ThreeSide.LEFT;
                    this.mySide2 = ThreeSide.RIGHT;
                    id = "Diff.ComparePartial.Left.Right";
                    if (hasFourSides) break;
                    icon = AllIcons.Diff.Compare3LeftRight;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            String text = ActionsBundle.message((String)"action.Diff.ComparePartial.Generic", (Object[])new Object[]{this.mySide1.getIndex(), this.mySide2.getIndex()});
            this.getTemplatePresentation().setText(text);
            this.getTemplatePresentation().setIcon(icon);
            ActionUtil.mergeFrom((AnAction)this, (String)id);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowPartialDiffAction.$$$reportNull$$$0(1);
            }
            SimpleDiffRequest request = this.createRequest();
            DiffManager.getInstance().showDiff(ThreesideDiffViewer.this.myProject, (DiffRequest)request, new DiffDialogHints(null, (Component)ThreesideDiffViewer.this.myPanel));
        }

        @NotNull
        protected SimpleDiffRequest createRequest() {
            List contents = ThreesideDiffViewer.this.myRequest.getContents();
            List titles = ThreesideDiffViewer.this.myRequest.getContentTitles();
            SimpleDiffRequest simpleDiffRequest = new SimpleDiffRequest(ThreesideDiffViewer.this.myRequest.getTitle(), (DiffContent)this.mySide1.select(contents), (DiffContent)this.mySide2.select(contents), (String)this.mySide1.select(titles), (String)this.mySide2.select(titles));
            if (simpleDiffRequest == null) {
                ShowPartialDiffAction.$$$reportNull$$$0(2);
            }
            return simpleDiffRequest;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mode";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/util/side/ThreesideDiffViewer$ShowPartialDiffAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/util/side/ThreesideDiffViewer$ShowPartialDiffAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createRequest";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static enum PartialDiffMode {
        LEFT_MIDDLE,
        RIGHT_MIDDLE,
        MIDDLE_LEFT,
        MIDDLE_RIGHT,
        LEFT_RIGHT;

    }
}

