/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison;

import com.intellij.diff.comparison.ByWord;
import com.intellij.diff.comparison.ChangeCorrector;
import com.intellij.diff.comparison.TrimUtil;
import com.intellij.diff.comparison.iterables.DiffIterable;
import com.intellij.diff.comparison.iterables.DiffIterableUtil;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.util.Range;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Pair;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class ByChar {
    @NotNull
    public static FairDiffIterable compare(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ProgressIndicator indicator) {
        if (text1 == null) {
            ByChar.$$$reportNull$$$0(0);
        }
        if (text2 == null) {
            ByChar.$$$reportNull$$$0(1);
        }
        if (indicator == null) {
            ByChar.$$$reportNull$$$0(2);
        }
        indicator.checkCanceled();
        int[] codePoints1 = ByChar.getAllCodePoints(text1);
        int[] codePoints2 = ByChar.getAllCodePoints(text2);
        FairDiffIterable iterable = DiffIterableUtil.diff(codePoints1, codePoints2, indicator);
        int offset1 = 0;
        int offset2 = 0;
        DiffIterableUtil.ChangeBuilder builder2 = new DiffIterableUtil.ChangeBuilder(text1.length(), text2.length());
        for (Pair<Range, Boolean> pair : DiffIterableUtil.iterateAll(iterable)) {
            Range range2 = (Range)pair.first;
            boolean equals = (Boolean)pair.second;
            int end1 = offset1 + ByChar.countChars(codePoints1, range2.start1, range2.end1);
            int end2 = offset2 + ByChar.countChars(codePoints2, range2.start2, range2.end2);
            if (equals) {
                builder2.markEqual(offset1, offset2, end1, end2);
            }
            offset1 = end1;
            offset2 = end2;
        }
        assert (offset1 == text1.length());
        assert (offset2 == text2.length());
        FairDiffIterable fairDiffIterable = DiffIterableUtil.fair(builder2.finish());
        if (fairDiffIterable == null) {
            ByChar.$$$reportNull$$$0(3);
        }
        return fairDiffIterable;
    }

    @NotNull
    public static FairDiffIterable compareTwoStep(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ProgressIndicator indicator) {
        if (text1 == null) {
            ByChar.$$$reportNull$$$0(4);
        }
        if (text2 == null) {
            ByChar.$$$reportNull$$$0(5);
        }
        if (indicator == null) {
            ByChar.$$$reportNull$$$0(6);
        }
        indicator.checkCanceled();
        CodePointsOffsets codePoints1 = ByChar.getNonSpaceCodePoints(text1);
        CodePointsOffsets codePoints2 = ByChar.getNonSpaceCodePoints(text2);
        FairDiffIterable nonSpaceChanges = DiffIterableUtil.diff(codePoints1.codePoints, codePoints2.codePoints, indicator);
        FairDiffIterable fairDiffIterable = ByChar.matchAdjustmentSpaces(codePoints1, codePoints2, text1, text2, nonSpaceChanges, indicator);
        if (fairDiffIterable == null) {
            ByChar.$$$reportNull$$$0(7);
        }
        return fairDiffIterable;
    }

    @NotNull
    public static DiffIterable compareTrimWhitespaces(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ProgressIndicator indicator) {
        if (text1 == null) {
            ByChar.$$$reportNull$$$0(8);
        }
        if (text2 == null) {
            ByChar.$$$reportNull$$$0(9);
        }
        if (indicator == null) {
            ByChar.$$$reportNull$$$0(10);
        }
        FairDiffIterable iterable = ByChar.compareTwoStep(text1, text2, indicator);
        DiffIterable diffIterable = new ByWord.TrimSpacesCorrector(iterable, text1, text2, indicator).build();
        if (diffIterable == null) {
            ByChar.$$$reportNull$$$0(11);
        }
        return diffIterable;
    }

    @NotNull
    public static DiffIterable compareIgnoreWhitespaces(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ProgressIndicator indicator) {
        if (text1 == null) {
            ByChar.$$$reportNull$$$0(12);
        }
        if (text2 == null) {
            ByChar.$$$reportNull$$$0(13);
        }
        if (indicator == null) {
            ByChar.$$$reportNull$$$0(14);
        }
        indicator.checkCanceled();
        CodePointsOffsets codePoints1 = ByChar.getNonSpaceCodePoints(text1);
        CodePointsOffsets codePoints2 = ByChar.getNonSpaceCodePoints(text2);
        FairDiffIterable changes2 = DiffIterableUtil.diff(codePoints1.codePoints, codePoints2.codePoints, indicator);
        DiffIterable diffIterable = ByChar.matchAdjustmentSpacesIW(codePoints1, codePoints2, text1, text2, changes2);
        if (diffIterable == null) {
            ByChar.$$$reportNull$$$0(15);
        }
        return diffIterable;
    }

    @NotNull
    public static FairDiffIterable comparePunctuation(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ProgressIndicator indicator) {
        if (text1 == null) {
            ByChar.$$$reportNull$$$0(16);
        }
        if (text2 == null) {
            ByChar.$$$reportNull$$$0(17);
        }
        if (indicator == null) {
            ByChar.$$$reportNull$$$0(18);
        }
        indicator.checkCanceled();
        CodePointsOffsets chars1 = ByChar.getPunctuationChars(text1);
        CodePointsOffsets chars2 = ByChar.getPunctuationChars(text2);
        FairDiffIterable nonSpaceChanges = DiffIterableUtil.diff(chars1.codePoints, chars2.codePoints, indicator);
        FairDiffIterable fairDiffIterable = ByChar.transferPunctuation(chars1, chars2, text1, text2, nonSpaceChanges, indicator);
        if (fairDiffIterable == null) {
            ByChar.$$$reportNull$$$0(19);
        }
        return fairDiffIterable;
    }

    @NotNull
    private static FairDiffIterable transferPunctuation(@NotNull CodePointsOffsets chars1, @NotNull CodePointsOffsets chars2, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull FairDiffIterable changes2, @NotNull ProgressIndicator indicator) {
        if (chars1 == null) {
            ByChar.$$$reportNull$$$0(20);
        }
        if (chars2 == null) {
            ByChar.$$$reportNull$$$0(21);
        }
        if (text1 == null) {
            ByChar.$$$reportNull$$$0(22);
        }
        if (text2 == null) {
            ByChar.$$$reportNull$$$0(23);
        }
        if (changes2 == null) {
            ByChar.$$$reportNull$$$0(24);
        }
        if (indicator == null) {
            ByChar.$$$reportNull$$$0(25);
        }
        DiffIterableUtil.ChangeBuilder builder2 = new DiffIterableUtil.ChangeBuilder(text1.length(), text2.length());
        for (Range range2 : changes2.iterateUnchanged()) {
            int count = range2.end1 - range2.start1;
            for (int i = 0; i < count; ++i) {
                int offset1 = chars1.offsets[range2.start1 + i];
                int offset2 = chars2.offsets[range2.start2 + i];
                builder2.markEqual(offset1, offset2);
            }
        }
        FairDiffIterable fairDiffIterable = DiffIterableUtil.fair(builder2.finish());
        if (fairDiffIterable == null) {
            ByChar.$$$reportNull$$$0(26);
        }
        return fairDiffIterable;
    }

    @NotNull
    private static FairDiffIterable matchAdjustmentSpaces(@NotNull CodePointsOffsets codePoints1, @NotNull CodePointsOffsets codePoints2, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull FairDiffIterable changes2, @NotNull ProgressIndicator indicator) {
        if (codePoints1 == null) {
            ByChar.$$$reportNull$$$0(27);
        }
        if (codePoints2 == null) {
            ByChar.$$$reportNull$$$0(28);
        }
        if (text1 == null) {
            ByChar.$$$reportNull$$$0(29);
        }
        if (text2 == null) {
            ByChar.$$$reportNull$$$0(30);
        }
        if (changes2 == null) {
            ByChar.$$$reportNull$$$0(31);
        }
        if (indicator == null) {
            ByChar.$$$reportNull$$$0(32);
        }
        FairDiffIterable fairDiffIterable = new ChangeCorrector.DefaultCharChangeCorrector(codePoints1, codePoints2, text1, text2, changes2, indicator).build();
        if (fairDiffIterable == null) {
            ByChar.$$$reportNull$$$0(33);
        }
        return fairDiffIterable;
    }

    @NotNull
    private static DiffIterable matchAdjustmentSpacesIW(@NotNull CodePointsOffsets codePoints1, @NotNull CodePointsOffsets codePoints2, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull FairDiffIterable changes2) {
        if (codePoints1 == null) {
            ByChar.$$$reportNull$$$0(34);
        }
        if (codePoints2 == null) {
            ByChar.$$$reportNull$$$0(35);
        }
        if (text1 == null) {
            ByChar.$$$reportNull$$$0(36);
        }
        if (text2 == null) {
            ByChar.$$$reportNull$$$0(37);
        }
        if (changes2 == null) {
            ByChar.$$$reportNull$$$0(38);
        }
        ArrayList<Range> ranges = new ArrayList<Range>();
        for (Range ch : changes2.iterateChanges()) {
            int startOffset2;
            int endOffset2;
            int startOffset1;
            int endOffset1;
            if (ch.start1 == ch.end1) {
                startOffset1 = endOffset1 = ByChar.expandForwardW(codePoints1, codePoints2, text1, text2, ch, true);
            } else {
                startOffset1 = codePoints1.charOffset(ch.start1);
                endOffset1 = codePoints1.charOffsetAfter(ch.end1 - 1);
            }
            if (ch.start2 == ch.end2) {
                startOffset2 = endOffset2 = ByChar.expandForwardW(codePoints1, codePoints2, text1, text2, ch, false);
            } else {
                startOffset2 = codePoints2.charOffset(ch.start2);
                endOffset2 = codePoints2.charOffsetAfter(ch.end2 - 1);
            }
            ranges.add(new Range(startOffset1, endOffset1, startOffset2, endOffset2));
        }
        DiffIterable diffIterable = DiffIterableUtil.create(ranges, text1.length(), text2.length());
        if (diffIterable == null) {
            ByChar.$$$reportNull$$$0(39);
        }
        return diffIterable;
    }

    private static int expandForwardW(@NotNull CodePointsOffsets codePoints1, @NotNull CodePointsOffsets codePoints2, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull Range ch, boolean left) {
        if (codePoints1 == null) {
            ByChar.$$$reportNull$$$0(40);
        }
        if (codePoints2 == null) {
            ByChar.$$$reportNull$$$0(41);
        }
        if (text1 == null) {
            ByChar.$$$reportNull$$$0(42);
        }
        if (text2 == null) {
            ByChar.$$$reportNull$$$0(43);
        }
        if (ch == null) {
            ByChar.$$$reportNull$$$0(44);
        }
        int offset1 = ch.start1 == 0 ? 0 : codePoints1.charOffsetAfter(ch.start1 - 1);
        int offset2 = ch.start2 == 0 ? 0 : codePoints2.charOffsetAfter(ch.start2 - 1);
        int start2 = left ? offset1 : offset2;
        return start2 + TrimUtil.expandWhitespacesForward(text1, text2, offset1, offset2, text1.length(), text2.length());
    }

    @NotNull
    private static int[] getAllCodePoints(@NotNull CharSequence text) {
        int charCount;
        if (text == null) {
            ByChar.$$$reportNull$$$0(45);
        }
        TIntArrayList list2 = new TIntArrayList(text.length());
        int len = text.length();
        for (int offset = 0; offset < len; offset += charCount) {
            int ch = Character.codePointAt(text, offset);
            charCount = Character.charCount(ch);
            list2.add(ch);
        }
        int[] nArray = list2.toNativeArray();
        if (nArray == null) {
            ByChar.$$$reportNull$$$0(46);
        }
        return nArray;
    }

    @NotNull
    private static CodePointsOffsets getNonSpaceCodePoints(@NotNull CharSequence text) {
        int charCount;
        if (text == null) {
            ByChar.$$$reportNull$$$0(47);
        }
        TIntArrayList codePoints = new TIntArrayList(text.length());
        TIntArrayList offsets = new TIntArrayList(text.length());
        int len = text.length();
        for (int offset = 0; offset < len; offset += charCount) {
            int ch = Character.codePointAt(text, offset);
            charCount = Character.charCount(ch);
            if (TrimUtil.isWhiteSpaceCodePoint(ch)) continue;
            codePoints.add(ch);
            offsets.add(offset);
        }
        CodePointsOffsets codePointsOffsets = new CodePointsOffsets(codePoints.toNativeArray(), offsets.toNativeArray());
        if (codePointsOffsets == null) {
            ByChar.$$$reportNull$$$0(48);
        }
        return codePointsOffsets;
    }

    @NotNull
    private static CodePointsOffsets getPunctuationChars(@NotNull CharSequence text) {
        if (text == null) {
            ByChar.$$$reportNull$$$0(49);
        }
        TIntArrayList codePoints = new TIntArrayList(text.length());
        TIntArrayList offsets = new TIntArrayList(text.length());
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (!TrimUtil.isPunctuation(c)) continue;
            codePoints.add((int)c);
            offsets.add(i);
        }
        CodePointsOffsets codePointsOffsets = new CodePointsOffsets(codePoints.toNativeArray(), offsets.toNativeArray());
        if (codePointsOffsets == null) {
            ByChar.$$$reportNull$$$0(50);
        }
        return codePointsOffsets;
    }

    private static int countChars(int[] codePoints, int start2, int end) {
        int count = 0;
        for (int i = start2; i < end; ++i) {
            count += Character.charCount(codePoints[i]);
        }
        return count;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 15: 
            case 19: 
            case 26: 
            case 33: 
            case 39: 
            case 46: 
            case 48: 
            case 50: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 15: 
            case 19: 
            case 26: 
            case 33: 
            case 39: 
            case 46: 
            case 48: 
            case 50: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text1";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 13: 
            case 17: 
            case 23: 
            case 30: 
            case 37: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text2";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 14: 
            case 18: 
            case 25: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 15: 
            case 19: 
            case 26: 
            case 33: 
            case 39: 
            case 46: 
            case 48: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/comparison/ByChar";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars1";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars2";
                break;
            }
            case 24: 
            case 31: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 27: 
            case 34: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codePoints1";
                break;
            }
            case 28: 
            case 35: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codePoints2";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ch";
                break;
            }
            case 45: 
            case 47: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/comparison/ByChar";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "compare";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "compareTwoStep";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "compareTrimWhitespaces";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "compareIgnoreWhitespaces";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "comparePunctuation";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "transferPunctuation";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "matchAdjustmentSpaces";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "matchAdjustmentSpacesIW";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllCodePoints";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonSpaceCodePoints";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getPunctuationChars";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "compare";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 15: 
            case 19: 
            case 26: 
            case 33: 
            case 39: 
            case 46: 
            case 48: 
            case 50: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "compareTwoStep";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "compareTrimWhitespaces";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "compareIgnoreWhitespaces";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "comparePunctuation";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "transferPunctuation";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "matchAdjustmentSpaces";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "matchAdjustmentSpacesIW";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "expandForwardW";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getAllCodePoints";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getNonSpaceCodePoints";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getPunctuationChars";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 15: 
            case 19: 
            case 26: 
            case 33: 
            case 39: 
            case 46: 
            case 48: 
            case 50: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class CodePointsOffsets {
        public final int[] codePoints;
        public final int[] offsets;

        CodePointsOffsets(int[] codePoints, int[] offsets) {
            this.codePoints = codePoints;
            this.offsets = offsets;
        }

        public int charOffset(int index) {
            return this.offsets[index];
        }

        public int charOffsetAfter(int index) {
            return this.offsets[index] + Character.charCount(this.codePoints[index]);
        }
    }
}

