/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore;

import com.intellij.credentialStore.CredentialStore;
import com.intellij.credentialStore.CredentialStoreKt;
import com.intellij.credentialStore.EncryptionSpec;
import com.intellij.credentialStore.EncryptionSupportKt;
import com.intellij.credentialStore.EncryptionType;
import com.intellij.credentialStore.MacOsKeychainLibraryKt;
import com.intellij.credentialStore.PasswordSafeConfigurableKt;
import com.intellij.credentialStore.PasswordSafeConfigurableUi;
import com.intellij.credentialStore.PasswordSafeConfigurableUi$WhenMappings;
import com.intellij.credentialStore.PasswordSafeSettings;
import com.intellij.credentialStore.ProviderType;
import com.intellij.credentialStore.gpg.Pgp;
import com.intellij.credentialStore.gpg.PgpKey;
import com.intellij.credentialStore.kdbx.IncorrectMasterPasswordException;
import com.intellij.credentialStore.keePass.KeePassCredentialStoreKt;
import com.intellij.credentialStore.keePass.KeePassFileManager;
import com.intellij.credentialStore.keePass.MasterKeyFileStorage;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.ide.passwordSafe.impl.PasswordSafeImpl;
import com.intellij.ide.passwordSafe.impl.PasswordSafeImplKt;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.layout.BooleanPropertyWithComboBoxUiManager;
import com.intellij.ui.layout.BooleanPropertyWithListUiManager;
import com.intellij.ui.layout.CCFlags;
import com.intellij.ui.layout.Cell;
import com.intellij.ui.layout.ChoicePropertyUiManager;
import com.intellij.ui.layout.GrowPolicy;
import com.intellij.ui.layout.LCFlags;
import com.intellij.ui.layout.LayoutBuilder;
import com.intellij.ui.layout.LayoutBuilderKt;
import com.intellij.ui.layout.LayoutBuilderWithButtonGroup;
import com.intellij.ui.layout.LayoutImplKt;
import com.intellij.ui.layout.Row;
import com.intellij.util.io.PathKt;
import com.intellij.util.text.StringKt;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.SecureRandom;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003,-.B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0002H\u0016J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0002H\u0002J\n\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0002J\n\u0010!\u001a\u0004\u0018\u00010\"H\u0002J\n\u0010#\u001a\u0004\u0018\u00010$H\u0002J\n\u0010%\u001a\u0004\u0018\u00010\u0006H\u0002J\b\u0010&\u001a\u00020\u0013H\u0002J\u0010\u0010'\u001a\u00020(2\u0006\u0010\u0019\u001a\u00020\u0002H\u0002J\u0010\u0010)\u001a\u00020(2\u0006\u0010\u0019\u001a\u00020\u0002H\u0016J\u0010\u0010*\u001a\u00020(2\u0006\u0010\u0019\u001a\u00020\u0002H\u0002J\u0010\u0010+\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0002H\u0016R(\u0010\u0004\u001a\u001c\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\b0\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/intellij/credentialStore/PasswordSafeConfigurableUi;", "Lcom/intellij/openapi/options/ConfigurableUi;", "Lcom/intellij/credentialStore/PasswordSafeSettings;", "()V", "isUsePgp", "Lcom/intellij/ui/layout/BooleanPropertyWithComboBoxUiManager;", "Lcom/intellij/credentialStore/gpg/PgpKey;", "kotlin.jvm.PlatformType", "Lcom/intellij/ui/CollectionComboBoxModel;", "keePassDbFile", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "pgp", "Lcom/intellij/credentialStore/gpg/Pgp;", "getPgp", "()Lcom/intellij/credentialStore/gpg/Pgp;", "pgp$delegate", "Lkotlin/Lazy;", "providerTypeModel", "Lcom/intellij/ui/layout/ChoicePropertyUiManager;", "Lcom/intellij/credentialStore/ProviderType;", "secureRandom", "Lkotlin/Lazy;", "Ljava/security/SecureRandom;", "apply", "", "settings", "createAndSaveKeePassDatabaseWithNewOptions", "createKeePassFileManager", "Lcom/intellij/credentialStore/keePass/KeePassFileManager;", "getComponent", "Ljavax/swing/JPanel;", "getEncryptionSpec", "Lcom/intellij/credentialStore/EncryptionSpec;", "getNewDbFile", "Ljava/nio/file/Path;", "getNewDbFileAsString", "", "getNewPgpKey", "getNewProviderType", "isKeepassFileLocationChanged", "", "isModified", "isPgpKeyChanged", "reset", "ChangeKeePassDatabaseMasterPasswordAction", "ClearKeePassDatabaseAction", "ImportKeePassDatabaseAction", "intellij.platform.credentialStore"})
public final class PasswordSafeConfigurableUi
implements ConfigurableUi<PasswordSafeSettings> {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private TextFieldWithBrowseButton keePassDbFile;
    private BooleanPropertyWithComboBoxUiManager<PgpKey, CollectionComboBoxModel<PgpKey>> isUsePgp = new BooleanPropertyWithComboBoxUiManager((ComboBoxModel)new CollectionComboBoxModel());
    private final ChoicePropertyUiManager<ProviderType> providerTypeModel = new ChoicePropertyUiManager<ProviderType>(ProviderType.KEYCHAIN);
    private final Lazy pgp$delegate = LazyKt.lazy((Function0)pgp.2.INSTANCE);
    private final Lazy<SecureRandom> secureRandom = LazyKt.lazy((Function0)secureRandom.1.INSTANCE);

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(PasswordSafeConfigurableUi.class), "pgp", "getPgp()Lcom/intellij/credentialStore/gpg/Pgp;"))};
    }

    private final Pgp getPgp() {
        Lazy lazy = this.pgp$delegate;
        PasswordSafeConfigurableUi passwordSafeConfigurableUi = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (Pgp)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public void reset(@NotNull PasswordSafeSettings settings) {
        PgpKey pgpKey;
        PgpKey pgpKey2;
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        this.providerTypeModel.setSelected(settings.getProviderType());
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.keePassDbFile;
        if (textFieldWithBrowseButton != null) {
            String string = settings.getKeepassDb();
            if (string == null) {
                string = ((Object)PasswordSafeImplKt.getDefaultKeePassDbFile()).toString();
            }
            textFieldWithBrowseButton.setText(string);
        }
        List<PgpKey> secretKeys = this.getPgp().listKeys();
        ((CollectionComboBoxModel)this.isUsePgp.getListModel()).replaceAll(secretKeys);
        String currentKeyId = settings.getState().getPgpKeyId();
        BooleanPropertyWithComboBoxUiManager<PgpKey, CollectionComboBoxModel<PgpKey>> booleanPropertyWithComboBoxUiManager = this.isUsePgp;
        if (currentKeyId == null) {
            pgpKey2 = null;
        } else {
            Object v4;
            BooleanPropertyWithComboBoxUiManager<PgpKey, CollectionComboBoxModel<PgpKey>> booleanPropertyWithComboBoxUiManager2;
            block6: {
                void $receiver$iv;
                Iterable iterable = secretKeys;
                booleanPropertyWithComboBoxUiManager2 = booleanPropertyWithComboBoxUiManager;
                for (Object element$iv : $receiver$iv) {
                    PgpKey it = (PgpKey)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getKeyId(), (Object)currentKeyId)) continue;
                    v4 = element$iv;
                    break block6;
                }
                v4 = null;
            }
            Object var11_10 = v4;
            booleanPropertyWithComboBoxUiManager = booleanPropertyWithComboBoxUiManager2;
            pgpKey2 = pgpKey = (PgpKey)var11_10;
        }
        if (pgpKey2 == null) {
            pgpKey = (PgpKey)CollectionsKt.firstOrNull(secretKeys);
        }
        booleanPropertyWithComboBoxUiManager.setSelected(pgpKey);
        this.isUsePgp.setValue(!secretKeys.isEmpty() && currentKeyId != null);
        this.isUsePgp.setEnabled(this.providerTypeModel.getSelected() == ProviderType.KEEPASS && !secretKeys.isEmpty());
    }

    public boolean isModified(@NotNull PasswordSafeSettings settings) {
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        if (this.keePassDbFile == null) {
            return false;
        }
        return this.getNewProviderType() != settings.getProviderType() || this.isKeepassFileLocationChanged(settings) || this.isPgpKeyChanged(settings);
    }

    private final boolean isPgpKeyChanged(PasswordSafeSettings settings) {
        PgpKey pgpKey = this.getNewPgpKey();
        return Intrinsics.areEqual((Object)settings.getState().getPgpKeyId(), (Object)(pgpKey != null ? pgpKey.getKeyId() : null)) ^ true;
    }

    private final boolean isKeepassFileLocationChanged(PasswordSafeSettings settings) {
        return this.getNewProviderType() == ProviderType.KEEPASS && Intrinsics.areEqual((Object)this.getNewDbFileAsString(), (Object)settings.getKeepassDb()) ^ true;
    }

    public void apply(@NotNull PasswordSafeSettings settings) {
        ProviderType providerType;
        block21: {
            block22: {
                Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
                providerType = this.getNewProviderType();
                PasswordSafe passwordSafe = PasswordSafe.Companion.getInstance();
                if (passwordSafe == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.ide.passwordSafe.impl.PasswordSafeImpl");
                }
                ((PasswordSafeImpl)passwordSafe).closeCurrentStore$intellij_platform_credentialStore(false, providerType != ProviderType.MEMORY_ONLY);
                PasswordSafe passwordSafe2 = PasswordSafe.Companion.getInstance();
                if (passwordSafe2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.ide.passwordSafe.impl.PasswordSafeImpl");
                }
                PasswordSafeImpl passwordSafe3 = (PasswordSafeImpl)passwordSafe2;
                if (settings.getProviderType() == providerType) break block22;
                switch (PasswordSafeConfigurableUi$WhenMappings.$EnumSwitchMapping$0[providerType.ordinal()]) {
                    case 1: {
                        break block21;
                    }
                    case 2: {
                        try {
                            CredentialStore store = PasswordSafeImplKt.createPersistentCredentialStore();
                            if (store == null) {
                                throw (Throwable)new ConfigurationException("Internal error, no available credential store implementation.");
                            }
                            passwordSafe3.setCurrentProvider$intellij_platform_credentialStore(store);
                            Unit unit = Unit.INSTANCE;
                            break block21;
                        }
                        catch (UnsatisfiedLinkError e) {
                            CredentialStoreKt.getLOG().warn((Throwable)e);
                            if (SystemInfo.isLinux) {
                                throw (Throwable)new ConfigurationException("Package libsecret-1-0 is not installed (to install: sudo apt-get install libsecret-1-0 gnome-keyring).");
                            }
                            throw (Throwable)new ConfigurationException(e.getMessage());
                        }
                    }
                    case 3: {
                        this.createAndSaveKeePassDatabaseWithNewOptions(settings);
                        break block21;
                    }
                    default: {
                        throw (Throwable)new ConfigurationException("Unknown provider type: " + (Object)((Object)providerType));
                    }
                }
            }
            if (this.isKeepassFileLocationChanged(settings)) {
                this.createAndSaveKeePassDatabaseWithNewOptions(settings);
            } else if (providerType == ProviderType.KEEPASS && this.isPgpKeyChanged(settings)) {
                try {
                    Unit unit;
                    KeePassFileManager keePassFileManager = this.createKeePassFileManager();
                    if (keePassFileManager != null) {
                        keePassFileManager.saveMasterKeyToApplyNewEncryptionSpec();
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    Unit unit2 = unit;
                }
                catch (ConfigurationException e) {
                    throw (Throwable)e;
                }
                catch (Exception e) {
                    CredentialStoreKt.getLOG().error((Throwable)e);
                    throw (Throwable)new ConfigurationException("Internal error: " + e.getMessage());
                }
            }
        }
        if (providerType == ProviderType.KEEPASS) {
            KeePassFileManager keePassFileManager = this.createKeePassFileManager();
            if (keePassFileManager != null) {
                Path path = PasswordSafeImplKt.getDefaultKeePassDbFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"getDefaultKeePassDbFile()");
                keePassFileManager.setCustomMasterPasswordIfNeed(path);
            }
        }
        settings.setProviderType(providerType);
        PgpKey pgpKey = this.getNewPgpKey();
        settings.getState().setPgpKeyId(pgpKey != null ? pgpKey.getKeyId() : null);
    }

    private final void createAndSaveKeePassDatabaseWithNewOptions(PasswordSafeSettings settings) {
        Path path = this.getNewDbFile();
        if (path == null) {
            throw (Throwable)new ConfigurationException("KeePass database path is empty.");
        }
        Path newDbFile = path;
        if (PathKt.isDirectory((Path)newDbFile)) {
            throw (Throwable)new ConfigurationException("KeePass database file is directory.");
        }
        if (!StringsKt.endsWith$default((String)((Object)newDbFile.getFileName()).toString(), (String)".kdbx", (boolean)false, (int)2, null)) {
            throw (Throwable)new ConfigurationException("KeePass database file should ends with \".kdbx\".");
        }
        settings.setKeepassDb(((Object)newDbFile).toString());
        try {
            Path path2 = KeePassCredentialStoreKt.getDefaultMasterPasswordFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"getDefaultMasterPasswordFile()");
            new KeePassFileManager(newDbFile, path2, this.getEncryptionSpec(), this.secureRandom).useExisting();
        }
        catch (IncorrectMasterPasswordException e) {
            throw (Throwable)new ConfigurationException("Master password for KeePass database is not correct (\"Clear\" can be used to reset database).");
        }
        catch (Exception e) {
            CredentialStoreKt.getLOG().error((Throwable)e);
            throw (Throwable)new ConfigurationException("Internal error: " + e.getMessage());
        }
    }

    private final Path getNewDbFile() {
        Path path;
        String string = this.getNewDbFileAsString();
        if (string != null) {
            String string2;
            String it = string2 = string;
            boolean bl = false;
            path = Paths.get(it, new String[0]);
        } else {
            path = null;
        }
        return path;
    }

    private final String getNewDbFileAsString() {
        String string;
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.keePassDbFile;
        if (textFieldWithBrowseButton == null) {
            Intrinsics.throwNpe();
        }
        String string2 = textFieldWithBrowseButton.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"keePassDbFile!!.text");
        String string3 = string = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return StringKt.nullize$default((String)((Object)StringsKt.trim((CharSequence)string3)).toString(), (boolean)false, (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public JPanel getComponent() {
        void propertyUiManager$iv;
        void this_$iv;
        Row row$iv;
        FileChooserDescriptor fileChooserDescriptor2;
        Row this_$iv2;
        Row row$iv2;
        Row $receiver;
        Row row$iv3;
        boolean $i$f$row;
        boolean separated$iv;
        LayoutBuilderWithButtonGroup<ProviderType> this_$iv3;
        Row row$iv4;
        LayoutBuilder builder$iv;
        LCFlags[] constraints$iv = new LCFlags[]{};
        String title$iv = null;
        boolean $i$f$panel = false;
        LayoutBuilder $receiver2 = builder$iv = LayoutImplKt.createLayoutBuilder(!ArraysKt.contains((Object[])constraints$iv, (Object)((Object)LCFlags.disableMagic)));
        boolean bl = false;
        LayoutBuilder this_$iv4 = $receiver2;
        JLabel label$iv = null;
        boolean separated$iv2 = false;
        boolean $i$f$row2 = false;
        Row $receiver3 = row$iv4 = this_$iv4.getBuilder().newRow(label$iv, this_$iv4.getButtonGroup(), separated$iv2);
        boolean bl2 = false;
        Row.label$default($receiver3, "Save passwords:", 0, null, null, false, 30, null);
        this_$iv4 = $receiver2;
        ChoicePropertyUiManager<ProviderType> propertyManager$iv = this.providerTypeModel;
        boolean $i$f$buttonGroup = false;
        LayoutBuilderWithButtonGroup<ProviderType> $receiver4 = new LayoutBuilderWithButtonGroup<ProviderType>(this_$iv4.getBuilder(), propertyManager$iv);
        boolean bl3 = false;
        if (SystemInfo.isLinux || MacOsKeychainLibraryKt.isMacOsCredentialStoreSupported()) {
            this_$iv3 = $receiver4;
            JLabel label$iv2 = null;
            separated$iv = false;
            $i$f$row = false;
            $receiver = row$iv3 = this_$iv3.getBuilder().newRow(label$iv2, this_$iv3.getButtonGroup(), separated$iv);
            boolean bl4 = false;
            $receiver.radioButton($receiver4, "In native Keychain", ProviderType.KEYCHAIN);
        }
        this_$iv3 = $receiver4;
        JLabel label$iv3 = null;
        separated$iv = false;
        $i$f$row = false;
        $receiver = row$iv3 = this_$iv3.getBuilder().newRow(label$iv3, this_$iv3.getButtonGroup(), separated$iv);
        boolean bl5 = false;
        $receiver.radioButton($receiver4, "In KeePass", ProviderType.KEEPASS);
        Row row2 = $receiver;
        String label$iv4 = "Database:";
        boolean $i$f$row3 = false;
        Row $receiver5 = row$iv2 = this_$iv2.createRow(label$iv4);
        boolean bl6 = false;
        FileChooserDescriptor fileChooserDescriptor3 = fileChooserDescriptor2 = FileChooserDescriptorFactory.createSingleLocalFileDescriptor().withFileFilter((Condition)getComponent.1.2.2.1.fileChooserDescriptor.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)fileChooserDescriptor3, (String)"fileChooserDescriptor");
        this.keePassDbFile = Cell.textFieldWithBrowseButton$default($receiver5, "KeePass Database File", null, null, fileChooserDescriptor3, getComponent.1.2.2.1.1.INSTANCE, SystemInfo.isWindows ? null : "Stored using weak encryption. It is recommended to store on encrypted volume for additional security.", 6, null);
        $receiver5.gearButton((AnAction)new ClearKeePassDatabaseAction(), (AnAction)new ImportKeePassDatabaseAction(), (AnAction)new ChangeKeePassDatabaseMasterPasswordAction());
        this_$iv2 = $receiver;
        boolean $i$f$row4 = false;
        Row $receiver6 = row$iv = this_$iv2.createRow(null);
        boolean bl7 = false;
        Row this_$iv5 = $receiver6;
        boolean isVerticalFlow$iv = false;
        boolean $i$f$cell = false;
        this_$iv5.setCellMode(true, isVerticalFlow$iv);
        Cell $receiver7 = this_$iv5;
        boolean bl8 = false;
        String prefix = "Protect master password using PGP key";
        Cell.checkBox$default($receiver7, ((CollectionComboBoxModel)this.isUsePgp.getListModel()).isEmpty() ? prefix + " (No keys configured)" : prefix + ':', false, null, this.isUsePgp, new CCFlags[0], 6, null);
        Cell cell = $receiver7;
        BooleanPropertyWithListUiManager booleanPropertyWithListUiManager = this.isUsePgp;
        GrowPolicy growPolicy$iv = GrowPolicy.MEDIUM_TEXT;
        boolean $i$f$comboBox = false;
        this_$iv.comboBox((ComboBoxModel)propertyUiManager$iv.getListModel(), (BooleanPropertyWithListUiManager<?, ?>)propertyUiManager$iv, growPolicy$iv, (ListCellRenderer)new ListCellRendererWrapper<PgpKey>(){

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            public void customize(@NotNull JList list2, @Nullable Object value, int index, boolean isSelected, boolean hasFocus) {
                Intrinsics.checkParameterIsNotNull((Object)list2, (String)"list");
                if (value != null) {
                    void value2;
                    boolean bl = isSelected;
                    int n = index;
                    PgpKey pgpKey = (PgpKey)value;
                    ListCellRendererWrapper $receiver = this;
                    boolean bl2 = false;
                    $receiver.setText(value2.getUserId() + " (" + value2.getKeyId() + ')');
                }
            }
        });
        this_$iv5.setCellMode(false, isVerticalFlow$iv);
        this_$iv3 = $receiver4;
        label$iv3 = null;
        separated$iv = false;
        $i$f$row = false;
        $receiver = row$iv3 = this_$iv3.getBuilder().newRow(label$iv3, this_$iv3.getButtonGroup(), separated$iv);
        boolean bl9 = false;
        $receiver.radioButton($receiver4, "Do not save, forget passwords after restart", ProviderType.MEMORY_ONLY);
        JPanel panel$iv = ComponentsKt.Panel(title$iv, null);
        builder$iv.getBuilder().build(panel$iv, constraints$iv);
        return panel$iv;
    }

    private final KeePassFileManager createKeePassFileManager() {
        Path path = this.getNewDbFile();
        if (path == null) {
            return null;
        }
        Path path2 = KeePassCredentialStoreKt.getDefaultMasterPasswordFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"getDefaultMasterPasswordFile()");
        return new KeePassFileManager(path, path2, this.getEncryptionSpec(), this.secureRandom);
    }

    private final EncryptionSpec getEncryptionSpec() {
        PgpKey pgpKey = this.getNewPgpKey();
        PgpKey pgpKey2 = pgpKey;
        return pgpKey2 == null ? new EncryptionSpec(EncryptionSupportKt.getDefaultEncryptionType(), null) : new EncryptionSpec(EncryptionType.PGP_KEY, pgpKey.getKeyId());
    }

    private final PgpKey getNewPgpKey() {
        return this.isUsePgp.getSelected();
    }

    private final ProviderType getNewProviderType() {
        return this.providerTypeModel.getSelected();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/credentialStore/PasswordSafeConfigurableUi$ClearKeePassDatabaseAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "(Lcom/intellij/credentialStore/PasswordSafeConfigurableUi;)V", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "e", "intellij.platform.credentialStore"})
    private final class ClearKeePassDatabaseAction
    extends DumbAwareAction {
        public void actionPerformed(@NotNull AnActionEvent event) {
            block1: {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                MessageDialogBuilder messageDialogBuilder = MessageDialogBuilder.yesNo((String)"Clear Passwords", (String)"Are you sure want to remove all passwords?").yesText("Remove Passwords");
                Intrinsics.checkExpressionValueIsNotNull((Object)messageDialogBuilder, (String)"MessageDialogBuilder.yes\u2026sText(\"Remove Passwords\")");
                if (!((MessageDialogBuilder.YesNo)messageDialogBuilder).isYes()) {
                    return;
                }
                PasswordSafeConfigurableKt.access$closeCurrentStore();
                CredentialStoreKt.getLOG().info("Passwords cleared", (Throwable)new Error());
                KeePassFileManager keePassFileManager = PasswordSafeConfigurableUi.this.createKeePassFileManager();
                if (keePassFileManager == null) break block1;
                keePassFileManager.clear();
            }
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            Presentation presentation = e.getPresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
            Path path = PasswordSafeConfigurableUi.this.getNewDbFile();
            presentation.setEnabled(path != null ? PathKt.exists((Path)path) : false);
        }

        public ClearKeePassDatabaseAction() {
            super("Clear");
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/credentialStore/PasswordSafeConfigurableUi$ImportKeePassDatabaseAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "(Lcom/intellij/credentialStore/PasswordSafeConfigurableUi;)V", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.platform.credentialStore"})
    private final class ImportKeePassDatabaseAction
    extends DumbAwareAction {
        public void actionPerformed(@NotNull AnActionEvent event) {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            PasswordSafeConfigurableKt.access$closeCurrentStore();
            FileChooserDescriptor fileChooserDescriptor2 = FileChooserDescriptorFactory.createSingleLocalFileDescriptor().withFileFilter((Condition)actionPerformed.1.INSTANCE);
            Intrinsics.checkExpressionValueIsNotNull((Object)fileChooserDescriptor2, (String)"FileChooserDescriptorFac\u2026dsWith(\".kdbx\")\n        }");
            LayoutBuilderKt.chooseFile(fileChooserDescriptor2, event, (Function1<? super VirtualFile, Unit>)((Function1)new Function1<VirtualFile, Unit>(this, event){
                final /* synthetic */ ImportKeePassDatabaseAction this$0;
                final /* synthetic */ AnActionEvent $event;

                public final void invoke(@NotNull VirtualFile it) {
                    block0: {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        KeePassFileManager keePassFileManager = PasswordSafeConfigurableUi.access$createKeePassFileManager(this.this$0.PasswordSafeConfigurableUi.this);
                        if (keePassFileManager == null) break block0;
                        Path path = Paths.get(it.getPath(), new String[0]);
                        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"Paths.get(it.path)");
                        keePassFileManager.import(path, this.$event);
                    }
                }
                {
                    this.this$0 = importKeePassDatabaseAction;
                    this.$event = anActionEvent;
                    super(1);
                }
            }));
        }

        public ImportKeePassDatabaseAction() {
            super("Import");
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/credentialStore/PasswordSafeConfigurableUi$ChangeKeePassDatabaseMasterPasswordAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "(Lcom/intellij/credentialStore/PasswordSafeConfigurableUi;)V", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "e", "intellij.platform.credentialStore"})
    private final class ChangeKeePassDatabaseMasterPasswordAction
    extends DumbAwareAction {
        public void actionPerformed(@NotNull AnActionEvent event) {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            PasswordSafeConfigurableKt.access$closeCurrentStore();
            KeePassFileManager keePassFileManager = PasswordSafeConfigurableUi.this.createKeePassFileManager();
            if (keePassFileManager != null) {
                if (KeePassFileManager.askAndSetMasterKey$default(keePassFileManager, event, null, 2, null)) {
                    Presentation presentation = this.getTemplatePresentation();
                    Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"templatePresentation");
                    presentation.setText("Change Master Password");
                }
            }
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            Presentation presentation = e.getPresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
            presentation.setEnabled(PasswordSafeConfigurableUi.this.getNewDbFileAsString() != null);
        }

        public ChangeKeePassDatabaseMasterPasswordAction() {
            StringBuilder stringBuilder = new StringBuilder();
            Path path = KeePassCredentialStoreKt.getDefaultMasterPasswordFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"getDefaultMasterPasswordFile()");
            super(stringBuilder.append(new MasterKeyFileStorage(path).isAutoGenerated() ? "Set" : "Change").append(" Master Password").toString());
        }
    }
}

