/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore.schemeManager;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.LazySchemeProcessor;
import com.intellij.configurationStore.SchemeContentChangedHandler;
import com.intellij.configurationStore.schemeManager.ExternalInfo;
import com.intellij.configurationStore.schemeManager.SchemeDataHolderImpl;
import com.intellij.configurationStore.schemeManager.SchemeLoader;
import com.intellij.configurationStore.schemeManager.SchemeLoaderKt;
import com.intellij.configurationStore.schemeManager.SchemeManagerImpl;
import com.intellij.configurationStore.schemeManager.SchemeManagerImplKt;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xmlpull.mxp1.MXParser;
import org.xmlpull.v1.XmlPullParser;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a6\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\tH\u0002\u001a&\u0010\n\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\tH\u0000\u001a:\u0010\u000b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\r2\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\tH\u0000\u00a8\u0006\u000e"}, d2={"callSchemeContentChangedIfSupported", "", "changedScheme", "", "fileName", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "schemeManager", "Lcom/intellij/configurationStore/schemeManager/SchemeManagerImpl;", "findExternalizableSchemeByFileName", "readSchemeFromFile", "schemeLoader", "Lcom/intellij/configurationStore/schemeManager/SchemeLoader;", "intellij.platform.configurationStore.impl"})
public final class SchemeChangeApplicatorKt {
    @Nullable
    public static final Object findExternalizableSchemeByFileName(@NotNull String fileName2, @NotNull SchemeManagerImpl<Object, Object> schemeManager2) {
        Object v2;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)fileName2, (String)"fileName");
            Intrinsics.checkParameterIsNotNull(schemeManager2, (String)"schemeManager");
            Iterable $receiver$iv = (Iterable)schemeManager2.getSchemes$intellij_platform_configurationStore_impl();
            Iterator iterator = $receiver$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator.next();
                boolean bl = false;
                StringBuilder stringBuilder = new StringBuilder();
                Object t = it;
                Intrinsics.checkExpressionValueIsNotNull(t, (String)"it");
                if (!Intrinsics.areEqual((Object)fileName2, (Object)stringBuilder.append(schemeManager2.getFileName$intellij_platform_configurationStore_impl(t)).append(schemeManager2.getSchemeExtension$intellij_platform_configurationStore_impl()).toString())) continue;
                v2 = element$iv;
                break block1;
            }
            v2 = null;
        }
        return v2;
    }

    @Nullable
    public static final Object readSchemeFromFile(@NotNull VirtualFile file2, @NotNull SchemeLoader<Object, Object> schemeLoader, @NotNull SchemeManagerImpl<Object, Object> schemeManager2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull(schemeLoader, (String)"schemeLoader");
        Intrinsics.checkParameterIsNotNull(schemeManager2, (String)"schemeManager");
        String string = file2.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.name");
        String fileName2 = string;
        if (file2.isDirectory() || !schemeManager2.canRead(fileName2)) {
            return null;
        }
        boolean $i$f$catchAndLog = false;
        try {
            boolean bl = false;
            schemeLoader.loadScheme(fileName2, null, file2.contentsToByteArray());
        }
        catch (ProcessCanceledException e$iv) {
            throw (Throwable)e$iv;
        }
        catch (Throwable e$iv) {
            ComponentStoreImplKt.getLOG().error("Cannot read scheme " + fileName2, e$iv);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean callSchemeContentChangedIfSupported(Object changedScheme, String fileName2, VirtualFile file2, SchemeManagerImpl<Object, Object> schemeManager2) {
        if (changedScheme == null || !(schemeManager2.getProcessor$intellij_platform_configurationStore_impl() instanceof SchemeContentChangedHandler) || !(schemeManager2.getProcessor$intellij_platform_configurationStore_impl() instanceof LazySchemeProcessor)) {
            return false;
        }
        ExternalInfo externalInfo = (ExternalInfo)schemeManager2.getSchemeToInfo$intellij_platform_configurationStore_impl().get(changedScheme);
        if (externalInfo == null) {
            return false;
        }
        ExternalInfo externalInfo2 = externalInfo;
        boolean $i$f$catchAndLog = false;
        try {
            void parser;
            boolean bl = false;
            byte[] byArray = file2.contentsToByteArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"file.contentsToByteArray()");
            byte[] bytes = byArray;
            boolean isOldSchemeNaming$iv = schemeManager2.isOldSchemeNaming$intellij_platform_configurationStore_impl();
            boolean $i$f$lazyPreloadScheme = false;
            MXParser parser$iv = new MXParser();
            Object object = bytes;
            MXParser mXParser = parser$iv;
            Closeable closeable = new ByteArrayInputStream((byte[])object);
            object = closeable;
            Charset charset = Charsets.UTF_8;
            closeable = new InputStreamReader((InputStream)object, charset);
            mXParser.setInput((Reader)closeable);
            XmlPullParser xmlPullParser = (XmlPullParser)parser$iv;
            String name = SchemeLoaderKt.access$preload(isOldSchemeNaming$iv, parser$iv);
            boolean bl2 = false;
            Function attributeProvider2 = new Function<String, String>((XmlPullParser)parser){
                final /* synthetic */ XmlPullParser $parser;

                public final String apply(@NotNull String it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return this.$parser.getAttributeValue(null, it);
                }
                {
                    this.$parser = xmlPullParser;
                }
            };
            String string = name;
            if (string == null) {
                LazySchemeProcessor lazySchemeProcessor = (LazySchemeProcessor)schemeManager2.getProcessor$intellij_platform_configurationStore_impl();
                String string2 = FileUtilRt.getNameWithoutExtension((String)fileName2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"FileUtilRt.getNameWithoutExtension(fileName)");
                string = lazySchemeProcessor.getSchemeKey(attributeProvider2, string2);
            }
            if (string == null) {
                throw (Throwable)SchemeManagerImplKt.nameIsMissed(bytes);
            }
            String schemeName = string;
            SchemeDataHolderImpl dataHolder = new SchemeDataHolderImpl(schemeManager2.getProcessor$intellij_platform_configurationStore_impl(), bytes, externalInfo2);
            SchemeProcessor schemeProcessor = schemeManager2.getProcessor$intellij_platform_configurationStore_impl();
            if (schemeProcessor == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.SchemeContentChangedHandler<kotlin.Any>");
            }
            ((SchemeContentChangedHandler)((Object)schemeProcessor)).schemeContentChanged(changedScheme, schemeName, dataHolder);
            return true;
        }
        catch (ProcessCanceledException e$iv) {
            throw (Throwable)e$iv;
        }
        catch (Throwable e$iv) {
            ComponentStoreImplKt.getLOG().error("Cannot read scheme " + fileName2, e$iv);
            return false;
        }
    }

    public static final /* synthetic */ boolean access$callSchemeContentChangedIfSupported(Object changedScheme, String fileName2, VirtualFile file2, SchemeManagerImpl schemeManager2) {
        return SchemeChangeApplicatorKt.callSchemeContentChangedIfSupported(changedScheme, fileName2, file2, schemeManager2);
    }
}

