/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.TypeMarker;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataInputStream;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0002J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0002J\b\u0010\u000e\u001a\u00020\tH\u0002J\b\u0010\u000f\u001a\u00020\u0007H\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/configurationStore/BinaryXmlReader;", "", "input", "Ljava/io/DataInputStream;", "(Ljava/io/DataInputStream;)V", "strings", "Ljava/util/ArrayList;", "", "read", "Lorg/jdom/Element;", "readAttributes", "", "element", "readContent", "readElement", "readString", "readUInt29", "", "intellij.platform.projectModel.impl"})
final class BinaryXmlReader {
    private final ArrayList<String> strings;
    private final DataInputStream input;

    @NotNull
    public final Element read() {
        return this.readElement();
    }

    private final String readString() {
        int lengthOrIndex = this.readUInt29();
        if (lengthOrIndex == 1) {
            return "";
        }
        if ((lengthOrIndex & 1) == 1) {
            String string = IOUtil.readUTF((DataInput)this.input);
            this.strings.add(string);
            String string2 = string;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"string");
            return string2;
        }
        String string = this.strings.get(lengthOrIndex >> 1);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"strings.get(lengthOrIndex shr 1)");
        return string;
    }

    private final Element readElement() {
        Element element = new Element(this.readString());
        this.readAttributes(element);
        this.readContent(element);
        return element;
    }

    private final void readContent(Element element) {
        while (true) {
            int n;
            if ((n = this.input.read()) == TypeMarker.ELEMENT.ordinal()) {
                element.addContent(this.readElement());
                continue;
            }
            if (n == TypeMarker.TEXT.ordinal()) {
                element.addContent((Content)new Text(this.readString()));
                continue;
            }
            if (n == TypeMarker.CDATA.ordinal()) {
                element.addContent((Content)new CDATA(this.readString()));
                continue;
            }
            if (n == TypeMarker.ELEMENT_END.ordinal()) break;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void readAttributes(Element element) {
        int size = this.input.readUnsignedByte();
        int n = 0;
        int n2 = size;
        while (n < n2) {
            void i;
            element.setAttribute(new Attribute(this.readString(), this.readString()));
            ++i;
        }
    }

    private final int readUInt29() {
        int value = 0;
        int b = this.input.read();
        if ((b & 0xFF) < 128) {
            return b;
        }
        value = (b & 0x7F) << 7;
        b = this.input.read();
        if ((b & 0xFF) < 128) {
            return value | b;
        }
        value = (value | b & 0x7F) << 7;
        b = this.input.read();
        if ((b & 0xFF) < 128) {
            return value | b;
        }
        return (value | b & 0x7F) << 8 | this.input.read() & 0xFF;
    }

    public BinaryXmlReader(@NotNull DataInputStream input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        this.input = input;
        this.strings = new ArrayList();
    }
}

