/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.HTMLComposerImpl;
import com.intellij.codeInspection.ex.QuickFixAction;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class DescriptorComposer
extends HTMLComposerImpl {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.ex.DescriptorComposer");
    private final InspectionToolPresentation myTool;

    public DescriptorComposer(@NotNull InspectionToolPresentation tool) {
        if (tool == null) {
            DescriptorComposer.$$$reportNull$$$0(0);
        }
        this.myTool = tool;
    }

    @Override
    public void compose(StringBuffer buf, RefEntity refEntity) {
        this.genPageHeader(buf, refEntity);
        if (this.myTool.getDescriptions(refEntity) != null) {
            DescriptorComposer.appendHeading((StringBuffer)buf, (String)InspectionsBundle.message((String)"inspection.problem.synopsis", (Object[])new Object[0]));
            buf.append("<div class=\"problem-description\">");
            CommonProblemDescriptor[] descriptions = this.myTool.getDescriptions(refEntity);
            LOG.assertTrue(descriptions != null);
            this.startList(buf);
            for (int i = 0; i < descriptions.length; ++i) {
                CommonProblemDescriptor description = descriptions[i];
                this.startListItem(buf);
                this.composeDescription(description, i, buf, refEntity);
                DescriptorComposer.doneListItem(buf);
            }
            this.doneList(buf);
            buf.append("</div>");
            this.appendResolution(buf, refEntity, DescriptorComposer.quickFixTexts(refEntity, this.myTool));
        } else {
            this.appendNoProblems(buf);
        }
    }

    @NotNull
    public static String[] quickFixTexts(RefEntity where, @NotNull InspectionToolPresentation toolPresentation) {
        if (toolPresentation == null) {
            DescriptorComposer.$$$reportNull$$$0(1);
        }
        QuickFixAction[] quickFixes = toolPresentation.getQuickFixes(where);
        ArrayList<String> texts = new ArrayList<String>();
        for (QuickFixAction quickFix : quickFixes) {
            String text = quickFix.getText();
            if (text == null) continue;
            texts.add(DescriptorComposer.escapeQuickFixText(text));
        }
        String[] stringArray = ArrayUtil.toStringArray(texts);
        if (stringArray == null) {
            DescriptorComposer.$$$reportNull$$$0(2);
        }
        return stringArray;
    }

    private static String escapeQuickFixText(@NotNull String text) {
        if (text == null) {
            DescriptorComposer.$$$reportNull$$$0(3);
        }
        return XmlStringUtil.isWrappedInHtml((String)text) ? XmlStringUtil.stripHtml((String)text) : StringUtil.escapeXmlEntities((String)text);
    }

    protected void composeAdditionalDescription(@NotNull StringBuffer buf, @NotNull RefEntity refEntity) {
        if (buf == null) {
            DescriptorComposer.$$$reportNull$$$0(4);
        }
        if (refEntity == null) {
            DescriptorComposer.$$$reportNull$$$0(5);
        }
    }

    @Override
    public void compose(StringBuffer buf, RefEntity refElement, CommonProblemDescriptor descriptor) {
        CommonProblemDescriptor[] descriptions = this.myTool.getDescriptions(refElement);
        int problemIdx = 0;
        if (descriptions != null) {
            problemIdx = -1;
            for (int i = 0; i < descriptions.length; ++i) {
                CommonProblemDescriptor description = descriptions[i];
                if (description != descriptor) continue;
                problemIdx = i;
                break;
            }
            if (problemIdx == -1) {
                return;
            }
        }
        this.genPageHeader(buf, refElement);
        DescriptorComposer.appendHeading((StringBuffer)buf, (String)InspectionsBundle.message((String)"inspection.problem.synopsis", (Object[])new Object[0]));
        buf.append("<br>");
        DescriptorComposer.appendAfterHeaderIndention((StringBuffer)buf);
        this.composeDescription(descriptor, problemIdx, buf, refElement);
        if (refElement instanceof RefElement && !refElement.isValid()) {
            return;
        }
        QuickFix[] fixes = descriptor.getFixes();
        if (fixes != null && fixes.length > 0) {
            buf.append("<br><br>");
            DescriptorComposer.appendHeading((StringBuffer)buf, (String)InspectionsBundle.message((String)"inspection.problem.resolution", (Object[])new Object[0]));
            buf.append("<br>");
            DescriptorComposer.appendAfterHeaderIndention((StringBuffer)buf);
            int idx = 0;
            for (QuickFix fix : fixes) {
                buf.append("<a HREF=\"file://bred.txt#invokelocal:" + idx++);
                buf.append("\">");
                buf.append(DescriptorComposer.escapeQuickFixText(fix.getName()));
                buf.append("</a>");
                buf.append("<br>");
                DescriptorComposer.appendAfterHeaderIndention((StringBuffer)buf);
            }
        }
    }

    protected void composeDescription(@NotNull CommonProblemDescriptor description, int i, @NotNull StringBuffer buf, @NotNull RefEntity refElement) {
        if (description == null) {
            DescriptorComposer.$$$reportNull$$$0(6);
        }
        if (buf == null) {
            DescriptorComposer.$$$reportNull$$$0(7);
        }
        if (refElement == null) {
            DescriptorComposer.$$$reportNull$$$0(8);
        }
        PsiElement expression = description instanceof ProblemDescriptor ? ((ProblemDescriptor)description).getPsiElement() : null;
        StringBuilder anchor2 = new StringBuilder();
        VirtualFile vFile = null;
        if (expression != null) {
            vFile = expression.getContainingFile().getVirtualFile();
            if (vFile instanceof VirtualFileWindow) {
                vFile = ((VirtualFileWindow)vFile).getDelegate();
            }
            anchor2.append("<a HREF=\"");
            anchor2.append(DescriptorComposer.appendURL(vFile, "descr:" + i));
            anchor2.append("\">");
            anchor2.append(ProblemDescriptorUtil.extractHighlightedText(description, expression).replaceAll("\\$", "\\\\\\$"));
            anchor2.append("</a>");
        } else {
            anchor2.append("<font style=\"font-weight:bold; color:#FF0000\";>");
            anchor2.append(InspectionsBundle.message((String)"inspection.export.results.invalidated.item", (Object[])new Object[0]));
            anchor2.append("</font>");
        }
        String descriptionTemplate = description.getDescriptionTemplate();
        if (XmlStringUtil.isWrappedInHtml((String)descriptionTemplate)) {
            descriptionTemplate = XmlStringUtil.stripHtml((String)descriptionTemplate);
        } else {
            descriptionTemplate = StringUtil.replace((String)descriptionTemplate, (String)"<code>", (String)"'");
            descriptionTemplate = StringUtil.replace((String)descriptionTemplate, (String)"</code>", (String)"'");
            descriptionTemplate = XmlStringUtil.escapeString((String)descriptionTemplate);
        }
        String reference = "#ref";
        boolean containsReference = descriptionTemplate.contains("#ref");
        String res2 = descriptionTemplate.replaceAll("#ref", anchor2.toString());
        int lineNumber = description instanceof ProblemDescriptor ? ((ProblemDescriptor)description).getLineNumber() : -1;
        StringBuilder lineAnchor = new StringBuilder();
        if (expression != null && lineNumber >= 0) {
            Document doc = FileDocumentManager.getInstance().getDocument(vFile);
            lineAnchor.append(InspectionsBundle.message((String)"inspection.export.results.at.line", (Object[])new Object[0])).append(" ");
            lineAnchor.append("<a HREF=\"");
            int offset = doc.getLineStartOffset(lineNumber);
            offset = CharArrayUtil.shiftForward((CharSequence)doc.getCharsSequence(), (int)offset, (String)" \t");
            lineAnchor.append(DescriptorComposer.appendURL(vFile, String.valueOf(offset)));
            lineAnchor.append("\">");
            lineAnchor.append(lineNumber + 1);
            lineAnchor.append("</a>");
            String location = "#loc";
            if (!res2.contains("#loc")) {
                res2 = res2 + " (#loc)";
            }
            res2 = res2.replaceAll("#loc", lineAnchor.toString());
        }
        buf.append(res2.replace("#end", "").replace("#treeend", ""));
        buf.append("<br>").append("<br>");
        this.composeAdditionalDescription(buf, refElement);
    }

    private static String appendURL(VirtualFile vFile, String anchor2) {
        return vFile.getUrl() + "#" + anchor2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolPresentation";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ex/DescriptorComposer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buf";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refEntity";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ex/DescriptorComposer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "quickFixTexts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "quickFixTexts";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "escapeQuickFixText";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "composeAdditionalDescription";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "composeDescription";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

