/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.completion.LookupElementListPresenter;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.WeighingContext;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LookupArranger
implements WeighingContext {
    protected final List<LookupElement> myItems = new ArrayList<LookupElement>();
    private final List<LookupElement> myMatchingItems = new ArrayList<LookupElement>();
    private final List<LookupElement> myExactPrefixItems = new ArrayList<LookupElement>();
    private final List<LookupElement> myInexactPrefixItems = new ArrayList<LookupElement>();
    private final Key<PrefixMatcher> myMatcherKey = Key.create((String)"LookupArrangerMatcher");
    private String myAdditionalPrefix = "";

    public void addElement(LookupElement item, LookupElementPresentation presentation) {
        this.myItems.add(item);
        this.updateCache(item);
    }

    public void clear() {
        this.myItems.clear();
        this.myMatchingItems.clear();
        this.myExactPrefixItems.clear();
        this.myInexactPrefixItems.clear();
    }

    private void updateCache(LookupElement item) {
        if (!this.prefixMatches(item)) {
            return;
        }
        this.myMatchingItems.add(item);
        if (this.isPrefixItem(item, true)) {
            this.myExactPrefixItems.add(item);
        } else if (this.isPrefixItem(item, false)) {
            this.myInexactPrefixItems.add(item);
        }
    }

    public void registerMatcher(@NotNull LookupElement item, @NotNull PrefixMatcher matcher) {
        if (item == null) {
            LookupArranger.$$$reportNull$$$0(0);
        }
        if (matcher == null) {
            LookupArranger.$$$reportNull$$$0(1);
        }
        item.putUserData(this.myMatcherKey, (Object)matcher);
    }

    @NotNull
    public String itemPattern(@NotNull LookupElement element) {
        if (element == null) {
            LookupArranger.$$$reportNull$$$0(2);
        }
        String prefix = this.itemMatcher(element).getPrefix();
        String additionalPrefix = this.myAdditionalPrefix;
        String string = additionalPrefix.isEmpty() ? prefix : prefix + additionalPrefix;
        if (string == null) {
            LookupArranger.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public PrefixMatcher itemMatcher(@NotNull LookupElement item) {
        PrefixMatcher matcher;
        if (item == null) {
            LookupArranger.$$$reportNull$$$0(4);
        }
        if ((matcher = (PrefixMatcher)item.getUserData(this.myMatcherKey)) == null) {
            throw new AssertionError((Object)("Item not in lookup: item=" + item + "; lookup items=" + this.myItems));
        }
        PrefixMatcher prefixMatcher = matcher;
        if (prefixMatcher == null) {
            LookupArranger.$$$reportNull$$$0(5);
        }
        return prefixMatcher;
    }

    private boolean prefixMatches(LookupElement item) {
        PrefixMatcher matcher = this.itemMatcher(item);
        if (!this.myAdditionalPrefix.isEmpty()) {
            matcher = matcher.cloneWithPrefix(matcher.getPrefix() + this.myAdditionalPrefix);
        }
        return matcher.prefixMatches(item);
    }

    public void itemSelected(@Nullable LookupElement lookupItem, char completionChar) {
    }

    public final void prefixReplaced(Lookup lookup, String newPrefix) {
        ArrayList itemCopy = ContainerUtil.newArrayList(this.myItems);
        this.myItems.clear();
        for (LookupElement item : itemCopy) {
            PrefixMatcher matcher;
            if (!item.isValid() || !(matcher = this.itemMatcher(item).cloneWithPrefix(newPrefix)).prefixMatches(item)) continue;
            item.putUserData(this.myMatcherKey, (Object)matcher);
            this.myItems.add(item);
        }
        this.prefixChanged(lookup);
    }

    public void prefixChanged(Lookup lookup) {
        this.myAdditionalPrefix = ((LookupElementListPresenter)lookup).getAdditionalPrefix();
        this.rebuildItemCache();
    }

    private void rebuildItemCache() {
        this.myMatchingItems.clear();
        this.myExactPrefixItems.clear();
        this.myInexactPrefixItems.clear();
        for (LookupElement item : this.myItems) {
            this.updateCache(item);
        }
    }

    protected List<LookupElement> retainItems(Set<LookupElement> retained) {
        ArrayList filtered = ContainerUtil.newArrayList();
        ArrayList removed = ContainerUtil.newArrayList();
        for (LookupElement item : this.myItems) {
            (retained.contains(item) ? filtered : removed).add(item);
        }
        this.myItems.clear();
        this.myItems.addAll(filtered);
        this.rebuildItemCache();
        return removed;
    }

    public abstract Pair<List<LookupElement>, Integer> arrangeItems(@NotNull Lookup var1, boolean var2);

    public abstract LookupArranger createEmptyCopy();

    protected List<LookupElement> getPrefixItems(boolean exactly) {
        return Collections.unmodifiableList(exactly ? this.myExactPrefixItems : this.myInexactPrefixItems);
    }

    protected boolean isPrefixItem(LookupElement item, boolean exactly) {
        String pattern = this.itemPattern(item);
        for (String s : item.getAllLookupStrings()) {
            if (!s.equalsIgnoreCase(pattern) || item.isCaseSensitive() && exactly && !s.equals(pattern)) continue;
            return true;
        }
        return false;
    }

    public List<LookupElement> getMatchingItems() {
        return this.myMatchingItems;
    }

    @NotNull
    public Map<LookupElement, List<Pair<String, Object>>> getRelevanceObjects(@NotNull Iterable<LookupElement> items, boolean hideSingleValued) {
        if (items == null) {
            LookupArranger.$$$reportNull$$$0(6);
        }
        Map<LookupElement, List<Pair<String, Object>>> map2 = Collections.emptyMap();
        if (map2 == null) {
            LookupArranger.$$$reportNull$$$0(7);
        }
        return map2;
    }

    public void prefixTruncated(@NotNull LookupImpl lookup, int hideOffset) {
        if (lookup == null) {
            LookupArranger.$$$reportNull$$$0(8);
        }
        lookup.hideLookup(false);
    }

    public boolean isCompletion() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/lookup/LookupArranger";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/lookup/LookupArranger";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "itemPattern";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "itemMatcher";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelevanceObjects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerMatcher";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "itemPattern";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "itemMatcher";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRelevanceObjects";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "prefixTruncated";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DefaultArranger
    extends LookupArranger {
        @Override
        public Pair<List<LookupElement>, Integer> arrangeItems(@NotNull Lookup lookup, boolean onExplicitAction) {
            if (lookup == null) {
                DefaultArranger.$$$reportNull$$$0(0);
            }
            LinkedHashSet<LookupElement> result2 = new LinkedHashSet<LookupElement>();
            result2.addAll(this.getPrefixItems(true));
            result2.addAll(this.getPrefixItems(false));
            List<LookupElement> items = this.getMatchingItems();
            for (LookupElement item : items) {
                if (!CompletionServiceImpl.isStartMatch(item, this)) continue;
                result2.add(item);
            }
            result2.addAll(items);
            ArrayList list2 = new ArrayList(result2);
            int selected = !lookup.isSelectionTouched() && onExplicitAction ? 0 : list2.indexOf(lookup.getCurrentItem());
            return new Pair(list2, (Object)(selected >= 0 ? selected : 0));
        }

        @Override
        public LookupArranger createEmptyCopy() {
            return new DefaultArranger();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookup", "com/intellij/codeInsight/lookup/LookupArranger$DefaultArranger", "arrangeItems"));
        }
    }
}

