/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.daemon.impl.IdentifierUtil;
import com.intellij.codeInsight.daemon.impl.VisibleHighlightingPassFactory;
import com.intellij.codeInsight.highlighting.HighlightHandlerBase;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.highlighting.HighlightManagerImpl;
import com.intellij.codeInsight.highlighting.HighlightUsagesDescriptionLocation;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerFactory;
import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.find.EditorSearchSession;
import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.pom.PsiDeclaredTarget;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.ExternallyAnnotated;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ReferenceRange;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageTargetUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightUsagesHandler
extends HighlightHandlerBase {
    public static void invoke(@NotNull Project project, @NotNull Editor editor, @Nullable PsiFile file2) {
        if (project == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(1);
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        SelectionModel selectionModel = editor.getSelectionModel();
        if (file2 == null && !selectionModel.hasSelection()) {
            selectionModel.selectWordAtCaret(false);
        }
        if (file2 == null || selectionModel.hasSelection()) {
            HighlightUsagesHandler.doRangeHighlighting(editor, project);
            return;
        }
        HighlightUsagesHandlerBase handler2 = HighlightUsagesHandler.createCustomHandler(editor, file2);
        if (handler2 != null) {
            String featureId = handler2.getFeatureId();
            if (featureId != null) {
                FeatureUsageTracker.getInstance().triggerFeatureUsed(featureId);
            }
            handler2.highlightUsages();
            return;
        }
        DumbService.getInstance((Project)project).withAlternativeResolveEnabled(() -> {
            UsageTarget[] usageTargets = HighlightUsagesHandler.getUsageTargets(editor, file2);
            if (usageTargets == null) {
                HighlightUsagesHandler.handleNoUsageTargets(file2, editor, selectionModel, project);
                return;
            }
            boolean clearHighlights = HighlightUsagesHandler.isClearHighlights(editor);
            for (UsageTarget target2 : usageTargets) {
                target2.highlightUsages(file2, editor, clearHighlights);
            }
        });
    }

    @Nullable
    private static UsageTarget[] getUsageTargets(@NotNull Editor editor, @NotNull PsiFile file2) {
        Object[] results;
        PsiReference ref;
        PsiElement targetElement;
        UsageTarget[] usageTargets;
        if (editor == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(3);
        }
        if ((usageTargets = UsageTargetUtil.findUsageTargets((Editor)editor, (PsiFile)file2)) == null && (targetElement = HighlightUsagesHandler.getTargetElement(editor, file2)) != null && targetElement != file2) {
            if (!(targetElement instanceof NavigationItem)) {
                targetElement = targetElement.getNavigationElement();
            }
            if (targetElement instanceof NavigationItem) {
                usageTargets = new UsageTarget[]{new PsiElement2UsageTargetAdapter(targetElement)};
            }
        }
        if (usageTargets == null && (ref = TargetElementUtil.findReference(editor)) instanceof PsiPolyVariantReference && (results = ((PsiPolyVariantReference)ref).multiResolve(false)).length > 0) {
            usageTargets = (UsageTarget[])ContainerUtil.mapNotNull((Object[])results, result2 -> {
                PsiElement element = result2.getElement();
                return element == null ? null : new PsiElement2UsageTargetAdapter(element);
            }, (Object[])UsageTarget.EMPTY_ARRAY);
        }
        return usageTargets;
    }

    private static void handleNoUsageTargets(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull SelectionModel selectionModel, @NotNull Project project) {
        if (file2 == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(5);
        }
        if (selectionModel == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(6);
        }
        if (project == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(7);
        }
        if (file2.findElementAt(editor.getCaretModel().getOffset()) instanceof PsiWhiteSpace) {
            return;
        }
        selectionModel.selectWordAtCaret(false);
        String selection = selectionModel.getSelectedText();
        if (selection != null) {
            for (int i = 0; i < selection.length(); ++i) {
                if (Character.isJavaIdentifierPart(selection.charAt(i))) continue;
                selectionModel.removeSelection();
            }
        }
        HighlightUsagesHandler.doRangeHighlighting(editor, project);
        selectionModel.removeSelection();
    }

    @Nullable
    public static <T extends PsiElement> HighlightUsagesHandlerBase<T> createCustomHandler(@NotNull Editor editor, @NotNull PsiFile file2) {
        if (editor == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(8);
        }
        if (file2 == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(9);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ProperTextRange visibleRange = VisibleHighlightingPassFactory.calculateVisibleRange(editor);
        return HighlightUsagesHandler.createCustomHandler(editor, file2, visibleRange);
    }

    @Nullable
    public static <T extends PsiElement> HighlightUsagesHandlerBase<T> createCustomHandler(@NotNull Editor editor, @NotNull PsiFile file2, @NotNull ProperTextRange visibleRange) {
        if (editor == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(10);
        }
        if (file2 == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(11);
        }
        if (visibleRange == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(12);
        }
        for (HighlightUsagesHandlerFactory factory : HighlightUsagesHandlerFactory.EP_NAME.getExtensionList()) {
            HighlightUsagesHandlerBase handler2 = factory.createHighlightUsagesHandler(editor, file2, visibleRange);
            if (handler2 == null) continue;
            return handler2;
        }
        return null;
    }

    @Nullable
    private static PsiElement getTargetElement(@NotNull Editor editor, @NotNull PsiFile file2) {
        int offset;
        PsiElement element;
        PsiElement target2;
        if (editor == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(13);
        }
        if (file2 == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(14);
        }
        if ((target2 = TargetElementUtil.findTargetElement(editor, TargetElementUtil.getInstance().getReferenceSearchFlags())) == null && (element = file2.findElementAt(offset = TargetElementUtil.adjustOffset(file2, editor.getDocument(), editor.getCaretModel().getOffset()))) == null) {
            return null;
        }
        return target2;
    }

    private static void doRangeHighlighting(@NotNull Editor editor, @NotNull Project project) {
        EditorSearchSession oldSearch;
        if (editor == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(15);
        }
        if (project == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(16);
        }
        if (!editor.getSelectionModel().hasSelection()) {
            return;
        }
        String text = editor.getSelectionModel().getSelectedText();
        if (text == null) {
            return;
        }
        if (editor instanceof EditorWindow) {
            editor = ((EditorWindow)editor).getDelegate();
        }
        if ((oldSearch = EditorSearchSession.get(editor)) != null && oldSearch.hasMatches()) {
            String oldText = oldSearch.getTextInField();
            if (!oldSearch.getFindModel().isRegularExpressions()) {
                oldText = StringUtil.escapeToRegexp((String)oldText);
                oldSearch.getFindModel().setRegularExpressions(true);
            }
            String newText = oldText + '|' + StringUtil.escapeToRegexp((String)text);
            oldSearch.setTextInField(newText);
            return;
        }
        EditorSearchSession.start(editor, project).getFindModel().setRegularExpressions(false);
    }

    public static void highlightReferences(@NotNull Project project, @NotNull PsiElement element, @NotNull List<? extends PsiReference> refs, @NotNull Editor editor, PsiFile file2, boolean clearHighlights) {
        if (project == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(17);
        }
        if (element == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(18);
        }
        if (refs == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(19);
        }
        if (editor == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(20);
        }
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
        EditorColorsManager manager = EditorColorsManager.getInstance();
        TextAttributes attributes = manager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        TextAttributes writeAttributes = manager.getGlobalScheme().getAttributes(EditorColors.WRITE_SEARCH_RESULT_ATTRIBUTES);
        HighlightUsagesHandler.setupFindModel(project);
        ReadWriteAccessDetector detector = ReadWriteAccessDetector.findDetector((PsiElement)element);
        if (detector != null) {
            ArrayList<PsiReference> readRefs = new ArrayList<PsiReference>();
            ArrayList<PsiReference> writeRefs = new ArrayList<PsiReference>();
            for (PsiReference psiReference : refs) {
                if (detector.getReferenceAccess(element, psiReference) == ReadWriteAccessDetector.Access.Read) {
                    readRefs.add(psiReference);
                    continue;
                }
                writeRefs.add(psiReference);
            }
            HighlightUsagesHandler.doHighlightRefs(highlightManager, editor, readRefs, attributes, clearHighlights);
            HighlightUsagesHandler.doHighlightRefs(highlightManager, editor, writeRefs, writeAttributes, clearHighlights);
        } else {
            HighlightUsagesHandler.doHighlightRefs(highlightManager, editor, refs, attributes, clearHighlights);
        }
        TextRange range2 = HighlightUsagesHandler.getNameIdentifierRange(file2, element);
        if (range2 != null) {
            TextAttributes nameAttributes = attributes;
            if (detector != null && detector.isDeclarationWriteAccess(element)) {
                nameAttributes = writeAttributes;
            }
            HighlightUsagesHandler.highlightRanges(highlightManager, editor, nameAttributes, clearHighlights, Collections.singletonList(range2));
        }
    }

    @Nullable
    public static TextRange getNameIdentifierRange(@NotNull PsiFile file2, @NotNull PsiElement element) {
        PsiDeclaredTarget declaredTarget;
        TextRange range2;
        PomTarget target2;
        if (file2 == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(21);
        }
        if (element == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(22);
        }
        InjectedLanguageManager injectedManager = InjectedLanguageManager.getInstance((Project)element.getProject());
        if (element instanceof PomTargetPsiElement && (target2 = ((PomTargetPsiElement)element).getTarget()) instanceof PsiDeclaredTarget && (range2 = (declaredTarget = (PsiDeclaredTarget)target2).getNameIdentifierRange()) != null) {
            if (range2.getStartOffset() < 0 || range2.getLength() <= 0) {
                return null;
            }
            PsiElement navElement = declaredTarget.getNavigationElement();
            if (PsiUtilBase.isUnderPsiRoot((PsiFile)file2, (PsiElement)navElement)) {
                return injectedManager.injectedToHost(navElement, range2.shiftRight(navElement.getTextRange().getStartOffset()));
            }
        }
        if (!PsiUtilBase.isUnderPsiRoot((PsiFile)file2, (PsiElement)element)) {
            return null;
        }
        PsiElement identifier = IdentifierUtil.getNameIdentifier(element);
        if (identifier != null && PsiUtilBase.isUnderPsiRoot((PsiFile)file2, (PsiElement)identifier)) {
            TextRange range3 = identifier instanceof ExternallyAnnotated ? ((ExternallyAnnotated)identifier).getAnnotationRegion() : identifier.getTextRange();
            return range3 == null ? null : injectedManager.injectedToHost(identifier, range3);
        }
        return null;
    }

    public static void doHighlightElements(@NotNull Editor editor, @NotNull PsiElement[] elements, @NotNull TextAttributes attributes, boolean clearHighlights) {
        if (editor == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(23);
        }
        if (elements == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(24);
        }
        if (attributes == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(25);
        }
        HighlightManager highlightManager = HighlightManager.getInstance((Project)editor.getProject());
        ArrayList<TextRange> textRanges = new ArrayList<TextRange>(elements.length);
        for (PsiElement element : elements) {
            TextRange range2 = element.getTextRange();
            range2 = InjectedLanguageManager.getInstance((Project)element.getProject()).injectedToHost(element, range2);
            textRanges.add(range2);
        }
        HighlightUsagesHandler.highlightRanges(highlightManager, editor, attributes, clearHighlights, textRanges);
    }

    public static void highlightRanges(@NotNull HighlightManager highlightManager, @NotNull Editor editor, @NotNull TextAttributes attributes, boolean clearHighlights, @NotNull List<? extends TextRange> textRanges) {
        if (highlightManager == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(26);
        }
        if (editor == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(27);
        }
        if (attributes == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(28);
        }
        if (textRanges == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(29);
        }
        if (clearHighlights) {
            HighlightUsagesHandler.clearHighlights(editor, highlightManager, textRanges, attributes);
            return;
        }
        ArrayList highlighters = new ArrayList();
        for (TextRange textRange : textRanges) {
            highlightManager.addRangeHighlight(editor, textRange.getStartOffset(), textRange.getEndOffset(), attributes, false, highlighters);
        }
        for (RangeHighlighter rangeHighlighter : highlighters) {
            String tooltip = HighlightUsagesHandler.getLineTextErrorStripeTooltip(editor.getDocument(), rangeHighlighter.getStartOffset(), true);
            rangeHighlighter.setErrorStripeTooltip((Object)tooltip);
        }
    }

    public static boolean isClearHighlights(@NotNull Editor editor) {
        if (editor == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(30);
        }
        if (editor instanceof EditorWindow) {
            editor = ((EditorWindow)editor).getDelegate();
        }
        RangeHighlighter[] highlighters = ((HighlightManagerImpl)HighlightManager.getInstance((Project)editor.getProject())).getHighlighters(editor);
        int caretOffset = editor.getCaretModel().getOffset();
        for (RangeHighlighter highlighter : highlighters) {
            if (!TextRange.create((Segment)highlighter).grown(1).contains(caretOffset)) continue;
            return true;
        }
        return false;
    }

    private static void clearHighlights(@NotNull Editor editor, @NotNull HighlightManager highlightManager, @NotNull List<? extends TextRange> rangesToHighlight, @NotNull TextAttributes attributes) {
        if (editor == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(31);
        }
        if (highlightManager == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(32);
        }
        if (rangesToHighlight == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(33);
        }
        if (attributes == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(34);
        }
        if (editor instanceof EditorWindow) {
            editor = ((EditorWindow)editor).getDelegate();
        }
        RangeHighlighter[] highlighters = ((HighlightManagerImpl)highlightManager).getHighlighters(editor);
        Arrays.sort(highlighters, Comparator.comparingInt(RangeMarker::getStartOffset));
        Collections.sort(rangesToHighlight, Comparator.comparingInt(TextRange::getStartOffset));
        int i = 0;
        int j = 0;
        while (i < highlighters.length && j < rangesToHighlight.size()) {
            RangeHighlighter highlighter = highlighters[i];
            TextRange highlighterRange = TextRange.create((Segment)highlighter);
            TextRange refRange = rangesToHighlight.get(j);
            if (refRange.equals((Object)highlighterRange) && attributes.equals((Object)highlighter.getTextAttributes()) && highlighter.getLayer() == 5999) {
                highlightManager.removeSegmentHighlighter(editor, highlighter);
                ++i;
                continue;
            }
            if (refRange.getStartOffset() > highlighterRange.getEndOffset()) {
                ++i;
                continue;
            }
            if (refRange.getEndOffset() < highlighterRange.getStartOffset()) {
                ++j;
                continue;
            }
            ++i;
            ++j;
        }
    }

    private static void doHighlightRefs(@NotNull HighlightManager highlightManager, @NotNull Editor editor, @NotNull List<? extends PsiReference> refs, @NotNull TextAttributes attributes, boolean clearHighlights) {
        if (highlightManager == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(35);
        }
        if (editor == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(36);
        }
        if (refs == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(37);
        }
        if (attributes == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(38);
        }
        ArrayList<TextRange> textRanges = new ArrayList<TextRange>(refs.size());
        for (PsiReference psiReference : refs) {
            HighlightUsagesHandler.collectRangesToHighlight(psiReference, textRanges);
        }
        HighlightUsagesHandler.highlightRanges(highlightManager, editor, attributes, clearHighlights, textRanges);
    }

    @NotNull
    public static List<TextRange> collectRangesToHighlight(@NotNull PsiReference ref, @NotNull List<TextRange> result2) {
        if (ref == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(39);
        }
        if (result2 == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(40);
        }
        for (TextRange relativeRange : ReferenceRange.getRanges((PsiReference)ref)) {
            PsiElement element = ref.getElement();
            TextRange range2 = HighlightUsagesHandler.safeCut(element.getTextRange(), relativeRange);
            if (range2.isEmpty()) continue;
            result2.add(InjectedLanguageManager.getInstance((Project)element.getProject()).injectedToHost(element, range2));
        }
        List<TextRange> list2 = result2;
        if (list2 == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(41);
        }
        return list2;
    }

    @NotNull
    private static TextRange safeCut(@NotNull TextRange range2, @NotNull TextRange relative) {
        if (range2 == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(42);
        }
        if (relative == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(43);
        }
        int start2 = Math.min(range2.getEndOffset(), range2.getStartOffset() + relative.getStartOffset());
        int end = Math.min(range2.getEndOffset(), range2.getStartOffset() + relative.getEndOffset());
        TextRange textRange = new TextRange(start2, end);
        if (textRange == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(44);
        }
        return textRange;
    }

    private static void setStatusText(@NotNull Project project, @Nullable String elementName, int refCount, boolean clearHighlights) {
        if (project == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(45);
        }
        String message = clearHighlights ? "" : (refCount > 0 ? CodeInsightBundle.message((String)(elementName != null ? "status.bar.highlighted.usages.message" : "status.bar.highlighted.usages.no.target.message"), (Object[])new Object[]{refCount, elementName, HighlightUsagesHandler.getShortcutText()}) : CodeInsightBundle.message((String)(elementName != null ? "status.bar.highlighted.usages.not.found.message" : "status.bar.highlighted.usages.not.found.no.target.message"), (Object[])new Object[]{elementName}));
        WindowManager.getInstance().getStatusBar(project).setInfo(message);
    }

    @NotNull
    private static String getElementName(@NotNull PsiElement element) {
        if (element == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(46);
        }
        String string = ElementDescriptionUtil.getElementDescription((PsiElement)element, (ElementDescriptionLocation)HighlightUsagesDescriptionLocation.INSTANCE);
        if (string == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(47);
        }
        return string;
    }

    @NotNull
    public static String getShortcutText() {
        Shortcut[] shortcuts = ActionManager.getInstance().getAction("HighlightUsagesInFile").getShortcutSet().getShortcuts();
        if (shortcuts.length == 0) {
            if ("<no key assigned>" == null) {
                HighlightUsagesHandler.$$$reportNull$$$0(48);
            }
            return "<no key assigned>";
        }
        String string = KeymapUtil.getShortcutText((Shortcut)shortcuts[0]);
        if (string == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(49);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 41: 
            case 44: 
            case 47: 
            case 48: 
            case 49: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 41: 
            case 44: 
            case 47: 
            case 48: 
            case 49: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 10: 
            case 13: 
            case 15: 
            case 20: 
            case 23: 
            case 27: 
            case 30: 
            case 31: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 11: 
            case 14: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionModel";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibleRange";
                break;
            }
            case 18: 
            case 22: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 19: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 25: 
            case 28: 
            case 34: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 26: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightManager";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRanges";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangesToHighlight";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 41: 
            case 44: 
            case 47: 
            case 48: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/highlighting/HighlightUsagesHandler";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relative";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/highlighting/HighlightUsagesHandler";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "collectRangesToHighlight";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "safeCut";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementName";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortcutText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getUsageTargets";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "handleNoUsageTargets";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createCustomHandler";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getTargetElement";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "doRangeHighlighting";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "highlightReferences";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getNameIdentifierRange";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "doHighlightElements";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "highlightRanges";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isClearHighlights";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "clearHighlights";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "doHighlightRefs";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "collectRangesToHighlight";
                break;
            }
            case 41: 
            case 44: 
            case 47: 
            case 48: 
            case 49: {
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "safeCut";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "setStatusText";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getElementName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 41: 
            case 44: 
            case 47: 
            case 48: 
            case 49: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DoHighlightRunnable
    implements Runnable {
        private final List<? extends PsiReference> myRefs;
        @NotNull
        private final Project myProject;
        private final PsiElement myTarget;
        private final Editor myEditor;
        private final PsiFile myFile;
        private final boolean myClearHighlights;

        public DoHighlightRunnable(@NotNull List<? extends PsiReference> refs, @NotNull Project project, @NotNull PsiElement target2, @NotNull Editor editor, @NotNull PsiFile file2, boolean clearHighlights) {
            if (refs == null) {
                DoHighlightRunnable.$$$reportNull$$$0(0);
            }
            if (project == null) {
                DoHighlightRunnable.$$$reportNull$$$0(1);
            }
            if (target2 == null) {
                DoHighlightRunnable.$$$reportNull$$$0(2);
            }
            if (editor == null) {
                DoHighlightRunnable.$$$reportNull$$$0(3);
            }
            if (file2 == null) {
                DoHighlightRunnable.$$$reportNull$$$0(4);
            }
            this.myRefs = refs;
            this.myProject = project;
            this.myTarget = target2;
            this.myEditor = editor instanceof EditorWindow ? ((EditorWindow)editor).getDelegate() : editor;
            this.myFile = file2;
            this.myClearHighlights = clearHighlights;
        }

        @Override
        public void run() {
            HighlightUsagesHandler.highlightReferences(this.myProject, this.myTarget, this.myRefs, this.myEditor, this.myFile, this.myClearHighlights);
            HighlightUsagesHandler.setStatusText(this.myProject, HighlightUsagesHandler.getElementName(this.myTarget), this.myRefs.size(), this.myClearHighlights);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "refs";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "target";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/highlighting/HighlightUsagesHandler$DoHighlightRunnable";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

