/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.documentation.DockablePopupManager;
import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.documentation.DocumentationManagerUtil;
import com.intellij.codeInsight.documentation.DocumentationPreviewPanelProvider;
import com.intellij.codeInsight.documentation.QuickDocUtil;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.ParameterInfoController;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.actions.BaseNavigateToSourceAction;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.gotoByName.QuickSearchComponent;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageDocumentation;
import com.intellij.lang.documentation.CompositeDocumentationProvider;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.documentation.DocumentationProviderEx;
import com.intellij.lang.documentation.ExternalDocumentationHandler;
import com.intellij.lang.documentation.ExternalDocumentationProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.preview.PreviewManager;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiDocCommentBase;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.reference.SoftReference;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.content.Content;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.PopupUpdateProcessor;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.diff.Diff;
import com.intellij.util.diff.FilesTooBigForDiffException;
import com.intellij.util.text.DateFormatUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.ref.WeakReference;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import javax.swing.JComponent;
import javax.swing.MenuSelectionManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DocumentationManager
extends DockablePopupManager<DocumentationComponent> {
    public static final String JAVADOC_LOCATION_AND_SIZE = "javadoc.popup";
    public static final String NEW_JAVADOC_LOCATION_AND_SIZE = "javadoc.popup.new";
    public static final DataKey<String> SELECTED_QUICK_DOC_TEXT = DataKey.create((String)"QUICK_DOC.SELECTED_TEXT");
    private static final Logger LOG = Logger.getInstance(DocumentationManager.class);
    private static final String SHOW_DOCUMENTATION_IN_TOOL_WINDOW = "ShowDocumentationInToolWindow";
    private static final String DOCUMENTATION_AUTO_UPDATE_ENABLED = "DocumentationAutoUpdateEnabled";
    private static final long DOC_GENERATION_TIMEOUT_MILLISECONDS = 60000L;
    private static final long DOC_GENERATION_PAUSE_MILLISECONDS = 100L;
    private Editor myEditor;
    private final Alarm myUpdateDocAlarm;
    private WeakReference<JBPopup> myDocInfoHintRef;
    private WeakReference<Component> myFocusedBeforePopup;
    public static final Key<SmartPsiElementPointer> ORIGINAL_ELEMENT_KEY = Key.create((String)"Original element");
    private final ActionManager myActionManager;
    private final TargetElementUtil myTargetElementUtil;
    private boolean myCloseOnSneeze;
    private String myPrecalculatedDocumentation;
    private ActionCallback myLastAction;
    private DocumentationComponent myTestDocumentationComponent;
    private AnAction myRestorePopupAction;

    @Override
    protected String getToolwindowId() {
        return ToolWindowId.DOCUMENTATION;
    }

    @Override
    protected DocumentationComponent createComponent() {
        return new DocumentationComponent(this);
    }

    @Override
    protected String getRestorePopupDescription() {
        return "Restore popup view mode";
    }

    @Override
    protected String getAutoUpdateDescription() {
        return "Refresh documentation on selection change automatically";
    }

    @Override
    protected String getAutoUpdateTitle() {
        return "Auto-update from Source";
    }

    @Override
    protected boolean getAutoUpdateDefault() {
        return true;
    }

    @Override
    @NotNull
    protected AnAction createRestorePopupAction() {
        AnAction anAction = this.myRestorePopupAction = super.createRestorePopupAction();
        if (anAction == null) {
            DocumentationManager.$$$reportNull$$$0(0);
        }
        return anAction;
    }

    @Override
    public void restorePopupBehavior() {
        super.restorePopupBehavior();
        Component previouslyFocused = (Component)SoftReference.dereference(this.myFocusedBeforePopup);
        if (previouslyFocused != null && previouslyFocused.isShowing()) {
            IdeFocusManager.getInstance((Project)this.myProject).requestFocus(previouslyFocused, true);
            this.updateComponent(true);
        }
    }

    @Override
    public void createToolWindow(PsiElement element, PsiElement originalElement) {
        super.createToolWindow(element, originalElement);
        if (this.myToolWindow != null) {
            this.myToolWindow.getComponent().putClientProperty("ChooseByNameBase.TemporarilyFocusableComponent", Boolean.TRUE);
            if (this.myRestorePopupAction != null) {
                ShortcutSet quickDocShortcut = ActionManager.getInstance().getAction("QuickJavaDoc").getShortcutSet();
                this.myRestorePopupAction.registerCustomShortcutSet(quickDocShortcut, this.myToolWindow.getComponent());
                this.myRestorePopupAction = null;
            }
        }
    }

    public boolean isCloseOnSneeze() {
        return this.myCloseOnSneeze;
    }

    @Override
    protected void installComponentActions(ToolWindow toolWindow, DocumentationComponent component) {
        ((ToolWindowEx)toolWindow).setTitleActions(component.getActions());
        DefaultActionGroup group = new DefaultActionGroup(this.createActions());
        group.add(component.getFontSizeAction());
        ((ToolWindowEx)toolWindow).setAdditionalGearActions((ActionGroup)group);
        component.removeCornerMenu();
    }

    @Override
    protected void setToolwindowDefaultState() {
        Rectangle rectangle = WindowManager.getInstance().getIdeFrame(this.myProject).suggestChildFrameBounds();
        this.myToolWindow.setDefaultState(ToolWindowAnchor.RIGHT, ToolWindowType.DOCKED, new Rectangle(rectangle.width / 4, rectangle.height));
        this.myToolWindow.setType(ToolWindowType.DOCKED, null);
        this.myToolWindow.setSplitMode(true, null);
        this.myToolWindow.setAutoHide(false);
    }

    public static DocumentationManager getInstance(Project project) {
        return (DocumentationManager)ServiceManager.getService((Project)project, DocumentationManager.class);
    }

    public DocumentationManager(Project project, ActionManager manager, TargetElementUtil targetElementUtil) {
        super(project);
        this.myActionManager = manager;
        AnActionListener actionListener = new AnActionListener(){

            public void beforeActionPerformed(@NotNull AnAction action, @NotNull DataContext dataContext, @NotNull AnActionEvent event) {
                JBPopup hint;
                if (action == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (dataContext == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (event == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((hint = DocumentationManager.this.getDocInfoHint()) != null) {
                    if (LookupManager.getActiveLookup(DocumentationManager.this.myEditor) != null) {
                        return;
                    }
                    if (action instanceof HintManagerImpl.ActionToIgnore) {
                        return;
                    }
                    if (action instanceof ScrollingUtil.ScrollingAction) {
                        return;
                    }
                    if (action == DocumentationManager.this.myActionManager.getAction("EditorDown")) {
                        return;
                    }
                    if (action == DocumentationManager.this.myActionManager.getAction("EditorUp")) {
                        return;
                    }
                    if (action == DocumentationManager.this.myActionManager.getAction("EditorPageDown")) {
                        return;
                    }
                    if (action == DocumentationManager.this.myActionManager.getAction("EditorPageUp")) {
                        return;
                    }
                    if (action == ActionManager.getInstance().getAction("EditorEscape")) {
                        return;
                    }
                    if ("JavadocInplaceSettings".equals(event.getPlace())) {
                        return;
                    }
                    if ("JavadocToolbar".equals(event.getPlace())) {
                        return;
                    }
                    if (action instanceof BaseNavigateToSourceAction) {
                        return;
                    }
                    DocumentationManager.this.closeDocHint();
                }
            }

            public void beforeEditorTyping(char c, @NotNull DataContext dataContext) {
                JBPopup hint;
                if (dataContext == null) {
                    1.$$$reportNull$$$0(3);
                }
                if ((hint = DocumentationManager.this.getDocInfoHint()) != null && LookupManager.getActiveLookup(DocumentationManager.this.myEditor) == null) {
                    hint.cancel();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "action";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataContext";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInsight/documentation/DocumentationManager$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeActionPerformed";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeEditorTyping";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)project).subscribe(AnActionListener.TOPIC, (Object)actionListener);
        this.myUpdateDocAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this.myProject);
        this.myTargetElementUtil = targetElementUtil;
    }

    private void closeDocHint() {
        JBPopup hint = this.getDocInfoHint();
        if (hint == null) {
            return;
        }
        this.myCloseOnSneeze = false;
        hint.cancel();
        Component toFocus = (Component)SoftReference.dereference(this.myFocusedBeforePopup);
        hint.cancel();
        if (toFocus != null) {
            IdeFocusManager.getInstance((Project)this.myProject).requestFocus(toFocus, true);
        }
    }

    public void setAllowContentUpdateFromContext(boolean allow) {
        if (this.hasActiveDockedDocWindow()) {
            this.restartAutoUpdate(allow);
        }
    }

    public void updateToolwindowContext() {
        if (this.hasActiveDockedDocWindow()) {
            this.updateComponent();
        }
    }

    public void showJavaDocInfoAtToolWindow(@NotNull PsiElement element, @NotNull PsiElement original) {
        Content content;
        if (element == null) {
            DocumentationManager.$$$reportNull$$$0(1);
        }
        if (original == null) {
            DocumentationManager.$$$reportNull$$$0(2);
        }
        if ((content = this.recreateToolWindow(element, original)) == null) {
            return;
        }
        DocumentationComponent component = (DocumentationComponent)content.getComponent();
        this.myUpdateDocAlarm.cancelAllRequests();
        this.doFetchDocInfo(component, new MyCollector(this.myProject, element, original, null)).doWhenDone(() -> component.clearHistory());
    }

    public void showJavaDocInfo(@NotNull PsiElement element, PsiElement original) {
        if (element == null) {
            DocumentationManager.$$$reportNull$$$0(3);
        }
        this.showJavaDocInfo(element, original, null);
    }

    public void showJavaDocInfo(@NotNull Editor editor, @NotNull PsiElement element, @NotNull PsiElement original, @Nullable Runnable closeCallback, @Nullable String documentation, boolean closeOnSneeze) {
        if (editor == null) {
            DocumentationManager.$$$reportNull$$$0(4);
        }
        if (element == null) {
            DocumentationManager.$$$reportNull$$$0(5);
        }
        if (original == null) {
            DocumentationManager.$$$reportNull$$$0(6);
        }
        this.myEditor = editor;
        this.myCloseOnSneeze = closeOnSneeze;
        this.showJavaDocInfo(element, original, false, closeCallback, documentation);
    }

    public void showJavaDocInfo(@NotNull PsiElement element, PsiElement original, @Nullable Runnable closeCallback) {
        if (element == null) {
            DocumentationManager.$$$reportNull$$$0(7);
        }
        this.showJavaDocInfo(element, original, false, closeCallback);
    }

    public void showJavaDocInfo(@NotNull PsiElement element, PsiElement original, boolean requestFocus, @Nullable Runnable closeCallback) {
        if (element == null) {
            DocumentationManager.$$$reportNull$$$0(8);
        }
        this.showJavaDocInfo(element, original, requestFocus, closeCallback, null);
    }

    public void showJavaDocInfo(@NotNull PsiElement element, final PsiElement original, final boolean requestFocus, @Nullable Runnable closeCallback, @Nullable String documentation) {
        if (element == null) {
            DocumentationManager.$$$reportNull$$$0(9);
        }
        if (!element.isValid()) {
            return;
        }
        PopupUpdateProcessor updateProcessor = new PopupUpdateProcessor(element.getProject()){

            public void updatePopup(Object lookupItemObject) {
                if (lookupItemObject instanceof PsiElement) {
                    DocumentationManager.this.doShowJavaDocInfo((PsiElement)lookupItemObject, requestFocus, this, original, null, null);
                }
            }
        };
        this.doShowJavaDocInfo(element, requestFocus, updateProcessor, original, closeCallback, documentation);
    }

    public void showJavaDocInfo(Editor editor, @Nullable PsiFile file2, boolean requestFocus) {
        this.showJavaDocInfo(editor, file2, requestFocus, null);
    }

    public void showJavaDocInfo(Editor editor, final @Nullable PsiFile file2, boolean requestFocus, final @Nullable Runnable closeCallback) {
        this.myEditor = editor;
        Project project = this.getProject((PsiElement)file2);
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        Object list2 = ParameterInfoController.findArgumentList(file2, editor.getCaretModel().getOffset(), -1);
        Object expressionList = null;
        if (list2 != null) {
            LookupEx lookup = LookupManager.getInstance(this.myProject).getActiveLookup();
            expressionList = lookup != null ? null : list2;
        }
        final PsiElement originalElement = DocumentationManager.getContextElement(editor, file2);
        PsiElement element = this.assertSameProject(this.findTargetElement(editor, file2));
        if (element == null && expressionList != null) {
            element = expressionList;
        }
        if (element == null && file2 == null) {
            return;
        }
        if (element == null) {
            element = this.assertSameProject(originalElement);
            if (element == null) {
                return;
            }
            PsiComment comment = (PsiComment)PsiTreeUtil.getParentOfType((PsiElement)element, PsiComment.class);
            if (comment == null) {
                return;
            }
            PsiElement psiElement = element = comment instanceof PsiDocCommentBase ? ((PsiDocCommentBase)comment).getOwner() : comment.getParent();
            if (element == null) {
                return;
            }
        }
        final PsiElement finalElement = element;
        PopupUpdateProcessor updateProcessor = new PopupUpdateProcessor(project){

            public void updatePopup(Object lookupIteObject) {
                if (lookupIteObject == null) {
                    DocumentationManager.this.doShowJavaDocInfo(finalElement, false, this, originalElement, closeCallback, CodeInsightBundle.message((String)"no.documentation.found", (Object[])new Object[0]));
                    return;
                }
                if (lookupIteObject instanceof PsiElement) {
                    DocumentationManager.this.doShowJavaDocInfo((PsiElement)lookupIteObject, false, this, originalElement, closeCallback, null);
                    return;
                }
                DocumentationProvider documentationProvider = DocumentationManager.getProviderFromElement((PsiElement)file2);
                PsiElement element = documentationProvider.getDocumentationElementForLookupItem(PsiManager.getInstance((Project)DocumentationManager.this.myProject), lookupIteObject, originalElement);
                if (element == null) {
                    DocumentationManager.this.doShowJavaDocInfo(finalElement, false, this, originalElement, closeCallback, CodeInsightBundle.message((String)"no.documentation.found", (Object[])new Object[0]));
                    return;
                }
                if (DocumentationManager.this.myEditor != null) {
                    PsiFile file22 = element.getContainingFile();
                    if (file22 != null) {
                        Editor editor = DocumentationManager.this.myEditor;
                        DocumentationManager.this.showJavaDocInfo(DocumentationManager.this.myEditor, file22, false);
                        DocumentationManager.this.myEditor = editor;
                    }
                } else {
                    DocumentationManager.this.doShowJavaDocInfo(element, false, this, originalElement, closeCallback, null);
                }
            }
        };
        this.doShowJavaDocInfo(element, requestFocus, updateProcessor, originalElement, closeCallback, null);
    }

    public PsiElement findTargetElement(Editor editor, PsiFile file2) {
        return this.findTargetElement(editor, file2, DocumentationManager.getContextElement(editor, file2));
    }

    private static PsiElement getContextElement(Editor editor, PsiFile file2) {
        return file2 != null ? file2.findElementAt(editor.getCaretModel().getOffset()) : null;
    }

    private void doShowJavaDocInfo(@NotNull PsiElement element, boolean requestFocus, PopupUpdateProcessor updateProcessor, PsiElement originalElement, @Nullable Runnable closeCallback, @Nullable String documentation) {
        Project project;
        if (element == null) {
            DocumentationManager.$$$reportNull$$$0(10);
        }
        if (!(project = this.getProject(element)).isOpen()) {
            return;
        }
        DocumentationManager.storeOriginalElement(project, originalElement, element);
        JBPopup prevHint = this.getDocInfoHint();
        if (PreviewManager.SERVICE.preview(this.myProject, DocumentationPreviewPanelProvider.ID, Couple.of((Object)element, (Object)originalElement), requestFocus) != null) {
            return;
        }
        this.myPrecalculatedDocumentation = documentation;
        if (this.myToolWindow == null && PropertiesComponent.getInstance().isTrueValue(SHOW_DOCUMENTATION_IN_TOOL_WINDOW)) {
            this.createToolWindow(element, originalElement);
        } else if (this.myToolWindow != null) {
            Content content = this.myToolWindow.getContentManager().getSelectedContent();
            if (content != null) {
                DocumentationComponent component = (DocumentationComponent)content.getComponent();
                boolean sameElement = element.getManager().areElementsEquivalent(component.getElement(), element);
                if (sameElement) {
                    boolean focus;
                    JComponent preferredFocusableComponent = content.getPreferredFocusableComponent();
                    boolean bl = focus = requestFocus || CommandProcessor.getInstance().getCurrentCommand() != null;
                    if (preferredFocusableComponent != null && focus) {
                        IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)preferredFocusableComponent, true);
                    }
                }
                if (!sameElement || !component.isUpToDate()) {
                    this.cancelAndFetchDocInfo(component, new MyCollector(this.myProject, element, originalElement, null)).doWhenDone(() -> component.clearHistory());
                }
            }
            if (!this.myToolWindow.isVisible()) {
                this.myToolWindow.show(null);
            }
        } else if (prevHint != null && prevHint.isVisible() && prevHint instanceof AbstractPopup) {
            DocumentationComponent component = (DocumentationComponent)((AbstractPopup)prevHint).getComponent();
            ActionCallback result2 = this.cancelAndFetchDocInfo(component, new MyCollector(this.myProject, element, originalElement, null));
            if (requestFocus) {
                result2.doWhenDone(() -> {
                    JBPopup hint = this.getDocInfoHint();
                    if (hint != null) {
                        ((AbstractPopup)hint).focusPreferredComponent();
                    }
                });
            }
        } else {
            this.showInPopup(element, requestFocus, updateProcessor, originalElement, closeCallback);
        }
    }

    private void showInPopup(final @NotNull PsiElement element, boolean requestFocus, PopupUpdateProcessor updateProcessor, final PsiElement originalElement, @Nullable Runnable closeCallback) {
        if (element == null) {
            DocumentationManager.$$$reportNull$$$0(11);
        }
        Component focusedComponent = WindowManagerEx.getInstanceEx().getFocusedComponent(this.myProject);
        this.myFocusedBeforePopup = new WeakReference<Component>(focusedComponent);
        DocumentationComponent component = this.myTestDocumentationComponent == null ? new DocumentationComponent(this) : this.myTestDocumentationComponent;
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DocumentationManager.this.createToolWindow(element, originalElement);
                JBPopup hint = DocumentationManager.this.getDocInfoHint();
                if (hint != null && hint.isVisible()) {
                    hint.cancel();
                }
            }
        };
        List actions = ContainerUtil.newSmartList();
        AnAction quickDocAction = ActionManager.getInstance().getAction("QuickJavaDoc");
        for (Shortcut shortcut : quickDocAction.getShortcutSet().getShortcuts()) {
            if (!(shortcut instanceof KeyboardShortcut)) continue;
            actions.add(Pair.create((Object)actionListener, (Object)((KeyboardShortcut)shortcut).getFirstKeyStroke()));
        }
        boolean hasLookup = LookupManager.getActiveLookup(this.myEditor) != null;
        AbstractPopup hint = (AbstractPopup)JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)component, (JComponent)component).setProject(element.getProject()).addListener((JBPopupListener)updateProcessor).addUserData((Object)updateProcessor).setKeyboardActions(actions).setResizable(true).setMovable(true).setFocusable(true).setRequestFocus(requestFocus).setCancelOnClickOutside(!hasLookup).setModalContext(false).setCancelCallback(() -> {
            if (MenuSelectionManager.defaultManager().getSelectedPath().length > 0) {
                return false;
            }
            this.myCloseOnSneeze = false;
            if (closeCallback != null) {
                closeCallback.run();
            }
            this.findQuickSearchComponent().ifPresent(QuickSearchComponent::unregisterHint);
            Disposer.dispose((Disposable)component);
            this.myEditor = null;
            return Boolean.TRUE;
        }).setKeyEventHandler(e -> {
            if (this.myCloseOnSneeze) {
                this.closeDocHint();
            }
            if (AbstractPopup.isCloseRequest(e) && this.getDocInfoHint() != null) {
                this.closeDocHint();
                return true;
            }
            return false;
        }).createPopup();
        component.setHint(hint);
        component.setToolwindowCallback(() -> {
            this.createToolWindow(element, originalElement);
            this.myToolWindow.setAutoHide(false);
            hint.cancel();
        });
        if (DimensionService.getInstance().getSize(NEW_JAVADOC_LOCATION_AND_SIZE, this.myProject) != null) {
            hint.setDimensionServiceKey(NEW_JAVADOC_LOCATION_AND_SIZE);
        }
        if (this.myEditor == null) {
            LookupEx lookup = LookupManager.getInstance(this.myProject).getActiveLookup();
            this.myEditor = lookup != null ? lookup.getEditor() : null;
        }
        this.cancelAndFetchDocInfo(component, new MyCollector(this.myProject, element, originalElement, null));
        this.myDocInfoHintRef = new WeakReference<AbstractPopup>(hint);
        this.findQuickSearchComponent().ifPresent(quickSearch -> quickSearch.registerHint((JBPopup)hint));
        IdeEventQueue.getInstance().addDispatcher(e -> {
            if (e.getID() == 501 && e.getSource() == hint.getPopupWindow()) {
                this.myCloseOnSneeze = false;
            }
            return false;
        }, component);
    }

    static String getTitle(@NotNull PsiElement element, boolean isShort) {
        if (element == null) {
            DocumentationManager.$$$reportNull$$$0(12);
        }
        String title = SymbolPresentationUtil.getSymbolPresentableText(element);
        return isShort ? (title != null ? title : element.getText()) : CodeInsightBundle.message((String)"javadoc.info.title", (Object[])new Object[]{title != null ? title : element.getText()});
    }

    public static void storeOriginalElement(Project project, PsiElement originalElement, PsiElement element) {
        if (element == null) {
            return;
        }
        try {
            element.putUserData(ORIGINAL_ELEMENT_KEY, (Object)SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer(originalElement));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Nullable
    public PsiElement findTargetElement(@NotNull Editor editor, @Nullable PsiFile file2, PsiElement contextElement) {
        if (editor == null) {
            DocumentationManager.$$$reportNull$$$0(13);
        }
        return this.findTargetElement(editor, editor.getCaretModel().getOffset(), file2, contextElement);
    }

    @Nullable
    public PsiElement findTargetElement(Editor editor, int offset, @Nullable PsiFile file2, PsiElement contextElement) {
        try {
            return this.findTargetElementUnsafe(editor, offset, file2, contextElement);
        }
        catch (IndexNotReadyException ex) {
            LOG.warn("Index not ready");
            LOG.debug((Throwable)ex);
            return null;
        }
    }

    @Nullable
    private PsiElement findTargetElementUnsafe(Editor editor, int offset, @Nullable PsiFile file2, PsiElement contextElement) {
        PsiReference ref;
        PsiElement adjusted;
        DocumentationProvider documentationProvider;
        if (LookupManager.getInstance(this.myProject).getActiveLookup() != null) {
            return this.assertSameProject(this.getElementFromLookup(editor, file2));
        }
        TargetElementUtil util = TargetElementUtil.getInstance();
        PsiElement element = null;
        if (file2 != null && (documentationProvider = DocumentationManager.getProviderFromElement((PsiElement)file2)) instanceof DocumentationProviderEx) {
            element = this.assertSameProject(((DocumentationProviderEx)documentationProvider).getCustomDocumentationElement(editor, file2, contextElement));
        }
        if (element == null && ((element = this.assertSameProject(util.findTargetElement(editor, this.myTargetElementUtil.getAllAccepted(), offset))) != null || contextElement != null) && (adjusted = this.assertSameProject(util.adjustElement(editor, this.myTargetElementUtil.getAllAccepted(), element, contextElement))) != null) {
            element = adjusted;
        }
        if (element == null && (ref = TargetElementUtil.findReference(editor, offset)) != null) {
            element = this.assertSameProject(util.adjustReference(ref));
            if (ref instanceof PsiPolyVariantReference) {
                element = this.assertSameProject(ref.getElement());
            }
        }
        DocumentationManager.storeOriginalElement(this.myProject, contextElement, element);
        return element;
    }

    @Nullable
    public PsiElement getElementFromLookup(Editor editor, @Nullable PsiFile file2) {
        LookupElement item;
        LookupEx activeLookup = LookupManager.getInstance(this.myProject).getActiveLookup();
        if (activeLookup != null && (item = activeLookup.getCurrentItem()) != null) {
            PsiElement targetElement;
            int offset = editor.getCaretModel().getOffset();
            if (offset > 0 && offset == editor.getDocument().getTextLength()) {
                --offset;
            }
            PsiReference ref = TargetElementUtil.findReference(editor, offset);
            PsiElement contextElement = file2 == null ? null : file2.findElementAt(offset);
            PsiElement psiElement = targetElement = ref != null ? ref.getElement() : contextElement;
            if (targetElement != null) {
                PsiUtilCore.ensureValid((PsiElement)targetElement);
            }
            DocumentationProvider documentationProvider = DocumentationManager.getProviderFromElement((PsiElement)file2);
            PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
            PsiElement fromProvider = targetElement == null ? null : documentationProvider.getDocumentationElementForLookupItem(psiManager, item.getObject(), targetElement);
            return fromProvider != null ? fromProvider : CompletionUtil.getTargetElement(item);
        }
        return null;
    }

    public String generateDocumentation(@NotNull PsiElement element, @Nullable PsiElement originalElement) {
        if (element == null) {
            DocumentationManager.$$$reportNull$$$0(14);
        }
        return new MyCollector(this.myProject, element, originalElement, null).getDocumentation();
    }

    @Nullable
    public JBPopup getDocInfoHint() {
        if (this.myDocInfoHintRef == null) {
            return null;
        }
        JBPopup hint = (JBPopup)this.myDocInfoHintRef.get();
        if (hint == null || !hint.isVisible() && !ApplicationManager.getApplication().isUnitTestMode()) {
            if (hint != null) {
                hint.cancel();
            }
            this.myDocInfoHintRef = null;
            return null;
        }
        return hint;
    }

    public void fetchDocInfo(@NotNull PsiElement element, @NotNull DocumentationComponent component) {
        if (element == null) {
            DocumentationManager.$$$reportNull$$$0(15);
        }
        if (component == null) {
            DocumentationManager.$$$reportNull$$$0(16);
        }
        this.cancelAndFetchDocInfo(component, new MyCollector(this.myProject, element, null, null));
    }

    public ActionCallback queueFetchDocInfo(@NotNull PsiElement element, @NotNull DocumentationComponent component) {
        if (element == null) {
            DocumentationManager.$$$reportNull$$$0(17);
        }
        if (component == null) {
            DocumentationManager.$$$reportNull$$$0(18);
        }
        return this.doFetchDocInfo(component, new MyCollector(this.myProject, element, null, null));
    }

    private ActionCallback cancelAndFetchDocInfo(@NotNull DocumentationComponent component, @NotNull DocumentationCollector provider) {
        if (component == null) {
            DocumentationManager.$$$reportNull$$$0(19);
        }
        if (provider == null) {
            DocumentationManager.$$$reportNull$$$0(20);
        }
        this.updateToolWindowTabName(provider.element);
        this.myUpdateDocAlarm.cancelAllRequests();
        return this.doFetchDocInfo(component, provider);
    }

    void updateToolWindowTabName(@NotNull PsiElement element) {
        Content content;
        if (element == null) {
            DocumentationManager.$$$reportNull$$$0(21);
        }
        if (this.myToolWindow != null && (content = this.myToolWindow.getContentManager().getSelectedContent()) != null) {
            content.setDisplayName(DocumentationManager.getTitle(element, true));
        }
    }

    private ActionCallback doFetchDocInfo(@NotNull DocumentationComponent component, @NotNull DocumentationCollector collector) {
        ActionCallback callback2;
        if (component == null) {
            DocumentationManager.$$$reportNull$$$0(22);
        }
        if (collector == null) {
            DocumentationManager.$$$reportNull$$$0(23);
        }
        this.myLastAction = callback2 = new ActionCallback();
        if (this.myPrecalculatedDocumentation != null) {
            LOG.debug("Setting precalculated documentation");
            PsiElement element = collector.element;
            PsiElement originalElement = collector instanceof MyCollector ? ((MyCollector)collector).originalElement : element;
            DocumentationProvider provider = (DocumentationProvider)ReadAction.compute(() -> DocumentationManager.getProviderFromElement(element, originalElement));
            component.setData(element, this.myPrecalculatedDocumentation, collector.effectiveUrl, collector.ref, provider);
            callback2.setDone();
            this.myPrecalculatedDocumentation = null;
            return callback2;
        }
        boolean wasEmpty = component.isEmpty();
        component.startWait();
        if (wasEmpty) {
            component.setText(CodeInsightBundle.message((String)"javadoc.fetching.progress", (Object[])new Object[0]), collector.element, collector.provider);
            AbstractPopup jbPopup = (AbstractPopup)this.getDocInfoHint();
            if (jbPopup != null) {
                jbPopup.setDimensionServiceKey(null);
            }
        }
        ModalityState modality = ModalityState.defaultModalityState();
        this.myUpdateDocAlarm.addRequest(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            LOG.debug("Started fetching documentation...");
            PsiElement element = (PsiElement)ReadAction.compute(() -> collector.element.isValid() ? collector.element : null);
            if (element == null) {
                LOG.debug("Element for which documentation was requested is not available anymore");
                return;
            }
            Throwable fail = null;
            String text = null;
            try {
                text = collector.getDocumentation();
            }
            catch (Throwable e) {
                LOG.info(e);
                fail = e;
            }
            if (fail != null) {
                Throwable finalFail = fail;
                GuiUtils.invokeLaterIfNeeded(() -> {
                    String message = finalFail instanceof IndexNotReadyException ? "Documentation is not available until indices are built." : CodeInsightBundle.message((String)"javadoc.external.fetch.error.message", (Object[])new Object[0]);
                    component.setText(message, null, collector.provider);
                    component.clearHistory();
                    callback2.setDone();
                }, (ModalityState)ModalityState.any());
                return;
            }
            LOG.debug("Documentation fetched successfully:\n", new Object[]{text});
            String finalText = text;
            PsiDocumentManager.getInstance((Project)this.myProject).performLaterWhenAllCommitted(() -> {
                if (!element.isValid()) {
                    LOG.debug("Element for which documentation was requested is not valid");
                    callback2.setDone();
                    return;
                }
                PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
                String currentText = component.getText();
                PsiElement currentElement = component.getElement();
                if (finalText == null) {
                    component.setText(CodeInsightBundle.message((String)"no.documentation.found", (Object[])new Object[0]), element, collector.provider);
                } else if (finalText.isEmpty()) {
                    component.setText(currentText, element, collector.provider);
                } else if (currentElement != null && psiManager.areElementsEquivalent(currentElement, element)) {
                    Diff.Change change = null;
                    try {
                        change = Diff.buildChanges((CharSequence)currentText, (CharSequence)finalText);
                    }
                    catch (FilesTooBigForDiffException filesTooBigForDiffException) {
                        // empty catch block
                    }
                    if (change == null || change.line0 > 10) {
                        component.replaceText(finalText, element);
                    } else {
                        component.setData(element, finalText, collector.effectiveUrl, collector.ref, collector.provider);
                    }
                } else {
                    component.setData(element, finalText, collector.effectiveUrl, collector.ref, collector.provider);
                }
                if (wasEmpty) {
                    component.clearHistory();
                }
                callback2.setDone();
            }, modality);
        }, 10);
        return callback2;
    }

    @NotNull
    public static DocumentationProvider getProviderFromElement(PsiElement element) {
        DocumentationProvider documentationProvider = DocumentationManager.getProviderFromElement(element, null);
        if (documentationProvider == null) {
            DocumentationManager.$$$reportNull$$$0(24);
        }
        return documentationProvider;
    }

    @NotNull
    public static DocumentationProvider getProviderFromElement(@Nullable PsiElement element, @Nullable PsiElement originalElement) {
        if (element != null && !element.isValid()) {
            element = null;
        }
        if (originalElement != null && !originalElement.isValid()) {
            originalElement = null;
        }
        if (originalElement == null) {
            originalElement = DocumentationManager.getOriginalElement(element);
        }
        PsiFile containingFile = originalElement != null ? originalElement.getContainingFile() : (element != null ? element.getContainingFile() : null);
        LinkedHashSet result2 = new LinkedHashSet();
        Language containingFileLanguage = containingFile != null ? containingFile.getLanguage() : null;
        DocumentationProvider originalProvider = containingFile != null ? LanguageDocumentation.INSTANCE.forLanguage(containingFileLanguage) : null;
        Language elementLanguage = element != null ? element.getLanguage() : null;
        DocumentationProvider elementProvider = element == null || elementLanguage.is(containingFileLanguage) ? null : LanguageDocumentation.INSTANCE.forLanguage(elementLanguage);
        ContainerUtil.addIfNotNull(result2, elementProvider);
        ContainerUtil.addIfNotNull(result2, (Object)originalProvider);
        if (containingFile != null) {
            Language baseLanguage = containingFile.getViewProvider().getBaseLanguage();
            if (!baseLanguage.is(containingFileLanguage)) {
                ContainerUtil.addIfNotNull(result2, (Object)LanguageDocumentation.INSTANCE.forLanguage(baseLanguage));
            }
        } else if (element instanceof PsiDirectory) {
            HashSet<Language> set2 = new HashSet<Language>();
            for (PsiFile file2 : ((PsiDirectory)element).getFiles()) {
                Language baseLanguage = file2.getViewProvider().getBaseLanguage();
                if (set2.contains(baseLanguage)) continue;
                set2.add(baseLanguage);
                ContainerUtil.addIfNotNull(result2, (Object)LanguageDocumentation.INSTANCE.forLanguage(baseLanguage));
            }
        }
        DocumentationProvider documentationProvider = CompositeDocumentationProvider.wrapProviders(result2);
        if (documentationProvider == null) {
            DocumentationManager.$$$reportNull$$$0(25);
        }
        return documentationProvider;
    }

    @Nullable
    public static PsiElement getOriginalElement(PsiElement element) {
        SmartPsiElementPointer originalElementPointer = element != null ? (SmartPsiElementPointer)element.getUserData(ORIGINAL_ELEMENT_KEY) : null;
        return originalElementPointer != null ? originalElementPointer.getElement() : null;
    }

    void navigateByLink(DocumentationComponent component, final String url) {
        component.setCursor(Cursor.getPredefinedCursor(3));
        final PsiElement psiElement = component.getElement();
        if (psiElement == null) {
            return;
        }
        PsiManager manager = PsiManager.getInstance((Project)this.getProject(psiElement));
        if (url.equals("external_doc")) {
            component.showExternalDoc();
            return;
        }
        if (url.startsWith("open")) {
            PsiFile containingFile = psiElement.getContainingFile();
            OrderEntry libraryEntry = null;
            if (containingFile != null) {
                VirtualFile virtualFile = containingFile.getVirtualFile();
                libraryEntry = LibraryUtil.findLibraryEntry((VirtualFile)virtualFile, (Project)this.myProject);
            } else if (psiElement instanceof PsiDirectoryContainer) {
                PsiDirectory directory;
                VirtualFile virtualFile;
                PsiDirectory[] directories;
                PsiDirectory[] psiDirectoryArray = directories = ((PsiDirectoryContainer)psiElement).getDirectories();
                int n = psiDirectoryArray.length;
                for (int i = 0; i < n && (libraryEntry = LibraryUtil.findLibraryEntry((VirtualFile)(virtualFile = (directory = psiDirectoryArray[i]).getVirtualFile()), (Project)this.myProject)) == null; ++i) {
                }
            }
            if (libraryEntry != null) {
                ProjectSettingsService.getInstance(this.myProject).openLibraryOrSdkSettings(libraryEntry);
            }
        } else if (url.startsWith("psi_element://")) {
            Iterator iterator;
            DocumentationProvider provider;
            PsiElement targetElement;
            String refText = url.substring("psi_element://".length());
            int separatorPos = refText.lastIndexOf("###");
            String ref = null;
            if (separatorPos >= 0) {
                ref = refText.substring(separatorPos + "###".length());
                refText = refText.substring(0, separatorPos);
            }
            if ((targetElement = (provider = DocumentationManager.getProviderFromElement(psiElement)).getDocumentationElementForLink(manager, refText, psiElement)) == null) {
                DocumentationProvider documentationProvider;
                iterator = DocumentationProvider.EP_NAME.getExtensionList().iterator();
                while (iterator.hasNext() && (targetElement = (documentationProvider = (DocumentationProvider)iterator.next()).getDocumentationElementForLink(manager, refText, psiElement)) == null) {
                }
            }
            if (targetElement == null) {
                Language language;
                DocumentationProvider documentationProvider;
                iterator = Language.getRegisteredLanguages().iterator();
                while (iterator.hasNext() && ((documentationProvider = LanguageDocumentation.INSTANCE.forLanguage(language = (Language)iterator.next())) == null || (targetElement = documentationProvider.getDocumentationElementForLink(manager, refText, psiElement)) == null)) {
                }
            }
            if (targetElement != null) {
                this.cancelAndFetchDocInfo(component, new MyCollector(this.myProject, targetElement, null, ref));
            }
        } else {
            DocumentationProvider provider = DocumentationManager.getProviderFromElement(psiElement);
            boolean processed2 = false;
            if (provider instanceof CompositeDocumentationProvider) {
                for (DocumentationProvider p : ((CompositeDocumentationProvider)provider).getAllProviders()) {
                    if (!(p instanceof ExternalDocumentationHandler)) continue;
                    final ExternalDocumentationHandler externalHandler = (ExternalDocumentationHandler)p;
                    if (externalHandler.canFetchDocumentationLink(url)) {
                        String ref = externalHandler.extractRefFromLink(url);
                        this.cancelAndFetchDocInfo(component, new DocumentationCollector(psiElement, url, ref, p){

                            @Override
                            public String getDocumentation() {
                                return externalHandler.fetchExternalDocumentation(url, psiElement);
                            }
                        });
                        processed2 = true;
                        continue;
                    }
                    if (!externalHandler.handleExternalLink(manager, url, psiElement)) continue;
                    processed2 = true;
                    break;
                }
            }
            if (!processed2) {
                this.cancelAndFetchDocInfo(component, new DocumentationCollector(psiElement, url, null, provider){

                    @Override
                    public String getDocumentation() {
                        if (BrowserUtil.isAbsoluteURL((String)url)) {
                            BrowserUtil.browse((String)url);
                            return "";
                        }
                        return CodeInsightBundle.message((String)"javadoc.error.resolving.url", (Object[])new Object[]{url});
                    }
                });
            }
        }
        component.setCursor(Cursor.getPredefinedCursor(0));
    }

    public Project getProject(@Nullable PsiElement element) {
        this.assertSameProject(element);
        return this.myProject;
    }

    private PsiElement assertSameProject(@Nullable PsiElement element) {
        if (element != null && element.isValid() && this.myProject != element.getProject()) {
            throw new AssertionError((Object)(this.myProject + "!=" + element.getProject() + "; element=" + element));
        }
        return element;
    }

    public static void createHyperlink(StringBuilder buffer, String refText, String label2, boolean plainLink) {
        DocumentationManagerUtil.createHyperlink((StringBuilder)buffer, (String)refText, (String)label2, (boolean)plainLink);
    }

    @Override
    public String getShowInToolWindowProperty() {
        return SHOW_DOCUMENTATION_IN_TOOL_WINDOW;
    }

    @Override
    public String getAutoUpdateEnabledProperty() {
        return DOCUMENTATION_AUTO_UPDATE_ENABLED;
    }

    @Override
    protected void doUpdateComponent(PsiElement element, PsiElement originalElement, DocumentationComponent component) {
        this.cancelAndFetchDocInfo(component, new MyCollector(this.myProject, element, originalElement, null));
    }

    @Override
    protected void doUpdateComponent(Editor editor, PsiFile psiFile, boolean requestFocus) {
        this.showJavaDocInfo(editor, psiFile, requestFocus, null);
    }

    @Override
    protected void doUpdateComponent(Editor editor, PsiFile psiFile) {
        this.doUpdateComponent(editor, psiFile, false);
    }

    @Override
    protected void doUpdateComponent(@NotNull PsiElement element) {
        if (element == null) {
            DocumentationManager.$$$reportNull$$$0(26);
        }
        this.showJavaDocInfo(element, element, null);
    }

    @Override
    protected String getTitle(PsiElement element) {
        return DocumentationManager.getTitle(element, true);
    }

    @Nullable
    public Image getElementImage(@NotNull PsiElement element, @NotNull String imageSpec) {
        DocumentationProvider provider;
        if (element == null) {
            DocumentationManager.$$$reportNull$$$0(27);
        }
        if (imageSpec == null) {
            DocumentationManager.$$$reportNull$$$0(28);
        }
        if ((provider = DocumentationManager.getProviderFromElement(element)) instanceof CompositeDocumentationProvider) {
            for (DocumentationProvider p : ((CompositeDocumentationProvider)provider).getAllProviders()) {
                Image image;
                if (!(p instanceof DocumentationProviderEx) || (image = ((DocumentationProviderEx)p).getLocalImageForElement(element, imageSpec)) == null) continue;
                return image;
            }
        }
        return null;
    }

    Editor getEditor() {
        return this.myEditor;
    }

    public ActionCallback getLastAction() {
        return this.myLastAction;
    }

    public void setDocumentationComponent(DocumentationComponent documentationComponent) {
        this.myTestDocumentationComponent = documentationComponent;
    }

    @Nullable
    private static String generateFileDoc(@NotNull PsiFile psiFile, boolean withUrl) {
        VirtualFile file2;
        if (psiFile == null) {
            DocumentationManager.$$$reportNull$$$0(29);
        }
        File ioFile = (file2 = PsiUtilCore.getVirtualFile((PsiElement)psiFile)) == null || !file2.isInLocalFileSystem() ? null : VfsUtilCore.virtualToIoFile((VirtualFile)file2);
        BasicFileAttributes attr = null;
        try {
            attr = ioFile == null ? null : Files.readAttributes(Paths.get(ioFile.toURI()), BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (attr == null) {
            return null;
        }
        FileType type = file2.getFileType();
        String typeName = type == UnknownFileType.INSTANCE ? "Unknown" : (type == PlainTextFileType.INSTANCE ? "Text" : (type == ArchiveFileType.INSTANCE ? "Archive" : type.getName()));
        String languageName = type.isBinary() ? "" : psiFile.getLanguage().getDisplayName();
        return (withUrl ? "<div class='definition'><pre>" + file2.getPresentableUrl() + "</pre></div>" + "<div class='content'>" : "") + "<p><span class='grayed'>Size:</span> " + StringUtil.formatFileSize((long)attr.size()) + "<p><span class='grayed'>Type:</span> " + typeName + (type.isBinary() || typeName.equals(languageName) ? "" : " (" + languageName + ")") + "<p><span class='grayed'>Modified:</span> " + DateFormatUtil.formatDateTime((long)attr.lastModifiedTime().toMillis()) + "<p><span class='grayed'>Created:</span> " + DateFormatUtil.formatDateTime((long)attr.creationTime().toMillis()) + (withUrl ? "</div>" : "");
    }

    private Optional<QuickSearchComponent> findQuickSearchComponent() {
        for (Component c = (Component)SoftReference.dereference(this.myFocusedBeforePopup); c != null; c = c.getParent()) {
            if (!(c instanceof QuickSearchComponent)) continue;
            return Optional.of((QuickSearchComponent)c);
        }
        return Optional.empty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/documentation/DocumentationManager";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 21: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 16: 
            case 18: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imageSpec";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createRestorePopupAction";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/documentation/DocumentationManager";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getProviderFromElement";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "showJavaDocInfoAtToolWindow";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "showJavaDocInfo";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doShowJavaDocInfo";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "showInPopup";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getTitle";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findTargetElement";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "generateDocumentation";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "fetchDocInfo";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "queueFetchDocInfo";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "cancelAndFetchDocInfo";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "updateToolWindowTabName";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "doFetchDocInfo";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "doUpdateComponent";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getElementImage";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "generateFileDoc";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyCollector
    extends DocumentationCollector {
        final Project project;
        final PsiElement originalElement;

        MyCollector(@NotNull Project project, @NotNull PsiElement element, PsiElement originalElement, String ref) {
            if (project == null) {
                MyCollector.$$$reportNull$$$0(0);
            }
            if (element == null) {
                MyCollector.$$$reportNull$$$0(1);
            }
            super(element, null, ref, null);
            this.project = project;
            this.originalElement = originalElement;
        }

        @Override
        @Nullable
        public String getDocumentation() {
            this.provider = (DocumentationProvider)ReadAction.compute(() -> DocumentationManager.getProviderFromElement(this.element, this.originalElement));
            LOG.debug("Using provider ", new Object[]{this.provider});
            if (this.provider instanceof ExternalDocumentationProvider) {
                List urls = (List)ReadAction.compute(() -> {
                    SmartPsiElementPointer originalElementPtr = (SmartPsiElementPointer)this.element.getUserData(ORIGINAL_ELEMENT_KEY);
                    PsiElement originalElement = originalElementPtr != null ? originalElementPtr.getElement() : null;
                    return this.provider.getUrlFor(this.element, originalElement);
                });
                LOG.debug("External documentation URLs: ", new Object[]{urls});
                if (urls != null) {
                    for (String url : urls) {
                        String doc = ((ExternalDocumentationProvider)this.provider).fetchExternalDocumentation(this.project, this.element, Collections.singletonList(url));
                        if (doc == null) continue;
                        LOG.debug("Fetched documentation from ", new Object[]{url});
                        this.effectiveUrl = url;
                        return doc;
                    }
                }
            }
            Ref result2 = new Ref();
            QuickDocUtil.runInReadActionWithWriteActionPriorityWithRetries(() -> {
                String fileDoc;
                if (!this.element.isValid()) {
                    return;
                }
                SmartPsiElementPointer originalPointer = (SmartPsiElementPointer)this.element.getUserData(ORIGINAL_ELEMENT_KEY);
                PsiElement originalPsi = originalPointer != null ? originalPointer.getElement() : null;
                String doc = this.provider.generateDoc(this.element, originalPsi);
                if (this.element instanceof PsiFile && (fileDoc = DocumentationManager.generateFileDoc((PsiFile)this.element, doc == null)) != null) {
                    doc = doc == null ? fileDoc : doc + fileDoc;
                }
                result2.set((Object)doc);
            }, 60000L, 100L, null);
            return (String)result2.get();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/documentation/DocumentationManager$MyCollector";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class DocumentationCollector {
        final PsiElement element;
        final String ref;
        volatile DocumentationProvider provider;
        String effectiveUrl;

        DocumentationCollector(PsiElement element, String effectiveUrl, String ref, DocumentationProvider provider) {
            this.element = element;
            this.ref = ref;
            this.effectiveUrl = effectiveUrl;
            this.provider = provider;
        }

        @Nullable
        abstract String getDocumentation() throws Exception;
    }
}

