/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.HintRenderer$WhenMappings;
import com.intellij.codeInsight.hints.HintWidthAdjustment;
import com.intellij.ide.ui.AntialiasingType;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FocusModeModel;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Segment;
import com.intellij.ui.paint.EffectPainter;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0016\u0018\u0000 12\u00020\u0001:\u000212B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0014\u0010\u0014\u001a\u00020\u000f2\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0016J\u001a\u0010\u0017\u001a\u00020\u000f2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0004J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0004J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u001dH\u0002J,\u0010\"\u001a\u00020#2\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u00162\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u001dH\u0016J \u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020*2\u0006\u0010-\u001a\u00020.H\u0002J\f\u0010/\u001a\u000200*\u00020*H\u0002R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u00063"}, d2={"Lcom/intellij/codeInsight/daemon/impl/HintRenderer;", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "text", "", "(Ljava/lang/String;)V", "getText", "()Ljava/lang/String;", "setText", "widthAdjustment", "Lcom/intellij/codeInsight/hints/HintWidthAdjustment;", "getWidthAdjustment", "()Lcom/intellij/codeInsight/hints/HintWidthAdjustment;", "setWidthAdjustment", "(Lcom/intellij/codeInsight/hints/HintWidthAdjustment;)V", "calcWidthAdjustment", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "fontMetrics", "Ljava/awt/FontMetrics;", "calcWidthInPixels", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "doCalcWidth", "getFont", "Ljava/awt/Font;", "getFontMetrics", "Lcom/intellij/codeInsight/daemon/impl/HintRenderer$MyFontMetrics;", "getTextAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "isInsufficientContrast", "", "attributes", "surroundingAttributes", "paint", "", "g", "Ljava/awt/Graphics;", "r", "Ljava/awt/Rectangle;", "textAttributes", "srcOverBlend", "Ljava/awt/Color;", "foreground", "background", "foregroundAlpha", "", "toGray", "", "Companion", "MyFontMetrics", "intellij.platform.lang.impl"})
public class HintRenderer
implements EditorCustomElementRenderer {
    @Nullable
    private HintWidthAdjustment widthAdjustment;
    @Nullable
    private String text;
    private static final Key<MyFontMetrics> HINT_FONT_METRICS;
    private static final float BACKGROUND_ALPHA = 0.55f;
    public static final Companion Companion;

    @Nullable
    public final HintWidthAdjustment getWidthAdjustment() {
        return this.widthAdjustment;
    }

    public final void setWidthAdjustment(@Nullable HintWidthAdjustment hintWidthAdjustment) {
        this.widthAdjustment = hintWidthAdjustment;
    }

    public int calcWidthInPixels(@NotNull Inlay<?> inlay) {
        Intrinsics.checkParameterIsNotNull(inlay, (String)"inlay");
        Editor editor = inlay.getEditor();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"inlay.editor");
        Editor editor2 = editor;
        FontMetrics fontMetrics = this.getFontMetrics(editor2).getMetrics();
        return this.doCalcWidth(this.text, fontMetrics) + this.calcWidthAdjustment(editor2, fontMetrics);
    }

    @Nullable
    protected TextAttributes getTextAttributes(@NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        return editor.getColorsScheme().getAttributes(DefaultLanguageHighlighterColors.INLINE_PARAMETER_HINT);
    }

    public void paint(@NotNull Inlay<?> inlay, @NotNull Graphics g, @NotNull Rectangle r, @NotNull TextAttributes textAttributes) {
        TextAttributes attributes;
        TextAttributes textAttributes2;
        Intrinsics.checkParameterIsNotNull(inlay, (String)"inlay");
        Intrinsics.checkParameterIsNotNull((Object)g, (String)"g");
        Intrinsics.checkParameterIsNotNull((Object)r, (String)"r");
        Intrinsics.checkParameterIsNotNull((Object)textAttributes, (String)"textAttributes");
        Editor editor = inlay.getEditor();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"inlay.editor");
        Editor editor2 = editor;
        if (!(editor2 instanceof EditorImpl)) {
            return;
        }
        int ascent = ((EditorImpl)editor2).getAscent();
        int descent = ((EditorImpl)editor2).getDescent();
        Graphics2D g2d = (Graphics2D)g;
        Segment focusModeRange = ((EditorImpl)editor2).getFocusModeRange();
        if (focusModeRange != null && (inlay.getOffset() <= focusModeRange.getStartOffset() || focusModeRange.getEndOffset() <= inlay.getOffset())) {
            textAttributes2 = (TextAttributes)editor2.getUserData(FocusModeModel.FOCUS_MODE_ATTRIBUTES);
            if (textAttributes2 == null) {
                textAttributes2 = this.getTextAttributes(editor2);
            }
        } else {
            textAttributes2 = attributes = this.getTextAttributes(editor2);
        }
        if (this.text != null && attributes != null) {
            Color foregroundColor;
            MyFontMetrics fontMetrics = this.getFontMetrics(editor2);
            int gap = r.height < fontMetrics.getLineHeight() + 2 ? 1 : 2;
            Color backgroundColor = attributes.getBackgroundColor();
            if (backgroundColor != null) {
                float alpha = this.isInsufficientContrast(attributes, textAttributes) ? 1.0f : 0.55f;
                GraphicsConfig config2 = GraphicsUtil.setupAAPainting((Graphics)g);
                GraphicsUtil.paintWithAlpha((Graphics)g, (float)alpha);
                g.setColor(backgroundColor);
                g.fillRoundRect(r.x + 2, r.y + gap, r.width - 4, r.height - gap * 2, 8, 8);
                config2.restore();
            }
            if ((foregroundColor = attributes.getForegroundColor()) != null) {
                Object savedHint = g2d.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                Shape savedClip = g.getClip();
                g.setColor(foregroundColor);
                g.setFont(this.getFont(editor2));
                g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AntialiasingType.getKeyForCurrentScope((boolean)false));
                g.clipRect(r.x + 3, r.y + 2, r.width - 6, r.height - 4);
                FontMetrics metrics = fontMetrics.getMetrics();
                int startX = r.x + 7;
                int startY = r.y + Math.max(ascent, (r.height + metrics.getAscent() - metrics.getDescent()) / 2) - 1;
                FontMetrics fontMetrics2 = ((Graphics2D)g).getFontMetrics();
                Intrinsics.checkExpressionValueIsNotNull((Object)fontMetrics2, (String)"g.fontMetrics");
                int widthAdjustment = this.calcWidthAdjustment(editor2, fontMetrics2);
                if (widthAdjustment == 0) {
                    g.drawString(this.text, startX, startY);
                } else {
                    String string;
                    HintWidthAdjustment hintWidthAdjustment = this.widthAdjustment;
                    if (hintWidthAdjustment == null) {
                        Intrinsics.throwNpe();
                    }
                    int adjustmentPosition = hintWidthAdjustment.getAdjustmentPosition();
                    String string2 = this.text;
                    if (string2 == null) {
                        Intrinsics.throwNpe();
                    }
                    String string3 = string2;
                    int n = 0;
                    String string4 = string3;
                    if (string4 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string5 = string4.substring(n, adjustmentPosition);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    String firstPart = string5;
                    String string6 = this.text;
                    if (string6 == null) {
                        Intrinsics.throwNpe();
                    }
                    String string7 = string = string6;
                    if (string7 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string8 = string7.substring(adjustmentPosition);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"(this as java.lang.String).substring(startIndex)");
                    String secondPart = string8;
                    g.drawString(firstPart, startX, startY);
                    g.drawString(secondPart, startX + g.getFontMetrics().stringWidth(firstPart) + widthAdjustment, startY);
                }
                g.setClip(savedClip);
                g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, savedHint);
            }
        }
        Color effectColor = textAttributes.getEffectColor();
        EffectType effectType = textAttributes.getEffectType();
        if (effectColor != null) {
            g.setColor(effectColor);
            int xStart = r.x;
            int xEnd = r.x + r.width;
            int y = r.y + ascent;
            Font font = editor2.getColorsScheme().getFont(EditorFontType.PLAIN);
            Intrinsics.checkExpressionValueIsNotNull((Object)font, (String)"editor.getColorsScheme()\u2026ont(EditorFontType.PLAIN)");
            Font font2 = font;
            EffectType effectType2 = effectType;
            if (effectType2 != null) {
                switch (HintRenderer$WhenMappings.$EnumSwitchMapping$0[effectType2.ordinal()]) {
                    case 1: {
                        EffectPainter.LINE_UNDERSCORE.paint(g2d, xStart, y, xEnd - xStart, descent, (Object)font2);
                        break;
                    }
                    case 2: {
                        EffectPainter.BOLD_LINE_UNDERSCORE.paint(g2d, xStart, y, xEnd - xStart, descent, (Object)font2);
                        break;
                    }
                    case 3: {
                        EffectPainter.STRIKE_THROUGH.paint(g2d, xStart, y, xEnd - xStart, ((EditorImpl)editor2).getCharHeight(), (Object)font2);
                        break;
                    }
                    case 4: {
                        EffectPainter.WAVE_UNDERSCORE.paint(g2d, xStart, y, xEnd - xStart, descent, (Object)font2);
                        break;
                    }
                    case 5: {
                        EffectPainter.BOLD_DOTTED_UNDERSCORE.paint(g2d, xStart, y, xEnd - xStart, descent, (Object)font2);
                        break;
                    }
                }
            }
        }
    }

    private final boolean isInsufficientContrast(TextAttributes attributes, TextAttributes surroundingAttributes) {
        Color backgroundUnderHint = surroundingAttributes.getBackgroundColor();
        if (backgroundUnderHint != null && attributes.getForegroundColor() != null) {
            Color color = attributes.getBackgroundColor();
            Intrinsics.checkExpressionValueIsNotNull((Object)color, (String)"attributes.backgroundColor");
            Color backgroundBlended = this.srcOverBlend(color, backgroundUnderHint, 0.55f);
            double backgroundBlendedGrayed = this.toGray(backgroundBlended);
            Color color2 = attributes.getForegroundColor();
            Intrinsics.checkExpressionValueIsNotNull((Object)color2, (String)"attributes.foregroundColor");
            double textGrayed = this.toGray(color2);
            double delta = Math.abs(backgroundBlendedGrayed - textGrayed);
            return delta < (double)10;
        }
        return false;
    }

    private final double toGray(@NotNull Color $receiver) {
        return 0.3 * (double)$receiver.getRed() + 0.59 * (double)$receiver.getGreen() + 0.11 * (double)$receiver.getBlue();
    }

    private final Color srcOverBlend(Color foreground, Color background, float foregroundAlpha) {
        float r = (float)foreground.getRed() * foregroundAlpha + (float)background.getRed() * (1.0f - foregroundAlpha);
        float g = (float)foreground.getGreen() * foregroundAlpha + (float)background.getGreen() * (1.0f - foregroundAlpha);
        float b = (float)foreground.getBlue() * foregroundAlpha + (float)background.getBlue() * (1.0f - foregroundAlpha);
        return new Color(MathKt.roundToInt((float)r), MathKt.roundToInt((float)g), MathKt.roundToInt((float)b));
    }

    private final int calcWidthAdjustment(Editor editor, FontMetrics fontMetrics) {
        if (this.widthAdjustment == null || !(editor instanceof EditorImpl)) {
            return 0;
        }
        FontMetrics fontMetrics2 = ((EditorImpl)editor).getFontMetrics(0);
        HintWidthAdjustment hintWidthAdjustment = this.widthAdjustment;
        if (hintWidthAdjustment == null) {
            Intrinsics.throwNpe();
        }
        int editorTextWidth = fontMetrics2.stringWidth(hintWidthAdjustment.getEditorTextToMatch());
        HintWidthAdjustment hintWidthAdjustment2 = this.widthAdjustment;
        if (hintWidthAdjustment2 == null) {
            Intrinsics.throwNpe();
        }
        return Math.max(0, editorTextWidth + this.doCalcWidth(hintWidthAdjustment2.getHintTextToMatch(), fontMetrics) - this.doCalcWidth(this.text, fontMetrics));
    }

    @NotNull
    protected final MyFontMetrics getFontMetrics(@NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Font font = UIManager.getFont("Label.font");
        Intrinsics.checkExpressionValueIsNotNull((Object)font, (String)"UIManager.getFont(\"Label.font\")");
        String familyName = font.getFamily();
        EditorColorsScheme editorColorsScheme = editor.getColorsScheme();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorColorsScheme, (String)"editor.colorsScheme");
        int size = Math.max(1, editorColorsScheme.getEditorFontSize() - 1);
        MyFontMetrics metrics = (MyFontMetrics)editor.getUserData(HINT_FONT_METRICS);
        if (metrics != null) {
            String string = familyName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"familyName");
            if (!metrics.isActual(editor, string, size)) {
                metrics = null;
            }
        }
        if (metrics == null) {
            String string = familyName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"familyName");
            metrics = new MyFontMetrics(editor, string, size);
            editor.putUserData(HINT_FONT_METRICS, (Object)metrics);
        }
        return metrics;
    }

    private final Font getFont(Editor editor) {
        return this.getFontMetrics(editor).getFont();
    }

    protected final int doCalcWidth(@Nullable String text, @NotNull FontMetrics fontMetrics) {
        Intrinsics.checkParameterIsNotNull((Object)fontMetrics, (String)"fontMetrics");
        return text == null ? 0 : fontMetrics.stringWidth(text) + 14;
    }

    @Nullable
    public final String getText() {
        return this.text;
    }

    public final void setText(@Nullable String string) {
        this.text = string;
    }

    public HintRenderer(@Nullable String text) {
        this.text = text;
    }

    static {
        Companion = new Companion(null);
        Key key = Key.create((String)"ParameterHintFontMetrics");
        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"Key.create<MyFontMetrics\u2026arameterHintFontMetrics\")");
        HINT_FONT_METRICS = key;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0018"}, d2={"Lcom/intellij/codeInsight/daemon/impl/HintRenderer$MyFontMetrics;", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "familyName", "", "size", "", "(Lcom/intellij/openapi/editor/Editor;Ljava/lang/String;I)V", "font", "Ljava/awt/Font;", "getFont", "()Ljava/awt/Font;", "lineHeight", "getLineHeight", "()I", "metrics", "Ljava/awt/FontMetrics;", "getMetrics", "()Ljava/awt/FontMetrics;", "getCurrentContext", "Ljava/awt/font/FontRenderContext;", "isActual", "", "intellij.platform.lang.impl"})
    protected static final class MyFontMetrics {
        @NotNull
        private final FontMetrics metrics;
        private final int lineHeight;

        @NotNull
        public final FontMetrics getMetrics() {
            return this.metrics;
        }

        public final int getLineHeight() {
            return this.lineHeight;
        }

        @NotNull
        public final Font getFont() {
            Font font = this.metrics.getFont();
            Intrinsics.checkExpressionValueIsNotNull((Object)font, (String)"metrics.font");
            return font;
        }

        public final boolean isActual(@NotNull Editor editor, @NotNull String familyName, int size) {
            Font font;
            Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
            Intrinsics.checkParameterIsNotNull((Object)familyName, (String)"familyName");
            Font font2 = font = this.metrics.getFont();
            Intrinsics.checkExpressionValueIsNotNull((Object)font2, (String)"font");
            if (Intrinsics.areEqual((Object)familyName, (Object)font2.getFamily()) ^ true || size != font.getSize()) {
                return false;
            }
            FontRenderContext currentContext = this.getCurrentContext(editor);
            return currentContext.equals(this.metrics.getFontRenderContext());
        }

        private final FontRenderContext getCurrentContext(Editor editor) {
            FontRenderContext editorContext;
            FontRenderContext fontRenderContext = editorContext = FontInfo.getFontRenderContext(editor.getContentComponent());
            Intrinsics.checkExpressionValueIsNotNull((Object)fontRenderContext, (String)"editorContext");
            return new FontRenderContext(fontRenderContext.getTransform(), AntialiasingType.getKeyForCurrentScope((boolean)false), editor instanceof EditorImpl ? ((EditorImpl)editor).myFractionalMetricsHintValue : RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        }

        public MyFontMetrics(@NotNull Editor editor, @NotNull String familyName, int size) {
            Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
            Intrinsics.checkParameterIsNotNull((Object)familyName, (String)"familyName");
            FontUIResource fontUIResource = UIUtil.getFontWithFallback((String)familyName, (int)0, (int)size);
            Intrinsics.checkExpressionValueIsNotNull((Object)fontUIResource, (String)"UIUtil.getFontWithFallba\u2026lyName, Font.PLAIN, size)");
            FontUIResource font = fontUIResource;
            FontRenderContext context = this.getCurrentContext(editor);
            FontMetrics fontMetrics = FontInfo.getFontMetrics(font, context);
            Intrinsics.checkExpressionValueIsNotNull((Object)fontMetrics, (String)"FontInfo.getFontMetrics(font, context)");
            this.metrics = fontMetrics;
            GlyphVector glyphVector = font.createGlyphVector(context, "Ap");
            Intrinsics.checkExpressionValueIsNotNull((Object)glyphVector, (String)"font.createGlyphVector(context, \"Ap\")");
            Rectangle2D rectangle2D = glyphVector.getVisualBounds();
            Intrinsics.checkExpressionValueIsNotNull((Object)rectangle2D, (String)"font.createGlyphVector(context, \"Ap\").visualBounds");
            this.lineHeight = (int)Math.ceil(rectangle2D.getHeight());
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/codeInsight/daemon/impl/HintRenderer$Companion;", "", "()V", "BACKGROUND_ALPHA", "", "HINT_FONT_METRICS", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/codeInsight/daemon/impl/HintRenderer$MyFontMetrics;", "kotlin.jvm.PlatformType", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

