/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.CompletionWeigher;
import com.intellij.codeInsight.completion.StatisticsComparable;
import com.intellij.codeInsight.lookup.Classifier;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.statistics.StatisticsInfo;
import com.intellij.psi.statistics.StatisticsManager;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StatisticsWeigher
extends CompletionWeigher {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.completion.StatisticsWeigher.LookupStatisticsWeigher");
    private static final Key<StatisticsInfo> BASE_STATISTICS_INFO = Key.create((String)"Base statistics info");

    public Comparable weigh(@NotNull LookupElement item, @NotNull CompletionLocation location) {
        if (item == null) {
            StatisticsWeigher.$$$reportNull$$$0(0);
        }
        if (location == null) {
            StatisticsWeigher.$$$reportNull$$$0(1);
        }
        throw new UnsupportedOperationException();
    }

    public static void clearBaseStatisticsInfo(LookupElement item) {
        item.putUserData(BASE_STATISTICS_INFO, null);
    }

    @NotNull
    public static StatisticsInfo getBaseStatisticsInfo(LookupElement item, @Nullable CompletionLocation location) {
        StatisticsInfo info = (StatisticsInfo)BASE_STATISTICS_INFO.get((UserDataHolder)item);
        if (info == null) {
            if (location == null) {
                StatisticsInfo statisticsInfo = StatisticsInfo.EMPTY;
                if (statisticsInfo == null) {
                    StatisticsWeigher.$$$reportNull$$$0(2);
                }
                return statisticsInfo;
            }
            info = StatisticsWeigher.calcBaseInfo(item, location);
            BASE_STATISTICS_INFO.set((UserDataHolder)item, (Object)info);
        }
        StatisticsInfo statisticsInfo = info;
        if (statisticsInfo == null) {
            StatisticsWeigher.$$$reportNull$$$0(3);
        }
        return statisticsInfo;
    }

    @NotNull
    private static StatisticsInfo calcBaseInfo(LookupElement item, @NotNull CompletionLocation location) {
        StatisticsInfo info;
        if (location == null) {
            StatisticsWeigher.$$$reportNull$$$0(4);
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.assertTrue(!ApplicationManager.getApplication().isDispatchThread());
        }
        StatisticsInfo statisticsInfo = (info = StatisticsManager.serialize((Key)CompletionService.STATISTICS_KEY, (Object)item, (Object)location)) == null ? StatisticsInfo.EMPTY : info;
        if (statisticsInfo == null) {
            StatisticsWeigher.$$$reportNull$$$0(5);
        }
        return statisticsInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/StatisticsWeigher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/StatisticsWeigher";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseStatisticsInfo";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "calcBaseInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "weigh";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "calcBaseInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class LookupStatisticsWeigher
    extends Classifier<LookupElement> {
        private final CompletionLocation myLocation;
        private final Map<LookupElement, StatisticsComparable> myWeights = ContainerUtil.newIdentityHashMap();
        private final Set<String> myStringsWithWeights = ContainerUtil.newTroveSet();
        private final Set<LookupElement> myNoStats = ContainerUtil.newIdentityTroveSet();

        public LookupStatisticsWeigher(CompletionLocation location, Classifier<LookupElement> next) {
            super(next, "stats");
            this.myLocation = location;
        }

        @Override
        public void addElement(@NotNull LookupElement element, @NotNull ProcessingContext context) {
            StatisticsInfo baseInfo;
            int weight2;
            if (element == null) {
                LookupStatisticsWeigher.$$$reportNull$$$0(0);
            }
            if (context == null) {
                LookupStatisticsWeigher.$$$reportNull$$$0(1);
            }
            if ((weight2 = LookupStatisticsWeigher.weigh(baseInfo = StatisticsWeigher.getBaseStatisticsInfo(element, this.myLocation))) != 0) {
                this.myWeights.put(element, new StatisticsComparable(weight2, baseInfo));
                this.myStringsWithWeights.add(element.getLookupString());
            }
            if (baseInfo == StatisticsInfo.EMPTY) {
                this.myNoStats.add(element);
            }
            super.addElement(element, context);
        }

        @Override
        @NotNull
        public Iterable<LookupElement> classify(@NotNull Iterable<LookupElement> source, @NotNull ProcessingContext context) {
            if (source == null) {
                LookupStatisticsWeigher.$$$reportNull$$$0(2);
            }
            if (context == null) {
                LookupStatisticsWeigher.$$$reportNull$$$0(3);
            }
            List<LookupElement> initialList = this.getInitialNoStatElements(source, context);
            Iterable<LookupElement> rest = LookupStatisticsWeigher.withoutInitial(source, initialList);
            Collection byWeight = this.buildMapByWeight(rest).descendingMap().values();
            JBIterable jBIterable = JBIterable.from(initialList).append((Iterable)JBIterable.from(byWeight).flatten(group -> this.myNext.classify(group, context)));
            if (jBIterable == null) {
                LookupStatisticsWeigher.$$$reportNull$$$0(4);
            }
            return jBIterable;
        }

        private static Iterable<LookupElement> withoutInitial(Iterable<LookupElement> allItems, List<LookupElement> initial) {
            THashSet initialSet = ContainerUtil.newIdentityTroveSet(initial);
            return JBIterable.from(allItems).filter(arg_0 -> LookupStatisticsWeigher.lambda$withoutInitial$1((Set)initialSet, arg_0));
        }

        private List<LookupElement> getInitialNoStatElements(Iterable<LookupElement> source, ProcessingContext context) {
            ArrayList<LookupElement> initialList = new ArrayList<LookupElement>();
            for (LookupElement next : this.myNext.classify(source, context)) {
                if (!this.myNoStats.contains(next)) break;
                initialList.add(next);
            }
            return initialList;
        }

        private TreeMap<Integer, List<LookupElement>> buildMapByWeight(Iterable<LookupElement> source) {
            MultiMap byName = MultiMap.create();
            ArrayList<LookupElement> noStats = new ArrayList<LookupElement>();
            for (LookupElement element : source) {
                String string = element.getLookupString();
                if (this.myStringsWithWeights.contains(string)) {
                    byName.putValue((Object)string, (Object)element);
                    continue;
                }
                noStats.add(element);
            }
            TreeMap<Integer, List<LookupElement>> map2 = new TreeMap<Integer, List<LookupElement>>();
            map2.put(0, noStats);
            for (String s : byName.keySet()) {
                List group = (List)byName.get((Object)s);
                Collections.sort(group, Comparator.comparing(this::getScalarWeight).reversed());
                map2.computeIfAbsent(this.getMaxWeight(group), __ -> new ArrayList()).addAll(group);
            }
            return map2;
        }

        private int getMaxWeight(List<LookupElement> group) {
            int max = 0;
            for (int i = 0; i < group.size(); ++i) {
                max = Math.max(max, this.getScalarWeight(group.get(i)));
            }
            return max;
        }

        private int getScalarWeight(LookupElement e) {
            StatisticsComparable comparable = this.myWeights.get(e);
            return comparable == null ? 0 : comparable.getScalar();
        }

        private StatisticsComparable getWeight(LookupElement t) {
            StatisticsComparable w = this.myWeights.get(t);
            if (w == null) {
                StatisticsInfo info = StatisticsWeigher.getBaseStatisticsInfo(t, this.myLocation);
                w = new StatisticsComparable(LookupStatisticsWeigher.weigh(info), info);
                this.myWeights.put(t, w);
            }
            return w;
        }

        private static int weigh(StatisticsInfo baseInfo) {
            if (baseInfo == StatisticsInfo.EMPTY) {
                return 0;
            }
            int minRecency = baseInfo.getLastUseRecency();
            return minRecency == Integer.MAX_VALUE ? 0 : 10000 - minRecency;
        }

        @Override
        @NotNull
        public List<Pair<LookupElement, Object>> getSortingWeights(@NotNull Iterable<LookupElement> items, @NotNull ProcessingContext context) {
            if (items == null) {
                LookupStatisticsWeigher.$$$reportNull$$$0(5);
            }
            if (context == null) {
                LookupStatisticsWeigher.$$$reportNull$$$0(6);
            }
            List list2 = ContainerUtil.map(items, lookupElement -> new Pair(lookupElement, (Object)this.getWeight((LookupElement)lookupElement)));
            if (list2 == null) {
                LookupStatisticsWeigher.$$$reportNull$$$0(7);
            }
            return list2;
        }

        @Override
        public void removeElement(@NotNull LookupElement element, @NotNull ProcessingContext context) {
            if (element == null) {
                LookupStatisticsWeigher.$$$reportNull$$$0(8);
            }
            if (context == null) {
                LookupStatisticsWeigher.$$$reportNull$$$0(9);
            }
            this.myWeights.remove(element);
            this.myNoStats.remove(element);
            super.removeElement(element, context);
        }

        private static /* synthetic */ boolean lambda$withoutInitial$1(Set initialSet, LookupElement element) {
            return !initialSet.contains(element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 3: 
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/completion/StatisticsWeigher$LookupStatisticsWeigher";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "items";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/completion/StatisticsWeigher$LookupStatisticsWeigher";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "classify";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSortingWeights";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addElement";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "classify";
                    break;
                }
                case 4: 
                case 7: {
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getSortingWeights";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "removeElement";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

