/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.navigation.ChooseByNameContributor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileNameMatcherEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileInfoManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelperRegistrar;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceOwner;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileSystemItemUtil;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilePathCompletionContributor
extends CompletionContributor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.completion.FilePathCompletionContributor");

    public FilePathCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement(), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
                PsiReference psiReference;
                if (parameters == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (result2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (FilePathCompletionContributor.getReference(psiReference = parameters.getPosition().getContainingFile().findReferenceAt(parameters.getOffset())) != null && parameters.getInvocationCount() == 1) {
                    String shortcut = CompletionContributor.getActionShortcut((String)"CodeCompletion");
                    result2.addLookupAdvertisement(CodeInsightBundle.message((String)"class.completion.file.path", (Object[])new Object[]{shortcut}));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInsight/completion/FilePathCompletionContributor$1";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        CompletionProvider<CompletionParameters> provider = new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet _result) {
                if (parameters == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (_result == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (!parameters.isExtendedCompletion()) {
                    return;
                }
                CompletionResultSet result2 = _result.caseInsensitive();
                PsiElement e = parameters.getPosition();
                Project project = e.getProject();
                PsiReference psiReference = parameters.getPosition().getContainingFile().findReferenceAt(parameters.getOffset());
                Pair fileReferencePair = FilePathCompletionContributor.getReference(psiReference);
                if (fileReferencePair != null) {
                    FileReference first = (FileReference)fileReferencePair.getFirst();
                    if (first == null) {
                        return;
                    }
                    FileReferenceSet set2 = first.getFileReferenceSet();
                    int end = parameters.getOffset() - set2.getElement().getTextRange().getStartOffset() - set2.getStartInElement();
                    String pathString = set2.getPathString();
                    if (pathString.length() < end) {
                        return;
                    }
                    PsiFile originalFile = parameters.getOriginalFile();
                    VirtualFile contextFile = originalFile.getVirtualFile();
                    String relativePrefix = FilePathCompletionContributor.getRelativePathPrefix(pathString);
                    VirtualFile parent = null;
                    if (relativePrefix != null && relativePrefix.length() <= end && (parent = VfsUtilCore.findRelativeFile((String)relativePrefix, (VirtualFile)contextFile.getParent())) != null) {
                        pathString = pathString.substring(relativePrefix.length());
                        end -= relativePrefix.length();
                    }
                    String prefix = pathString.substring(0, end);
                    List pathPrefixParts = null;
                    int lastSlashIndex = prefix.lastIndexOf(47);
                    if (lastSlashIndex != -1) {
                        pathPrefixParts = StringUtil.split((String)prefix.substring(0, lastSlashIndex), (String)"/");
                        prefix = prefix.substring(lastSlashIndex + 1);
                    }
                    CompletionResultSet __result = result2.withPrefixMatcher(prefix).caseInsensitive();
                    if (contextFile != null) {
                        String[] fileNames = FilePathCompletionContributor.getAllNames(project);
                        TreeSet<String> resultNames = new TreeSet<String>();
                        for (String fileName2 : fileNames) {
                            if (!FilePathCompletionContributor.filenameMatchesPrefixOrType(fileName2, prefix, set2.getSuitableFileTypes(), parameters.getInvocationCount())) continue;
                            resultNames.add(fileName2);
                        }
                        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
                        Module contextModule = index.getModuleForFile(contextFile);
                        if (contextModule != null) {
                            List<FileReferenceHelper> helpers = FileReferenceHelperRegistrar.getHelpers(originalFile);
                            GlobalSearchScope scope = ProjectScope.getProjectScope((Project)project);
                            for (String name : resultNames) {
                                ProgressManager.checkCanceled();
                                PsiFile[] files2 = FilenameIndex.getFilesByName(project, name, scope);
                                if (files2.length <= 0) continue;
                                for (PsiFile file2 : files2) {
                                    ProgressManager.checkCanceled();
                                    VirtualFile virtualFile = file2.getVirtualFile();
                                    if (virtualFile == null || !virtualFile.isValid() || Comparing.equal((Object)virtualFile, (Object)contextFile) || parent != null && !VfsUtilCore.isAncestor((VirtualFile)parent, (VirtualFile)virtualFile, (boolean)true)) continue;
                                    ArrayList<FileReferenceHelper> helperList = new ArrayList<FileReferenceHelper>();
                                    for (FileReferenceHelper contextHelper : helpers) {
                                        ProgressManager.checkCanceled();
                                        if (!contextHelper.isMine(project, virtualFile) || pathPrefixParts != null && !FilePathCompletionContributor.fileMatchesPathPrefix(contextHelper.getPsiFileSystemItem(project, virtualFile), parent, pathPrefixParts)) continue;
                                        helperList.add(contextHelper);
                                    }
                                    if (helperList.isEmpty()) continue;
                                    __result.addElement((LookupElement)new FilePathLookupItem(file2, helperList));
                                }
                            }
                        }
                    }
                    if (set2.getSuitableFileTypes().length > 0 && parameters.getInvocationCount() == 1) {
                        String shortcut = CompletionContributor.getActionShortcut((String)"CodeCompletion");
                        result2.addLookupAdvertisement(CodeInsightBundle.message((String)"class.completion.file.path.all.variants", (Object[])new Object[]{shortcut}));
                    }
                    if (((Boolean)fileReferencePair.getSecond()).booleanValue()) {
                        result2.stopHere();
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "_result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInsight/completion/FilePathCompletionContributor$2";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement(), (CompletionProvider)provider);
    }

    private static boolean filenameMatchesPrefixOrType(String fileName2, String prefix, FileType[] suitableFileTypes, int invocationCount) {
        boolean prefixMatched;
        boolean bl = prefixMatched = prefix.length() == 0 || StringUtil.startsWithIgnoreCase((String)fileName2, (String)prefix);
        if (prefixMatched && (suitableFileTypes.length == 0 || invocationCount > 2)) {
            return true;
        }
        if (prefixMatched) {
            String extension = FileUtilRt.getExtension((String)fileName2);
            if (extension.length() == 0) {
                return false;
            }
            for (FileType fileType : suitableFileTypes) {
                for (FileNameMatcher matcher : FileTypeManager.getInstance().getAssociations(fileType)) {
                    if (!FileNameMatcherEx.acceptsCharSequence((FileNameMatcher)matcher, (CharSequence)fileName2)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static String getRelativePathPrefix(@NotNull String path) {
        if (path == null) {
            FilePathCompletionContributor.$$$reportNull$$$0(0);
        }
        if (!path.startsWith("./") && !path.startsWith("../")) {
            return null;
        }
        int index = 0;
        char currentChar = path.charAt(index);
        while ((currentChar == '.' || currentChar == '/') && ++index < path.length()) {
            currentChar = path.charAt(index);
        }
        return path.substring(0, index);
    }

    private static boolean fileMatchesPathPrefix(@Nullable PsiFileSystemItem file2, @Nullable VirtualFile stopParent, @NotNull List<String> pathPrefix) {
        PsiFileSystemItem parent;
        if (pathPrefix == null) {
            FilePathCompletionContributor.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            return false;
        }
        ArrayList<String> contextParts = new ArrayList<String>();
        PsiFileSystemItem parentFile = file2;
        while (!((parent = parentFile.getParent()) == null || stopParent != null && Objects.equals(parent.getVirtualFile(), stopParent))) {
            if (parent.getName().length() > 0) {
                contextParts.add(0, parent.getName().toLowerCase());
            }
            parentFile = parent;
        }
        String path = StringUtil.join(contextParts, (String)"/");
        int nextIndex = 0;
        for (String s : pathPrefix) {
            nextIndex = path.indexOf(s.toLowerCase(), nextIndex);
            if (nextIndex != -1) continue;
            return false;
        }
        return true;
    }

    private static String[] getAllNames(@NotNull Project project) {
        ChooseByNameContributor[] nameContributors;
        if (project == null) {
            FilePathCompletionContributor.$$$reportNull$$$0(2);
        }
        HashSet names = new HashSet();
        for (ChooseByNameContributor contributor : nameContributors = (ChooseByNameContributor[])ChooseByNameContributor.FILE_EP_NAME.getExtensions()) {
            try {
                ContainerUtil.addAll(names, (Object[])contributor.getNames(project, false));
            }
            catch (ProcessCanceledException processCanceledException) {
            }
            catch (Exception ex) {
                LOG.error((Throwable)ex);
            }
        }
        return ArrayUtil.toStringArray(names);
    }

    @Nullable
    private static Pair<FileReference, Boolean> getReference(PsiReference original) {
        PsiFileReference fileReference;
        if (original == null) {
            return null;
        }
        if (original instanceof PsiMultiReference) {
            PsiMultiReference multiReference = (PsiMultiReference)original;
            for (PsiReference reference : multiReference.getReferences()) {
                if (!(reference instanceof FileReference) || !((FileReference)reference).getFileReferenceSet().supportsExtendedCompletion()) continue;
                return Pair.create((Object)((FileReference)reference), (Object)false);
            }
        } else if (original instanceof FileReferenceOwner && (fileReference = ((FileReferenceOwner)original).getLastFileReference()) instanceof FileReference && ((FileReference)fileReference).getFileReferenceSet().supportsExtendedCompletion()) {
            return Pair.create((Object)((FileReference)fileReference), (Object)true);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathPrefix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/completion/FilePathCompletionContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getRelativePathPrefix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "fileMatchesPathPrefix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getAllNames";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class FilePathLookupItem
    extends LookupElement {
        private final String myName;
        private final String myPath;
        private final String myInfo;
        private final Icon myIcon;
        private final PsiFile myFile;
        private final List<? extends FileReferenceHelper> myHelpers;

        public FilePathLookupItem(@NotNull PsiFile file2, @NotNull List<? extends FileReferenceHelper> helpers) {
            if (file2 == null) {
                FilePathLookupItem.$$$reportNull$$$0(0);
            }
            if (helpers == null) {
                FilePathLookupItem.$$$reportNull$$$0(1);
            }
            this.myName = file2.getName();
            this.myPath = file2.getVirtualFile().getPath();
            this.myHelpers = helpers;
            this.myInfo = FileInfoManager.getFileAdditionalInfo((PsiElement)file2);
            this.myIcon = file2.getIcon(0);
            this.myFile = file2;
        }

        public String toString() {
            return String.format("%s%s", this.myName, this.myInfo == null ? "" : " (" + this.myInfo + ")");
        }

        @NotNull
        public Object getObject() {
            PsiFile psiFile = this.myFile;
            if (psiFile == null) {
                FilePathLookupItem.$$$reportNull$$$0(2);
            }
            return psiFile;
        }

        @NotNull
        public String getLookupString() {
            String string = this.myName;
            if (string == null) {
                FilePathLookupItem.$$$reportNull$$$0(3);
            }
            return string;
        }

        public void handleInsert(@NotNull InsertionContext context) {
            PsiReference psiReference;
            Pair fileReferencePair;
            if (context == null) {
                FilePathLookupItem.$$$reportNull$$$0(4);
            }
            context.commitDocument();
            if (this.myFile.isValid() && (fileReferencePair = FilePathCompletionContributor.getReference(psiReference = context.getFile().findReferenceAt(context.getStartOffset()))) != null) {
                FileReference ref = (FileReference)fileReferencePair.getFirst();
                context.setTailOffset(ref.getRangeInElement().getEndOffset() + ref.getElement().getTextRange().getStartOffset());
                ref.bindToElement((PsiElement)this.myFile);
            }
        }

        public void renderElement(LookupElementPresentation presentation) {
            String relativePath = this.getRelativePath();
            StringBuilder sb = new StringBuilder();
            if (this.myInfo != null) {
                sb.append(" (").append(this.myInfo);
            }
            if (relativePath != null && !relativePath.equals(this.myName)) {
                if (this.myInfo != null) {
                    sb.append(", ");
                } else {
                    sb.append(" (");
                }
                sb.append(relativePath);
            }
            if (sb.length() > 0) {
                sb.append(')');
            }
            presentation.setItemText(this.myName);
            if (sb.length() > 0) {
                presentation.setTailText(sb.toString(), true);
            }
            presentation.setIcon(this.myIcon);
        }

        @Nullable
        private String getRelativePath() {
            VirtualFile virtualFile = this.myFile.getVirtualFile();
            LOG.assertTrue(virtualFile != null);
            for (FileReferenceHelper fileReferenceHelper : this.myHelpers) {
                PsiFileSystemItem root = fileReferenceHelper.findRoot(this.myFile.getProject(), virtualFile);
                String path = PsiFileSystemItemUtil.findRelativePath(root, fileReferenceHelper.getPsiFileSystemItem(this.myFile.getProject(), virtualFile));
                if (path == null) continue;
                return path;
            }
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            FilePathLookupItem that = (FilePathLookupItem)((Object)o);
            if (!this.myName.equals(that.myName)) {
                return false;
            }
            return this.myPath.equals(that.myPath);
        }

        public int hashCode() {
            int result2 = this.myName.hashCode();
            result2 = 31 * result2 + this.myPath.hashCode();
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helpers";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/completion/FilePathCompletionContributor$FilePathLookupItem";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/completion/FilePathCompletionContributor$FilePathLookupItem";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getObject";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLookupString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "handleInsert";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

