/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeInsightUtilBase
extends CodeInsightUtilCore {
    private CodeInsightUtilBase() {
    }

    public boolean prepareFileForWrite(@Nullable PsiFile psiFile) {
        if (psiFile == null) {
            return false;
        }
        VirtualFile file2 = psiFile.getVirtualFile();
        Project project = psiFile.getProject();
        if (ReadonlyStatusHandler.ensureFilesWritable((Project)project, (VirtualFile[])new VirtualFile[]{file2})) {
            return true;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, file2), true);
            if (editor != null && editor.getComponent().isDisplayable()) {
                HintManager.getInstance().showErrorHint(editor, CodeInsightBundle.message((String)"error.hint.file.is.readonly", (Object[])new Object[]{file2.getPresentableUrl()}));
            }
        }, project.getDisposed());
        return false;
    }

    public boolean preparePsiElementForWrite(@Nullable PsiElement element) {
        PsiFile file2 = element == null ? null : element.getContainingFile();
        return this.prepareFileForWrite(file2);
    }

    public boolean preparePsiElementsForWrite(PsiElement ... elements) {
        if (elements == null) {
            CodeInsightUtilBase.$$$reportNull$$$0(0);
        }
        return this.preparePsiElementsForWrite(Arrays.asList(elements));
    }

    public boolean preparePsiElementsForWrite(@NotNull Collection<? extends PsiElement> elements) {
        if (elements == null) {
            CodeInsightUtilBase.$$$reportNull$$$0(1);
        }
        if (elements.isEmpty()) {
            return true;
        }
        THashSet files2 = new THashSet();
        Project project = null;
        for (PsiElement psiElement : elements) {
            PsiFile file2;
            if (psiElement == null || (file2 = psiElement.getContainingFile()) == null || !file2.isPhysical()) continue;
            project = file2.getProject();
            VirtualFile virtualFile = file2.getVirtualFile();
            if (virtualFile == null) continue;
            files2.add(virtualFile);
        }
        if (!files2.isEmpty()) {
            ReadonlyStatusHandler.OperationStatus status = ReadonlyStatusHandler.getInstance(project).ensureFilesWritable((Collection)files2);
            return !status.hasReadonlyFiles();
        }
        return true;
    }

    public boolean prepareVirtualFilesForWrite(@NotNull Project project, @NotNull Collection<VirtualFile> files2) {
        ReadonlyStatusHandler.OperationStatus status;
        if (project == null) {
            CodeInsightUtilBase.$$$reportNull$$$0(2);
        }
        if (files2 == null) {
            CodeInsightUtilBase.$$$reportNull$$$0(3);
        }
        return !(status = ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(files2)).hasReadonlyFiles();
    }

    @Deprecated
    public static boolean prepareEditorForWrite(@NotNull Editor editor) {
        if (editor == null) {
            CodeInsightUtilBase.$$$reportNull$$$0(4);
        }
        return EditorModificationUtil.checkModificationAllowed((Editor)editor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/CodeInsightUtilBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "preparePsiElementsForWrite";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareVirtualFilesForWrite";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareEditorForWrite";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

