/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.editor;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.profile.codeInspection.ui.ErrorOptionsProvider;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class ErrorHighlightingPanel {
    private JTextField myAutoreparseDelayField;
    private JTextField myMarkMinHeight;
    private JPanel myPanel;
    private JPanel myErrorsPanel;
    private JCheckBox myNextErrorGoesToErrorsFirst;

    public ErrorHighlightingPanel(@NotNull List<ErrorOptionsProvider> configurables) {
        if (configurables == null) {
            ErrorHighlightingPanel.$$$reportNull$$$0(0);
        }
        this.$$$setupUI$$$();
        for (ErrorOptionsProvider optionsProvider : configurables) {
            this.myErrorsPanel.add(optionsProvider.createComponent());
        }
    }

    public void reset() {
        DaemonCodeAnalyzerSettings settings = DaemonCodeAnalyzerSettings.getInstance();
        this.myAutoreparseDelayField.setText(Integer.toString(settings.getAutoReparseDelay()));
        this.myMarkMinHeight.setText(Integer.toString(settings.getErrorStripeMarkMinHeight()));
        this.myNextErrorGoesToErrorsFirst.setSelected(settings.isNextErrorActionGoesToErrorsFirst());
    }

    public void apply() throws ConfigurationException {
        DaemonCodeAnalyzerSettings settings = DaemonCodeAnalyzerSettings.getInstance();
        settings.setAutoReparseDelay(this.getAutoReparseDelay());
        settings.setErrorStripeMarkMinHeight(this.getErrorStripeMarkMinHeight());
        settings.setNextErrorActionGoesToErrorsFirst(this.myNextErrorGoesToErrorsFirst.isSelected());
    }

    public JPanel getPanel() {
        return this.myPanel;
    }

    private int getErrorStripeMarkMinHeight() {
        return ErrorHighlightingPanel.parseInteger(this.myMarkMinHeight);
    }

    public boolean isModified() {
        DaemonCodeAnalyzerSettings settings = DaemonCodeAnalyzerSettings.getInstance();
        boolean isModified = settings.getAutoReparseDelay() != this.getAutoReparseDelay();
        isModified |= this.getErrorStripeMarkMinHeight() != settings.getErrorStripeMarkMinHeight();
        return isModified |= this.myNextErrorGoesToErrorsFirst.isSelected() != settings.isNextErrorActionGoesToErrorsFirst();
    }

    private int getAutoReparseDelay() {
        return ErrorHighlightingPanel.parseInteger(this.myAutoreparseDelayField);
    }

    private static int parseInteger(JTextField textField2) {
        try {
            int delay = Integer.parseInt(textField2.getText());
            if (delay < 0) {
                delay = 0;
            }
            return delay;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurables", "com/intellij/application/options/editor/ErrorHighlightingPanel", "<init>"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JPanel jPanel;
        JTextField jTextField;
        JTextField jTextField2;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("messages/ApplicationBundle").getString("group.error.highlighting"), (int)0, (int)0, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/ApplicationBundle").getString("editbox.error.stripe.mark.min.height.pixels"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("editbox.autoreparse.delay.ms"));
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAutoreparseDelayField = jTextField2 = new JTextField();
        jTextField2.setColumns(20);
        jPanel2.add((Component)jTextField2, new GridConstraints(1, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        this.myMarkMinHeight = jTextField = new JTextField();
        jTextField.setColumns(20);
        jTextField.setText("");
        jPanel2.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myErrorsPanel = jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 5, 5));
        jPanel2.add((Component)jPanel, new GridConstraints(3, 0, 1, 2, 0, 3, 0, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        jPanel2.add((Component)jPanel3, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myNextErrorGoesToErrorsFirst = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.next.error.action.goes.to.errors.first"));
        jCheckBox.setVerticalAlignment(1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel3.add((Component)jCheckBox, gridBagConstraints);
        jLabel.setLabelFor(jTextField);
        jLabel2.setLabelFor(jTextField2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

