/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k.ast;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.j2k.CodeBuilder;
import org.jetbrains.kotlin.j2k.ast.Element;
import org.jetbrains.kotlin.j2k.ast.Expression;
import org.jetbrains.kotlin.j2k.ast.Statement;
import org.jetbrains.kotlin.j2k.ast.UtilKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/j2k/ast/WhileStatement;", "Lorg/jetbrains/kotlin/j2k/ast/Statement;", "condition", "Lorg/jetbrains/kotlin/j2k/ast/Expression;", "body", "Lorg/jetbrains/kotlin/j2k/ast/Element;", "singleLine", "", "(Lorg/jetbrains/kotlin/j2k/ast/Expression;Lorg/jetbrains/kotlin/j2k/ast/Element;Z)V", "getBody", "()Lorg/jetbrains/kotlin/j2k/ast/Element;", "br", "", "getCondition", "()Lorg/jetbrains/kotlin/j2k/ast/Expression;", "generateCode", "", "builder", "Lorg/jetbrains/kotlin/j2k/CodeBuilder;", "j2k"})
public final class WhileStatement
extends Statement {
    private final String br;
    @NotNull
    private final Expression condition;
    @NotNull
    private final Element body;

    @Override
    public void generateCode(@NotNull CodeBuilder builder) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        builder.append("while (").append(this.condition).append(")").append(this.br).append(UtilKt.wrapToBlockIfRequired(this.body));
        if (this.body.isEmpty()) {
            builder.append(";");
        }
    }

    @NotNull
    public final Expression getCondition() {
        return this.condition;
    }

    @NotNull
    public final Element getBody() {
        return this.body;
    }

    public WhileStatement(@NotNull Expression condition, @NotNull Element body2, boolean singleLine) {
        Intrinsics.checkParameterIsNotNull((Object)condition, (String)"condition");
        Intrinsics.checkParameterIsNotNull((Object)body2, (String)"body");
        this.condition = condition;
        this.body = body2;
        this.br = singleLine ? " " : "\n";
    }
}

