/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac.ast.api;

import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.DataInputOutputUtilRt;
import com.intellij.util.ThrowableConsumer;
import gnu.trove.THashSet;
import gnu.trove.TObjectIntHashMap;
import gnu.trove.TObjectIntProcedure;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Modifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.javac.ast.api.JavacDef;
import org.jetbrains.jps.javac.ast.api.JavacRef;
import org.jetbrains.jps.javac.ast.api.JavacTypeCast;

public class JavacFileData {
    public static final String CUSTOM_DATA_PLUGIN_ID = "ast.reference.collector";
    public static final String CUSTOM_DATA_KIND = "JavacFileData";
    private static final byte CLASS_MARKER = 0;
    private static final byte METHOD_MARKER = 1;
    private static final byte FIELD_MARKER = 2;
    private static final byte FUN_EXPR_MARKER = 3;
    private final String myFilePath;
    private final TObjectIntHashMap<JavacRef> myRefs;
    private final TObjectIntHashMap<JavacRef> myImportRefs;
    private final List<JavacTypeCast> myCasts;
    private final List<JavacDef> myDefs;
    private final Set<JavacRef> myImplicitRefs;

    public JavacFileData(@NotNull String path, @NotNull TObjectIntHashMap<JavacRef> refs, @NotNull TObjectIntHashMap<JavacRef> importRefs, @NotNull List<JavacTypeCast> casts, @NotNull List<JavacDef> defs, @NotNull Set<JavacRef> implicitRefs) {
        if (path == null) {
            JavacFileData.$$$reportNull$$$0(0);
        }
        if (refs == null) {
            JavacFileData.$$$reportNull$$$0(1);
        }
        if (importRefs == null) {
            JavacFileData.$$$reportNull$$$0(2);
        }
        if (casts == null) {
            JavacFileData.$$$reportNull$$$0(3);
        }
        if (defs == null) {
            JavacFileData.$$$reportNull$$$0(4);
        }
        if (implicitRefs == null) {
            JavacFileData.$$$reportNull$$$0(5);
        }
        this.myFilePath = path;
        this.myRefs = refs;
        this.myImportRefs = importRefs;
        this.myCasts = casts;
        this.myDefs = defs;
        this.myImplicitRefs = implicitRefs;
    }

    @NotNull
    public String getFilePath() {
        String string = this.myFilePath;
        if (string == null) {
            JavacFileData.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public Set<JavacRef> getImplicitToStringRefs() {
        Set<JavacRef> set = this.myImplicitRefs;
        if (set == null) {
            JavacFileData.$$$reportNull$$$0(7);
        }
        return set;
    }

    @NotNull
    public TObjectIntHashMap<JavacRef> getRefs() {
        TObjectIntHashMap<JavacRef> tObjectIntHashMap = this.myRefs;
        if (tObjectIntHashMap == null) {
            JavacFileData.$$$reportNull$$$0(8);
        }
        return tObjectIntHashMap;
    }

    @NotNull
    public TObjectIntHashMap<JavacRef> getImportRefs() {
        TObjectIntHashMap<JavacRef> tObjectIntHashMap = this.myImportRefs;
        if (tObjectIntHashMap == null) {
            JavacFileData.$$$reportNull$$$0(9);
        }
        return tObjectIntHashMap;
    }

    @NotNull
    public List<JavacTypeCast> getCasts() {
        List<JavacTypeCast> list = this.myCasts;
        if (list == null) {
            JavacFileData.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    public List<JavacDef> getDefs() {
        List<JavacDef> list = this.myDefs;
        if (list == null) {
            JavacFileData.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    public byte[] asBytes() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        DataOutputStream stream = new DataOutputStream(os);
        try {
            stream.writeUTF(this.getFilePath());
            JavacFileData.saveRefs(stream, this.getRefs());
            JavacFileData.saveRefs(stream, this.getImportRefs());
            JavacFileData.saveCasts(stream, this.getCasts());
            JavacFileData.saveDefs(stream, this.getDefs());
            JavacFileData.saveImplicitToString(stream, this.getImplicitToStringRefs());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        byte[] byArray = os.toByteArray();
        if (byArray == null) {
            JavacFileData.$$$reportNull$$$0(12);
        }
        return byArray;
    }

    @NotNull
    public static JavacFileData fromBytes(byte[] bytes) {
        JavacFileData javacFileData;
        block2: {
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
            try {
                javacFileData = new JavacFileData(in.readUTF(), JavacFileData.readRefs(in), JavacFileData.readRefs(in), JavacFileData.readCasts(in), JavacFileData.readDefs(in), JavacFileData.readImplicitToString(in));
                if (javacFileData != null) break block2;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            JavacFileData.$$$reportNull$$$0(13);
        }
        return javacFileData;
    }

    private static void saveRefs(final DataOutput out, TObjectIntHashMap<JavacRef> refs) throws IOException {
        final IOException[] exception = new IOException[]{null};
        DataInputOutputUtilRt.writeINT((DataOutput)out, (int)refs.size());
        if (!refs.forEachEntry((TObjectIntProcedure)new TObjectIntProcedure<JavacRef>(){

            public boolean execute(JavacRef ref, int count) {
                try {
                    JavacFileData.writeJavacRef(out, ref);
                    DataInputOutputUtilRt.writeINT((DataOutput)out, (int)count);
                }
                catch (IOException e) {
                    exception[0] = e;
                    return false;
                }
                return true;
            }
        })) {
            assert (exception[0] != null);
            throw exception[0];
        }
    }

    private static TObjectIntHashMap<JavacRef> readRefs(DataInput in) throws IOException {
        int size = DataInputOutputUtilRt.readINT((DataInput)in);
        TObjectIntHashMap deserialized = new TObjectIntHashMap(size);
        for (int i = 0; i < size; ++i) {
            deserialized.put((Object)JavacFileData.readJavacRef(in), DataInputOutputUtilRt.readINT((DataInput)in));
        }
        return deserialized;
    }

    private static void saveDefs(final DataOutput out, List<JavacDef> defs) throws IOException {
        DataInputOutputUtilRt.writeSeq((DataOutput)out, defs, (ThrowableConsumer)new ThrowableConsumer<JavacDef, IOException>(){

            public void consume(JavacDef def) throws IOException {
                JavacFileData.writeJavacDef(out, def);
            }
        });
    }

    private static List<JavacDef> readDefs(final DataInput in) throws IOException {
        return DataInputOutputUtilRt.readSeq((DataInput)in, (ThrowableComputable)new ThrowableComputable<JavacDef, IOException>(){

            public JavacDef compute() throws IOException {
                return JavacFileData.readJavacDef(in);
            }
        });
    }

    private static JavacDef readJavacDef(@NotNull DataInput in) throws IOException {
        if (in == null) {
            JavacFileData.$$$reportNull$$$0(14);
        }
        byte marker = in.readByte();
        switch (marker) {
            case 0: {
                int supersSize = in.readInt();
                JavacRef[] superClasses = new JavacRef[supersSize];
                for (int i = 0; i < supersSize; ++i) {
                    superClasses[i] = JavacFileData.readJavacRef(in);
                }
                return new JavacDef.JavacClassDef(JavacFileData.readJavacRef(in), superClasses);
            }
            case 3: {
                return new JavacDef.JavacFunExprDef(JavacFileData.readJavacRef(in));
            }
            case 1: {
                JavacRef retType = JavacFileData.readJavacRef(in);
                byte dimension = in.readByte();
                boolean isStatic = in.readBoolean();
                return new JavacDef.JavacMemberDef(JavacFileData.readJavacRef(in), retType, dimension, isStatic);
            }
        }
        throw new IllegalStateException("unknown marker " + marker);
    }

    private static void writeJavacDef(@NotNull DataOutput out, JavacDef def) throws IOException {
        if (out == null) {
            JavacFileData.$$$reportNull$$$0(15);
        }
        if (def instanceof JavacDef.JavacClassDef) {
            out.writeByte(0);
            JavacRef[] superClasses = ((JavacDef.JavacClassDef)def).getSuperClasses();
            out.writeInt(superClasses.length);
            for (JavacRef aClass : superClasses) {
                JavacFileData.writeJavacRef(out, aClass);
            }
        } else if (def instanceof JavacDef.JavacFunExprDef) {
            out.writeByte(3);
        } else if (def instanceof JavacDef.JavacMemberDef) {
            out.writeByte(1);
            JavacFileData.writeJavacRef(out, ((JavacDef.JavacMemberDef)def).getReturnType());
            out.writeByte(((JavacDef.JavacMemberDef)def).getIteratorKind());
            out.writeBoolean(((JavacDef.JavacMemberDef)def).isStatic());
        } else {
            throw new IllegalStateException("unknown type: " + def.getClass());
        }
        JavacFileData.writeJavacRef(out, def.getDefinedElement());
    }

    private static void writeJavacRef(@NotNull DataOutput out, JavacRef ref) throws IOException {
        if (out == null) {
            JavacFileData.$$$reportNull$$$0(16);
        }
        if (ref instanceof JavacRef.JavacClass) {
            out.writeByte(0);
            out.writeBoolean(((JavacRef.JavacClass)ref).isAnonymous());
        } else if (ref instanceof JavacRef.JavacField) {
            out.writeByte(2);
            out.writeUTF(ref.getOwnerName());
        } else if (ref instanceof JavacRef.JavacMethod) {
            out.writeByte(1);
            out.writeUTF(ref.getOwnerName());
            out.write(((JavacRef.JavacMethod)ref).getParamCount());
        } else {
            throw new IllegalStateException("unknown type: " + ref.getClass());
        }
        JavacFileData.writeModifiers(out, ref.getModifiers());
        out.writeUTF(ref.getName());
    }

    private static JavacRef readJavacRef(@NotNull DataInput in) throws IOException {
        if (in == null) {
            JavacFileData.$$$reportNull$$$0(17);
        }
        byte marker = in.readByte();
        switch (marker) {
            case 0: {
                return new JavacRef.JavacClassImpl(in.readBoolean(), JavacFileData.readModifiers(in), in.readUTF());
            }
            case 1: {
                return new JavacRef.JavacMethodImpl(in.readUTF(), in.readByte(), JavacFileData.readModifiers(in), in.readUTF());
            }
            case 2: {
                return new JavacRef.JavacFieldImpl(in.readUTF(), JavacFileData.readModifiers(in), in.readUTF());
            }
        }
        throw new IllegalStateException("unknown marker " + marker);
    }

    private static void writeModifiers(final DataOutput output, Set<Modifier> modifiers) throws IOException {
        DataInputOutputUtilRt.writeSeq((DataOutput)output, modifiers, (ThrowableConsumer)new ThrowableConsumer<Modifier, IOException>(){

            public void consume(Modifier modifier) throws IOException {
                output.writeUTF(modifier.name());
            }
        });
    }

    private static Set<Modifier> readModifiers(final DataInput input) throws IOException {
        List modifierList = DataInputOutputUtilRt.readSeq((DataInput)input, (ThrowableComputable)new ThrowableComputable<Modifier, IOException>(){

            public Modifier compute() throws IOException {
                return Modifier.valueOf(input.readUTF());
            }
        });
        return modifierList.isEmpty() ? Collections.emptySet() : EnumSet.copyOf(modifierList);
    }

    private static void saveCasts(final @NotNull DataOutput output, @NotNull List<JavacTypeCast> casts) throws IOException {
        if (output == null) {
            JavacFileData.$$$reportNull$$$0(18);
        }
        if (casts == null) {
            JavacFileData.$$$reportNull$$$0(19);
        }
        DataInputOutputUtilRt.writeSeq((DataOutput)output, casts, (ThrowableConsumer)new ThrowableConsumer<JavacTypeCast, IOException>(){

            public void consume(JavacTypeCast cast) throws IOException {
                JavacFileData.writeJavacRef(output, cast.getOperandType());
                JavacFileData.writeJavacRef(output, cast.getCastType());
            }
        });
    }

    @NotNull
    private static List<JavacTypeCast> readCasts(final @NotNull DataInput input) throws IOException {
        if (input == null) {
            JavacFileData.$$$reportNull$$$0(20);
        }
        List list = DataInputOutputUtilRt.readSeq((DataInput)input, (ThrowableComputable)new ThrowableComputable<JavacTypeCast, IOException>(){

            public JavacTypeCast compute() throws IOException {
                return new JavacTypeCast((JavacRef.JavacClass)JavacFileData.readJavacRef(input), (JavacRef.JavacClass)JavacFileData.readJavacRef(input));
            }
        });
        if (list == null) {
            JavacFileData.$$$reportNull$$$0(21);
        }
        return list;
    }

    @NotNull
    private static Set<JavacRef> readImplicitToString(@NotNull DataInputStream in) throws IOException {
        if (in == null) {
            JavacFileData.$$$reportNull$$$0(22);
        }
        int size = DataInputOutputUtilRt.readINT((DataInput)in);
        THashSet result = new THashSet(size);
        for (int i = 0; i < size; ++i) {
            result.add((Object)JavacFileData.readJavacRef(in));
        }
        THashSet tHashSet = result;
        if (tHashSet == null) {
            JavacFileData.$$$reportNull$$$0(23);
        }
        return tHashSet;
    }

    private static void saveImplicitToString(@NotNull DataOutputStream out, @NotNull Set<JavacRef> refs) throws IOException {
        if (out == null) {
            JavacFileData.$$$reportNull$$$0(24);
        }
        if (refs == null) {
            JavacFileData.$$$reportNull$$$0(25);
        }
        DataInputOutputUtilRt.writeINT((DataOutput)out, (int)refs.size());
        for (JavacRef ref : refs) {
            JavacFileData.writeJavacRef(out, ref);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 21: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 21: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importRefs";
                break;
            }
            case 3: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "casts";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defs";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implicitRefs";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/javac/ast/api/JavacFileData";
                break;
            }
            case 14: 
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
            case 15: 
            case 16: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/javac/ast/api/JavacFileData";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePath";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitToStringRefs";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefs";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportRefs";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCasts";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefs";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "asBytes";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "fromBytes";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "readCasts";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "readImplicitToString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 21: 
            case 23: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "readJavacDef";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "writeJavacDef";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "writeJavacRef";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "readJavacRef";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "saveCasts";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "readCasts";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "readImplicitToString";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "saveImplicitToString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 21: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

