/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac;

import com.google.protobuf.MessageLite;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.protobuf.ProtobufDecoder;
import io.netty.handler.codec.protobuf.ProtobufEncoder;
import io.netty.handler.codec.protobuf.ProtobufVarint32FrameDecoder;
import io.netty.handler.codec.protobuf.ProtobufVarint32LengthFieldPrepender;
import io.netty.util.internal.logging.InternalLoggerFactory;
import io.netty.util.internal.logging.Log4JLoggerFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.api.CanceledStatus;
import org.jetbrains.jps.builders.impl.java.JavacCompilerTool;
import org.jetbrains.jps.builders.java.JavaCompilingTool;
import org.jetbrains.jps.javac.DiagnosticOutputConsumer;
import org.jetbrains.jps.javac.JavacMain;
import org.jetbrains.jps.javac.JavacProtoUtil;
import org.jetbrains.jps.javac.JavacRemoteProto;
import org.jetbrains.jps.javac.OutputFileConsumer;
import org.jetbrains.jps.javac.OutputFileObject;
import org.jetbrains.jps.javac.ast.api.JavacFileData;

public class ExternalJavacProcess {
    public static final String JPS_JAVA_COMPILING_TOOL_PROPERTY = "jps.java.compiling.tool";
    private final ChannelInitializer myChannelInitializer;
    private final EventLoopGroup myEventLoopGroup;
    private final boolean myKeepRunning;
    private volatile ChannelFuture myConnectFuture;
    private final ConcurrentMap<UUID, Boolean> myCanceled = new ConcurrentHashMap<UUID, Boolean>();
    private final ExecutorService myThreadPool = Executors.newCachedThreadPool();

    public ExternalJavacProcess(boolean keepRunning) {
        this.myKeepRunning = keepRunning;
        final JavacRemoteProto.Message msgDefaultInstance = JavacRemoteProto.Message.getDefaultInstance();
        this.myEventLoopGroup = new NioEventLoopGroup(1, (Executor)this.myThreadPool);
        this.myChannelInitializer = new ChannelInitializer(){

            protected void initChannel(Channel channel) throws Exception {
                channel.pipeline().addLast(new ChannelHandler[]{new ProtobufVarint32FrameDecoder(), new ProtobufDecoder((MessageLite)msgDefaultInstance), new ProtobufVarint32LengthFieldPrepender(), new ProtobufEncoder(), new CompilationRequestsHandler()});
            }
        };
    }

    public static void main(String[] args) {
        UUID uuid = null;
        String host = null;
        int port = -1;
        boolean keepRunning = false;
        if (args.length >= 3) {
            try {
                uuid = UUID.fromString(args[0]);
            }
            catch (Exception e) {
                System.err.println("Error parsing session id: " + e.getMessage());
                System.exit(-1);
            }
            host = args[1];
            try {
                port = Integer.parseInt(args[2]);
            }
            catch (NumberFormatException e) {
                System.err.println("Error parsing port: " + e.getMessage());
                System.exit(-1);
            }
            if (args.length > 3) {
                keepRunning = Boolean.valueOf(args[3]);
            }
        } else {
            System.err.println("Insufficient number of parameters");
            System.exit(-1);
        }
        ExternalJavacProcess process = new ExternalJavacProcess(keepRunning);
        try {
            if (process.connect(host, port)) {
                process.myConnectFuture.channel().writeAndFlush((Object)JavacProtoUtil.toMessage(uuid, JavacProtoUtil.createRequestAckResponse()));
            } else {
                System.err.println("Failed to connect to parent process");
                System.exit(-1);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
            System.exit(-1);
        }
    }

    private boolean connect(String host, int port) throws Throwable {
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.myEventLoopGroup)).channel(NioSocketChannel.class)).handler((ChannelHandler)this.myChannelInitializer);
        ((Bootstrap)bootstrap.option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)true);
        ChannelFuture future = bootstrap.connect(host, port).syncUninterruptibly();
        if (future.isSuccess()) {
            this.myConnectFuture = future;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JavacRemoteProto.Message compile(final ChannelHandlerContext context, final UUID sessionId, List<String> options, Collection<File> files, Collection<File> classpath, Collection<File> platformCp, Collection<File> modulePath, Collection<File> upgradeModulePath, Collection<File> sourcePath, Map<File, Set<File>> outs, CanceledStatus canceledStatus) {
        long compileStart = System.currentTimeMillis();
        DiagnosticOutputConsumer diagnostic = new DiagnosticOutputConsumer(){

            @Override
            public void javaFileLoaded(File file) {
                context.channel().writeAndFlush((Object)JavacProtoUtil.toMessage(sessionId, JavacProtoUtil.createSourceFileLoadedResponse(file)));
            }

            @Override
            public void outputLineAvailable(String line) {
                context.channel().writeAndFlush((Object)JavacProtoUtil.toMessage(sessionId, JavacProtoUtil.createStdOutputResponse(line)));
            }

            @Override
            public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
                JavacRemoteProto.Message.Response response = JavacProtoUtil.createBuildMessageResponse(diagnostic);
                context.channel().writeAndFlush((Object)JavacProtoUtil.toMessage(sessionId, response));
            }

            @Override
            public void registerJavacFileData(JavacFileData data) {
                this.customOutputData("ast.reference.collector", "JavacFileData", data.asBytes());
            }

            @Override
            public void customOutputData(String pluginId, String dataName, byte[] data) {
                JavacRemoteProto.Message.Response response = JavacProtoUtil.createCustomDataResponse(pluginId, dataName, data);
                context.channel().writeAndFlush((Object)JavacProtoUtil.toMessage(sessionId, response));
            }
        };
        OutputFileConsumer outputSink = new OutputFileConsumer(){

            @Override
            public void save(@NotNull OutputFileObject fileObject) {
                if (fileObject == null) {
                    3.$$$reportNull$$$0(0);
                }
                context.channel().writeAndFlush((Object)JavacProtoUtil.toMessage(sessionId, JavacProtoUtil.createOutputObjectResponse(fileObject)));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileObject", "org/jetbrains/jps/javac/ExternalJavacProcess$3", "save"));
            }
        };
        try {
            JavaCompilingTool tool = ExternalJavacProcess.getCompilingTool();
            boolean rc = JavacMain.compile(options, files, classpath, platformCp, modulePath, upgradeModulePath, sourcePath, outs, diagnostic, outputSink, canceledStatus, tool);
            JavacRemoteProto.Message message = JavacProtoUtil.toMessage(sessionId, JavacProtoUtil.createBuildCompletedResponse(rc));
            return message;
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            JavacRemoteProto.Message message = JavacProtoUtil.toMessage(sessionId, JavacProtoUtil.createFailure(e.getMessage(), e));
            return message;
        }
        finally {
            long compileEnd = System.currentTimeMillis();
            System.err.println("Compiled in " + (compileEnd - compileStart) + " ms");
        }
    }

    private static JavaCompilingTool getCompilingTool() {
        String property = System.getProperty(JPS_JAVA_COMPILING_TOOL_PROPERTY);
        if (property != null) {
            ServiceLoader<JavaCompilingTool> loader = ServiceLoader.load(JavaCompilingTool.class, JavaCompilingTool.class.getClassLoader());
            for (JavaCompilingTool tool : loader) {
                if (!property.equals(tool.getId()) && !property.equals(tool.getAlternativeId())) continue;
                return tool;
            }
        }
        return new JavacCompilerTool();
    }

    public void stop() {
        try {
            ChannelFuture future = this.myConnectFuture;
            if (future != null) {
                future.channel().close().await();
            }
            this.myEventLoopGroup.shutdownGracefully(0L, 15L, TimeUnit.SECONDS).await();
            System.exit(0);
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            System.exit(-1);
        }
    }

    private static List<File> toFiles(List<String> paths) {
        ArrayList<File> files = new ArrayList<File>(paths.size());
        for (String path : paths) {
            files.add(new File(path));
        }
        return files;
    }

    public void cancelBuild(UUID sessionId) {
        this.myCanceled.replace(sessionId, Boolean.FALSE, Boolean.TRUE);
    }

    static {
        Logger root = Logger.getRootLogger();
        if (!root.getAllAppenders().hasMoreElements()) {
            root.setLevel(Level.INFO);
            root.addAppender((Appender)new ConsoleAppender((Layout)new PatternLayout("%m%n")));
        }
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)new Log4JLoggerFactory());
    }

    @ChannelHandler.Sharable
    private class CompilationRequestsHandler
    extends SimpleChannelInboundHandler<JavacRemoteProto.Message> {
        private CompilationRequestsHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void channelRead0(final ChannelHandlerContext context, JavacRemoteProto.Message message) throws Exception {
            final UUID sessionId = JavacProtoUtil.fromProtoUUID(message.getSessionId());
            JavacRemoteProto.Message.Type messageType = message.getMessageType();
            JavacRemoteProto.Message reply = null;
            try {
                if (messageType == JavacRemoteProto.Message.Type.REQUEST) {
                    JavacRemoteProto.Message.Request request = message.getRequest();
                    JavacRemoteProto.Message.Request.Type requestType = request.getRequestType();
                    if (requestType == JavacRemoteProto.Message.Request.Type.COMPILE) {
                        if (ExternalJavacProcess.this.myCanceled.putIfAbsent(sessionId, Boolean.FALSE) == null) {
                            final List<String> options = request.getOptionList();
                            final List files = ExternalJavacProcess.toFiles(request.getFileList());
                            final List cp = ExternalJavacProcess.toFiles(request.getClasspathList());
                            final List platformCp = ExternalJavacProcess.toFiles(request.getPlatformClasspathList());
                            final List srcPath = ExternalJavacProcess.toFiles(request.getSourcepathList());
                            final List modulePath = ExternalJavacProcess.toFiles(request.getModulePathList());
                            final List upgradeModulePath = ExternalJavacProcess.toFiles(request.getUpgradeModulePathList());
                            final HashMap outs = new HashMap();
                            for (JavacRemoteProto.Message.Request.OutputGroup outputGroup : request.getOutputList()) {
                                HashSet<File> srcRoots = new HashSet<File>();
                                for (String root : outputGroup.getSourceRootList()) {
                                    srcRoots.add(new File(root));
                                }
                                outs.put(new File(outputGroup.getOutputRoot()), srcRoots);
                            }
                            ExternalJavacProcess.this.myThreadPool.submit(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        JavacRemoteProto.Message result = ExternalJavacProcess.compile(context, sessionId, options, files, cp, platformCp, modulePath, upgradeModulePath, srcPath, outs, new CanceledStatus(){

                                            @Override
                                            public boolean isCanceled() {
                                                return Boolean.TRUE.equals(ExternalJavacProcess.this.myCanceled.get(sessionId));
                                            }
                                        });
                                        context.channel().writeAndFlush((Object)result).awaitUninterruptibly();
                                    }
                                    finally {
                                        ExternalJavacProcess.this.myCanceled.remove(sessionId);
                                        if (!ExternalJavacProcess.this.myKeepRunning) {
                                            ExternalJavacProcess.this.stop();
                                        }
                                        Thread.interrupted();
                                    }
                                }
                            });
                        }
                    } else if (requestType == JavacRemoteProto.Message.Request.Type.CANCEL) {
                        ExternalJavacProcess.this.cancelBuild(sessionId);
                    } else if (requestType == JavacRemoteProto.Message.Request.Type.SHUTDOWN) {
                        for (UUID uuid : ExternalJavacProcess.this.myCanceled.keySet()) {
                            ExternalJavacProcess.this.cancelBuild(uuid);
                        }
                        new Thread("StopThread"){

                            @Override
                            public void run() {
                                ExternalJavacProcess.this.stop();
                            }
                        }.start();
                    } else {
                        reply = JavacProtoUtil.toMessage(sessionId, JavacProtoUtil.createFailure("Unsupported request type: " + requestType.name(), null));
                    }
                } else {
                    reply = JavacProtoUtil.toMessage(sessionId, JavacProtoUtil.createFailure("Unsupported message: " + messageType.name(), null));
                }
                if (reply == null) return;
            }
            catch (Throwable throwable) {
                if (reply == null) throw throwable;
                context.channel().writeAndFlush(reply);
                throw throwable;
            }
            context.channel().writeAndFlush((Object)reply);
        }
    }
}

