/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.codeInsight.hierarchy;

import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.openapi.util.JDOMUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import junit.framework.TestCase;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HierarchyViewTestFixture {
    private static final String NODE_ELEMENT_NAME = "node";
    private static final String ANY_NODES_ELEMENT_NAME = "any";
    private static final String TEXT_ATTR_NAME = "text";
    private static final String BASE_ATTR_NAME = "base";

    public void doHierarchyTest(@NotNull HierarchyTreeStructure treeStructure, @NotNull String expectedStructure) {
        if (treeStructure == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(0);
        }
        if (expectedStructure == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(1);
        }
        try {
            HierarchyViewTestFixture.checkHierarchyTreeStructure(treeStructure, JDOMUtil.load((CharSequence)expectedStructure));
        }
        catch (Throwable e) {
            TestCase.assertEquals((String)"XML structure comparison for your convenience, actual failure details BELOW", (String)expectedStructure, (String)HierarchyViewTestFixture.dump(treeStructure, null, 0));
            e.printStackTrace();
        }
    }

    @NotNull
    public static String dump(@NotNull HierarchyTreeStructure treeStructure, @Nullable HierarchyNodeDescriptor descriptor2, int level) {
        if (treeStructure == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(2);
        }
        StringBuilder s = new StringBuilder();
        HierarchyViewTestFixture.dump(treeStructure, descriptor2, level, s);
        String string = s.toString();
        if (string == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static void dump(@NotNull HierarchyTreeStructure treeStructure, @Nullable HierarchyNodeDescriptor descriptor2, int level, @NotNull StringBuilder b) {
        if (treeStructure == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(4);
        }
        if (b == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(5);
        }
        if (level > 10) {
            for (int i = 0; i < level; ++i) {
                b.append("  ");
            }
            b.append("<Probably infinite part skipped>\n");
            return;
        }
        if (descriptor2 == null) {
            descriptor2 = (HierarchyNodeDescriptor)treeStructure.getRootElement();
        }
        for (int i = 0; i < level; ++i) {
            b.append("  ");
        }
        descriptor2.update();
        b.append("<node text=\"").append(descriptor2.getHighlightedText().getText()).append("\"").append(treeStructure.getBaseDescriptor() == descriptor2 ? " base=\"true\"" : "");
        Object[] children = treeStructure.getChildElements((Object)descriptor2);
        if (children.length > 0) {
            b.append(">\n");
            for (Object o : children) {
                HierarchyNodeDescriptor d = (HierarchyNodeDescriptor)o;
                HierarchyViewTestFixture.dump(treeStructure, d, level + 1, b);
            }
            for (int i = 0; i < level; ++i) {
                b.append("  ");
            }
            b.append("</node>\n");
        } else {
            b.append("/>\n");
        }
    }

    private static void checkHierarchyTreeStructure(@NotNull HierarchyTreeStructure treeStructure, @Nullable Element rootElement) {
        if (treeStructure == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(6);
        }
        HierarchyNodeDescriptor rootNodeDescriptor = (HierarchyNodeDescriptor)treeStructure.getRootElement();
        rootNodeDescriptor.update();
        if (rootElement == null || !NODE_ELEMENT_NAME.equals(rootElement.getName())) {
            throw new IllegalArgumentException("Incorrect root element in verification resource");
        }
        HierarchyViewTestFixture.checkNodeDescriptorRecursively(treeStructure, rootNodeDescriptor, rootElement);
    }

    private static void checkNodeDescriptorRecursively(@NotNull HierarchyTreeStructure treeStructure, @NotNull HierarchyNodeDescriptor descriptor2, @NotNull Element expectedElement) {
        if (treeStructure == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(7);
        }
        if (descriptor2 == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(8);
        }
        if (expectedElement == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(9);
        }
        HierarchyViewTestFixture.checkBaseNode(treeStructure, descriptor2, expectedElement);
        HierarchyViewTestFixture.checkContent(descriptor2, expectedElement);
        HierarchyViewTestFixture.checkChildren(treeStructure, descriptor2, expectedElement);
    }

    private static void checkBaseNode(@NotNull HierarchyTreeStructure treeStructure, @NotNull HierarchyNodeDescriptor descriptor2, @NotNull Element expectedElement) {
        if (treeStructure == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(10);
        }
        if (descriptor2 == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(11);
        }
        if (expectedElement == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(12);
        }
        String baseAttrValue = expectedElement.getAttributeValue(BASE_ATTR_NAME);
        HierarchyNodeDescriptor baseDescriptor = treeStructure.getBaseDescriptor();
        boolean mustBeBase = "true".equalsIgnoreCase(baseAttrValue);
        TestCase.assertTrue((String)"Incorrect base node", (boolean)(mustBeBase ? baseDescriptor == descriptor2 : baseDescriptor != descriptor2));
    }

    private static void checkContent(@NotNull HierarchyNodeDescriptor descriptor2, @NotNull Element expectedElement) {
        if (descriptor2 == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(13);
        }
        if (expectedElement == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(14);
        }
        TestCase.assertEquals((String)expectedElement.getAttributeValue(TEXT_ATTR_NAME), (String)descriptor2.getHighlightedText().getText());
    }

    private static void checkChildren(@NotNull HierarchyTreeStructure treeStructure, @NotNull HierarchyNodeDescriptor descriptor2, @NotNull Element element) {
        if (treeStructure == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(15);
        }
        if (descriptor2 == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(16);
        }
        if (element == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(17);
        }
        if (element.getChild(ANY_NODES_ELEMENT_NAME) != null) {
            return;
        }
        Object[] children = treeStructure.getChildElements((Object)descriptor2);
        ArrayList expectedChildren = new ArrayList(element.getChildren(NODE_ELEMENT_NAME));
        StringBuilder messageBuilder = new StringBuilder("Actual children of [" + descriptor2.getHighlightedText().getText() + "]:\n");
        for (Object child2 : children) {
            HierarchyNodeDescriptor nodeDescriptor = (HierarchyNodeDescriptor)child2;
            nodeDescriptor.update();
            messageBuilder.append("    [").append(nodeDescriptor.getHighlightedText().getText()).append("]\n");
        }
        TestCase.assertEquals((String)messageBuilder.toString(), (int)expectedChildren.size(), (int)children.length);
        Arrays.sort(children, Comparator.comparing(child -> ((HierarchyNodeDescriptor)child).getHighlightedText().getText()));
        Collections.sort(expectedChildren, Comparator.comparing(child -> child.getAttributeValue(TEXT_ATTR_NAME)));
        Iterator iterator = expectedChildren.iterator();
        for (Object child3 : children) {
            HierarchyViewTestFixture.checkNodeDescriptorRecursively(treeStructure, (HierarchyNodeDescriptor)child3, (Element)iterator.next());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeStructure";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedStructure";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/codeInsight/hierarchy/HierarchyViewTestFixture";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 8: 
            case 11: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 9: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedElement";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/codeInsight/hierarchy/HierarchyViewTestFixture";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "dump";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doHierarchyTest";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "dump";
                break;
            }
            case 3: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkHierarchyTreeStructure";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkNodeDescriptorRecursively";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "checkBaseNode";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "checkContent";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "checkChildren";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

