/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.util.io.PathKt;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a\u001a\u0010\u0004\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b\u001a\u001a\u0010\u0004\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003\u00a8\u0006\t"}, d2={"generateTemporaryPath", "Ljava/nio/file/Path;", "fileName", "", "writeChild", "Lcom/intellij/openapi/vfs/VirtualFile;", "relativePath", "data", "", "intellij.platform.testFramework"})
public final class TemporaryDirectoryKt {
    @NotNull
    public static final Path generateTemporaryPath(@Nullable String fileName) {
        Path tempDirectory = Paths.get(FileUtilRt.getTempDirectory(), new String[0]);
        Path path = tempDirectory.resolve(fileName);
        int i = 0;
        while (true) {
            Path path2 = path;
            Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"path");
            if (!PathKt.exists((Path)path2) || i >= 9) break;
            path = tempDirectory.resolve(fileName + '_' + i);
            ++i;
        }
        if (PathKt.exists((Path)path)) {
            throw (Throwable)new IOException("Cannot generate unique random path");
        }
        return path;
    }

    @NotNull
    public static final VirtualFile writeChild(@NotNull VirtualFile $receiver, @NotNull String relativePath, @NotNull String data) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        VirtualFile virtualFile = VfsTestUtil.createFile($receiver, relativePath, data);
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"VfsTestUtil.createFile(this, relativePath, data)");
        return virtualFile;
    }

    @NotNull
    public static final VirtualFile writeChild(@NotNull VirtualFile $receiver, @NotNull String relativePath, @NotNull byte[] data) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        VirtualFile virtualFile = VfsTestUtil.createFile($receiver, relativePath, data);
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"VfsTestUtil.createFile(this, relativePath, data)");
        return virtualFile;
    }
}

