/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.JavaModuleExternalPaths;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.ContentEntryImpl;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.stubs.StubTextInconsistencyException;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.testFramework.PlatformTestCase;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.Function;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.junit.Assert;

public class PsiTestUtil {
    @NotNull
    public static VirtualFile createTestProjectStructure(@NotNull Project project2, @NotNull Module module2, String rootPath, @NotNull Collection<? super File> filesToDelete) throws Exception {
        if (project2 == null) {
            PsiTestUtil.$$$reportNull$$$0(0);
        }
        if (module2 == null) {
            PsiTestUtil.$$$reportNull$$$0(1);
        }
        if (filesToDelete == null) {
            PsiTestUtil.$$$reportNull$$$0(2);
        }
        VirtualFile virtualFile = PsiTestUtil.createTestProjectStructure(project2, module2, rootPath, filesToDelete, true);
        if (virtualFile == null) {
            PsiTestUtil.$$$reportNull$$$0(3);
        }
        return virtualFile;
    }

    @NotNull
    public static VirtualFile createTestProjectStructure(@NotNull Project project2, @NotNull Module module2, @NotNull Collection<? super File> filesToDelete) throws IOException {
        if (project2 == null) {
            PsiTestUtil.$$$reportNull$$$0(4);
        }
        if (module2 == null) {
            PsiTestUtil.$$$reportNull$$$0(5);
        }
        if (filesToDelete == null) {
            PsiTestUtil.$$$reportNull$$$0(6);
        }
        VirtualFile virtualFile = PsiTestUtil.createTestProjectStructure(project2, module2, null, filesToDelete, true);
        if (virtualFile == null) {
            PsiTestUtil.$$$reportNull$$$0(7);
        }
        return virtualFile;
    }

    @NotNull
    public static VirtualFile createTestProjectStructure(@NotNull Project project2, @Nullable Module module2, String rootPath, @NotNull Collection<? super File> filesToDelete, boolean addProjectRoots) throws IOException {
        if (project2 == null) {
            PsiTestUtil.$$$reportNull$$$0(8);
        }
        if (filesToDelete == null) {
            PsiTestUtil.$$$reportNull$$$0(9);
        }
        VirtualFile vDir = PsiTestUtil.createTestProjectStructure("unitTest", module2, rootPath, filesToDelete, addProjectRoots);
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        VirtualFile virtualFile = vDir;
        if (virtualFile == null) {
            PsiTestUtil.$$$reportNull$$$0(10);
        }
        return virtualFile;
    }

    @NotNull
    public static VirtualFile createTestProjectStructure(@NotNull String tempName, @Nullable Module module2, String rootPath, @NotNull Collection<? super File> filesToDelete, boolean addProjectRoots) throws IOException {
        if (tempName == null) {
            PsiTestUtil.$$$reportNull$$$0(11);
        }
        if (filesToDelete == null) {
            PsiTestUtil.$$$reportNull$$$0(12);
        }
        File dir = FileUtil.createTempDirectory((String)tempName, null, (boolean)false);
        filesToDelete.add(dir);
        VirtualFile vDir = LocalFileSystem.getInstance().refreshAndFindFileByPath(dir.getCanonicalPath().replace(File.separatorChar, '/'));
        assert (vDir != null && vDir.isDirectory()) : dir;
        PlatformTestCase.synchronizeTempDirVfs(vDir);
        EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> WriteAction.run(() -> {
            if (rootPath != null) {
                VirtualFile vDir1 = LocalFileSystem.getInstance().findFileByPath(rootPath.replace(File.separatorChar, '/'));
                if (vDir1 == null) {
                    throw new Exception(rootPath + " not found");
                }
                VfsUtil.copyDirectory(null, (VirtualFile)vDir1, (VirtualFile)vDir, null);
            }
            if (addProjectRoots) {
                PsiTestUtil.addSourceContentToRoots(module2, vDir);
            }
        })));
        VirtualFile virtualFile = vDir;
        if (virtualFile == null) {
            PsiTestUtil.$$$reportNull$$$0(13);
        }
        return virtualFile;
    }

    public static void removeAllRoots(@NotNull Module module2, Sdk jdk) {
        if (module2 == null) {
            PsiTestUtil.$$$reportNull$$$0(14);
        }
        ModuleRootModificationUtil.updateModel((Module)module2, model -> {
            model.clear();
            model.setSdk(jdk);
        });
    }

    @NotNull
    public static SourceFolder addSourceContentToRoots(@NotNull Module module2, @NotNull VirtualFile vDir) {
        if (module2 == null) {
            PsiTestUtil.$$$reportNull$$$0(15);
        }
        if (vDir == null) {
            PsiTestUtil.$$$reportNull$$$0(16);
        }
        SourceFolder sourceFolder = PsiTestUtil.addSourceContentToRoots(module2, vDir, false);
        if (sourceFolder == null) {
            PsiTestUtil.$$$reportNull$$$0(17);
        }
        return sourceFolder;
    }

    @NotNull
    public static SourceFolder addSourceContentToRoots(@NotNull Module module2, @NotNull VirtualFile vDir, boolean testSource) {
        if (module2 == null) {
            PsiTestUtil.$$$reportNull$$$0(18);
        }
        if (vDir == null) {
            PsiTestUtil.$$$reportNull$$$0(19);
        }
        Ref result = Ref.create();
        ModuleRootModificationUtil.updateModel((Module)module2, model -> result.set((Object)model.addContentEntry(vDir).addSourceFolder(vDir, testSource)));
        SourceFolder sourceFolder = (SourceFolder)result.get();
        if (sourceFolder == null) {
            PsiTestUtil.$$$reportNull$$$0(20);
        }
        return sourceFolder;
    }

    @NotNull
    public static SourceFolder addSourceRoot(@NotNull Module module2, @NotNull VirtualFile vDir) {
        if (module2 == null) {
            PsiTestUtil.$$$reportNull$$$0(21);
        }
        if (vDir == null) {
            PsiTestUtil.$$$reportNull$$$0(22);
        }
        SourceFolder sourceFolder = PsiTestUtil.addSourceRoot(module2, vDir, false);
        if (sourceFolder == null) {
            PsiTestUtil.$$$reportNull$$$0(23);
        }
        return sourceFolder;
    }

    @NotNull
    public static SourceFolder addSourceRoot(@NotNull Module module2, @NotNull VirtualFile vDir, boolean isTestSource) {
        if (module2 == null) {
            PsiTestUtil.$$$reportNull$$$0(24);
        }
        if (vDir == null) {
            PsiTestUtil.$$$reportNull$$$0(25);
        }
        SourceFolder sourceFolder = PsiTestUtil.addSourceRoot(module2, vDir, isTestSource ? JavaSourceRootType.TEST_SOURCE : JavaSourceRootType.SOURCE);
        if (sourceFolder == null) {
            PsiTestUtil.$$$reportNull$$$0(26);
        }
        return sourceFolder;
    }

    @NotNull
    public static <P extends JpsElement> SourceFolder addSourceRoot(@NotNull Module module2, @NotNull VirtualFile vDir, @NotNull JpsModuleSourceRootType<P> rootType) {
        if (module2 == null) {
            PsiTestUtil.$$$reportNull$$$0(27);
        }
        if (vDir == null) {
            PsiTestUtil.$$$reportNull$$$0(28);
        }
        if (rootType == null) {
            PsiTestUtil.$$$reportNull$$$0(29);
        }
        SourceFolder sourceFolder = PsiTestUtil.addSourceRoot(module2, vDir, rootType, (JpsElement)rootType.createDefaultProperties());
        if (sourceFolder == null) {
            PsiTestUtil.$$$reportNull$$$0(30);
        }
        return sourceFolder;
    }

    @NotNull
    public static <P extends JpsElement> SourceFolder addSourceRoot(@NotNull Module module2, @NotNull VirtualFile vDir, @NotNull JpsModuleSourceRootType<P> rootType, @NotNull P properties) {
        if (module2 == null) {
            PsiTestUtil.$$$reportNull$$$0(31);
        }
        if (vDir == null) {
            PsiTestUtil.$$$reportNull$$$0(32);
        }
        if (rootType == null) {
            PsiTestUtil.$$$reportNull$$$0(33);
        }
        if (properties == null) {
            PsiTestUtil.$$$reportNull$$$0(34);
        }
        Ref result = Ref.create();
        ModuleRootModificationUtil.updateModel((Module)module2, model -> {
            ContentEntry entry = PsiTestUtil.findContentEntry((ModuleRootModel)model, vDir);
            if (entry == null) {
                entry = model.addContentEntry(vDir);
            }
            result.set((Object)entry.addSourceFolder(vDir, rootType, properties));
        });
        SourceFolder sourceFolder = (SourceFolder)result.get();
        if (sourceFolder == null) {
            PsiTestUtil.$$$reportNull$$$0(35);
        }
        return sourceFolder;
    }

    @Nullable
    private static ContentEntry findContentEntry(@NotNull ModuleRootModel rootModel, @NotNull VirtualFile file) {
        if (rootModel == null) {
            PsiTestUtil.$$$reportNull$$$0(36);
        }
        if (file == null) {
            PsiTestUtil.$$$reportNull$$$0(37);
        }
        return (ContentEntry)ContainerUtil.find((Object[])rootModel.getContentEntries(), object -> {
            VirtualFile entryRoot = object.getFile();
            return entryRoot != null && VfsUtilCore.isAncestor((VirtualFile)entryRoot, (VirtualFile)file, (boolean)false);
        });
    }

    public static ContentEntry addContentRoot(@NotNull Module module2, @NotNull VirtualFile vDir) {
        if (module2 == null) {
            PsiTestUtil.$$$reportNull$$$0(38);
        }
        if (vDir == null) {
            PsiTestUtil.$$$reportNull$$$0(39);
        }
        ModuleRootModificationUtil.updateModel((Module)module2, model -> model.addContentEntry(vDir));
        for (ContentEntry entry : ModuleRootManager.getInstance((Module)module2).getContentEntries()) {
            if (!Comparing.equal((Object)entry.getFile(), (Object)vDir)) continue;
            Assert.assertFalse((boolean)((ContentEntryImpl)entry).isDisposed());
            return entry;
        }
        return null;
    }

    public static void addExcludedRoot(@NotNull Module module2, @NotNull VirtualFile dir) {
        if (module2 == null) {
            PsiTestUtil.$$$reportNull$$$0(40);
        }
        if (dir == null) {
            PsiTestUtil.$$$reportNull$$$0(41);
        }
        ModuleRootModificationUtil.updateModel((Module)module2, model -> ApplicationManager.getApplication().runReadAction(() -> PsiTestUtil.findContentEntryWithAssertion(model, dir).addExcludeFolder(dir)));
    }

    @NotNull
    private static ContentEntry findContentEntryWithAssertion(@NotNull ModifiableRootModel model, @NotNull VirtualFile dir) {
        ContentEntry entry;
        if (model == null) {
            PsiTestUtil.$$$reportNull$$$0(42);
        }
        if (dir == null) {
            PsiTestUtil.$$$reportNull$$$0(43);
        }
        if ((entry = PsiTestUtil.findContentEntry((ModuleRootModel)model, dir)) == null) {
            throw new RuntimeException(dir + " is not under content roots: " + Arrays.toString(model.getContentRoots()));
        }
        ContentEntry contentEntry = entry;
        if (contentEntry == null) {
            PsiTestUtil.$$$reportNull$$$0(44);
        }
        return contentEntry;
    }

    public static void removeContentEntry(@NotNull Module module2, @NotNull VirtualFile contentRoot) {
        if (module2 == null) {
            PsiTestUtil.$$$reportNull$$$0(45);
        }
        if (contentRoot == null) {
            PsiTestUtil.$$$reportNull$$$0(46);
        }
        ModuleRootModificationUtil.updateModel((Module)module2, model -> model.removeContentEntry(PsiTestUtil.findContentEntryWithAssertion(model, contentRoot)));
    }

    public static void removeSourceRoot(@NotNull Module module2, @NotNull VirtualFile root) {
        if (module2 == null) {
            PsiTestUtil.$$$reportNull$$$0(47);
        }
        if (root == null) {
            PsiTestUtil.$$$reportNull$$$0(48);
        }
        ModuleRootModificationUtil.updateModel((Module)module2, model -> {
            ContentEntry entry = PsiTestUtil.findContentEntryWithAssertion(model, root);
            for (SourceFolder sourceFolder : entry.getSourceFolders()) {
                if (!root.equals(sourceFolder.getFile())) continue;
                entry.removeSourceFolder(sourceFolder);
                break;
            }
        });
    }

    public static void removeExcludedRoot(@NotNull Module module2, @NotNull VirtualFile root) {
        if (module2 == null) {
            PsiTestUtil.$$$reportNull$$$0(49);
        }
        if (root == null) {
            PsiTestUtil.$$$reportNull$$$0(50);
        }
        ModuleRootModificationUtil.updateModel((Module)module2, model -> {
            ContentEntry entry = PsiTestUtil.findContentEntryWithAssertion(model, root);
            entry.removeExcludeFolder(root.getUrl());
        });
    }

    public static void checkErrorElements(@NotNull PsiElement element) {
        if (element == null) {
            PsiTestUtil.$$$reportNull$$$0(51);
        }
        StringBuilder err = null;
        int s = 0;
        String text = element.getText();
        for (PsiErrorElement error : ((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot((Object)element)).filter(PsiErrorElement.class)) {
            TextRange r;
            if (err == null) {
                err = new StringBuilder();
            }
            if ((r = error.getTextRange()).getStartOffset() < s) continue;
            err.append(text, s, r.getStartOffset()).append("<error desc=\"");
            err.append(error.getErrorDescription()).append("\">");
            err.append(error.getText()).append("</error>");
            s = r.getEndOffset();
        }
        if (err == null) {
            return;
        }
        err.append(text, s, text.length());
        UsefulTestCase.assertSameLines(text, err.toString());
    }

    public static void checkFileStructure(@NotNull PsiFile file) {
        if (file == null) {
            PsiTestUtil.$$$reportNull$$$0(52);
        }
        PsiTestUtil.compareFromAllRoots(file, (Function<? super PsiFile, String>)((Function)f -> DebugUtil.psiTreeToString((PsiElement)f, (boolean)false)));
    }

    private static void compareFromAllRoots(@NotNull PsiFile file, @NotNull Function<? super PsiFile, String> fun) {
        if (file == null) {
            PsiTestUtil.$$$reportNull$$$0(53);
        }
        if (fun == null) {
            PsiTestUtil.$$$reportNull$$$0(54);
        }
        PsiFile dummyFile = PsiTestUtil.createDummyCopy(file);
        String psiTree = StringUtil.join((Collection)file.getViewProvider().getAllFiles(), fun, (String)"\n");
        String reparsedTree = StringUtil.join((Collection)dummyFile.getViewProvider().getAllFiles(), fun, (String)"\n");
        PsiTestUtil.assertPsiTextTreeConsistency(psiTree, reparsedTree);
    }

    private static void assertPsiTextTreeConsistency(@NotNull String psiTree, @NotNull String reparsedTree) {
        if (psiTree == null) {
            PsiTestUtil.$$$reportNull$$$0(55);
        }
        if (reparsedTree == null) {
            PsiTestUtil.$$$reportNull$$$0(56);
        }
        if (!psiTree.equals(reparsedTree)) {
            String[] psiLines = StringUtil.splitByLinesDontTrim((String)psiTree);
            String[] reparsedLines = StringUtil.splitByLinesDontTrim((String)reparsedTree);
            int i = 0;
            while (true) {
                if (i >= psiLines.length || i >= reparsedLines.length || !psiLines[i].equals(reparsedLines[i])) break;
                ++i;
            }
            int n = Math.min(i, psiLines.length - 1);
            psiLines[n] = psiLines[n] + "   // in PSI structure";
            int n2 = Math.min(i, reparsedLines.length - 1);
            reparsedLines[n2] = reparsedLines[n2] + "   // re-created from text";
            psiTree = StringUtil.join((String[])psiLines, (String)"\n");
            reparsedTree = StringUtil.join((String[])reparsedLines, (String)"\n");
            Assert.assertEquals((Object)reparsedTree, (Object)psiTree);
        }
    }

    @NotNull
    private static PsiFile createDummyCopy(@NotNull PsiFile file) {
        if (file == null) {
            PsiTestUtil.$$$reportNull$$$0(57);
        }
        LightVirtualFile copy = new LightVirtualFile(file.getName(), (CharSequence)file.getText());
        copy.setOriginalFile(file.getViewProvider().getVirtualFile());
        PsiFile dummyCopy = Objects.requireNonNull(file.getManager().findFile((VirtualFile)copy));
        if (dummyCopy instanceof PsiFileImpl) {
            ((PsiFileImpl)dummyCopy).setOriginalFile(file);
        }
        PsiFile psiFile = dummyCopy;
        if (psiFile == null) {
            PsiTestUtil.$$$reportNull$$$0(58);
        }
        return psiFile;
    }

    public static void checkPsiMatchesTextIgnoringNonCode(@NotNull PsiFile file) {
        if (file == null) {
            PsiTestUtil.$$$reportNull$$$0(59);
        }
        PsiTestUtil.compareFromAllRoots(file, (Function<? super PsiFile, String>)((Function)f -> DebugUtil.psiToStringIgnoringNonCode((PsiElement)f)));
    }

    @Deprecated
    public static void disablePsiTextConsistencyChecks(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            PsiTestUtil.$$$reportNull$$$0(60);
        }
        Registry.get((String)"ide.check.structural.psi.text.consistency.in.tests").setValue(false, parentDisposable);
    }

    @NotNull
    public static LibraryBuilder newLibrary(String name2) {
        LibraryBuilder libraryBuilder = new LibraryBuilder(name2);
        if (libraryBuilder == null) {
            PsiTestUtil.$$$reportNull$$$0(61);
        }
        return libraryBuilder;
    }

    public static void addLibrary(@NotNull Module module2, @NotNull String libPath) {
        if (module2 == null) {
            PsiTestUtil.$$$reportNull$$$0(62);
        }
        if (libPath == null) {
            PsiTestUtil.$$$reportNull$$$0(63);
        }
        File file = new File(libPath);
        String libName = file.getName();
        PsiTestUtil.addLibrary(module2, libName, file.getParent(), libName);
    }

    public static void addLibrary(@NotNull Module module2, String libName, @NotNull String libPath, String ... jarArr) {
        if (module2 == null) {
            PsiTestUtil.$$$reportNull$$$0(64);
        }
        if (libPath == null) {
            PsiTestUtil.$$$reportNull$$$0(65);
        }
        if (jarArr == null) {
            PsiTestUtil.$$$reportNull$$$0(66);
        }
        ModuleRootModificationUtil.updateModel((Module)module2, model -> PsiTestUtil.addLibrary(model, libName, libPath, jarArr));
    }

    public static void addLibrary(@NotNull Disposable parent, @NotNull Module module2, String libName, @NotNull String libPath, String ... jarArr) {
        if (parent == null) {
            PsiTestUtil.$$$reportNull$$$0(67);
        }
        if (module2 == null) {
            PsiTestUtil.$$$reportNull$$$0(68);
        }
        if (libPath == null) {
            PsiTestUtil.$$$reportNull$$$0(69);
        }
        if (jarArr == null) {
            PsiTestUtil.$$$reportNull$$$0(70);
        }
        Ref ref = new Ref();
        ModuleRootModificationUtil.updateModel((Module)module2, model -> ref.set((Object)PsiTestUtil.addLibrary(model, libName, libPath, jarArr)));
        Disposer.register((Disposable)parent, () -> {
            Library library = (Library)ref.get();
            ModuleRootModificationUtil.updateModel((Module)module2, model -> {
                LibraryOrderEntry entry = model.findLibraryOrderEntry(library);
                if (entry != null) {
                    model.removeOrderEntry((OrderEntry)entry);
                }
            });
            WriteCommandAction.runWriteCommandAction(null, () -> {
                LibraryTable table = ProjectLibraryTable.getInstance((Project)module2.getProject());
                LibraryTable.ModifiableModel model = table.getModifiableModel();
                model.removeLibrary(library);
                model.commit();
            });
        });
    }

    public static void addProjectLibrary(@NotNull Module module2, String libName, @NotNull List<String> classesRootPaths) {
        if (module2 == null) {
            PsiTestUtil.$$$reportNull$$$0(71);
        }
        if (classesRootPaths == null) {
            PsiTestUtil.$$$reportNull$$$0(72);
        }
        List<VirtualFile> roots = PsiTestUtil.getLibraryRoots(classesRootPaths);
        PsiTestUtil.addProjectLibrary(module2, libName, roots, Collections.emptyList());
    }

    @NotNull
    private static List<VirtualFile> getLibraryRoots(@NotNull List<String> classesRootPaths) {
        if (classesRootPaths == null) {
            PsiTestUtil.$$$reportNull$$$0(73);
        }
        List list = ContainerUtil.map(classesRootPaths, path -> VirtualFileManager.getInstance().refreshAndFindFileByUrl(VfsUtil.getUrlForLibraryRoot((File)new File((String)path))));
        if (list == null) {
            PsiTestUtil.$$$reportNull$$$0(74);
        }
        return list;
    }

    public static void addProjectLibrary(@NotNull ModifiableRootModel model, String libName, @NotNull List<String> classesRootPaths) {
        if (model == null) {
            PsiTestUtil.$$$reportNull$$$0(75);
        }
        if (classesRootPaths == null) {
            PsiTestUtil.$$$reportNull$$$0(76);
        }
        List<VirtualFile> roots = PsiTestUtil.getLibraryRoots(classesRootPaths);
        PsiTestUtil.addProjectLibrary(model, libName, roots, Collections.emptyList(), Collections.emptyList());
    }

    public static void addProjectLibrary(@NotNull Module module2, String libName, VirtualFile ... classesRoots) {
        if (module2 == null) {
            PsiTestUtil.$$$reportNull$$$0(77);
        }
        if (classesRoots == null) {
            PsiTestUtil.$$$reportNull$$$0(78);
        }
        PsiTestUtil.addProjectLibrary(module2, libName, Arrays.asList(classesRoots), Collections.emptyList());
    }

    @NotNull
    public static Library addProjectLibrary(@NotNull Module module2, String libName, @NotNull List<? extends VirtualFile> classesRoots, @NotNull List<? extends VirtualFile> sourceRoots) {
        if (module2 == null) {
            PsiTestUtil.$$$reportNull$$$0(79);
        }
        if (classesRoots == null) {
            PsiTestUtil.$$$reportNull$$$0(80);
        }
        if (sourceRoots == null) {
            PsiTestUtil.$$$reportNull$$$0(81);
        }
        Ref result = Ref.create();
        ModuleRootModificationUtil.updateModel((Module)module2, model -> result.set((Object)PsiTestUtil.addProjectLibrary(model, libName, classesRoots, sourceRoots, Collections.emptyList())));
        Library library = (Library)result.get();
        if (library == null) {
            PsiTestUtil.$$$reportNull$$$0(82);
        }
        return library;
    }

    @NotNull
    private static Library addProjectLibrary(@NotNull ModifiableRootModel model, String libName, @NotNull List<? extends VirtualFile> classesRoots, @NotNull List<? extends VirtualFile> sourceRoots, @NotNull List<? extends VirtualFile> javaDocs) {
        if (model == null) {
            PsiTestUtil.$$$reportNull$$$0(83);
        }
        if (classesRoots == null) {
            PsiTestUtil.$$$reportNull$$$0(84);
        }
        if (sourceRoots == null) {
            PsiTestUtil.$$$reportNull$$$0(85);
        }
        if (javaDocs == null) {
            PsiTestUtil.$$$reportNull$$$0(86);
        }
        LibraryTable libraryTable = ProjectLibraryTable.getInstance((Project)model.getProject());
        Library library = (Library)WriteAction.computeAndWait(() -> {
            Library library = libraryTable.createLibrary(libName);
            Library.ModifiableModel libraryModel = library.getModifiableModel();
            try {
                for (VirtualFile root : classesRoots) {
                    libraryModel.addRoot(root, OrderRootType.CLASSES);
                }
                for (VirtualFile root : sourceRoots) {
                    libraryModel.addRoot(root, OrderRootType.SOURCES);
                }
                for (VirtualFile root : javaDocs) {
                    libraryModel.addRoot(root, JavadocOrderRootType.getInstance());
                }
                libraryModel.commit();
            }
            catch (Throwable t) {
                libraryModel.dispose();
                throw t;
            }
            model.addLibraryEntry(library);
            OrderEntry[] orderEntries = model.getOrderEntries();
            OrderEntry last = orderEntries[orderEntries.length - 1];
            System.arraycopy(orderEntries, 0, orderEntries, 1, orderEntries.length - 1);
            orderEntries[0] = last;
            model.rearrangeOrderEntries(orderEntries);
            return library;
        });
        if (library == null) {
            PsiTestUtil.$$$reportNull$$$0(87);
        }
        return library;
    }

    @NotNull
    public static Library addLibrary(@NotNull ModifiableRootModel model, String libName, @NotNull String libPath, String ... jarArr) {
        if (model == null) {
            PsiTestUtil.$$$reportNull$$$0(88);
        }
        if (libPath == null) {
            PsiTestUtil.$$$reportNull$$$0(89);
        }
        if (jarArr == null) {
            PsiTestUtil.$$$reportNull$$$0(90);
        }
        ArrayList<VirtualFile> classesRoots = new ArrayList<VirtualFile>();
        for (String jar : jarArr) {
            String path;
            if (!libPath.endsWith("/") && !jar.startsWith("/")) {
                jar = "/" + jar;
            }
            VirtualFile root = (path = libPath + jar).endsWith(".jar") ? JarFileSystem.getInstance().refreshAndFindFileByPath(path + "!/") : LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
            assert (root != null) : "Library root folder not found: " + path + "!/";
            classesRoots.add(root);
        }
        Library library = PsiTestUtil.addProjectLibrary(model, libName, classesRoots, Collections.emptyList(), Collections.emptyList());
        if (library == null) {
            PsiTestUtil.$$$reportNull$$$0(91);
        }
        return library;
    }

    public static void addLibrary(@NotNull Module module2, String libName, @NotNull String libDir, @NotNull String[] classRoots, @NotNull String[] sourceRoots) {
        if (module2 == null) {
            PsiTestUtil.$$$reportNull$$$0(92);
        }
        if (libDir == null) {
            PsiTestUtil.$$$reportNull$$$0(93);
        }
        if (classRoots == null) {
            PsiTestUtil.$$$reportNull$$$0(94);
        }
        if (sourceRoots == null) {
            PsiTestUtil.$$$reportNull$$$0(95);
        }
        String proto = (classRoots.length > 0 ? classRoots[0] : sourceRoots[0]).endsWith(".jar!/") ? "jar" : "file";
        String parentUrl = VirtualFileManager.constructUrl((String)proto, (String)libDir);
        ArrayList<String> classesUrls = new ArrayList<String>();
        for (String classRoot : classRoots) {
            classesUrls.add(parentUrl + classRoot);
        }
        ArrayList<String> sourceUrls = new ArrayList<String>();
        for (String sourceRoot : sourceRoots) {
            sourceUrls.add(parentUrl + sourceRoot);
        }
        ModuleRootModificationUtil.addModuleLibrary((Module)module2, (String)libName, classesUrls, sourceUrls);
    }

    @NotNull
    public static Module addModule(@NotNull Project project2, @NotNull ModuleType type, @NotNull String name2, @NotNull VirtualFile root) {
        if (project2 == null) {
            PsiTestUtil.$$$reportNull$$$0(96);
        }
        if (type == null) {
            PsiTestUtil.$$$reportNull$$$0(97);
        }
        if (name2 == null) {
            PsiTestUtil.$$$reportNull$$$0(98);
        }
        if (root == null) {
            PsiTestUtil.$$$reportNull$$$0(99);
        }
        Module module2 = (Module)WriteCommandAction.writeCommandAction((Project)project2).compute(() -> {
            String moduleName;
            ModifiableModuleModel moduleModel = ModuleManager.getInstance((Project)project2).getModifiableModel();
            try {
                moduleName = moduleModel.newModule(root.getPath() + "/" + name2 + ".iml", type.getId()).getName();
                moduleModel.commit();
            }
            catch (Throwable t) {
                moduleModel.dispose();
                throw t;
            }
            Module dep = ModuleManager.getInstance((Project)project2).findModuleByName(moduleName);
            assert (dep != null) : moduleName;
            ModifiableRootModel model = ModuleRootManager.getInstance((Module)dep).getModifiableModel();
            try {
                model.addContentEntry(root).addSourceFolder(root, false);
                model.commit();
            }
            catch (Throwable t) {
                model.dispose();
                throw t;
            }
            return dep;
        });
        if (module2 == null) {
            PsiTestUtil.$$$reportNull$$$0(100);
        }
        return module2;
    }

    public static void setCompilerOutputPath(@NotNull Module module2, @NotNull String url, boolean forTests) {
        if (module2 == null) {
            PsiTestUtil.$$$reportNull$$$0(101);
        }
        if (url == null) {
            PsiTestUtil.$$$reportNull$$$0(102);
        }
        ModuleRootModificationUtil.updateModel((Module)module2, model -> {
            CompilerModuleExtension extension = (CompilerModuleExtension)model.getModuleExtension(CompilerModuleExtension.class);
            extension.inheritCompilerOutputPath(false);
            if (forTests) {
                extension.setCompilerOutputPathForTests(url);
            } else {
                extension.setCompilerOutputPath(url);
            }
        });
    }

    public static void setExcludeCompileOutput(@NotNull Module module2, boolean exclude) {
        if (module2 == null) {
            PsiTestUtil.$$$reportNull$$$0(103);
        }
        ModuleRootModificationUtil.updateModel((Module)module2, model -> ((CompilerModuleExtension)model.getModuleExtension(CompilerModuleExtension.class)).setExcludeOutput(exclude));
    }

    public static void setJavadocUrls(@NotNull Module module2, String ... urls) {
        if (module2 == null) {
            PsiTestUtil.$$$reportNull$$$0(104);
        }
        if (urls == null) {
            PsiTestUtil.$$$reportNull$$$0(105);
        }
        ModuleRootModificationUtil.updateModel((Module)module2, model -> ((JavaModuleExternalPaths)model.getModuleExtension(JavaModuleExternalPaths.class)).setJavadocUrls(urls));
    }

    @NotNull
    @Contract(pure=true)
    public static Sdk addJdkAnnotations(@NotNull Sdk sdk) {
        if (sdk == null) {
            PsiTestUtil.$$$reportNull$$$0(106);
        }
        String path = FileUtil.toSystemIndependentName((String)PlatformTestUtil.getCommunityPath()) + "/java/jdkAnnotations";
        VirtualFile root = LocalFileSystem.getInstance().findFileByPath(path);
        Sdk sdk2 = PsiTestUtil.addRootsToJdk(sdk, AnnotationOrderRootType.getInstance(), root);
        if (sdk2 == null) {
            PsiTestUtil.$$$reportNull$$$0(107);
        }
        return sdk2;
    }

    @NotNull
    @Contract(pure=true)
    public static Sdk addRootsToJdk(@NotNull Sdk sdk, @NotNull OrderRootType rootType, VirtualFile ... roots) {
        Sdk clone;
        if (sdk == null) {
            PsiTestUtil.$$$reportNull$$$0(108);
        }
        if (rootType == null) {
            PsiTestUtil.$$$reportNull$$$0(109);
        }
        if (roots == null) {
            PsiTestUtil.$$$reportNull$$$0(110);
        }
        try {
            clone = (Sdk)sdk.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        SdkModificator sdkModificator = clone.getSdkModificator();
        for (VirtualFile root : roots) {
            sdkModificator.addRoot(root, rootType);
        }
        sdkModificator.commitChanges();
        Sdk sdk2 = clone;
        if (sdk2 == null) {
            PsiTestUtil.$$$reportNull$$$0(111);
        }
        return sdk2;
    }

    public static void checkStubsMatchText(@NotNull PsiFile file) {
        if (file == null) {
            PsiTestUtil.$$$reportNull$$$0(112);
        }
        try {
            StubTextInconsistencyException.checkStubTextConsistency((PsiFile)file);
        }
        catch (StubTextInconsistencyException e) {
            PsiTestUtil.compareStubTexts(e);
        }
    }

    public static void compareStubTexts(@NotNull StubTextInconsistencyException e) {
        if (e == null) {
            PsiTestUtil.$$$reportNull$$$0(113);
        }
        PsiTestUtil.assertPsiTextTreeConsistency(e.getStubsFromPsi(), e.getStubsFromText());
        throw e;
    }

    public static void checkPsiStructureWithCommit(@NotNull PsiFile psiFile, @NotNull Consumer<? super PsiFile> checker) {
        if (psiFile == null) {
            PsiTestUtil.$$$reportNull$$$0(114);
        }
        if (checker == null) {
            PsiTestUtil.$$$reportNull$$$0(115);
        }
        checker.accept((PsiFile)psiFile);
        Document document = psiFile.getViewProvider().getDocument();
        PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)psiFile.getProject());
        if (document != null && manager.isUncommited(document)) {
            manager.commitDocument(document);
            checker.accept((PsiFile)manager.getPsiFile(document));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 13: 
            case 17: 
            case 20: 
            case 23: 
            case 26: 
            case 30: 
            case 35: 
            case 44: 
            case 58: 
            case 61: 
            case 74: 
            case 82: 
            case 87: 
            case 91: 
            case 100: 
            case 107: 
            case 111: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 13: 
            case 17: 
            case 20: 
            case 23: 
            case 26: 
            case 30: 
            case 35: 
            case 44: 
            case 58: 
            case 61: 
            case 74: 
            case 82: 
            case 87: 
            case 91: 
            case 100: 
            case 107: 
            case 111: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 14: 
            case 15: 
            case 18: 
            case 21: 
            case 24: 
            case 27: 
            case 31: 
            case 38: 
            case 40: 
            case 45: 
            case 47: 
            case 49: 
            case 62: 
            case 64: 
            case 68: 
            case 71: 
            case 77: 
            case 79: 
            case 92: 
            case 101: 
            case 103: 
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToDelete";
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 13: 
            case 17: 
            case 20: 
            case 23: 
            case 26: 
            case 30: 
            case 35: 
            case 44: 
            case 58: 
            case 61: 
            case 74: 
            case 82: 
            case 87: 
            case 91: 
            case 100: 
            case 107: 
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/PsiTestUtil";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tempName";
                break;
            }
            case 16: 
            case 19: 
            case 22: 
            case 25: 
            case 28: 
            case 32: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vDir";
                break;
            }
            case 29: 
            case 33: 
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
            case 37: 
            case 52: 
            case 53: 
            case 57: 
            case 59: 
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 41: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 42: 
            case 75: 
            case 83: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRoot";
                break;
            }
            case 48: 
            case 50: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fun";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiTree";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reparsedTree";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 63: 
            case 65: 
            case 69: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libPath";
                break;
            }
            case 66: 
            case 70: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jarArr";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 72: 
            case 73: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classesRootPaths";
                break;
            }
            case 78: 
            case 80: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classesRoots";
                break;
            }
            case 81: 
            case 85: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRoots";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaDocs";
                break;
            }
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libDir";
                break;
            }
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classRoots";
                break;
            }
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 106: 
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/PsiTestUtil";
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestProjectStructure";
                break;
            }
            case 17: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "addSourceContentToRoots";
                break;
            }
            case 23: 
            case 26: 
            case 30: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "addSourceRoot";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "findContentEntryWithAssertion";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "createDummyCopy";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "newLibrary";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryRoots";
                break;
            }
            case 82: 
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "addProjectLibrary";
                break;
            }
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "addLibrary";
                break;
            }
            case 100: {
                objectArray = objectArray2;
                objectArray2[1] = "addModule";
                break;
            }
            case 107: {
                objectArray = objectArray2;
                objectArray2[1] = "addJdkAnnotations";
                break;
            }
            case 111: {
                objectArray = objectArray2;
                objectArray2[1] = "addRootsToJdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createTestProjectStructure";
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 13: 
            case 17: 
            case 20: 
            case 23: 
            case 26: 
            case 30: 
            case 35: 
            case 44: 
            case 58: 
            case 61: 
            case 74: 
            case 82: 
            case 87: 
            case 91: 
            case 100: 
            case 107: 
            case 111: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "removeAllRoots";
                break;
            }
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addSourceContentToRoots";
                break;
            }
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "addSourceRoot";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "findContentEntry";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "addContentRoot";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "addExcludedRoot";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "findContentEntryWithAssertion";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "removeContentEntry";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "removeSourceRoot";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "removeExcludedRoot";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "checkErrorElements";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "checkFileStructure";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "compareFromAllRoots";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "assertPsiTextTreeConsistency";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "createDummyCopy";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "checkPsiMatchesTextIgnoringNonCode";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "disablePsiTextConsistencyChecks";
                break;
            }
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 88: 
            case 89: 
            case 90: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "addLibrary";
                break;
            }
            case 71: 
            case 72: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "addProjectLibrary";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryRoots";
                break;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "addModule";
                break;
            }
            case 101: 
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "setCompilerOutputPath";
                break;
            }
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "setExcludeCompileOutput";
                break;
            }
            case 104: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "setJavadocUrls";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "addJdkAnnotations";
                break;
            }
            case 108: 
            case 109: 
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "addRootsToJdk";
                break;
            }
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "checkStubsMatchText";
                break;
            }
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "compareStubTexts";
                break;
            }
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "checkPsiStructureWithCommit";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 13: 
            case 17: 
            case 20: 
            case 23: 
            case 26: 
            case 30: 
            case 35: 
            case 44: 
            case 58: 
            case 61: 
            case 74: 
            case 82: 
            case 87: 
            case 91: 
            case 100: 
            case 107: 
            case 111: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class LibraryBuilder {
        private final String myName;
        private final List<VirtualFile> myClassesRoots = new ArrayList<VirtualFile>();
        private final List<VirtualFile> mySourceRoots = new ArrayList<VirtualFile>();
        private final List<VirtualFile> myJavaDocRoots = new ArrayList<VirtualFile>();

        private LibraryBuilder(String name2) {
            this.myName = name2;
        }

        @NotNull
        public LibraryBuilder classesRoot(@NotNull VirtualFile root) {
            if (root == null) {
                LibraryBuilder.$$$reportNull$$$0(0);
            }
            this.myClassesRoots.add(root);
            LibraryBuilder libraryBuilder = this;
            if (libraryBuilder == null) {
                LibraryBuilder.$$$reportNull$$$0(1);
            }
            return libraryBuilder;
        }

        @NotNull
        public LibraryBuilder classesRoot(@NotNull String rootPath) {
            if (rootPath == null) {
                LibraryBuilder.$$$reportNull$$$0(2);
            }
            this.myClassesRoots.add(VirtualFileManager.getInstance().refreshAndFindFileByUrl(VfsUtil.getUrlForLibraryRoot((File)new File(rootPath))));
            LibraryBuilder libraryBuilder = this;
            if (libraryBuilder == null) {
                LibraryBuilder.$$$reportNull$$$0(3);
            }
            return libraryBuilder;
        }

        @NotNull
        public LibraryBuilder sourceRoot(@NotNull VirtualFile root) {
            if (root == null) {
                LibraryBuilder.$$$reportNull$$$0(4);
            }
            this.mySourceRoots.add(root);
            LibraryBuilder libraryBuilder = this;
            if (libraryBuilder == null) {
                LibraryBuilder.$$$reportNull$$$0(5);
            }
            return libraryBuilder;
        }

        @NotNull
        public LibraryBuilder sourceRoot(@NotNull String rootPath) {
            if (rootPath == null) {
                LibraryBuilder.$$$reportNull$$$0(6);
            }
            this.mySourceRoots.add(VirtualFileManager.getInstance().refreshAndFindFileByUrl(VfsUtil.getUrlForLibraryRoot((File)new File(rootPath))));
            LibraryBuilder libraryBuilder = this;
            if (libraryBuilder == null) {
                LibraryBuilder.$$$reportNull$$$0(7);
            }
            return libraryBuilder;
        }

        @NotNull
        public LibraryBuilder javaDocRoot(@NotNull VirtualFile root) {
            if (root == null) {
                LibraryBuilder.$$$reportNull$$$0(8);
            }
            this.myJavaDocRoots.add(root);
            LibraryBuilder libraryBuilder = this;
            if (libraryBuilder == null) {
                LibraryBuilder.$$$reportNull$$$0(9);
            }
            return libraryBuilder;
        }

        @NotNull
        public LibraryBuilder javaDocRoot(@NotNull String rootPath) {
            if (rootPath == null) {
                LibraryBuilder.$$$reportNull$$$0(10);
            }
            this.myJavaDocRoots.add(VirtualFileManager.getInstance().refreshAndFindFileByUrl(VfsUtil.getUrlForLibraryRoot((File)new File(rootPath))));
            LibraryBuilder libraryBuilder = this;
            if (libraryBuilder == null) {
                LibraryBuilder.$$$reportNull$$$0(11);
            }
            return libraryBuilder;
        }

        @NotNull
        public Library addTo(@NotNull ModifiableRootModel model) {
            if (model == null) {
                LibraryBuilder.$$$reportNull$$$0(12);
            }
            Library library = PsiTestUtil.addProjectLibrary(model, this.myName, this.myClassesRoots, this.mySourceRoots, this.myJavaDocRoots);
            if (library == null) {
                LibraryBuilder.$$$reportNull$$$0(13);
            }
            return library;
        }

        @NotNull
        public Library addTo(@NotNull Module module2) {
            if (module2 == null) {
                LibraryBuilder.$$$reportNull$$$0(14);
            }
            Ref result = Ref.create();
            ModuleRootModificationUtil.updateModel((Module)module2, model -> result.set((Object)this.addTo((ModifiableRootModel)model)));
            Library library = (Library)result.get();
            if (library == null) {
                LibraryBuilder.$$$reportNull$$$0(15);
            }
            return library;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 11: 
                case 13: 
                case 15: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 11: 
                case 13: 
                case 15: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 11: 
                case 13: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/testFramework/PsiTestUtil$LibraryBuilder";
                    break;
                }
                case 2: 
                case 6: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootPath";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/testFramework/PsiTestUtil$LibraryBuilder";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "classesRoot";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "sourceRoot";
                    break;
                }
                case 9: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "javaDocRoot";
                    break;
                }
                case 13: 
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addTo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "classesRoot";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 11: 
                case 13: 
                case 15: {
                    break;
                }
                case 4: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "sourceRoot";
                    break;
                }
                case 8: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "javaDocRoot";
                    break;
                }
                case 12: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "addTo";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 11: 
                case 13: 
                case 15: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

