/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.util.TimeoutUtil;
import java.lang.management.ManagementFactory;
import java.math.BigInteger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanServer;
import javax.management.ObjectName;

class CpuTimings {
    CpuTimings() {
    }

    static long calcStableCpuTiming() {
        long start = System.currentTimeMillis();
        long minTime = Integer.MAX_VALUE;
        long minIteration = -1L;
        StringBuilder log = new StringBuilder();
        int i = 0;
        while (true) {
            long time;
            if ((time = TimeoutUtil.measureExecutionTime(CpuTimings::addBigIntegers)) < minTime) {
                minTime = time;
                minIteration = i;
            } else if ((long)i - minIteration > 100L) {
                System.out.println(log + "CPU timing: " + minTime + ", calculated in " + (System.currentTimeMillis() - start) + "ms");
                return minTime;
            }
            ++i;
        }
    }

    private static void addBigIntegers() {
        BigInteger k = new BigInteger("1");
        for (int i = 0; i < 1000000; ++i) {
            k = k.add(new BigInteger("1"));
        }
    }

    private static void mulDiv() {
        long k = 241L;
        for (int i = 0; i < 22222222; ++i) {
            k = i % 10 == 3 ? k * 239L : k % 12342L;
        }
        CpuTimings.ensureOdd(k);
    }

    private static void ensureOdd(long k) {
        if (k % 2L == 0L) {
            throw new AssertionError((Object)"Should be an odd value");
        }
    }

    private static void mulDivMemAccess() {
        int[] array = new int[240000];
        for (int i = 0; i < array.length; ++i) {
            array[i] = i * 42 + 1;
        }
        int k = 241;
        for (int i = 0; i < 5750000; ++i) {
            k *= array[Math.abs(k) % array.length];
        }
        CpuTimings.ensureOdd(k);
    }

    public static double getProcessCpuLoad() {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName name2 = ObjectName.getInstance("java.lang:type=OperatingSystem");
            AttributeList list = mbs.getAttributes(name2, new String[]{"ProcessCpuLoad"});
            if (list.isEmpty()) {
                return Double.NaN;
            }
            Attribute att = (Attribute)list.get(0);
            Double value = (Double)att.getValue();
            if (value == -1.0) {
                return Double.NaN;
            }
            return (double)((int)(value * 1000.0)) / 10.0;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static double getSystemCpuLoad() {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName name2 = ObjectName.getInstance("java.lang:type=OperatingSystem");
            AttributeList list = mbs.getAttributes(name2, new String[]{"SystemCpuLoad"});
            if (list.isEmpty()) {
                return Double.NaN;
            }
            Attribute att = (Attribute)list.get(0);
            Double value = (Double)att.getValue();
            if (value == -1.0) {
                return Double.NaN;
            }
            return (double)((int)(value * 1000.0)) / 10.0;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        for (int i = 0; i < 20; ++i) {
        }
    }
}

