/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.NamedScriptableDefinition;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import org.jdom.Attribute;
import org.jdom.DataConversionException;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class Configuration
implements JDOMExternalizable,
Comparable<Configuration> {
    @NonNls
    public static final String CONTEXT_VAR_NAME = "__context__";
    public static final Configuration[] EMPTY_ARRAY = new Configuration[0];
    @NonNls
    protected static final String NAME_ATTRIBUTE_NAME = "name";
    @NonNls
    private static final String CREATED_ATTRIBUTE_NAME = "created";
    private String name;
    private String category;
    private boolean predefined;
    private long created;
    private transient String myCurrentVariableName = null;

    public Configuration() {
        this.name = "";
        this.category = "";
        this.created = -1L;
    }

    public Configuration(String name2, String category) {
        this.name = name2;
        this.category = category;
        this.created = -1L;
    }

    protected Configuration(Configuration configuration) {
        this.name = configuration.name;
        this.category = configuration.category;
        this.created = -1L;
        this.predefined = false;
    }

    public abstract Configuration copy();

    @NotNull
    public String getName() {
        if (StringUtil.isEmptyOrSpaces((String)this.name)) {
            String string = StringUtil.collapseWhiteSpace((CharSequence)this.getMatchOptions().getSearchPattern());
            if (string == null) {
                Configuration.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = this.name;
        if (string == null) {
            Configuration.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void setName(@NotNull String value) {
        if (value == null) {
            Configuration.$$$reportNull$$$0(2);
        }
        this.name = value;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(@NotNull String category) {
        if (category == null) {
            Configuration.$$$reportNull$$$0(3);
        }
        this.category = category;
    }

    public long getCreated() {
        return this.created;
    }

    public void setCreated(long created) {
        if (this.predefined) {
            throw new AssertionError();
        }
        this.created = created;
    }

    public void readExternal(Element element) {
        this.name = element.getAttributeValue(NAME_ATTRIBUTE_NAME);
        Attribute attribute = element.getAttribute(CREATED_ATTRIBUTE_NAME);
        if (attribute != null) {
            try {
                this.created = attribute.getLongValue();
            }
            catch (DataConversionException dataConversionException) {
                // empty catch block
            }
        }
    }

    public void writeExternal(Element element) {
        element.setAttribute(NAME_ATTRIBUTE_NAME, this.name);
        if (this.created > 0L) {
            element.setAttribute(CREATED_ATTRIBUTE_NAME, String.valueOf(this.created));
        }
    }

    public boolean isPredefined() {
        return this.predefined;
    }

    public void setPredefined(boolean predefined) {
        this.predefined = predefined;
    }

    public abstract MatchOptions getMatchOptions();

    public ReplaceOptions getReplaceOptions() {
        return null;
    }

    public abstract NamedScriptableDefinition findVariable(String var1);

    public abstract void removeUnusedVariables();

    public String getCurrentVariableName() {
        return this.myCurrentVariableName;
    }

    public void setCurrentVariableName(String variableName) {
        this.myCurrentVariableName = variableName;
    }

    @Override
    public int compareTo(Configuration other) {
        int result = StringUtil.naturalCompare((String)this.getCategory(), (String)other.getCategory());
        return result != 0 ? result : StringUtil.naturalCompare((String)this.getName(), (String)other.getName());
    }

    public boolean equals(Object configuration) {
        if (!(configuration instanceof Configuration)) {
            return false;
        }
        Configuration other = (Configuration)configuration;
        if (this.category != null ? !this.category.equals(other.category) : other.category != null) {
            return false;
        }
        return this.name.equals(other.name);
    }

    public int hashCode() {
        return 31 * this.name.hashCode() + (this.category != null ? this.category.hashCode() : 0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/plugin/ui/Configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/Configuration";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setCategory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

