/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher;

import com.intellij.dupLocator.iterators.ArrayBackedNodeIterator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.GlobalMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.handlers.SubstitutionHandler;
import com.intellij.structuralsearch.impl.matcher.iterators.SsrFilteringNodeIterator;
import com.intellij.xml.util.XmlUtil;

public class XmlMatchingVisitor
extends XmlElementVisitor {
    private final GlobalMatchingVisitor myMatchingVisitor;

    public XmlMatchingVisitor(GlobalMatchingVisitor matchingVisitor) {
        this.myMatchingVisitor = matchingVisitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitXmlAttribute(XmlAttribute attribute) {
        XmlAttribute another = (XmlAttribute)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.getMatchContext().pushResult();
        XmlElement name2 = attribute.getNameElement();
        boolean isTypedVar = this.myMatchingVisitor.getMatchContext().getPattern().isTypedVar((PsiElement)name2);
        try {
            if (!this.myMatchingVisitor.setResult(isTypedVar || this.myMatchingVisitor.matchText((PsiElement)name2, (PsiElement)another.getNameElement()))) {
                return;
            }
            XmlAttributeValue valueElement = attribute.getValueElement();
            this.myMatchingVisitor.setResult(valueElement == null || this.myMatchingVisitor.matchOptionally((PsiElement)valueElement, (PsiElement)another.getValueElement()));
        }
        finally {
            this.myMatchingVisitor.scopeMatch((PsiElement)name2, isTypedVar, (PsiElement)another);
        }
    }

    public void visitXmlAttributeValue(XmlAttributeValue value) {
        XmlAttributeValue another = (XmlAttributeValue)this.myMatchingVisitor.getElement();
        String text = value.getValue();
        if (this.myMatchingVisitor.getMatchContext().getPattern().isTypedVar(text)) {
            SubstitutionHandler handler = (SubstitutionHandler)this.myMatchingVisitor.getMatchContext().getPattern().getHandler(text);
            String text2 = another.getText();
            int offset = StringUtil.isQuotedString((String)text2) ? 1 : 0;
            this.myMatchingVisitor.setResult(handler.handle((PsiElement)another, offset, text2.length() - offset, this.myMatchingVisitor.getMatchContext()));
        } else {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchText(text, another.getValue()));
        }
    }

    public void visitXmlTag(XmlTag tag) {
        SsrFilteringNodeIterator matchNodes;
        XmlToken name2;
        XmlTag another = (XmlTag)this.myMatchingVisitor.getElement();
        CompiledPattern pattern = this.myMatchingVisitor.getMatchContext().getPattern();
        boolean isTypedVar = pattern.isTypedVar((PsiElement)(name2 = XmlUtil.getTokenOfType((PsiElement)tag, (IElementType)XmlTokenType.XML_NAME)));
        if (!this.myMatchingVisitor.setResult((isTypedVar || this.myMatchingVisitor.matchText(tag.getName(), another.getName())) && this.myMatchingVisitor.matchInAnyOrder((PsiElement[])tag.getAttributes(), (PsiElement[])another.getAttributes()))) {
            return;
        }
        SsrFilteringNodeIterator patternNodes = new SsrFilteringNodeIterator(new ArrayBackedNodeIterator((PsiElement[])tag.getValue().getChildren()));
        if (patternNodes.current() != null && !this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSequentially(patternNodes, matchNodes = new SsrFilteringNodeIterator(new ArrayBackedNodeIterator((PsiElement[])another.getValue().getChildren()))))) {
            return;
        }
        if (isTypedVar) {
            SubstitutionHandler handler = (SubstitutionHandler)pattern.getHandler((PsiElement)name2);
            this.myMatchingVisitor.setResult(handler.handle((PsiElement)XmlUtil.getTokenOfType((PsiElement)another, (IElementType)XmlTokenType.XML_NAME), this.myMatchingVisitor.getMatchContext()));
        }
    }

    public void visitXmlText(XmlText text) {
        PsiElement element = this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.getMatchContext().getPattern().isTypedVar((PsiElement)text) ? this.myMatchingVisitor.handleTypedElement((PsiElement)text, element) : element instanceof XmlText && this.myMatchingVisitor.matchText(text.getText().trim(), element.getText().trim()));
    }
}

