/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.tree.IElementType;

public class JavaMatchUtil {
    private JavaMatchUtil() {
    }

    public static String getCommentText(PsiComment comment) {
        if (comment instanceof PsiDocComment) {
            PsiDocComment docComment = (PsiDocComment)comment;
            StringBuilder result = new StringBuilder();
            for (PsiElement element : docComment.getDescriptionElements()) {
                result.append(element.getText());
            }
            return result.toString();
        }
        IElementType type = comment.getTokenType();
        String text = comment.getText();
        return type == JavaTokenType.END_OF_LINE_COMMENT ? StringUtil.trimStart((String)text, (String)"//") : StringUtil.trimEnd((String)text.substring(2), (String)"*/");
    }
}

