/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher;

import com.intellij.dupLocator.iterators.ArrayBackedNodeIterator;
import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.SimpleHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.SubstitutionHandler;
import com.intellij.structuralsearch.impl.matcher.strategies.MatchingStrategy;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public abstract class CompiledPattern {
    public static final Key<Object> HANDLER_KEY = Key.create((String)"ss.handler");
    private final Map<Object, MatchingHandler> handlers = new THashMap();
    private final MultiMap<String, PsiElement> variableNodes = MultiMap.createSmart();
    private SearchScope scope;
    private NodeIterator nodes;
    private MatchingStrategy strategy;
    private PsiElement targetNode;
    private int nodeCount;
    private PsiElement last;
    private MatchingHandler lastHandler;

    public abstract String[] getTypedVarPrefixes();

    public abstract boolean isTypedVar(String var1);

    public void setTargetNode(PsiElement element) {
        this.targetNode = element;
    }

    public PsiElement getTargetNode() {
        return this.targetNode;
    }

    public MatchingStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(MatchingStrategy strategy) {
        this.strategy = strategy;
    }

    public int getNodeCount() {
        return this.nodeCount;
    }

    public NodeIterator getNodes() {
        return this.nodes;
    }

    public void setNodes(List<PsiElement> elements) {
        this.nodes = new ArrayBackedNodeIterator(PsiUtilCore.toPsiElementArray(elements));
        this.nodeCount = elements.size();
    }

    @Contract(value="null -> false")
    public boolean isTypedVar(PsiElement element) {
        return element != null && this.isTypedVar(element.getText());
    }

    public boolean isRealTypedVar(PsiElement element) {
        if (element == null || element.getTextLength() <= 0) {
            return false;
        }
        String str = this.getTypedVarString(element);
        return !str.isEmpty() && this.isTypedVar(str);
    }

    @NotNull
    public String getTypedVarString(PsiElement element) {
        StructuralSearchProfile profile2 = StructuralSearchUtil.getProfileByPsiElement(element);
        if (profile2 == null) {
            String string = element.getText();
            if (string == null) {
                CompiledPattern.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = profile2.getTypedVarString(element);
        if (string == null) {
            CompiledPattern.$$$reportNull$$$0(1);
        }
        return string;
    }

    public MatchingHandler getHandlerSimple(PsiElement node) {
        return this.handlers.get(node);
    }

    public MatchingHandler getHandler(@NotNull PsiElement node) {
        if (node == null) {
            CompiledPattern.$$$reportNull$$$0(2);
        }
        if (node == this.last) {
            return this.lastHandler;
        }
        MatchingHandler handler = this.handlers.get(node);
        if (handler == null) {
            handler = new SimpleHandler();
            this.setHandler(node, handler);
        }
        this.last = node;
        this.lastHandler = handler;
        return handler;
    }

    public MatchingHandler getHandler(String name2) {
        return this.handlers.get(name2);
    }

    public void setHandler(PsiElement node, MatchingHandler handler) {
        this.last = null;
        this.handlers.put(node, handler);
    }

    public SubstitutionHandler createSubstitutionHandler(String name2, String compiledName, boolean target, int minOccurs, int maxOccurs, boolean greedy) {
        SubstitutionHandler handler = (SubstitutionHandler)this.handlers.get(compiledName);
        if (handler != null) {
            return handler;
        }
        handler = this.doCreateSubstitutionHandler(name2, target, minOccurs, maxOccurs, greedy);
        this.handlers.put(compiledName, handler);
        return handler;
    }

    protected SubstitutionHandler doCreateSubstitutionHandler(String name2, boolean target, int minOccurs, int maxOccurs, boolean greedy) {
        return new SubstitutionHandler(name2, target, minOccurs, maxOccurs, greedy);
    }

    public SearchScope getScope() {
        return this.scope;
    }

    public void setScope(SearchScope scope) {
        this.scope = scope;
    }

    public void clearHandlers() {
        this.handlers.clear();
        this.last = null;
        this.lastHandler = null;
    }

    void clearHandlersState() {
        for (MatchingHandler h : this.handlers.values()) {
            if (h == null) continue;
            h.reset();
        }
    }

    public boolean isToResetHandler(PsiElement element) {
        return true;
    }

    @NotNull
    public List<PsiElement> getVariableNodes(@NotNull String name2) {
        Collection elements;
        if (name2 == null) {
            CompiledPattern.$$$reportNull$$$0(3);
        }
        List list = (elements = this.variableNodes.get((Object)name2)) instanceof List ? (List)elements : new SmartList(elements);
        if (list == null) {
            CompiledPattern.$$$reportNull$$$0(4);
        }
        return list;
    }

    public void putVariableNode(@NotNull String name2, @NotNull PsiElement node) {
        if (name2 == null) {
            CompiledPattern.$$$reportNull$$$0(5);
        }
        if (node == null) {
            CompiledPattern.$$$reportNull$$$0(6);
        }
        this.variableNodes.putValue((Object)name2, (Object)node);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/impl/matcher/CompiledPattern";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypedVarString";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/impl/matcher/CompiledPattern";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableNodes";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getHandler";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getVariableNodes";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "putVariableNode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

