/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.dupLocator.AbstractMatchingVisitor;
import com.intellij.dupLocator.equivalence.EquivalenceDescriptor;
import com.intellij.dupLocator.equivalence.EquivalenceDescriptorProvider;
import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.dupLocator.util.DuplocatorUtil;
import com.intellij.dupLocator.util.NodeFilter;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.structuralsearch.DocumentBasedReplaceHandler;
import com.intellij.structuralsearch.StructuralReplaceHandler;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.GlobalMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;
import com.intellij.structuralsearch.impl.matcher.compiler.GlobalCompilingVisitor;
import com.intellij.structuralsearch.impl.matcher.handlers.DelegatingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.LightTopLevelMatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.SkippingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.SubstitutionHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.TopLevelMatchingHandler;
import com.intellij.structuralsearch.impl.matcher.iterators.SsrFilteringNodeIterator;
import com.intellij.structuralsearch.impl.matcher.strategies.MatchingStrategy;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.util.ArrayUtil;
import com.intellij.util.LocalTimeCounter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StructuralSearchProfileBase
extends StructuralSearchProfile {
    private static final String DELIMETER_CHARS = ",;.[]{}():";
    protected static final String PATTERN_PLACEHOLDER = "$$PATTERN_PLACEHOLDER$$";

    @Override
    public void compile(PsiElement[] elements, final @NotNull GlobalCompilingVisitor globalVisitor) {
        if (globalVisitor == null) {
            StructuralSearchProfileBase.$$$reportNull$$$0(0);
        }
        PsiElement topElement = elements[0].getParent();
        PsiElement element = elements.length > 1 ? topElement : elements[0];
        element.accept((PsiElementVisitor)new MyCompilingVisitor(globalVisitor, topElement));
        element.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

            public void visitElement(PsiElement element) {
                MatchingHandler delegate;
                super.visitElement(element);
                if (DuplocatorUtil.isIgnoredNode(element)) {
                    return;
                }
                CompiledPattern pattern = globalVisitor.getContext().getPattern();
                MatchingHandler handler = pattern.getHandler(element);
                if (!(handler instanceof SubstitutionHandler || handler instanceof TopLevelMatchingHandler || handler instanceof LightTopLevelMatchingHandler)) {
                    pattern.setHandler(element, new SkippingHandler(handler));
                }
                if (handler instanceof LightTopLevelMatchingHandler && !((delegate = ((LightTopLevelMatchingHandler)handler).getDelegate()) instanceof SubstitutionHandler)) {
                    pattern.setHandler(element, new LightTopLevelMatchingHandler(new SkippingHandler(delegate)));
                }
            }
        });
        final Language baseLanguage = element.getContainingFile().getLanguage();
        globalVisitor.getContext().getPattern().setStrategy(new MatchingStrategy(){

            @Override
            public boolean continueMatching(PsiElement start) {
                Language fileLanguage;
                Language language = start.getLanguage();
                PsiFile file = start.getContainingFile();
                if (file != null && (fileLanguage = file.getLanguage()).isKindOf(language)) {
                    language = fileLanguage;
                }
                return language == baseLanguage;
            }

            @Override
            public boolean shouldSkip(PsiElement element, PsiElement elementToMatchWith) {
                return DuplocatorUtil.shouldSkip(element, elementToMatchWith);
            }
        });
    }

    @Override
    @NotNull
    public PsiElementVisitor createMatchingVisitor(@NotNull GlobalMatchingVisitor globalVisitor) {
        if (globalVisitor == null) {
            StructuralSearchProfileBase.$$$reportNull$$$0(1);
        }
        MyMatchingVisitor myMatchingVisitor = new MyMatchingVisitor(globalVisitor);
        if (myMatchingVisitor == null) {
            StructuralSearchProfileBase.$$$reportNull$$$0(2);
        }
        return myMatchingVisitor;
    }

    @Override
    @NotNull
    public NodeFilter getLexicalNodesFilter() {
        NodeFilter nodeFilter = element -> DuplocatorUtil.isIgnoredNode(element);
        if (nodeFilter == null) {
            StructuralSearchProfileBase.$$$reportNull$$$0(3);
        }
        return nodeFilter;
    }

    public static boolean containsOnlyDelimeters(String s) {
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            if (DELIMETER_CHARS.indexOf(s.charAt(i)) >= 0) continue;
            return false;
        }
        return true;
    }

    @NotNull
    protected abstract String[] getVarPrefixes();

    @Override
    @NotNull
    public CompiledPattern createCompiledPattern() {
        CompiledPattern compiledPattern = new CompiledPattern(){

            @Override
            protected SubstitutionHandler doCreateSubstitutionHandler(String name2, boolean target, int minOccurs, int maxOccurs, boolean greedy) {
                return new MySubstitutionHandler(name2, target, minOccurs, maxOccurs, greedy);
            }

            @Override
            public String[] getTypedVarPrefixes() {
                return StructuralSearchProfileBase.this.getVarPrefixes();
            }

            @Override
            public boolean isTypedVar(String str) {
                for (String prefix : StructuralSearchProfileBase.this.getVarPrefixes()) {
                    if (!str.startsWith(prefix)) continue;
                    return true;
                }
                return false;
            }

            @Override
            @NotNull
            public String getTypedVarString(PsiElement element) {
                PsiElement initialElement = element;
                PsiElement child = SkippingHandler.getOnlyNonWhitespaceChild(element);
                while (child != element && child != null && !(child instanceof LeafElement)) {
                    element = child;
                    child = SkippingHandler.getOnlyNonWhitespaceChild(element);
                }
                String string = child instanceof LeafElement ? element.getText() : initialElement.getText();
                if (string == null) {
                    3.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/StructuralSearchProfileBase$3", "getTypedVarString"));
            }
        };
        if (compiledPattern == null) {
            StructuralSearchProfileBase.$$$reportNull$$$0(4);
        }
        return compiledPattern;
    }

    @Override
    public boolean isMyLanguage(@NotNull Language language) {
        if (language == null) {
            StructuralSearchProfileBase.$$$reportNull$$$0(5);
        }
        return language.isKindOf(this.getFileType().getLanguage());
    }

    @NotNull
    protected abstract LanguageFileType getFileType();

    @Override
    @NotNull
    public PsiElement[] createPatternTree(@NotNull String text, @NotNull PatternTreeContext context, @NotNull FileType fileType, @Nullable Language language, @Nullable String contextName, @Nullable String extension, @NotNull Project project2, boolean physical) {
        if (text == null) {
            StructuralSearchProfileBase.$$$reportNull$$$0(6);
        }
        if (context == null) {
            StructuralSearchProfileBase.$$$reportNull$$$0(7);
        }
        if (fileType == null) {
            StructuralSearchProfileBase.$$$reportNull$$$0(8);
        }
        if (project2 == null) {
            StructuralSearchProfileBase.$$$reportNull$$$0(9);
        }
        if (context == PatternTreeContext.Block) {
            String strContext = this.getContext(text, language, contextName);
            PsiElement[] psiElementArray = strContext != null ? StructuralSearchProfileBase.parsePattern(project2, strContext, text, fileType, language, extension, physical) : PsiElement.EMPTY_ARRAY;
            if (psiElementArray == null) {
                StructuralSearchProfileBase.$$$reportNull$$$0(10);
            }
            return psiElementArray;
        }
        PsiElement[] psiElementArray = super.createPatternTree(text, context, fileType, language, contextName, extension, project2, physical);
        if (psiElementArray == null) {
            StructuralSearchProfileBase.$$$reportNull$$$0(11);
        }
        return psiElementArray;
    }

    @Override
    public void checkReplacementPattern(Project project2, ReplaceOptions options) {
    }

    @Override
    public StructuralReplaceHandler getReplaceHandler(@NotNull Project project2, @NotNull ReplaceOptions replaceOptionss) {
        if (project2 == null) {
            StructuralSearchProfileBase.$$$reportNull$$$0(12);
        }
        if (replaceOptionss == null) {
            StructuralSearchProfileBase.$$$reportNull$$$0(13);
        }
        return new DocumentBasedReplaceHandler(project2);
    }

    @NotNull
    public String[] getContextNames() {
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            StructuralSearchProfileBase.$$$reportNull$$$0(14);
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @Nullable
    protected String getContext(@NotNull String pattern, @Nullable Language language, @Nullable String contextName) {
        if (pattern == null) {
            StructuralSearchProfileBase.$$$reportNull$$$0(15);
        }
        return PATTERN_PLACEHOLDER;
    }

    private static boolean canBePatternVariable(PsiElement element) {
        if (element instanceof LeafElement) {
            return true;
        }
        while (!(element instanceof LeafElement) && element != null) {
            element = SkippingHandler.getOnlyNonWhitespaceChild(element);
        }
        return element != null;
    }

    protected boolean isStringLiteral(PsiElement element) {
        if (element == null) {
            return false;
        }
        ASTNode astNode = element.getNode();
        if (astNode == null) {
            return false;
        }
        IElementType elementType = astNode.getElementType();
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(element.getLanguage());
        if (parserDefinition != null) {
            TokenSet literals = parserDefinition.getStringLiteralElements();
            return literals.contains(elementType);
        }
        return false;
    }

    private static boolean canBePatternVariableValue(PsiElement element) {
        return !StructuralSearchProfileBase.containsOnlyDelimeters(element.getText());
    }

    @Override
    public boolean canBeVarDelimeter(@NotNull PsiElement element) {
        ASTNode node;
        if (element == null) {
            StructuralSearchProfileBase.$$$reportNull$$$0(16);
        }
        return (node = element.getNode()) != null && this.getVariableDelimiters().contains(node.getElementType());
    }

    protected TokenSet getVariableDelimiters() {
        return TokenSet.EMPTY;
    }

    public static PsiElement[] parsePattern(Project project2, String context, String pattern, FileType fileType, Language language, String extension, boolean physical) {
        PsiFile file;
        int offset = context.indexOf(PATTERN_PLACEHOLDER);
        int patternLength = pattern.length();
        String patternInContext = context.replace(PATTERN_PLACEHOLDER, pattern);
        String ext = extension != null ? extension : fileType.getDefaultExtension();
        String name2 = "__dummy." + ext;
        PsiFileFactory factory = PsiFileFactory.getInstance((Project)project2);
        PsiFile psiFile = file = language == null ? factory.createFileFromText(name2, fileType, (CharSequence)patternInContext, LocalTimeCounter.currentTime(), physical, true) : factory.createFileFromText(name2, language, (CharSequence)patternInContext, physical, true);
        if (file == null) {
            return PsiElement.EMPTY_ARRAY;
        }
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        PsiElement element = file.findElementAt(offset);
        if (element == null) {
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement topElement = element;
        for (element = element.getParent(); element != null; element = element.getParent()) {
            if (element.getTextRange().getStartOffset() != offset || element.getTextLength() > patternLength) continue;
            topElement = element;
        }
        if (topElement instanceof PsiFile) {
            return topElement.getChildren();
        }
        int endOffset = offset + patternLength;
        result.add(topElement);
        for (topElement = topElement.getNextSibling(); topElement != null && topElement.getTextRange().getEndOffset() <= endOffset; topElement = topElement.getNextSibling()) {
            result.add(topElement);
        }
        return result.toArray(PsiElement.EMPTY_ARRAY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalVisitor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/StructuralSearchProfileBase";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replaceOptionss";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/StructuralSearchProfileBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createMatchingVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLexicalNodesFilter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompiledPattern";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createPatternTree";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "compile";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createMatchingVisitor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 14: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isMyLanguage";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createPatternTree";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getReplaceHandler";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getContext";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "canBeVarDelimeter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MySubstitutionHandler
    extends SubstitutionHandler {
        final Set<PsiElement> myExceptedNodes = new HashSet<PsiElement>();

        MySubstitutionHandler(String name2, boolean target, int minOccurs, int maxOccurs, boolean greedy) {
            super(name2, target, minOccurs, maxOccurs, greedy);
        }

        @Override
        public boolean matchSequentially(NodeIterator patternNodes, NodeIterator matchNodes, MatchContext context) {
            if (this.doMatchSequentially(patternNodes, matchNodes, context)) {
                return true;
            }
            PsiElement current = patternNodes.current();
            if (current != null) {
                this.myExceptedNodes.add(current);
            }
            boolean result = this.doMatchSequentiallyBySimpleHandler(patternNodes, matchNodes, context);
            this.myExceptedNodes.remove(current);
            return result;
        }
    }

    private class MyMatchingVisitor
    extends PsiElementVisitor {
        private final GlobalMatchingVisitor myGlobalVisitor;

        private MyMatchingVisitor(GlobalMatchingVisitor globalVisitor) {
            this.myGlobalVisitor = globalVisitor;
        }

        private boolean shouldIgnoreVarNode(PsiElement element) {
            MatchingHandler handler = this.myGlobalVisitor.getMatchContext().getPattern().getHandlerSimple(element);
            if (handler instanceof DelegatingHandler) {
                handler = ((DelegatingHandler)((Object)handler)).getDelegate();
            }
            return handler instanceof MySubstitutionHandler && ((MySubstitutionHandler)handler).myExceptedNodes.contains(element);
        }

        public void visitElement(PsiElement element) {
            super.visitElement(element);
            EquivalenceDescriptorProvider descriptorProvider = EquivalenceDescriptorProvider.getInstance(element);
            if (descriptorProvider != null) {
                EquivalenceDescriptor descriptor1 = descriptorProvider.buildDescriptor(element);
                EquivalenceDescriptor descriptor2 = descriptorProvider.buildDescriptor(this.myGlobalVisitor.getElement());
                if (descriptor1 != null && descriptor2 != null) {
                    boolean result = DuplocatorUtil.match(descriptor1, descriptor2, (AbstractMatchingVisitor)this.myGlobalVisitor, Collections.emptySet(), null);
                    this.myGlobalVisitor.setResult(result);
                    return;
                }
            }
            if (StructuralSearchProfileBase.this.isStringLiteral(element)) {
                this.visitLiteral(element);
                return;
            }
            if (StructuralSearchProfileBase.canBePatternVariable(element) && this.myGlobalVisitor.getMatchContext().getPattern().isRealTypedVar(element) && !this.shouldIgnoreVarNode(element)) {
                PsiElement matchedElement = this.myGlobalVisitor.getElement();
                PsiElement newElement = SkippingHandler.skipNodeIfNeccessary(matchedElement);
                while (newElement != matchedElement) {
                    matchedElement = newElement;
                    newElement = SkippingHandler.skipNodeIfNeccessary(matchedElement);
                }
                this.myGlobalVisitor.setResult(this.myGlobalVisitor.handleTypedElement(element, matchedElement));
            } else if (element instanceof LeafElement) {
                this.myGlobalVisitor.setResult(element.getText().equals(this.myGlobalVisitor.getElement().getText()));
            } else if (element.getFirstChild() == null && element.getTextLength() == 0) {
                this.myGlobalVisitor.setResult(true);
            } else {
                PsiElement patternChild = element.getFirstChild();
                PsiElement matchedChild = this.myGlobalVisitor.getElement().getFirstChild();
                SsrFilteringNodeIterator patternIterator = new SsrFilteringNodeIterator(patternChild);
                SsrFilteringNodeIterator matchedIterator = new SsrFilteringNodeIterator(matchedChild);
                boolean matched = this.myGlobalVisitor.matchSequentially(patternIterator, matchedIterator);
                this.myGlobalVisitor.setResult(matched);
            }
        }

        private void visitLiteral(PsiElement literal) {
            PsiElement l2 = this.myGlobalVisitor.getElement();
            MatchingHandler handler = (MatchingHandler)literal.getUserData(CompiledPattern.HANDLER_KEY);
            if (handler instanceof SubstitutionHandler) {
                char c;
                int offset = 0;
                int length = l2.getTextLength();
                String text = l2.getText();
                if (length > 2 && ((c = text.charAt(0)) == '\"' || c == '\'') && text.charAt(length - 1) == c) {
                    boolean looseMatching = this.myGlobalVisitor.getMatchContext().getOptions().isLooseMatching();
                    if (!looseMatching && c != literal.getText().charAt(0)) {
                        this.myGlobalVisitor.setResult(false);
                        return;
                    }
                    --length;
                    ++offset;
                }
                this.myGlobalVisitor.setResult(((SubstitutionHandler)handler).handle(l2, offset, length, this.myGlobalVisitor.getMatchContext()));
            } else if (handler != null) {
                this.myGlobalVisitor.setResult(handler.match(literal, l2, this.myGlobalVisitor.getMatchContext()));
            } else {
                this.myGlobalVisitor.setResult(literal.textMatches(l2));
            }
        }
    }

    private class MyCompilingVisitor
    extends PsiRecursiveElementVisitor {
        private final GlobalCompilingVisitor myGlobalVisitor;
        private final PsiElement myTopElement;
        private Pattern[] mySubstitutionPatterns;

        private MyCompilingVisitor(GlobalCompilingVisitor globalVisitor, PsiElement topElement) {
            this.myGlobalVisitor = globalVisitor;
            this.myTopElement = topElement;
        }

        public void visitElement(PsiElement element) {
            this.doVisitElement(element);
            if (StructuralSearchProfileBase.this.isStringLiteral(element)) {
                this.visitLiteral(element);
            }
        }

        private void doVisitElement(PsiElement element) {
            ParserDefinition parserDefinition;
            CompiledPattern pattern = this.myGlobalVisitor.getContext().getPattern();
            if (this.myGlobalVisitor.getCodeBlockLevel() == 0) {
                this.initTopLevelElement(element);
                return;
            }
            if (StructuralSearchProfileBase.canBePatternVariable(element) && pattern.isRealTypedVar(element)) {
                this.myGlobalVisitor.handle(element);
                MatchingHandler handler = pattern.getHandler(element);
                handler.setFilter(new NodeFilter(){

                    @Override
                    public boolean accepts(PsiElement other) {
                        return StructuralSearchProfileBase.canBePatternVariableValue(other);
                    }
                });
                super.visitElement(element);
                return;
            }
            super.visitElement(element);
            if (this.myGlobalVisitor.getContext().getSearchHelper().doOptimizing() && element instanceof LeafElement && (parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(element.getLanguage())) != null) {
                String text = element.getText();
                boolean flag = true;
                if (StringUtil.isJavaIdentifier((String)text) && flag) {
                    this.myGlobalVisitor.processTokenizedName(text, true, GlobalCompilingVisitor.OccurenceKind.CODE);
                }
            }
        }

        private void visitLiteral(PsiElement literal) {
            String value = literal.getText();
            if (StringUtil.isQuotedString((String)value)) {
                if (this.mySubstitutionPatterns == null) {
                    String[] prefixes = this.myGlobalVisitor.getContext().getPattern().getTypedVarPrefixes();
                    this.mySubstitutionPatterns = this.createPatterns(prefixes);
                }
                for (Pattern substitutionPattern : this.mySubstitutionPatterns) {
                    MatchingHandler handler = this.myGlobalVisitor.processPatternStringWithFragments(value, GlobalCompilingVisitor.OccurenceKind.LITERAL, substitutionPattern);
                    if (handler == null) continue;
                    literal.putUserData(CompiledPattern.HANDLER_KEY, (Object)handler);
                    break;
                }
            }
        }

        private Pattern[] createPatterns(String[] prefixes) {
            Pattern[] patterns = new Pattern[prefixes.length];
            for (int i = 0; i < prefixes.length; ++i) {
                String s = StructuralSearchUtil.shieldRegExpMetaChars(prefixes[i]);
                patterns[i] = Pattern.compile("\\b(" + s + "\\w+)\\b");
            }
            return patterns;
        }

        private void initTopLevelElement(PsiElement element) {
            CompiledPattern pattern = this.myGlobalVisitor.getContext().getPattern();
            PsiElement newElement = SkippingHandler.skipNodeIfNeccessary(element);
            if (element != newElement && newElement != null) {
                newElement.accept((PsiElementVisitor)this);
                pattern.setHandler(element, new LightTopLevelMatchingHandler(pattern.getHandler(element)));
            } else {
                this.myGlobalVisitor.setCodeBlockLevel(this.myGlobalVisitor.getCodeBlockLevel() + 1);
                for (PsiElement el = element.getFirstChild(); el != null; el = el.getNextSibling()) {
                    if (GlobalCompilingVisitor.getFilter().accepts(el)) {
                        if (!(el instanceof PsiWhiteSpace)) continue;
                        this.myGlobalVisitor.addLexicalNode(el);
                        continue;
                    }
                    el.accept((PsiElementVisitor)this);
                    MatchingHandler matchingHandler = pattern.getHandler(el);
                    pattern.setHandler(el, element == this.myTopElement ? new TopLevelMatchingHandler(matchingHandler) : new LightTopLevelMatchingHandler(matchingHandler));
                }
                this.myGlobalVisitor.setCodeBlockLevel(this.myGlobalVisitor.getCodeBlockLevel() - 1);
                pattern.setHandler(element, new TopLevelMatchingHandler(pattern.getHandler(element)));
            }
        }
    }
}

