/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.dupLocator.iterators.ArrayBackedNodeIterator;
import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.structuralsearch.DefaultMatchResultSink;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.MatchResultSink;
import com.intellij.structuralsearch.MatchingProcess;
import com.intellij.structuralsearch.StructuralSearchException;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.UnsupportedPatternException;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.GlobalMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.MatcherImplUtil;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;
import com.intellij.structuralsearch.impl.matcher.compiler.PatternCompiler;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.TopLevelMatchingHandler;
import com.intellij.structuralsearch.impl.matcher.iterators.SingleNodeIterator;
import com.intellij.structuralsearch.impl.matcher.iterators.SsrFilteringNodeIterator;
import com.intellij.structuralsearch.impl.matcher.strategies.MatchingStrategy;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.ConfigurationManager;
import com.intellij.structuralsearch.plugin.util.CollectingMatchResultSink;
import com.intellij.structuralsearch.plugin.util.DuplicateFilteringResultSink;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PairProcessor;
import com.intellij.util.SmartList;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class Matcher {
    static final Logger LOG = Logger.getInstance((String)"#com.intellij.structuralsearch.impl.matcher.MatcherImpl");
    private static final ThreadLocal<Set<String>> ourRecursionGuard = ThreadLocal.withInitial(() -> new HashSet());
    final Project project;
    final DumbService myDumbService;
    final MatchContext matchContext;
    private boolean isTesting;
    private final GlobalMatchingVisitor visitor = new GlobalMatchingVisitor();
    ProgressIndicator progress;
    private final TaskScheduler scheduler = new TaskScheduler();
    int totalFilesToScan;
    int scannedFilesCount;

    public Matcher(Project project2) {
        this(project2, null);
    }

    public Matcher(Project project2, MatchOptions matchOptions) {
        this.project = project2;
        this.matchContext = new MatchContext();
        this.matchContext.setMatcher(this.visitor);
        if (matchOptions != null) {
            this.matchContext.setOptions(matchOptions);
            this.matchContext.setPattern(PatternCompiler.compilePattern(project2, matchOptions, false));
        }
        this.myDumbService = DumbService.getInstance((Project)project2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Matcher buildMatcher(Project project2, FileType fileType, String constraint) {
        if (StringUtil.isQuotedString((String)constraint)) {
            MatchOptions myMatchOptions = new MatchOptions();
            myMatchOptions.setFileType(fileType);
            myMatchOptions.fillSearchCriteria(StringUtil.unquoteString((String)constraint));
            return new Matcher(project2, myMatchOptions);
        }
        Set<String> set = ourRecursionGuard.get();
        if (!set.add(constraint)) {
            throw new MalformedPatternException("Pattern recursively references itself");
        }
        try {
            Configuration configuration = ConfigurationManager.getInstance(project2).findConfigurationByName(constraint);
            if (configuration == null) {
                throw new MalformedPatternException("Configuration '" + constraint + "' not found");
            }
            Matcher matcher = new Matcher(project2, configuration.getMatchOptions());
            return matcher;
        }
        finally {
            set.remove(constraint);
            if (set.isEmpty()) {
                ourRecursionGuard.remove();
            }
        }
    }

    public static void validate(Project project2, MatchOptions options) {
        PatternCompiler.compilePattern(project2, options, true);
    }

    public static boolean checkIfShouldAttemptToMatch(MatchContext context, NodeIterator matchedNodes) {
        CompiledPattern pattern = context.getPattern();
        NodeIterator patternNodes = pattern.getNodes();
        try {
            while (true) {
                PsiElement patternNode;
                if ((patternNode = patternNodes.current()) == null) {
                    boolean bl = true;
                    return bl;
                }
                PsiElement matchedNode = matchedNodes.current();
                if (matchedNode == null) {
                    boolean bl = false;
                    return bl;
                }
                MatchingHandler matchingHandler = pattern.getHandler(patternNode);
                if (matchingHandler == null || !matchingHandler.canMatch(patternNode, matchedNode, context)) {
                    boolean bl = false;
                    return bl;
                }
                matchedNodes.advance();
                patternNodes.advance();
            }
        }
        finally {
            patternNodes.reset();
            matchedNodes.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMatchesInElement(MatchContext context, Configuration configuration, NodeIterator matchedNodes, PairProcessor<MatchResult, Configuration> processor) {
        try {
            this.configureOptions(context, configuration, matchedNodes.current(), processor);
            context.setShouldRecursivelyMatch(false);
            this.visitor.matchContext(matchedNodes);
        }
        finally {
            matchedNodes.reset();
            context.getOptions().setScope(null);
        }
    }

    public boolean matchNode(@NotNull PsiElement element) {
        MatchOptions options;
        CollectingMatchResultSink sink;
        CompiledPattern compiledPattern;
        if (element == null) {
            Matcher.$$$reportNull$$$0(0);
        }
        if ((compiledPattern = this.prepareMatching(sink = new CollectingMatchResultSink(), options = this.matchContext.getOptions())) == null) {
            return false;
        }
        this.matchContext.setShouldRecursivelyMatch(false);
        this.visitor.matchContext(SingleNodeIterator.newSingleNodeIterator(element));
        return !sink.getMatches().isEmpty();
    }

    public void clearContext() {
        this.matchContext.clear();
    }

    private void configureOptions(MatchContext context, final Configuration configuration, PsiElement psiFile, final PairProcessor<MatchResult, Configuration> processor) {
        if (psiFile == null) {
            return;
        }
        this.matchContext.clear();
        this.matchContext.setMatcher(this.visitor);
        MatchOptions options = context.getOptions();
        this.matchContext.setOptions(options);
        this.matchContext.setPattern(context.getPattern());
        this.matchContext.setShouldRecursivelyMatch(context.shouldRecursivelyMatch());
        this.visitor.setMatchContext(this.matchContext);
        this.matchContext.setSink(new DuplicateFilteringResultSink(new DefaultMatchResultSink(){

            @Override
            public void newMatch(MatchResult result) {
                processor.process((Object)result, (Object)configuration);
            }
        }));
    }

    public void precompileOptions(List<Configuration> configurations, Map<Configuration, MatchContext> out) {
        for (Configuration configuration : configurations) {
            if (out.containsKey(configuration)) continue;
            MatchContext matchContext = new MatchContext();
            matchContext.setMatcher(this.visitor);
            MatchOptions matchOptions = configuration.getMatchOptions();
            matchContext.setOptions(matchOptions);
            try {
                matchContext.setPattern(PatternCompiler.compilePattern(this.project, matchOptions, false));
                out.put(configuration, matchContext);
            }
            catch (StructuralSearchException e) {
                LOG.warn("Malformed structural search inspection pattern \"" + configuration.getName() + '\"', (Throwable)e);
                out.put(configuration, null);
            }
        }
    }

    public void findMatches(MatchResultSink sink, MatchOptions options) throws MalformedPatternException, UnsupportedPatternException {
        CompiledPattern compiledPattern = this.prepareMatching(sink, options);
        if (compiledPattern == null) {
            return;
        }
        this.matchContext.getSink().setMatchingProcess(this.scheduler);
        this.scheduler.init();
        this.progress = this.matchContext.getSink().getProgressIndicator();
        if (this.isTesting) {
            PsiElement[] elements = ((LocalSearchScope)options.getScope()).getScope();
            PsiElement parent = elements[0].getParent();
            if (this.matchContext.getPattern().getStrategy().continueMatching(parent != null ? parent : elements[0])) {
                this.visitor.matchContext(new SsrFilteringNodeIterator(new ArrayBackedNodeIterator(elements)));
            } else {
                LanguageFileType fileType = (LanguageFileType)this.matchContext.getOptions().getFileType();
                Language language = fileType.getLanguage();
                for (PsiElement element : elements) {
                    this.match(element, language);
                }
            }
            this.matchContext.getSink().matchingFinished();
            return;
        }
        if (!this.findMatches(options, compiledPattern)) {
            return;
        }
        if (this.scheduler.getTaskQueueEndAction() == null) {
            this.scheduler.setTaskQueueEndAction(() -> this.matchContext.getSink().matchingFinished());
        }
        this.scheduler.executeNext();
    }

    private boolean findMatches(MatchOptions options, CompiledPattern compiledPattern) {
        boolean ourOptimizedScope;
        SearchScope searchScope = compiledPattern.getScope();
        boolean bl = ourOptimizedScope = searchScope != null;
        if (!ourOptimizedScope) {
            searchScope = options.getScope();
        }
        if (searchScope instanceof GlobalSearchScope) {
            GlobalSearchScope scope = (GlobalSearchScope)searchScope;
            ContentIterator ci = fileOrDir -> {
                if (!fileOrDir.isDirectory() && scope.contains(fileOrDir) && fileOrDir.getFileType() != FileTypes.UNKNOWN) {
                    ++this.totalFilesToScan;
                    this.scheduler.addOneTask(new MatchOneVirtualFile(fileOrDir));
                }
                return true;
            };
            ReadAction.run(() -> FileBasedIndex.getInstance().iterateIndexableFiles(ci, this.project, this.progress));
            this.progress.setText2("");
        } else {
            PsiElement[] elementsToScan = ((LocalSearchScope)searchScope).getScope();
            this.totalFilesToScan = elementsToScan.length;
            for (int i = 0; i < elementsToScan.length; ++i) {
                PsiElement psiElement = elementsToScan[i];
                if (psiElement == null) continue;
                this.scheduler.addOneTask(new MatchOnePsiFile(psiElement));
                if (!ourOptimizedScope) continue;
                elementsToScan[i] = null;
            }
        }
        return true;
    }

    private CompiledPattern prepareMatching(MatchResultSink sink, MatchOptions options) {
        this.matchContext.clear();
        this.matchContext.setSink(new DuplicateFilteringResultSink(sink));
        this.matchContext.setOptions(options);
        this.matchContext.setMatcher(this.visitor);
        this.matchContext.setPattern(PatternCompiler.compilePattern(this.project, options, false));
        this.visitor.setMatchContext(this.matchContext);
        return this.matchContext.getPattern();
    }

    public List<MatchResult> testFindMatches(String source, MatchOptions options, boolean fileContext, FileType sourceFileType, String sourceExtension, boolean physicalSourceFile) throws MalformedPatternException, UnsupportedPatternException {
        CollectingMatchResultSink sink = new CollectingMatchResultSink();
        try {
            PsiElement[] elements = MatcherImplUtil.createSourceTreeFromText(source, fileContext ? PatternTreeContext.File : PatternTreeContext.Block, sourceFileType, sourceExtension, this.project, physicalSourceFile);
            options.setScope((SearchScope)new LocalSearchScope(elements));
            this.testFindMatches(sink, options);
        }
        catch (IncorrectOperationException e) {
            MalformedPatternException exception = new MalformedPatternException();
            exception.initCause(e);
            throw exception;
        }
        finally {
            options.setScope(null);
        }
        return sink.getMatches();
    }

    public List<MatchResult> testFindMatches(String source, MatchOptions options, boolean fileContext) throws MalformedPatternException, UnsupportedPatternException {
        return this.testFindMatches(source, options, fileContext, options.getFileType(), null, false);
    }

    public void testFindMatches(MatchResultSink sink, MatchOptions options) throws MalformedPatternException, UnsupportedPatternException {
        this.isTesting = true;
        try {
            this.findMatches(sink, options);
        }
        finally {
            this.isTesting = false;
        }
    }

    void match(@NotNull PsiElement element, Language language) {
        if (element == null) {
            Matcher.$$$reportNull$$$0(1);
        }
        MatchingStrategy strategy = this.matchContext.getPattern().getStrategy();
        Language elementLanguage = element.getLanguage();
        if (strategy.continueMatching(element) && elementLanguage.isKindOf(language)) {
            this.visitor.matchContext(SingleNodeIterator.newSingleNodeIterator(element));
            return;
        }
        for (PsiElement el = element.getFirstChild(); el != null; el = el.getNextSibling()) {
            this.match(el, language);
        }
        if (element instanceof PsiLanguageInjectionHost) {
            InjectedLanguageManager.getInstance((Project)this.project).enumerate(element, (injectedPsi, places) -> this.match((PsiElement)injectedPsi, language));
        }
    }

    @NotNull
    public List<MatchResult> matchByDownUp(PsiElement element) throws MalformedPatternException, UnsupportedPatternException {
        CollectingMatchResultSink sink = new CollectingMatchResultSink();
        MatchOptions options = this.matchContext.getOptions();
        CompiledPattern compiledPattern = this.prepareMatching(sink, options);
        this.matchContext.setShouldRecursivelyMatch(false);
        PsiElement targetNode = compiledPattern.getTargetNode();
        PsiElement elementToStartMatching = null;
        if (targetNode == null) {
            targetNode = compiledPattern.getNodes().current();
            if (targetNode != null) {
                compiledPattern.getNodes().advance();
                assert (!compiledPattern.getNodes().hasNext());
                compiledPattern.getNodes().rewind();
                element = element.getParent();
                if (element == null) {
                    List<MatchResult> list = Collections.emptyList();
                    if (list == null) {
                        Matcher.$$$reportNull$$$0(2);
                    }
                    return list;
                }
                while (element.getClass() != targetNode.getClass()) {
                    if ((element = element.getParent()) != null) continue;
                    List<MatchResult> list = Collections.emptyList();
                    if (list == null) {
                        Matcher.$$$reportNull$$$0(3);
                    }
                    return list;
                }
                elementToStartMatching = element;
            }
        } else {
            StructuralSearchProfile profile2 = StructuralSearchUtil.getProfileByPsiElement(element);
            if (profile2 == null) {
                List<MatchResult> list = Collections.emptyList();
                if (list == null) {
                    Matcher.$$$reportNull$$$0(4);
                }
                return list;
            }
            targetNode = profile2.extendMatchedByDownUp(targetNode);
            MatchingHandler handler = null;
            while (element.getClass() == targetNode.getClass() || compiledPattern.isTypedVar(targetNode) && compiledPattern.getHandler(targetNode).canMatch(targetNode, element, this.matchContext)) {
                handler = compiledPattern.getHandler(targetNode);
                handler.setPinnedElement(element);
                elementToStartMatching = element;
                if (handler instanceof TopLevelMatchingHandler) break;
                element = element.getParent();
                targetNode = targetNode.getParent();
                if (!options.isLooseMatching()) continue;
                element = profile2.updateCurrentNode(element);
                targetNode = profile2.updateCurrentNode(targetNode);
            }
            if (!(handler instanceof TopLevelMatchingHandler)) {
                List<MatchResult> list = Collections.emptyList();
                if (list == null) {
                    Matcher.$$$reportNull$$$0(5);
                }
                return list;
            }
        }
        assert (targetNode != null) : "Could not match down up when no target node";
        this.visitor.matchContext(SingleNodeIterator.newSingleNodeIterator(elementToStartMatching));
        this.matchContext.getSink().matchingFinished();
        List<MatchResult> list = sink.getMatches();
        if (list == null) {
            Matcher.$$$reportNull$$$0(6);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/Matcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/Matcher";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "matchByDownUp";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "matchNode";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "match";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private abstract class MatchOneFile
    implements Runnable {
        private MatchOneFile() {
        }

        @Override
        public void run() {
            List<PsiElement> files = this.getPsiElementsToProcess();
            if (Matcher.this.progress != null) {
                Matcher.this.progress.setFraction((double)Matcher.this.scannedFilesCount / (double)Matcher.this.totalFilesToScan);
            }
            ++Matcher.this.scannedFilesCount;
            if (files.isEmpty()) {
                return;
            }
            LanguageFileType fileType = (LanguageFileType)Matcher.this.matchContext.getOptions().getFileType();
            Language patternLanguage = fileType.getLanguage();
            for (PsiElement file : files) {
                if (file instanceof PsiFile) {
                    Matcher.this.matchContext.getSink().processFile((PsiFile)file);
                }
                Matcher.this.myDumbService.runReadActionInSmartMode(() -> {
                    if (!file.isValid()) {
                        return;
                    }
                    StructuralSearchProfile profile2 = StructuralSearchUtil.getProfileByLanguage(file.getLanguage());
                    if (profile2 == null) {
                        return;
                    }
                    Matcher.this.match(profile2.extendMatchOnePsiFile(file), patternLanguage);
                });
            }
        }

        @NotNull
        protected abstract List<PsiElement> getPsiElementsToProcess();
    }

    private class MatchOneVirtualFile
    extends MatchOneFile {
        private final VirtualFile myFile;

        MatchOneVirtualFile(VirtualFile file) {
            this.myFile = file;
        }

        @Override
        @NotNull
        protected List<PsiElement> getPsiElementsToProcess() {
            List list = (List)ReadAction.compute(() -> {
                if (!this.myFile.isValid()) {
                    return Collections.emptyList();
                }
                PsiFile file = PsiManager.getInstance((Project)Matcher.this.project).findFile(this.myFile);
                if (file == null) {
                    return Collections.emptyList();
                }
                FileViewProvider viewProvider = file.getViewProvider();
                SmartList elementsToProcess = new SmartList();
                for (Language lang : viewProvider.getLanguages()) {
                    elementsToProcess.add(viewProvider.getPsi(lang));
                }
                return elementsToProcess;
            });
            if (list == null) {
                MatchOneVirtualFile.$$$reportNull$$$0(0);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/Matcher$MatchOneVirtualFile", "getPsiElementsToProcess"));
        }
    }

    private class MatchOnePsiFile
    extends MatchOneFile {
        private PsiElement file;

        MatchOnePsiFile(PsiElement file) {
            this.file = file;
        }

        @Override
        @NotNull
        protected List<PsiElement> getPsiElementsToProcess() {
            PsiElement file = this.file;
            this.file = null;
            SmartList smartList = new SmartList((Object)file);
            if (smartList == null) {
                MatchOnePsiFile.$$$reportNull$$$0(0);
            }
            return smartList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/Matcher$MatchOnePsiFile", "getPsiElementsToProcess"));
        }
    }

    class TaskScheduler
    implements MatchingProcess {
        private ArrayList<Runnable> tasks = new ArrayList();
        private boolean ended;
        private Runnable taskQueueEndAction;
        private boolean suspended;

        TaskScheduler() {
        }

        @Override
        public void stop() {
            this.ended = true;
        }

        @Override
        public void pause() {
            this.suspended = true;
        }

        @Override
        public void resume() {
            if (!this.suspended) {
                return;
            }
            this.suspended = false;
            this.executeNext();
        }

        @Override
        public boolean isSuspended() {
            return this.suspended;
        }

        @Override
        public boolean isEnded() {
            return this.ended;
        }

        void setTaskQueueEndAction(Runnable taskQueueEndAction) {
            this.taskQueueEndAction = taskQueueEndAction;
        }

        Runnable getTaskQueueEndAction() {
            return this.taskQueueEndAction;
        }

        void addOneTask(Runnable runnable) {
            this.tasks.add(runnable);
        }

        void executeNext() {
            while (!this.suspended && !this.ended) {
                if (this.tasks.isEmpty()) {
                    this.ended = true;
                    break;
                }
                Runnable task = this.tasks.remove(this.tasks.size() - 1);
                try {
                    task.run();
                }
                catch (ProcessCanceledException | StructuralSearchException e) {
                    this.ended = true;
                    this.clearSchedule();
                    throw e;
                }
                catch (Throwable th) {
                    LOG.error(th);
                }
            }
            if (this.ended) {
                this.clearSchedule();
            }
        }

        void init() {
            this.ended = false;
            this.suspended = false;
            PsiManager.getInstance((Project)Matcher.this.project).startBatchFilesProcessingMode();
        }

        private void clearSchedule() {
            if (this.tasks != null) {
                this.taskQueueEndAction.run();
                if (!Matcher.this.project.isDisposed()) {
                    PsiManager.getInstance((Project)Matcher.this.project).finishBatchFilesProcessingMode();
                }
                this.tasks = null;
            }
        }
    }
}

