/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.RootConfigurationAccessor;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import org.jetbrains.annotations.Nullable;

public class UIRootConfigurationAccessor
extends RootConfigurationAccessor {
    private final Project myProject;

    public UIRootConfigurationAccessor(Project project2) {
        this.myProject = project2;
    }

    @Nullable
    public Library getLibrary(Library library, String libraryName, String libraryLevel) {
        StructureConfigurableContext context = ProjectStructureConfigurable.getInstance(this.myProject).getContext();
        if (library == null) {
            if (libraryName != null) {
                library = context.getLibrary(libraryName, libraryLevel);
            }
        } else {
            Library model = context.getLibraryModel(library);
            if (model != null) {
                library = model;
            }
            library = context.getLibrary(library.getName(), library.getTable().getTableLevel());
        }
        return library;
    }

    @Nullable
    public Sdk getSdk(Sdk sdk, String sdkName) {
        ProjectSdksModel model = ProjectStructureConfigurable.getInstance(this.myProject).getJdkConfig().getJdksTreeModel();
        return sdkName != null ? model.findSdk(sdkName) : sdk;
    }

    public Module getModule(Module module2, String moduleName) {
        if (module2 == null) {
            return ModuleStructureConfigurable.getInstance(this.myProject).getModule(moduleName);
        }
        return module2;
    }

    public Sdk getProjectSdk(Project project2) {
        return ProjectStructureConfigurable.getInstance(project2).getProjectJdksModel().getProjectSdk();
    }

    @Nullable
    public String getProjectSdkName(Project project2) {
        String projectJdkName = ProjectRootManager.getInstance((Project)project2).getProjectSdkName();
        Sdk projectJdk = this.getProjectSdk(project2);
        if (projectJdk != null) {
            return projectJdk.getName();
        }
        ProjectSdksModel projectJdksModel = ProjectStructureConfigurable.getInstance(project2).getProjectJdksModel();
        return projectJdksModel.findSdk(projectJdkName) == null ? projectJdkName : null;
    }
}

