/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.facet.impl.ProjectFacetsConfigurator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleConfigurationEditor;
import com.intellij.openapi.module.impl.ModuleConfigurationStateImpl;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ModuleConfigurableEP;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootManagerEx;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.impl.RootConfigurationAccessor;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import com.intellij.openapi.roots.ui.configuration.ModificationOfImportedModelWarningComponent;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurableWrapper;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationEditorProvider;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationEditorProviderEx;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationState;
import com.intellij.openapi.roots.ui.configuration.ModuleElementsEditor;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.roots.ui.configuration.UIRootConfigurationAccessor;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModuleEditor
implements Place.Navigator,
Disposable {
    private static final Logger LOG = Logger.getInstance(ModuleEditor.class);
    private static final ExtensionPointName<ModuleConfigurableEP> MODULE_CONFIGURABLES = ExtensionPointName.create((String)"com.intellij.moduleConfigurable");
    public static final String SELECTED_EDITOR_NAME = "selectedEditor";
    private final Project myProject;
    private JPanel myGenericSettingsPanel;
    private ModificationOfImportedModelWarningComponent myModificationOfImportedModelWarningComponent;
    private ModifiableRootModel myModifiableRootModel;
    private final ModulesProvider myModulesProvider;
    private String myName;
    private final Module myModule;
    protected final List<ModuleConfigurationEditor> myEditors;
    private ModifiableRootModel myModifiableRootModelProxy;
    private final EventDispatcher<ChangeListener> myEventDispatcher;
    @NonNls
    private static final String METHOD_COMMIT = "commit";
    private boolean myEditorsInitialized;
    protected History myHistory;
    private static final Set<Class<?>> ourReportedDeprecatedClasses = new HashSet();

    public ModuleEditor(Project project2, ModulesProvider modulesProvider, @NotNull Module module2) {
        if (module2 == null) {
            ModuleEditor.$$$reportNull$$$0(0);
        }
        this.myEditors = new ArrayList<ModuleConfigurationEditor>();
        this.myEventDispatcher = EventDispatcher.create(ChangeListener.class);
        this.myProject = project2;
        this.myModulesProvider = modulesProvider;
        this.myModule = module2;
        this.myName = module2.getName();
    }

    public void init(History history) {
        this.myHistory = history;
        for (ModuleConfigurationEditor each : this.myEditors) {
            if (!(each instanceof ModuleElementsEditor)) continue;
            ((ModuleElementsEditor)each).setHistory(this.myHistory);
        }
        this.restoreSelectedEditor();
    }

    public abstract ProjectFacetsConfigurator getFacetsConfigurator();

    protected abstract JComponent createCenterPanel();

    @Nullable
    public abstract ModuleConfigurationEditor getSelectedEditor();

    public abstract void selectEditor(String var1);

    protected abstract void restoreSelectedEditor();

    @Nullable
    public abstract ModuleConfigurationEditor getEditor(@NotNull String var1);

    protected abstract void disposeCenterPanel();

    public void addChangeListener(ChangeListener listener) {
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.myEventDispatcher.removeListener((EventListener)listener);
    }

    @Nullable
    public Module getModule() {
        Module[] all;
        for (Module each : all = this.myModulesProvider.getModules()) {
            if (each != this.myModule) continue;
            return this.myModule;
        }
        return this.myModulesProvider.getModule(this.myName);
    }

    public ModifiableRootModel getModifiableRootModel() {
        Module module2;
        if (this.myModifiableRootModel == null && (module2 = this.getModule()) != null) {
            this.myModifiableRootModel = ModuleRootManagerEx.getInstanceEx((Module)module2).getModifiableModel((RootConfigurationAccessor)new UIRootConfigurationAccessor(this.myProject));
        }
        return this.myModifiableRootModel;
    }

    @NotNull
    public OrderEntry[] getOrderEntries() {
        if (this.myModifiableRootModel == null) {
            OrderEntry[] orderEntryArray = ModuleRootManager.getInstance((Module)this.getModule()).getOrderEntries();
            if (orderEntryArray == null) {
                ModuleEditor.$$$reportNull$$$0(1);
            }
            return orderEntryArray;
        }
        OrderEntry[] orderEntryArray = this.myModifiableRootModel.getOrderEntries();
        if (orderEntryArray == null) {
            ModuleEditor.$$$reportNull$$$0(2);
        }
        return orderEntryArray;
    }

    public ModifiableRootModel getModifiableRootModelProxy() {
        ModifiableRootModel rootModel;
        if (this.myModifiableRootModelProxy == null && (rootModel = this.getModifiableRootModel()) != null) {
            this.myModifiableRootModelProxy = (ModifiableRootModel)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{ModifiableRootModel.class}, (InvocationHandler)new ModifiableRootModelInvocationHandler(rootModel));
        }
        return this.myModifiableRootModelProxy;
    }

    public ModuleRootModel getRootModel() {
        if (this.myModifiableRootModel != null) {
            return this.getModifiableRootModelProxy();
        }
        return ModuleRootManager.getInstance((Module)this.myModule);
    }

    public boolean isModified() {
        for (ModuleConfigurationEditor moduleElementsEditor : this.myEditors) {
            if (!moduleElementsEditor.isModified()) continue;
            return true;
        }
        return false;
    }

    private void createEditors(@Nullable Module module2) {
        if (module2 == null) {
            return;
        }
        ModuleConfigurationState state = this.createModuleConfigurationState();
        for (ModuleConfigurationEditorProvider provider : ModuleEditor.collectProviders(module2)) {
            Object[] editors = provider.createEditors(state);
            if (editors.length > 0 && provider instanceof ModuleConfigurationEditorProviderEx && ((ModuleConfigurationEditorProviderEx)provider).isCompleteEditorSet()) {
                this.myEditors.clear();
                ContainerUtil.addAll(this.myEditors, (Object[])editors);
                break;
            }
            ContainerUtil.addAll(this.myEditors, (Object[])editors);
        }
        for (Configurable moduleConfigurable : ServiceKt.getComponents((ComponentManager)module2, Configurable.class)) {
            ModuleEditor.reportDeprecatedModuleEditor(moduleConfigurable.getClass());
            this.myEditors.add(new ModuleConfigurableWrapper(moduleConfigurable));
        }
        for (ModuleConfigurableEP extension : MODULE_CONFIGURABLES.getExtensionList((AreaInstance)module2)) {
            Configurable configurable;
            if (!extension.canCreateConfigurable() || (configurable = (Configurable)extension.createConfigurable()) == null) continue;
            ModuleEditor.reportDeprecatedModuleEditor(configurable.getClass());
            this.myEditors.add(new ModuleConfigurableWrapper(configurable));
        }
        for (ModuleConfigurationEditor editor : this.myEditors) {
            if (!(editor instanceof ModuleElementsEditor)) continue;
            ((ModuleElementsEditor)editor).addListener(this::updateImportedModelWarning);
        }
    }

    private static void reportDeprecatedModuleEditor(@NotNull Class<?> aClass) {
        if (aClass == null) {
            ModuleEditor.$$$reportNull$$$0(3);
        }
        if (ourReportedDeprecatedClasses.add(aClass)) {
            LOG.warn(aClass.getName() + " uses deprecated way to register itself as a module editor. " + ModuleConfigurationEditorProvider.class.getName() + " extension point should be used instead");
        }
    }

    @NotNull
    private static ModuleConfigurationEditorProvider[] collectProviders(@NotNull Module module2) {
        if (module2 == null) {
            ModuleEditor.$$$reportNull$$$0(4);
        }
        ArrayList result = new ArrayList(ServiceKt.getComponents((ComponentManager)module2, ModuleConfigurationEditorProvider.class));
        for (ModuleConfigurationEditorProvider component : result) {
            ModuleEditor.reportDeprecatedModuleEditor(component.getClass());
        }
        ContainerUtil.addAll(result, (Object[])ModuleConfigurationEditorProvider.EP_NAME.getExtensions((AreaInstance)module2));
        ModuleConfigurationEditorProvider[] moduleConfigurationEditorProviderArray = result.toArray(new ModuleConfigurationEditorProvider[0]);
        if (moduleConfigurationEditorProviderArray == null) {
            ModuleEditor.$$$reportNull$$$0(5);
        }
        return moduleConfigurationEditorProviderArray;
    }

    @NotNull
    public ModuleConfigurationState createModuleConfigurationState() {
        ModuleConfigurationStateImpl moduleConfigurationStateImpl = new ModuleConfigurationStateImpl(this.myProject, this.myModulesProvider){

            public ModifiableRootModel getRootModel() {
                return ModuleEditor.this.getModifiableRootModelProxy();
            }

            public FacetsProvider getFacetsProvider() {
                return ModuleEditor.this.getFacetsConfigurator();
            }
        };
        if (moduleConfigurationStateImpl == null) {
            ModuleEditor.$$$reportNull$$$0(6);
        }
        return moduleConfigurationStateImpl;
    }

    @NotNull
    private JPanel createPanel() {
        this.getModifiableRootModel();
        this.getModifiableRootModelProxy();
        this.myGenericSettingsPanel = new ModuleEditorPanel();
        this.createEditors(this.getModule());
        JComponent component = this.createCenterPanel();
        this.myGenericSettingsPanel.add((Component)component, "Center");
        this.myModificationOfImportedModelWarningComponent = new ModificationOfImportedModelWarningComponent();
        this.myGenericSettingsPanel.add((Component)this.myModificationOfImportedModelWarningComponent.getLabel(), "South");
        this.updateImportedModelWarning();
        this.myEditorsInitialized = true;
        JPanel jPanel = this.myGenericSettingsPanel;
        if (jPanel == null) {
            ModuleEditor.$$$reportNull$$$0(7);
        }
        return jPanel;
    }

    @NotNull
    public JPanel getPanel() {
        if (this.myGenericSettingsPanel == null) {
            this.myGenericSettingsPanel = this.createPanel();
        }
        JPanel jPanel = this.myGenericSettingsPanel;
        if (jPanel == null) {
            ModuleEditor.$$$reportNull$$$0(8);
        }
        return jPanel;
    }

    public void moduleCountChanged() {
        this.updateOrderEntriesInEditors(false);
    }

    private void updateOrderEntriesInEditors(boolean forceInitEditors) {
        if (this.getModule() != null) {
            if (this.myEditorsInitialized || forceInitEditors) {
                this.getPanel();
                for (ModuleConfigurationEditor myEditor : this.myEditors) {
                    myEditor.moduleStateChanged();
                }
                this.updateImportedModelWarning();
            }
            ((ChangeListener)this.myEventDispatcher.getMulticaster()).moduleStateChanged(this.getModifiableRootModelProxy());
        }
    }

    private void updateImportedModelWarning() {
        if (!this.myEditorsInitialized) {
            return;
        }
        ProjectModelExternalSource externalSource = ModuleRootManager.getInstance((Module)this.myModule).getExternalSource();
        if (externalSource != null && this.isModified()) {
            this.myModificationOfImportedModelWarningComponent.showWarning("Module '" + this.myModule.getName() + "'", externalSource);
        } else {
            this.myModificationOfImportedModelWarningComponent.hideWarning();
        }
    }

    public void updateCompilerOutputPathChanged(String baseUrl, String moduleName) {
        if (this.myGenericSettingsPanel == null) {
            return;
        }
        for (ModuleConfigurationEditor myEditor : this.myEditors) {
            if (!(myEditor instanceof ModuleElementsEditor)) continue;
            ((ModuleElementsEditor)myEditor).moduleCompileOutputChanged(baseUrl, moduleName);
        }
    }

    public void dispose() {
        try {
            for (ModuleConfigurationEditor myEditor : this.myEditors) {
                myEditor.disposeUIResources();
            }
            this.myEditors.clear();
            this.disposeCenterPanel();
            if (this.myModifiableRootModel != null) {
                this.myModifiableRootModel.dispose();
            }
            this.myGenericSettingsPanel = null;
        }
        finally {
            this.resetModifiableModel();
        }
    }

    public ModifiableRootModel apply() throws ConfigurationException {
        for (ModuleConfigurationEditor editor : this.myEditors) {
            editor.saveData();
            editor.apply();
        }
        return this.myModifiableRootModel;
    }

    void resetModifiableModel() {
        this.myModifiableRootModel = null;
        this.myModifiableRootModelProxy = null;
    }

    public void canApply() throws ConfigurationException {
        for (ModuleConfigurationEditor editor : this.myEditors) {
            if (!(editor instanceof ModuleElementsEditor)) continue;
            ((ModuleElementsEditor)editor).canApply();
        }
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            ModuleEditor.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static Object[] unwrapParams(Object[] params) {
        if (params == null || params.length == 0) {
            return params;
        }
        Object[] unwrappedParams = new Object[params.length];
        for (int idx = 0; idx < params.length; ++idx) {
            InvocationHandler invocationHandler;
            Object param = params[idx];
            if (param != null && Proxy.isProxyClass(param.getClass()) && (invocationHandler = Proxy.getInvocationHandler(param)) instanceof ProxyDelegateAccessor) {
                param = ((ProxyDelegateAccessor)((Object)invocationHandler)).getDelegate();
            }
            unwrappedParams[idx] = param;
        }
        return unwrappedParams;
    }

    @Nullable
    public String getHelpTopic() {
        if (this.myEditors.isEmpty()) {
            return null;
        }
        ModuleConfigurationEditor selectedEditor = this.getSelectedEditor();
        return selectedEditor != null ? selectedEditor.getHelpTopic() : null;
    }

    public void setModuleName(@NotNull String name2) {
        if (name2 == null) {
            ModuleEditor.$$$reportNull$$$0(10);
        }
        this.myName = name2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/ModuleEditor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/ModuleEditor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderEntries";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "collectProviders";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createModuleConfigurationState";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createPanel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPanel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "reportDeprecatedModuleEditor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectProviders";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setModuleName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ModuleEditorPanel
    extends JPanel
    implements DataProvider {
        ModuleEditorPanel() {
            super(new BorderLayout());
        }

        public Object getData(@NotNull String dataId) {
            if (dataId == null) {
                ModuleEditorPanel.$$$reportNull$$$0(0);
            }
            if (LangDataKeys.MODULE_CONTEXT.is(dataId)) {
                return ModuleEditor.this.getModule();
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/openapi/roots/ui/configuration/ModuleEditor$ModuleEditorPanel", "getData"));
        }
    }

    public static interface ProxyDelegateAccessor {
        public Object getDelegate();
    }

    private class LibraryTableModelInvocationHandler
    implements InvocationHandler,
    ProxyDelegateAccessor {
        private final LibraryTable.ModifiableModel myDelegateModel;

        LibraryTableModelInvocationHandler(LibraryTable.ModifiableModel delegateModel) {
            if (delegateModel == null) {
                LibraryTableModelInvocationHandler.$$$reportNull$$$0(0);
            }
            this.myDelegateModel = delegateModel;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] params) throws Throwable {
            boolean needUpdate = ModuleEditor.METHOD_COMMIT.equals(method.getName());
            try {
                Object result = method.invoke((Object)this.myDelegateModel, ModuleEditor.unwrapParams(params));
                if (result instanceof Library[]) {
                    Library[] libraries2 = (Library[])result;
                    for (int idx = 0; idx < libraries2.length; ++idx) {
                        Library library = libraries2[idx];
                        libraries2[idx] = (Library)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{LibraryEx.class}, (InvocationHandler)new LibraryInvocationHandler(library));
                    }
                }
                if (result instanceof Library) {
                    result = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{LibraryEx.class}, (InvocationHandler)new LibraryInvocationHandler((Library)result));
                }
                Object object2 = result;
                return object2;
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
            finally {
                if (needUpdate) {
                    ModuleEditor.this.updateOrderEntriesInEditors(true);
                }
            }
        }

        @Override
        public Object getDelegate() {
            return this.myDelegateModel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateModel", "com/intellij/openapi/roots/ui/configuration/ModuleEditor$LibraryTableModelInvocationHandler", "<init>"));
        }
    }

    private class LibraryModifiableModelInvocationHandler
    implements InvocationHandler,
    ProxyDelegateAccessor {
        private final Library.ModifiableModel myDelegateModel;

        LibraryModifiableModelInvocationHandler(Library.ModifiableModel delegateModel) {
            if (delegateModel == null) {
                LibraryModifiableModelInvocationHandler.$$$reportNull$$$0(0);
            }
            this.myDelegateModel = delegateModel;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] params) throws Throwable {
            boolean needUpdate = ModuleEditor.METHOD_COMMIT.equals(method.getName());
            try {
                Object object2 = method.invoke((Object)this.myDelegateModel, ModuleEditor.unwrapParams(params));
                return object2;
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
            finally {
                if (needUpdate) {
                    ModuleEditor.this.updateOrderEntriesInEditors(true);
                }
            }
        }

        @Override
        public Object getDelegate() {
            return this.myDelegateModel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateModel", "com/intellij/openapi/roots/ui/configuration/ModuleEditor$LibraryModifiableModelInvocationHandler", "<init>"));
        }
    }

    private class LibraryInvocationHandler
    implements InvocationHandler,
    ProxyDelegateAccessor {
        private final Library myDelegateLibrary;

        LibraryInvocationHandler(Library delegateLibrary) {
            if (delegateLibrary == null) {
                LibraryInvocationHandler.$$$reportNull$$$0(0);
            }
            this.myDelegateLibrary = delegateLibrary;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] params) throws Throwable {
            try {
                Object result = method.invoke((Object)this.myDelegateLibrary, ModuleEditor.unwrapParams(params));
                if (result instanceof LibraryEx.ModifiableModelEx) {
                    return Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{LibraryEx.ModifiableModelEx.class}, (InvocationHandler)new LibraryModifiableModelInvocationHandler((Library.ModifiableModel)((LibraryEx.ModifiableModelEx)result)));
                }
                return result;
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }

        @Override
        public Object getDelegate() {
            return this.myDelegateLibrary;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateLibrary", "com/intellij/openapi/roots/ui/configuration/ModuleEditor$LibraryInvocationHandler", "<init>"));
        }
    }

    private class LibraryTableInvocationHandler
    implements InvocationHandler,
    ProxyDelegateAccessor {
        private final LibraryTable myDelegateTable;
        @NonNls
        private final Set<String> myCheckedNames;

        LibraryTableInvocationHandler(LibraryTable table) {
            if (table == null) {
                LibraryTableInvocationHandler.$$$reportNull$$$0(0);
            }
            this.myCheckedNames = new THashSet(Collections.singletonList("removeLibrary"));
            this.myDelegateTable = table;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] params) throws Throwable {
            boolean needUpdate = this.myCheckedNames.contains(method.getName());
            try {
                Object result = method.invoke((Object)this.myDelegateTable, ModuleEditor.unwrapParams(params));
                if (result instanceof Library) {
                    Object object2 = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{result instanceof LibraryEx ? LibraryEx.class : Library.class}, (InvocationHandler)new LibraryInvocationHandler((Library)result));
                    return object2;
                }
                if (result instanceof LibraryTable.ModifiableModel) {
                    Object object3 = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{LibraryTable.ModifiableModel.class}, (InvocationHandler)new LibraryTableModelInvocationHandler((LibraryTable.ModifiableModel)result));
                    return object3;
                }
                if (result instanceof Library[]) {
                    Library[] libraries2 = (Library[])result;
                    for (int idx = 0; idx < libraries2.length; ++idx) {
                        Library library = libraries2[idx];
                        libraries2[idx] = (Library)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{library instanceof LibraryEx ? LibraryEx.class : Library.class}, (InvocationHandler)new LibraryInvocationHandler(library));
                    }
                }
                Object object4 = result;
                return object4;
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
            finally {
                if (needUpdate) {
                    ModuleEditor.this.updateOrderEntriesInEditors(true);
                }
            }
        }

        @Override
        public Object getDelegate() {
            return this.myDelegateTable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/openapi/roots/ui/configuration/ModuleEditor$LibraryTableInvocationHandler", "<init>"));
        }
    }

    private class ModifiableRootModelInvocationHandler
    implements InvocationHandler,
    ProxyDelegateAccessor {
        private final ModifiableRootModel myDelegateModel;
        @NonNls
        private final Set<String> myCheckedNames;

        ModifiableRootModelInvocationHandler(ModifiableRootModel model) {
            if (model == null) {
                ModifiableRootModelInvocationHandler.$$$reportNull$$$0(0);
            }
            this.myCheckedNames = new HashSet<String>(Arrays.asList("addOrderEntry", "addLibraryEntry", "addInvalidLibrary", "addModuleOrderEntry", "addInvalidModuleEntry", "removeOrderEntry", "setSdk", "inheritSdk", "inheritCompilerOutputPath", "setExcludeOutput", "replaceEntryOfType", "rearrangeOrderEntries"));
            this.myDelegateModel = model;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] params) throws Throwable {
            boolean needUpdate = this.myCheckedNames.contains(method.getName());
            try {
                Object result = method.invoke((Object)this.myDelegateModel, ModuleEditor.unwrapParams(params));
                if (result instanceof LibraryTable) {
                    Object object2 = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{LibraryTable.class}, (InvocationHandler)new LibraryTableInvocationHandler((LibraryTable)result));
                    return object2;
                }
                Object object3 = result;
                return object3;
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
            finally {
                if (needUpdate) {
                    ModuleEditor.this.updateOrderEntriesInEditors(true);
                }
            }
        }

        @Override
        public Object getDelegate() {
            return this.myDelegateModel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/openapi/roots/ui/configuration/ModuleEditor$ModifiableRootModelInvocationHandler", "<init>"));
        }
    }

    public static interface ChangeListener
    extends EventListener {
        public void moduleStateChanged(ModifiableRootModel var1);
    }
}

