/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.ui.Util;
import com.intellij.openapi.roots.JavaModuleExternalPaths;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationState;
import com.intellij.openapi.roots.ui.configuration.ModuleElementsEditor;
import com.intellij.openapi.roots.ui.configuration.TableItem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.DumbAwareActionButton;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.ItemRemovable;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

public class JavadocEditor
extends ModuleElementsEditor {
    private JTable myTable;
    private static final String NAME = ProjectBundle.message((String)"module.javadoc.title", (Object[])new Object[0]);

    public JavadocEditor(ModuleConfigurationState state) {
        super(state);
    }

    public String getHelpTopic() {
        return "projectStructure.modules.paths";
    }

    public String getDisplayName() {
        return NAME;
    }

    public void saveData() {
        TableUtil.stopEditing((JTable)this.myTable);
        int count = this.myTable.getRowCount();
        String[] urls = ArrayUtil.newStringArray((int)count);
        for (int row = 0; row < count; ++row) {
            TableItem item = ((MyTableModel)this.myTable.getModel()).getTableItemAt(row);
            urls[row] = item.getUrl();
        }
        ((JavaModuleExternalPaths)this.getModel().getModuleExtension(JavaModuleExternalPaths.class)).setJavadocUrls(urls);
        this.fireConfigurationChanged();
    }

    public JComponent createComponentImpl() {
        DefaultTableModel tableModel = this.createModel();
        this.myTable = new JBTable((TableModel)tableModel);
        this.myTable.setIntercellSpacing(new Dimension(0, 0));
        this.myTable.setDefaultRenderer(TableItem.class, (TableCellRenderer)((Object)new MyRenderer()));
        this.myTable.setShowGrid(false);
        this.myTable.setDragEnabled(false);
        this.myTable.setShowHorizontalLines(false);
        this.myTable.setShowVerticalLines(false);
        this.myTable.getSelectionModel().setSelectionMode(2);
        JPanel tablePanel = ToolbarDecorator.createDecorator((JTable)this.myTable).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                FileChooserDescriptor myDescriptor = FileChooserDescriptorFactory.createMultipleJavaPathDescriptor();
                myDescriptor.setTitle(ProjectBundle.message((String)"module.javadoc.add.path.title", (Object[])new Object[0]));
                myDescriptor.setDescription(ProjectBundle.message((String)"module.javadoc.add.path.prompt", (Object[])new Object[0]));
                VirtualFile[] files = FileChooser.chooseFiles((FileChooserDescriptor)myDescriptor, (Component)JavadocEditor.this.myTable, (Project)JavadocEditor.this.myProject, null);
                MyTableModel tableModel = (MyTableModel)JavadocEditor.this.myTable.getModel();
                boolean changes = false;
                for (VirtualFile file : files) {
                    if (file == null) continue;
                    tableModel.addTableItem(new TableItem(file));
                    changes = true;
                }
                if (changes) {
                    JavadocEditor.this.saveData();
                    TableUtil.selectRows((JTable)JavadocEditor.this.myTable, (int[])new int[]{tableModel.getRowCount() - 1});
                }
            }
        }).addExtraAction((AnActionButton)new DumbAwareActionButton(ProjectBundle.message((String)"module.javadoc.add.url.button", (Object[])new Object[0]), IconUtil.getAddLinkIcon()){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                VirtualFile[] files = new VirtualFile[]{Util.showSpecifyJavadocUrlDialog((JComponent)JavadocEditor.this.myTable)};
                MyTableModel tableModel = (MyTableModel)JavadocEditor.this.myTable.getModel();
                boolean changes = false;
                for (VirtualFile file : files) {
                    if (file == null) continue;
                    tableModel.addTableItem(new TableItem(file));
                    changes = true;
                }
                if (changes) {
                    JavadocEditor.this.saveData();
                    TableUtil.selectRows((JTable)JavadocEditor.this.myTable, (int[])new int[]{tableModel.getRowCount() - 1});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/roots/ui/configuration/JavadocEditor$2", "actionPerformed"));
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                List removedItems = TableUtil.removeSelectedItems((JTable)JavadocEditor.this.myTable);
                if (removedItems.size() > 0) {
                    JavadocEditor.this.saveData();
                }
            }
        }).setButtonComparator(new String[]{"Add", ProjectBundle.message((String)"module.javadoc.add.url.button", (Object[])new Object[0]), "Remove"}).createPanel();
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)tablePanel, "Center");
        mainPanel.add((Component)new JBLabel(ProjectBundle.message((String)"project.roots.javadoc.tab.description", (Object[])new Object[0]), UIUtil.ComponentStyle.SMALL, UIUtil.FontColor.BRIGHTER), "North");
        return mainPanel;
    }

    protected DefaultTableModel createModel() {
        String[] javadocUrls;
        MyTableModel tableModel = new MyTableModel();
        for (String javadocUrl : javadocUrls = ((JavaModuleExternalPaths)this.getModel().getModuleExtension(JavaModuleExternalPaths.class)).getJavadocUrls()) {
            tableModel.addTableItem(new TableItem(javadocUrl));
        }
        return tableModel;
    }

    public void moduleStateChanged() {
        if (this.myTable != null) {
            DefaultTableModel tableModel = this.createModel();
            this.myTable.setModel(tableModel);
        }
    }

    private static class MyTableModel
    extends DefaultTableModel
    implements ItemRemovable {
        private MyTableModel() {
        }

        @Override
        public String getColumnName(int column) {
            return null;
        }

        public Class getColumnClass(int columnIndex) {
            return TableItem.class;
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public TableItem getTableItemAt(int row) {
            return (TableItem)this.getValueAt(row, 0);
        }

        public void addTableItem(TableItem item) {
            this.addRow(new Object[]{item});
        }
    }

    private static class MyRenderer
    extends ColoredTableCellRenderer {
        private static final Border NO_FOCUS_BORDER = BorderFactory.createEmptyBorder(1, 1, 1, 1);

        private MyRenderer() {
        }

        protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
            this.setPaintFocusBorder(false);
            this.setFocusBorderAroundIcon(true);
            this.setBorder(NO_FOCUS_BORDER);
            TableItem tableItem = (TableItem)value;
            if (tableItem != null) {
                tableItem.getCellAppearance().customize((SimpleColoredComponent)this);
            }
        }
    }
}

