/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.task.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.view.ExternalProjectsViewImpl;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.impl.ContentImpl;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractExternalSystemToolWindowFactory
implements ToolWindowFactory,
DumbAware {
    @NotNull
    private final ProjectSystemId myExternalSystemId;

    protected AbstractExternalSystemToolWindowFactory(@NotNull ProjectSystemId id) {
        if (id == null) {
            AbstractExternalSystemToolWindowFactory.$$$reportNull$$$0(0);
        }
        this.myExternalSystemId = id;
    }

    public void createToolWindowContent(@NotNull Project project2, @NotNull ToolWindow toolWindow) {
        if (project2 == null) {
            AbstractExternalSystemToolWindowFactory.$$$reportNull$$$0(1);
        }
        if (toolWindow == null) {
            AbstractExternalSystemToolWindowFactory.$$$reportNull$$$0(2);
        }
        toolWindow.setTitle(this.myExternalSystemId.getReadableName());
        ContentManager contentManager = toolWindow.getContentManager();
        contentManager.addContent((Content)new ContentImpl((JComponent)this.createInitializingLabel(), "", false));
        ExternalProjectsManager.getInstance((Project)project2).runWhenInitialized(() -> ApplicationManager.getApplication().invokeLater(() -> {
            ExternalProjectsViewImpl projectsView = new ExternalProjectsViewImpl(project2, (ToolWindowEx)toolWindow, this.myExternalSystemId);
            ExternalProjectsManagerImpl.getInstance(project2).registerView(projectsView);
            ContentImpl tasksContent = new ContentImpl((JComponent)((Object)projectsView), "", true);
            contentManager.removeAllContents(true);
            contentManager.addContent((Content)tasksContent);
        }, project2.getDisposed()));
    }

    @NotNull
    private JLabel createInitializingLabel() {
        JLabel label = new JLabel("Initializing " + this.myExternalSystemId.getReadableName() + " projects data...", 0);
        label.setOpaque(true);
        JLabel jLabel = label;
        if (jLabel == null) {
            AbstractExternalSystemToolWindowFactory.$$$reportNull$$$0(3);
        }
        return jLabel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/task/ui/AbstractExternalSystemToolWindowFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/task/ui/AbstractExternalSystemToolWindowFactory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createInitializingLabel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createToolWindowContent";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

